/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FloatFormatter;
import java.util.Locale;

public class SUVTransform {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/SUVTransform.java,v 1.19 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SUVTransform.class);
    private SingleSUVTransform useTransform;

    public static long deriveScanDateTimeFromHalfLifeAcquisitionDateTimeFrameReferenceTimeAndActualFrameDuration(AttributeList attributeList) {
        long l = 0L;
        try {
            long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.AcquisitionDate, TagFromName.AcquisitionTime);
            Attribute attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.RadiopharmaceuticalInformationSequence, TagFromName.RadionuclideHalfLife);
            if (attribute != null) {
                double d = attribute.getSingleDoubleValueOrDefault(0.0);
                double d2 = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.FrameReferenceTime, 0.0) / 1000.0;
                double d3 = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.ActualFrameDuration, 0.0) / 1000.0;
                if (d2 > 0.0 && d3 > 0.0) {
                    double d4 = Math.log(2.0) / d;
                    double d5 = d4 * d3;
                    double d6 = 1.0 / d4 * Math.log(d5 / (1.0 - Math.exp(-d5)));
                    double d7 = (d2 - d6) * 1000.0;
                    l = (long)((double)l2 - d7);
                }
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("Could not extract or parse values to compute scanDateTime from Half Life, Acquisition Date and Time, Frame Reference Time and Actual Frame Duration", exception);
        }
        return l;
    }

    public SingleSUVTransform getSingleSUVTransform(int n) {
        return this.useTransform;
    }

    public SUVTransform(AttributeList attributeList) {
        this.useTransform = new SingleSUVTransform(attributeList);
    }

    public String toString(int n, int n2) {
        return this.toString(n, (double)n2);
    }

    public String toString(int n, double d) {
        double d2;
        StringBuffer stringBuffer = new StringBuffer();
        SingleSUVTransform singleSUVTransform = this.useTransform;
        if (singleSUVTransform.isValidSUVbw()) {
            stringBuffer.append("SUVbw = ");
            d2 = singleSUVTransform.getSUVbwValue(d);
            stringBuffer.append(FloatFormatter.toString(d2, Locale.US));
            stringBuffer.append(" ");
            stringBuffer.append(singleSUVTransform.getSUVbwUnits());
        }
        if (singleSUVTransform.isValidSUVbsa()) {
            stringBuffer.append(" ");
            stringBuffer.append("SUVbsa = ");
            d2 = singleSUVTransform.getSUVbsaValue(d);
            stringBuffer.append(FloatFormatter.toString(d2, Locale.US));
            stringBuffer.append(" ");
            stringBuffer.append(singleSUVTransform.getSUVbsaUnits());
        }
        if (singleSUVTransform.isValidSUVlbm()) {
            stringBuffer.append(" ");
            stringBuffer.append("SUVlbm = ");
            d2 = singleSUVTransform.getSUVlbmValue(d);
            stringBuffer.append(FloatFormatter.toString(d2, Locale.US));
            stringBuffer.append(" ");
            stringBuffer.append(singleSUVTransform.getSUVlbmUnits());
        }
        if (singleSUVTransform.isValidSUVibw()) {
            stringBuffer.append(" ");
            stringBuffer.append("SUVibw = ");
            d2 = singleSUVTransform.getSUVibwValue(d);
            stringBuffer.append(FloatFormatter.toString(d2, Locale.US));
            stringBuffer.append(" ");
            stringBuffer.append(singleSUVTransform.getSUVibwUnits());
        }
        return stringBuffer.toString();
    }

    public class SingleSUVTransform {
        double rescaleIntercept;
        boolean haveSUVbw;
        double scaleFactorSUVbw;
        String unitsSUVbw;
        boolean haveSUVbsa;
        double scaleFactorSUVbsa;
        String unitsSUVbsa;
        boolean haveSUVlbm;
        double scaleFactorSUVlbm;
        String unitsSUVlbm;
        boolean haveSUVibw;
        double scaleFactorSUVibw;
        String unitsSUVibw;

        SingleSUVTransform(AttributeList attributeList) {
            String string;
            String string2;
            if (attributeList != null && (string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID)).equals("1.2.840.10008.5.1.4.1.1.128") && (string = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.CorrectedImage)).contains("ATTN") && string.contains("DECY")) {
                String string3;
                String string4 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.Units);
                double d = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RescaleSlope, 1.0);
                this.rescaleIntercept = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RescaleIntercept, 0.0);
                double d2 = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.PatientWeight, 0.0);
                double d3 = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.PatientSize, 0.0);
                if (d3 < 5.0) {
                    d3 *= 100.0;
                } else {
                    System.err.println("PatientSize unrealistically large, assuming is in cm rather than the required m = " + d3);
                }
                String string5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientSex).trim().toUpperCase(Locale.US);
                if (string4.equals("BQML")) {
                    Object object;
                    String string6;
                    string3 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.DecayCorrection);
                    Attribute attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.RadiopharmaceuticalInformationSequence, TagFromName.RadionuclideTotalDose);
                    Attribute attribute2 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.RadiopharmaceuticalInformationSequence, TagFromName.RadionuclideHalfLife);
                    Attribute attribute3 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.RadiopharmaceuticalInformationSequence, TagFromName.RadiopharmaceuticalStartDateTime);
                    Attribute attribute4 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.RadiopharmaceuticalInformationSequence, TagFromName.RadiopharmaceuticalStartTime);
                    String string7 = string6 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SeriesDate);
                    long l = 0L;
                    long l2 = 0L;
                    try {
                        Attribute attribute5 = attributeList.get(TagFromName.SeriesTime);
                        if (attribute5 != null && attribute5.getVM() > 0) {
                            l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
                        }
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("Could not extract or parse Series Date and Series Time", exception);
                    }
                    l = l2;
                    long l3 = 0L;
                    try {
                        object = attributeList.get(TagFromName.AcquisitionTime);
                        if (object != null && ((Attribute)object).getVM() > 0) {
                            l3 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.AcquisitionDate, TagFromName.AcquisitionTime);
                        }
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("Could not extract or parse Acquisition Date and Acquisition Time", exception);
                    }
                    if (l == 0L || l2 > l3) {
                        slf4jlogger.info("have missing series date time, or it is after acquisition date time");
                        object = Attribute.getSingleStringValueOrEmptyString(attributeList, new AttributeTag(9, 16)).trim();
                        String string8 = Attribute.getSingleStringValueOrNull(attributeList, new AttributeTag(9, 4109));
                        if (((String)object).equals("GEMS_PETD_01") && string8 != null) {
                            slf4jlogger.info("use GE private scan date time");
                            try {
                                l = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(string8);
                                string7 = string8.substring(0, 8);
                            }
                            catch (Exception exception) {
                                slf4jlogger.error("Could not extract or parse GE Private Scan Date and Time", exception);
                            }
                        } else {
                            long l4 = SUVTransform.deriveScanDateTimeFromHalfLifeAcquisitionDateTimeFrameReferenceTimeAndActualFrameDuration(attributeList);
                            if (l4 > 0L) {
                                slf4jlogger.info("use scan date time derived from HalfLife, AcquisitionDateTime, FrameReferenceTime and ActualFrameDuration");
                                l = l4;
                            }
                        }
                    }
                    if (string3.equals("START") && attribute != null && attribute2 != null && (attribute4 != null || attribute3 != null) && string7 != null && l != 0L && d2 != 0.0) {
                        long l5 = 0L;
                        try {
                            String string9 = Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.TimezoneOffsetFromUTC, "+0000");
                            String string10 = "";
                            if (attribute3 != null) {
                                string10 = attribute3.getSingleStringValueOrEmptyString();
                                slf4jlogger.debug("use start date time from RadiopharmaceuticalStartDateTime");
                                if (string10.length() > 0 && !string10.contains("+") && !string10.contains("-")) {
                                    string10 = string10 + string9;
                                }
                            }
                            if (string10.length() == 0) {
                                string10 = string7 + attribute4.getSingleStringValueOrEmptyString() + string9;
                            }
                            l5 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(string10);
                        }
                        catch (Exception exception) {
                            slf4jlogger.error("Could not parse Radiopharmaceutical Start DateTime, or combination of scan date and Radiopharmaceutical Start Time", exception);
                        }
                        if (l5 != 0L) {
                            double d4 = (double)(l - l5) / 1000.0;
                            double d5 = attribute2.getSingleDoubleValueOrDefault(0.0);
                            double d6 = attribute.getSingleDoubleValueOrDefault(0.0);
                            double d7 = d6 * Math.pow(2.0, -d4 / d5);
                            this.scaleFactorSUVbw = d2 * 1000.0 / d7;
                            this.scaleFactorSUVbw *= d;
                            this.haveSUVbw = true;
                            this.unitsSUVbw = "g/ml";
                        }
                    }
                } else if (string4.equals("CNTS")) {
                    string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, new AttributeTag(28755, 16)).trim();
                    double d8 = Attribute.getSingleDoubleValueOrDefault(attributeList, new AttributeTag(28755, 4096), 0.0);
                    if (string3.equals("Philips PET Private Group") && d8 != 0.0) {
                        this.scaleFactorSUVbw = d8 * d;
                        this.haveSUVbw = true;
                        this.unitsSUVbw = "g/ml";
                    }
                } else if (string4.equals("GML")) {
                    this.scaleFactorSUVbw = d;
                    this.haveSUVbw = true;
                    this.unitsSUVbw = "g/ml";
                }
                if (this.haveSUVbw && d2 > 0.0 && d3 > 0.0) {
                    double d9 = this.scaleFactorSUVbw / d2;
                    if (!this.haveSUVbsa) {
                        this.scaleFactorSUVbsa = d9 * 10.0 * Math.pow(d2, 0.425) * Math.pow(d3, 0.725) * 0.007184;
                        this.haveSUVbsa = true;
                        this.unitsSUVbsa = "cm2/ml";
                    }
                    if (!this.haveSUVlbm) {
                        if (string5.equals("M")) {
                            this.scaleFactorSUVlbm = d9 * (1.1 * d2 - 120.0 * Math.pow(d2 / d3, 2.0));
                            this.haveSUVlbm = true;
                            this.unitsSUVlbm = "g/ml";
                        } else if (string5.equals("F")) {
                            this.scaleFactorSUVlbm = d9 * (1.07 * d2 - 148.0 * Math.pow(d2 / d3, 2.0));
                            this.haveSUVlbm = true;
                            this.unitsSUVlbm = "g/ml";
                        }
                    }
                    if (!this.haveSUVibw) {
                        if (string5.equals("M")) {
                            this.scaleFactorSUVibw = d9 * (48.0 + 1.06 * (d3 - 152.0));
                            this.haveSUVibw = true;
                            this.unitsSUVibw = "g/ml";
                        } else if (string5.equals("F")) {
                            this.scaleFactorSUVibw = d9 * (45.5 + 0.91 * (d3 - 152.0));
                            this.haveSUVibw = true;
                            this.unitsSUVibw = "g/ml";
                        }
                    }
                }
            }
        }

        public boolean isValidSUVbw() {
            return this.haveSUVbw;
        }

        public double getSUVbwValue(double d) {
            double d2 = (d + this.rescaleIntercept) * this.scaleFactorSUVbw;
            return d2;
        }

        public String getSUVbwUnits() {
            return this.unitsSUVbw;
        }

        public boolean isValidSUVbsa() {
            return this.haveSUVbsa;
        }

        public double getSUVbsaValue(double d) {
            return (d + this.rescaleIntercept) * this.scaleFactorSUVbsa;
        }

        public String getSUVbsaUnits() {
            return this.unitsSUVbsa;
        }

        public boolean isValidSUVlbm() {
            return this.haveSUVlbm;
        }

        public double getSUVlbmValue(double d) {
            return (d + this.rescaleIntercept) * this.scaleFactorSUVlbm;
        }

        public String getSUVlbmUnits() {
            return this.unitsSUVlbm;
        }

        public boolean isValidSUVibw() {
            return this.haveSUVibw;
        }

        public double getSUVibwValue(double d) {
            return (d + this.rescaleIntercept) * this.scaleFactorSUVibw;
        }

        public String getSUVibwUnits() {
            return this.unitsSUVibw;
        }
    }
}

