/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class SetOfDicomFiles
extends HashSet<DicomFile> {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/SetOfDicomFiles.java,v 1.25 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SetOfDicomFiles.class);
    private HashSet setOfSOPClassUIDs = new HashSet();

    public Set getSetOfSOPClassUIDs() {
        return this.setOfSOPClassUIDs;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("DicomFile [");
            stringBuffer.append(Integer.toString(n));
            stringBuffer.append("]:\n");
            stringBuffer.append(((DicomFile)iterator.next()).toString());
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public DicomFile add(String string) {
        return this.add(string, false);
    }

    public DicomFile add(File file) throws IOException {
        return this.add(file.getCanonicalPath(), false);
    }

    public DicomFile add(String string, boolean bl) {
        DicomFile dicomFile = new DicomFile(string, bl);
        this.add(dicomFile);
        this.setOfSOPClassUIDs.add(dicomFile.sopClassUID);
        return dicomFile;
    }

    public DicomFile add(String string, boolean bl, boolean bl2) {
        DicomFile dicomFile = new DicomFile(string, bl, bl2);
        this.add(dicomFile);
        this.setOfSOPClassUIDs.add(dicomFile.sopClassUID);
        return dicomFile;
    }

    public DicomFile add(String string, String string2, String string3, String string4) {
        this.setOfSOPClassUIDs.add(string2);
        DicomFile dicomFile = new DicomFile(string, string2, string3, string4);
        this.add(dicomFile);
        return dicomFile;
    }

    public AttributeList[] getAttributeLists() {
        AttributeList[] attributeListArray = new AttributeList[this.size()];
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            attributeListArray[n] = ((DicomFile)iterator.next()).getAttributeList();
            ++n;
        }
        return attributeListArray;
    }

    public SetOfDicomFiles(AbstractList<String> abstractList) {
        for (int i = 0; i < abstractList.size(); ++i) {
            String string = abstractList.get(i);
            if (string == null) continue;
            this.add(string);
        }
    }

    public SetOfDicomFiles(AbstractList<String> abstractList, boolean bl, boolean bl2) {
        for (int i = 0; i < abstractList.size(); ++i) {
            String string = abstractList.get(i);
            if (string == null) continue;
            this.add(string, bl, bl2);
        }
    }

    public SetOfDicomFiles(String[] stringArray) {
        for (String string : stringArray) {
            if (string == null) continue;
            this.add(string);
        }
    }

    public SetOfDicomFiles(String[] stringArray, boolean bl, boolean bl2) {
        for (String string : stringArray) {
            if (string == null) continue;
            this.add(string, bl, bl2);
        }
    }

    public SetOfDicomFiles() {
    }

    public static void main(String[] stringArray) {
        AbstractCollection abstractCollection = new SetOfDicomFiles(stringArray);
        System.err.println(((SetOfDicomFiles)abstractCollection).toString());
        abstractCollection = new ArrayList(stringArray.length);
        for (String object2 : stringArray) {
            ((ArrayList)abstractCollection).add(object2);
        }
        Object object = new SetOfDicomFiles((AbstractList<String>)abstractCollection);
        System.err.println(((SetOfDicomFiles)object).toString());
        abstractCollection = new Vector(stringArray.length);
        for (String string : stringArray) {
            ((Vector)abstractCollection).add(string);
        }
        object = new SetOfDicomFiles((AbstractList<String>)abstractCollection);
        System.err.println(((SetOfDicomFiles)object).toString());
    }

    public class DicomFile
    implements Comparable {
        private String fileName;
        private String sopClassUID;
        private String sopInstanceUID;
        private String transferSyntaxUID;
        private AttributeList list;

        public String getFileName() {
            return this.fileName;
        }

        public String getSOPClassUID() {
            return this.sopClassUID;
        }

        public String getSOPInstanceUID() {
            return this.sopInstanceUID;
        }

        public String getTransferSyntaxUID() {
            return this.transferSyntaxUID;
        }

        public AttributeList getAttributeList() {
            return this.list;
        }

        public int compareTo(Object object) {
            return this.fileName == null ? (((DicomFile)object).fileName == null ? 0 : -1) : this.fileName.compareTo(((DicomFile)object).fileName);
        }

        public int hashCode() {
            return this.fileName == null ? 0 : this.fileName.hashCode();
        }

        public DicomFile(String string, String string2, String string3, String string4) {
            this.fileName = string;
            this.sopClassUID = string2;
            this.sopInstanceUID = string3;
            this.transferSyntaxUID = string4;
            this.list = null;
        }

        public DicomFile(String string, AttributeList attributeList) {
            this(string, attributeList, false);
        }

        public DicomFile(String string, AttributeList attributeList, boolean bl) {
            this.fileName = string;
            this.sopClassUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ReferencedSOPClassUIDInFile);
            if (this.sopClassUID == null) {
                this.sopClassUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPClassUID);
            }
            this.sopInstanceUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ReferencedSOPInstanceUIDInFile);
            if (this.sopInstanceUID == null) {
                this.sopInstanceUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID);
            }
            this.transferSyntaxUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.TransferSyntaxUID);
            this.list = bl ? attributeList : null;
        }

        public DicomFile(String string) {
            this(string, false);
        }

        public DicomFile(String string, boolean bl) {
            this(string, bl, bl);
        }

        public DicomFile(String string, boolean bl, boolean bl2) {
            slf4jlogger.debug("DicomFile(): filename={} keepList={} keepPixelData={}", string, bl, bl2);
            this.fileName = string;
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
                this.list = new AttributeList();
                boolean bl3 = false;
                if (bl) {
                    if (bl2) {
                        this.list.read(dicomInputStream);
                    } else {
                        this.list.read(dicomInputStream, TagFromName.PixelData);
                    }
                    bl3 = true;
                } else {
                    this.list.readOnlyMetaInformationHeader(dicomInputStream);
                }
                this.sopClassUID = Attribute.getSingleStringValueOrNull(this.list, TagFromName.ReferencedSOPClassUIDInFile);
                this.sopInstanceUID = Attribute.getSingleStringValueOrNull(this.list, TagFromName.ReferencedSOPInstanceUIDInFile);
                this.transferSyntaxUID = Attribute.getSingleStringValueOrNull(this.list, TagFromName.TransferSyntaxUID);
                if (this.sopClassUID == null || this.sopInstanceUID == null) {
                    if (!bl3) {
                        this.list.read(dicomInputStream, TagFromName.PixelData);
                    }
                    this.sopClassUID = Attribute.getSingleStringValueOrNull(this.list, TagFromName.SOPClassUID);
                    this.sopInstanceUID = Attribute.getSingleStringValueOrNull(this.list, TagFromName.SOPInstanceUID);
                }
                if (!bl) {
                    this.list = null;
                }
                slf4jlogger.debug("DicomFile(): sopClassUID={}", this.sopClassUID);
                slf4jlogger.debug("DicomFile(): sopInstanceUID={}", this.sopInstanceUID);
                slf4jlogger.debug("DicomFile(): transferSyntaxUID={}", this.transferSyntaxUID);
                dicomInputStream.close();
            }
            catch (Exception exception) {
                slf4jlogger.error("While reading \"{}\"", string, exception);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("file=");
            stringBuffer.append(this.fileName);
            stringBuffer.append(", sopClassUID=");
            stringBuffer.append(this.sopClassUID);
            stringBuffer.append(", sopInstanceUID=");
            stringBuffer.append(this.sopInstanceUID);
            stringBuffer.append(", transferSyntaxUID=");
            stringBuffer.append(this.transferSyntaxUID);
            return stringBuffer.toString();
        }
    }
}

