/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class UnPackBits {
    private static final int decodeOnePair(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = 0;
        int n2 = inputStream.read();
        if (n2 >= 0) {
            if (n2 >= 128) {
                n2 = 256 - n2 + 1;
                int n3 = inputStream.read();
                if (n3 < 0) {
                    new EOFException("Premature end of run length encoded stream while reading value");
                }
                while (n2-- > 0) {
                    outputStream.write(n3);
                    ++n;
                }
            } else {
                do {
                    int n4;
                    if ((n4 = inputStream.read()) < 0) {
                        new EOFException("Premature end of run length encoded stream while reading value");
                    }
                    outputStream.write(n4);
                    ++n;
                } while (n2-- > 0);
            }
        }
        return n;
    }

    private static final int decodeOnePair(InputStream inputStream, ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        int n2 = inputStream.read();
        if (n2 >= 0) {
            if (n2 >= 128) {
                n2 = 256 - n2 + 1;
                int n3 = inputStream.read();
                if (n3 < 0) {
                    new EOFException("Premature end of run length encoded stream while reading value");
                }
                while (n2-- > 0) {
                    if (!byteBuffer.hasRemaining()) continue;
                    byteBuffer.put((byte)n3);
                    ++n;
                }
            } else {
                do {
                    int n4;
                    if ((n4 = inputStream.read()) < 0) {
                        new EOFException("Premature end of run length encoded stream while reading value");
                    }
                    if (!byteBuffer.hasRemaining()) continue;
                    byteBuffer.put((byte)n4);
                    ++n;
                } while (n2-- > 0);
            }
        }
        return n;
    }

    public static final int decode(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2 = 0;
        while (n > 0) {
            int n3 = UnPackBits.decodeOnePair(inputStream, outputStream);
            if (n3 == 0) {
                throw new EOFException("Premature end of run length encoded stream");
            }
            n -= n3;
            n2 += n3;
        }
        return n2;
    }

    public static final ByteArrayOutputStream decode(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (UnPackBits.decodeOnePair(inputStream, byteArrayOutputStream) > 0) {
        }
        return byteArrayOutputStream;
    }

    public static final byte[] decode(byte[] byArray) throws IOException {
        return UnPackBits.decode(new ByteArrayInputStream(byArray)).toByteArray();
    }

    public static final int decode(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        int n3 = 0;
        while (n2 > 0) {
            int n4 = UnPackBits.decodeOnePair(inputStream, byteBuffer);
            if (n4 == 0) {
                throw new EOFException("Premature end of run length encoded stream");
            }
            n2 -= n4;
            n3 += n4;
        }
        return n3;
    }
}

