/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.ContentItemWithReference;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.XMLRepresentationOfDicomObjectFactory;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FloatFormatter;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLRepresentationOfStructuredReportObjectFactory {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/XMLRepresentationOfStructuredReportObjectFactory.java,v 1.37 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(XMLRepresentationOfStructuredReportObjectFactory.class);
    protected static String contentItemIdentiferPrefix = "ci_";
    private DocumentBuilder db;
    protected ContentItemFactory contentItemFactory;

    private void addCodedConceptAttributesToDocumentNode(Node node, Document document, CodedSequenceItem codedSequenceItem) {
        if (codedSequenceItem != null) {
            Object object;
            Object object2;
            Object object3;
            String string = codedSequenceItem.getCodeMeaning();
            if (string != null && string.length() > 0) {
                object3 = document.createAttribute("cm");
                object3.setValue(string);
                node.getAttributes().setNamedItem((Node)object3);
            }
            if ((object3 = codedSequenceItem.getCodeValue()) != null && ((String)object3).length() > 0) {
                object2 = document.createAttribute("cv");
                object2.setValue((String)object3);
                node.getAttributes().setNamedItem((Node)object2);
            }
            if ((object2 = codedSequenceItem.getCodingSchemeDesignator()) != null && ((String)object2).length() > 0) {
                object = document.createAttribute("csd");
                object.setValue((String)object2);
                node.getAttributes().setNamedItem((Node)object);
            }
            if ((object = codedSequenceItem.getCodingSchemeVersion()) != null && ((String)object).length() > 0) {
                Attr attr = document.createAttribute("csv");
                attr.setValue((String)object);
                node.getAttributes().setNamedItem(attr);
            }
        }
    }

    private void addContentItemsFromTreeToNode(ContentItem contentItem, Document document, Node node, String string) {
        if (contentItem != null) {
            Object object;
            Element element = null;
            String string2 = contentItem.getValueType();
            if (string2 != null && string2.length() > 0) {
                object = string2.toLowerCase(Locale.US);
                element = document.createElement((String)object);
            } else {
                element = document.createElement("reference");
            }
            if (element != null) {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                node.appendChild(element);
                if (string != null && string.length() > 0) {
                    object = document.createAttribute("ID");
                    object.setValue(contentItemIdentiferPrefix + string);
                    element.getAttributes().setNamedItem((Node)object);
                }
                if ((object = contentItem.getRelationshipType()) != null && ((String)object).length() > 0) {
                    object7 = document.createAttribute("relationship");
                    object7.setValue((String)object);
                    element.getAttributes().setNamedItem((Node)object7);
                }
                if ((object7 = contentItem.getObservationDateTime()) != null && ((String)object7).length() > 0) {
                    object6 = document.createAttribute("datetime");
                    object6.setValue((String)object7);
                    element.getAttributes().setNamedItem((Node)object6);
                }
                if ((object6 = contentItem.getObservationUID()) != null && ((String)object6).length() > 0) {
                    object5 = document.createAttribute("uid");
                    object5.setValue((String)object6);
                    element.getAttributes().setNamedItem((Node)object5);
                }
                if ((object5 = contentItem.getReferencedContentItemIdentifier()) != null && ((String)object5).length() > 0) {
                    object4 = document.createAttribute("IDREF");
                    object4.setValue(contentItemIdentiferPrefix + (String)object5);
                    element.getAttributes().setNamedItem((Node)object4);
                }
                if ((object4 = contentItem.getConceptName()) != null) {
                    object3 = document.createElement("concept");
                    element.appendChild((Node)object3);
                    this.addCodedConceptAttributesToDocumentNode((Node)object3, document, (CodedSequenceItem)object4);
                }
                if (contentItem instanceof ContentItemFactory.ContainerContentItem) {
                    Object object8;
                    object3 = ((ContentItemFactory.ContainerContentItem)contentItem).getContinuityOfContent();
                    if (object3 != null && ((String)object3).length() > 0) {
                        object2 = document.createAttribute("continuity");
                        object2.setValue((String)object3);
                        element.getAttributes().setNamedItem((Node)object2);
                    }
                    if ((object2 = ((ContentItemFactory.ContainerContentItem)contentItem).getTemplateMappingResource()) != null && ((String)object2).length() > 0) {
                        object8 = document.createAttribute("templatemappingresource");
                        object8.setValue((String)object2);
                        element.getAttributes().setNamedItem((Node)object8);
                    }
                    if ((object8 = ((ContentItemFactory.ContainerContentItem)contentItem).getTemplateIdentifier()) != null && ((String)object8).length() > 0) {
                        Attr attr = document.createAttribute("template");
                        attr.setValue((String)object8);
                        element.getAttributes().setNamedItem(attr);
                    }
                } else if (contentItem instanceof ContentItemFactory.CodeContentItem) {
                    object3 = ((ContentItemFactory.CodeContentItem)contentItem).getConceptCode();
                    if (object3 != null) {
                        object2 = document.createElement("value");
                        element.appendChild((Node)object2);
                        this.addCodedConceptAttributesToDocumentNode((Node)object2, document, (CodedSequenceItem)object3);
                    }
                } else if (contentItem instanceof ContentItemFactory.NumericContentItem) {
                    Object object9;
                    double d;
                    Object object10;
                    object3 = ((ContentItemFactory.NumericContentItem)contentItem).getNumericValue();
                    if (object3 != null && ((String)object3).length() > 0) {
                        Element element2 = document.createElement("value");
                        element.appendChild(element2);
                        element2.appendChild(document.createTextNode((String)object3));
                    }
                    if (((ContentItemFactory.NumericContentItem)contentItem).hasFloatingPointValue() && (object10 = Double.toString(d = ((ContentItemFactory.NumericContentItem)contentItem).getFloatingPointValue())) != null && ((String)object10).length() > 0) {
                        Element element3 = document.createElement("double");
                        element.appendChild(element3);
                        element3.appendChild(document.createTextNode((String)object10));
                    }
                    if (((ContentItemFactory.NumericContentItem)contentItem).hasRationalValue()) {
                        String string3 = Integer.toString(((ContentItemFactory.NumericContentItem)contentItem).getRationalNumeratorValue());
                        if (string3 != null && string3.length() > 0) {
                            object9 = document.createElement("numerator");
                            element.appendChild((Node)object9);
                            object9.appendChild(document.createTextNode(string3));
                        }
                        if ((object9 = Long.toString(((ContentItemFactory.NumericContentItem)contentItem).getRationalDenominatorValue())) != null && ((String)object9).length() > 0) {
                            object10 = document.createElement("denominator");
                            element.appendChild((Node)object10);
                            object10.appendChild(document.createTextNode((String)object9));
                        }
                    }
                    if ((object2 = ((ContentItemFactory.NumericContentItem)contentItem).getUnits()) != null) {
                        object9 = document.createElement("units");
                        element.appendChild((Node)object9);
                        this.addCodedConceptAttributesToDocumentNode((Node)object9, document, (CodedSequenceItem)object2);
                    }
                    if ((object9 = ((ContentItemFactory.NumericContentItem)contentItem).getQualifier()) != null) {
                        object10 = document.createElement("qualifier");
                        element.appendChild((Node)object10);
                        this.addCodedConceptAttributesToDocumentNode((Node)object10, document, (CodedSequenceItem)object9);
                    }
                } else if (contentItem instanceof ContentItemFactory.StringContentItem) {
                    object3 = ((ContentItemFactory.StringContentItem)contentItem).getConceptValue();
                    if (object3 != null && ((String)object3).length() > 0) {
                        object2 = document.createElement("value");
                        element.appendChild((Node)object2);
                        object2.appendChild(document.createTextNode((String)object3));
                    }
                } else if (contentItem instanceof ContentItemFactory.SpatialCoordinatesContentItem) {
                    object3 = ((ContentItemFactory.SpatialCoordinatesContentItem)contentItem).getGraphicType();
                    if (object3 != null) {
                        object2 = document.createElement(((String)object3).toLowerCase(Locale.US));
                        element.appendChild((Node)object2);
                        float[] fArray = ((ContentItemFactory.SpatialCoordinatesContentItem)contentItem).getGraphicData();
                        if (fArray != null) {
                            for (int i = 0; i < fArray.length; ++i) {
                                Element element4 = document.createElement(i % 2 == 0 ? "x" : "y");
                                object2.appendChild(element4);
                                element4.appendChild(document.createTextNode(FloatFormatter.toStringOfFixedMaximumLength(fArray[i], 16, false, Locale.US)));
                            }
                        }
                    }
                } else if (contentItem instanceof ContentItemFactory.SpatialCoordinates3DContentItem) {
                    Object object11;
                    object3 = ((ContentItemFactory.SpatialCoordinates3DContentItem)contentItem).getGraphicType();
                    if (object3 != null) {
                        object2 = document.createElement(((String)object3).toLowerCase(Locale.US));
                        element.appendChild((Node)object2);
                        object11 = ((ContentItemFactory.SpatialCoordinates3DContentItem)contentItem).getGraphicData();
                        if (object11 != null) {
                            for (int i = 0; i < ((Object)object11).length; ++i) {
                                int n = i % 3;
                                Element element5 = document.createElement(n == 0 ? "x" : (n == 1 ? "y" : "z"));
                                object2.appendChild(element5);
                                element5.appendChild(document.createTextNode(FloatFormatter.toStringOfFixedMaximumLength((double)object11[i], 16, false, Locale.US)));
                            }
                        }
                    }
                    if ((object2 = ((ContentItemFactory.SpatialCoordinates3DContentItem)contentItem).getReferencedFrameOfReferenceUID()) != null && ((String)object2).length() > 0) {
                        object11 = document.createElement("frameofreference");
                        element.appendChild((Node)object11);
                        object11.appendChild(document.createTextNode((String)object2));
                    }
                } else if (contentItem instanceof ContentItemFactory.TemporalCoordinatesContentItem) {
                    object3 = (ContentItemFactory.TemporalCoordinatesContentItem)contentItem;
                    object2 = ((ContentItemFactory.TemporalCoordinatesContentItem)object3).getTemporalRangeType();
                    if (object2 != null) {
                        Element element6;
                        int n;
                        Element element7;
                        Element element8 = document.createElement(((String)object2).toLowerCase(Locale.US));
                        element.appendChild(element8);
                        Object[] objectArray = ((ContentItemFactory.TemporalCoordinatesContentItem)object3).getReferencedSamplePositions();
                        if (objectArray != null) {
                            element7 = document.createElement("samplepositions");
                            element8.appendChild(element7);
                            for (n = 0; n < objectArray.length; ++n) {
                                element6 = document.createElement("position");
                                element7.appendChild(element6);
                                element6.appendChild(document.createTextNode(Integer.toString(objectArray[n])));
                            }
                        }
                        if ((objectArray = (Object[])((ContentItemFactory.TemporalCoordinatesContentItem)object3).getReferencedTimeOffsets()) != null) {
                            element7 = document.createElement("timeoffsets");
                            element8.appendChild(element7);
                            for (n = 0; n < objectArray.length; ++n) {
                                element6 = document.createElement("offset");
                                element7.appendChild(element6);
                                element6.appendChild(document.createTextNode(FloatFormatter.toString(objectArray[n], Locale.US)));
                            }
                        }
                        if ((objectArray = (Object[])((ContentItemFactory.TemporalCoordinatesContentItem)object3).getReferencedDateTimes()) != null) {
                            element7 = document.createElement("datetimes");
                            element8.appendChild(element7);
                            for (n = 0; n < objectArray.length; ++n) {
                                element6 = document.createElement("datetime");
                                element7.appendChild(element6);
                                element6.appendChild(document.createTextNode((String)objectArray[n]));
                            }
                        }
                    }
                } else if (contentItem instanceof ContentItemFactory.CompositeContentItem) {
                    object3 = ((ContentItemFactory.CompositeContentItem)contentItem).getReferencedSOPClassUID();
                    if (object3 != null && ((String)object3).length() > 0) {
                        object2 = document.createElement("class");
                        element.appendChild((Node)object2);
                        object2.appendChild(document.createTextNode((String)object3));
                    }
                    if ((object3 = ((ContentItemFactory.CompositeContentItem)contentItem).getReferencedSOPInstanceUID()) != null && ((String)object3).length() > 0) {
                        object2 = document.createElement("instance");
                        element.appendChild((Node)object2);
                        object2.appendChild(document.createTextNode((String)object3));
                    }
                    if (contentItem instanceof ContentItemFactory.ImageContentItem) {
                        Element element9;
                        Element element10;
                        Element element11;
                        Object object12;
                        object3 = (ContentItemFactory.ImageContentItem)contentItem;
                        int n = ((ContentItemFactory.ImageContentItem)object3).getReferencedFrameNumber();
                        if (n != 0) {
                            object12 = document.createElement("frame");
                            element.appendChild((Node)object12);
                            object12.appendChild(document.createTextNode(Integer.toString(n)));
                        }
                        if ((n = ((ContentItemFactory.ImageContentItem)object3).getReferencedSegmentNumber()) != 0) {
                            object12 = document.createElement("segment");
                            element.appendChild((Node)object12);
                            object12.appendChild(document.createTextNode(Integer.toString(n)));
                        }
                        object2 = ((ContentItemFactory.ImageContentItem)object3).getPresentationStateSOPClassUID();
                        object12 = ((ContentItemFactory.ImageContentItem)object3).getPresentationStateSOPInstanceUID();
                        if (object2 != null && ((String)object2).length() > 0 || object12 != null && ((String)object12).length() > 0) {
                            element11 = document.createElement("presentationstate");
                            element.appendChild(element11);
                            element10 = document.createElement("class");
                            element11.appendChild(element10);
                            element10.appendChild(document.createTextNode((String)object2));
                            element9 = document.createElement("instance");
                            element11.appendChild(element9);
                            element9.appendChild(document.createTextNode((String)object12));
                        }
                        object2 = ((ContentItemFactory.ImageContentItem)object3).getRealWorldValueMappingSOPClassUID();
                        object12 = ((ContentItemFactory.ImageContentItem)object3).getRealWorldValueMappingSOPInstanceUID();
                        if (object2 != null && ((String)object2).length() > 0 || object12 != null && ((String)object12).length() > 0) {
                            element11 = document.createElement("realworldvaluemapping");
                            element.appendChild(element11);
                            element10 = document.createElement("class");
                            element11.appendChild(element10);
                            element10.appendChild(document.createTextNode((String)object2));
                            element9 = document.createElement("instance");
                            element11.appendChild(element9);
                            element9.appendChild(document.createTextNode((String)object12));
                        }
                    } else if (contentItem instanceof ContentItemFactory.WaveformContentItem && (object3 = (Object)((ContentItemFactory.WaveformContentItem)contentItem).getReferencedWaveformChannels()) != null && ((Object)object3).length > 0) {
                        object2 = document.createElement("channels");
                        element.appendChild((Node)object2);
                        for (int i = 0; i < ((Object)object3).length; ++i) {
                            Element element12 = document.createElement("channel");
                            object2.appendChild(element12);
                            element12.appendChild(document.createTextNode(Integer.toString((int)object3[i])));
                        }
                    }
                }
                int n = contentItem.getChildCount();
                for (int i = 0; i < n; ++i) {
                    this.addContentItemsFromTreeToNode((ContentItem)contentItem.getChildAt(i), document, element, string + "." + Integer.toString(i + 1));
                }
            }
        }
    }

    public XMLRepresentationOfStructuredReportObjectFactory() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        this.db = documentBuilderFactory.newDocumentBuilder();
    }

    public Document getDocument(AttributeList attributeList) {
        return this.getDocument(null, attributeList);
    }

    public Document getDocument(StructuredReport structuredReport) {
        return this.getDocument(structuredReport, null);
    }

    public Document getDocument(StructuredReport structuredReport, AttributeList attributeList) {
        Object object;
        if (structuredReport == null) {
            try {
                structuredReport = new StructuredReport(attributeList);
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
            }
        }
        Document document = this.db.newDocument();
        Element element = document.createElement("DicomStructuredReport");
        document.appendChild(element);
        if (attributeList != null) {
            object = (AttributeList)attributeList.clone();
            ((AttributeList)object).removePrivateAttributes();
            ((AttributeList)object).removeGroupLengthAttributes();
            ((AttributeList)object).removeMetaInformationHeaderAttributes();
            ((AttributeList)object).remove(TagFromName.ContentSequence);
            ((AttributeList)object).remove(TagFromName.ValueType);
            ((AttributeList)object).remove(TagFromName.ContentTemplateSequence);
            ((AttributeList)object).remove(TagFromName.ContinuityOfContent);
            ((AttributeList)object).remove(TagFromName.ConceptNameCodeSequence);
            Element element2 = document.createElement("DicomStructuredReportHeader");
            element.appendChild(element2);
            try {
                new XMLRepresentationOfDicomObjectFactory().addAttributesFromListToNode((AttributeList)object, document, element2);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                slf4jlogger.error("", parserConfigurationException);
            }
        }
        if (structuredReport != null) {
            object = document.createElement("DicomStructuredReportContent");
            element.appendChild((Node)object);
            this.addContentItemsFromTreeToNode((ContentItem)structuredReport.getRoot(), document, (Node)object, "1");
        }
        return document;
    }

    public static String getNamedNodeAttributeOrNull(NamedNodeMap namedNodeMap, String string) {
        Node node;
        String string2 = null;
        if (namedNodeMap != null && (node = namedNodeMap.getNamedItem(string)) != null) {
            string2 = node.getNodeValue();
        }
        return string2;
    }

    public static Node getNamedChildElement(Node node, String string) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string2 = node2.getNodeName();
            if (node2.getNodeType() != 1 || string2 == null || !string2.equals(string)) continue;
            return node2;
        }
        return null;
    }

    public static String getTextValueOfNamedChildElementOrNull(Node node, String string) {
        String string2 = null;
        Node node2 = XMLRepresentationOfStructuredReportObjectFactory.getNamedChildElement(node, string);
        if (node2 != null && (string2 = node2.getTextContent()) != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    protected CodedSequenceItem getCodedSequenceItem(Node node) throws DicomException {
        CodedSequenceItem codedSequenceItem = null;
        if (node != null) {
            String string = "";
            String string2 = "";
            String string3 = null;
            String string4 = "";
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap != null) {
                string = XMLRepresentationOfStructuredReportObjectFactory.getNamedNodeAttributeOrNull(namedNodeMap, "cv");
                string2 = XMLRepresentationOfStructuredReportObjectFactory.getNamedNodeAttributeOrNull(namedNodeMap, "csd");
                string4 = XMLRepresentationOfStructuredReportObjectFactory.getNamedNodeAttributeOrNull(namedNodeMap, "cm");
                string3 = XMLRepresentationOfStructuredReportObjectFactory.getNamedNodeAttributeOrNull(namedNodeMap, "csv");
                if (string == null || string.length() == 0 || string2 == null || string2.length() == 0 || string4 == null || string4.length() == 0) {
                    throw new DicomException("Need at least Code Value (" + string + "), Coding Scheme Designator (" + string2 + ") and Code Meaning (" + string4 + ") to build CodedSequenceItem - cannot be absent or empty");
                }
            }
            codedSequenceItem = string3 == null || string3.length() == 0 ? new CodedSequenceItem(string, string2, string4) : new CodedSequenceItem(string, string2, string3, string4);
        }
        return codedSequenceItem;
    }

    protected ContentItem getNextContentItemFromXMLNodeSiblings(Node node) throws DicomException {
        while (node != null) {
            String string = node.getNodeName();
            if (node.getNodeType() == 1 && string != null) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                NamedNodeMap namedNodeMap = node.getAttributes();
                CodedSequenceItem codedSequenceItem = this.getCodedSequenceItem(XMLRepresentationOfStructuredReportObjectFactory.getNamedChildElement(node, "concept"));
                String string2 = XMLRepresentationOfStructuredReportObjectFactory.getNamedNodeAttributeOrNull(namedNodeMap, "relationship");
                String string3 = XMLRepresentationOfStructuredReportObjectFactory.getNamedNodeAttributeOrNull(namedNodeMap, "datetime");
                String string4 = XMLRepresentationOfStructuredReportObjectFactory.getNamedNodeAttributeOrNull(namedNodeMap, "uid");
                ContentItem contentItem = null;
                if (string.equals("container")) {
                    object4 = XMLRepresentationOfStructuredReportObjectFactory.getNamedNodeAttributeOrNull(namedNodeMap, "continuity");
                    object3 = XMLRepresentationOfStructuredReportObjectFactory.getNamedNodeAttributeOrNull(namedNodeMap, "template");
                    String string5 = XMLRepresentationOfStructuredReportObjectFactory.getNamedNodeAttributeOrNull(namedNodeMap, "templatemappingresource");
                    contentItem = this.contentItemFactory.makeContainerContentItem(null, string2, codedSequenceItem, object4 != null && ((String)object4).equals("SEPARATE"), string5, (String)object3, string3, string4);
                } else if (string.equals("code")) {
                    object4 = this.getCodedSequenceItem(XMLRepresentationOfStructuredReportObjectFactory.getNamedChildElement(node, "value"));
                    contentItem = this.contentItemFactory.makeCodeContentItem(null, string2, codedSequenceItem, (CodedSequenceItem)object4, string3, string4);
                } else if (string.equals("num")) {
                    object4 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node, "value");
                    object3 = this.getCodedSequenceItem(XMLRepresentationOfStructuredReportObjectFactory.getNamedChildElement(node, "units"));
                    CodedSequenceItem codedSequenceItem2 = this.getCodedSequenceItem(XMLRepresentationOfStructuredReportObjectFactory.getNamedChildElement(node, "qualifier"));
                    object2 = null;
                    Object object5 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node, "double");
                    if (object5 != null && ((String)object5).length() > 0) {
                        try {
                            double d = Double.parseDouble((String)object5);
                            object2 = new Double(d);
                        }
                        catch (NumberFormatException numberFormatException) {
                            slf4jlogger.error("", numberFormatException);
                        }
                    }
                    object5 = null;
                    Object object6 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node, "numerator");
                    if (object6 != null && ((String)object6).length() > 0) {
                        try {
                            int n = Integer.parseInt((String)object6);
                            object5 = new Integer(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            slf4jlogger.error("", numberFormatException);
                        }
                    }
                    object6 = null;
                    object = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node, "denominator");
                    if (object != null && ((String)object).length() > 0) {
                        try {
                            long l = Long.parseLong((String)object);
                            object6 = new Long(l);
                        }
                        catch (NumberFormatException numberFormatException) {
                            slf4jlogger.error("", numberFormatException);
                        }
                    }
                    contentItem = this.contentItemFactory.makeNumericContentItem(null, string2, codedSequenceItem, (String)object4, (Double)object2, (Integer)object5, (Long)object6, (CodedSequenceItem)object3, codedSequenceItem2, string3, string4);
                } else if (string.equals("datetime")) {
                    object4 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node, "value");
                    contentItem = this.contentItemFactory.makeDateTimeContentItem(null, string2, codedSequenceItem, (String)object4, string3, string4);
                } else if (string.equals("date")) {
                    object4 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node, "value");
                    contentItem = this.contentItemFactory.makeDateContentItem(null, string2, codedSequenceItem, (String)object4, string3, string4);
                } else if (string.equals("time")) {
                    object4 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node, "value");
                    contentItem = this.contentItemFactory.makeTimeContentItem(null, string2, codedSequenceItem, (String)object4, string3, string4);
                } else if (string.equals("pname")) {
                    object4 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node, "value");
                    contentItem = this.contentItemFactory.makePersonNameContentItem(null, string2, codedSequenceItem, (String)object4, string3, string4);
                } else if (string.equals("uidref")) {
                    object4 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node, "value");
                    contentItem = this.contentItemFactory.makeUIDContentItem(null, string2, codedSequenceItem, (String)object4, string3, string4);
                } else if (string.equals("text")) {
                    object4 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node, "value");
                    contentItem = this.contentItemFactory.makeTextContentItem(null, string2, codedSequenceItem, (String)object4, string3, string4);
                } else if (string.equals("scoord")) {
                    Node node2;
                    object4 = null;
                    object3 = null;
                    for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        object2 = node2.getNodeName();
                        if (node2.getNodeType() != 1 || object2 == null || !((String)object2).equals("point") && !((String)object2).equals("multipoint") && !((String)object2).equals("polyline") && !((String)object2).equals("circle") && !((String)object2).equals("ellipse")) continue;
                        object4 = ((String)object2).toUpperCase(Locale.US);
                        break;
                    }
                    if (object4 != null) {
                        assert (node2 != null);
                        object2 = new ArrayList();
                        for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                            String string6 = node3.getNodeName();
                            if ((node3.getNodeType() != 1 || string6 == null || !string6.equals("x")) && !string6.equals("y")) continue;
                            object = node3.getTextContent().trim();
                            ((ArrayList)object2).add(object);
                        }
                        int n = ((ArrayList)object2).size();
                        object3 = new float[n];
                        object = ((ArrayList)object2).iterator();
                        int n2 = 0;
                        while (object.hasNext()) {
                            object3[n2++] = Float.parseFloat((String)object.next());
                        }
                    }
                    contentItem = this.contentItemFactory.makeSpatialCoordinatesContentItem(null, string2, codedSequenceItem, (String)object4, (float[])object3, string3, string4);
                } else if (string.equals("scoord3d")) {
                    Node node4;
                    object4 = null;
                    object3 = null;
                    for (node4 = node.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                        object2 = node4.getNodeName();
                        if (node4.getNodeType() != 1 || object2 == null || !((String)object2).equals("point") && !((String)object2).equals("multipoint") && !((String)object2).equals("polyline") && !((String)object2).equals("polygon") && !((String)object2).equals("ellipse") && !((String)object2).equals("ellipsoid")) continue;
                        object4 = ((String)object2).toUpperCase(Locale.US);
                        break;
                    }
                    if (object4 != null) {
                        assert (node4 != null);
                        object2 = new ArrayList();
                        for (Node node5 = node4.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                            String string7 = node5.getNodeName();
                            if ((node5.getNodeType() != 1 || string7 == null || !string7.equals("x")) && !string7.equals("y") && !string7.equals("z")) continue;
                            object = node5.getTextContent().trim();
                            ((ArrayList)object2).add(object);
                        }
                        int n = ((ArrayList)object2).size();
                        object3 = new float[n];
                        object = ((ArrayList)object2).iterator();
                        int n3 = 0;
                        while (object.hasNext()) {
                            object3[n3++] = Float.parseFloat((String)object.next());
                        }
                    }
                    object2 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node, "frameofreference");
                    contentItem = this.contentItemFactory.makeSpatialCoordinates3DContentItem(null, string2, codedSequenceItem, (String)object4, (float[])object3, (String)object2, string3, string4);
                } else if (!string.equals("tcoord")) {
                    if (string.equals("composite")) {
                        object4 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node, "class");
                        object3 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node, "instance");
                        contentItem = this.contentItemFactory.makeCompositeContentItem(null, string2, codedSequenceItem, (String)object4, (String)object3, string3, string4);
                    } else if (string.equals("image")) {
                        object4 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node, "class");
                        object3 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node, "instance");
                        int n = 0;
                        object2 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node, "frame");
                        if (object2 != null && ((String)object2).length() > 0) {
                            n = Integer.parseInt((String)object2);
                        }
                        int n4 = 0;
                        String string8 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node, "segment");
                        if (string8 != null && string8.length() > 0) {
                            n4 = Integer.parseInt(string8);
                        }
                        object = null;
                        String string9 = null;
                        Node node6 = XMLRepresentationOfStructuredReportObjectFactory.getNamedChildElement(node, "presentationstate");
                        if (node6 != null) {
                            object = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node6, "class");
                            string9 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node6, "instance");
                        }
                        String string10 = null;
                        String string11 = null;
                        Node node7 = XMLRepresentationOfStructuredReportObjectFactory.getNamedChildElement(node, "realworldvaluemapping");
                        if (node7 != null) {
                            string10 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node7, "class");
                            string11 = XMLRepresentationOfStructuredReportObjectFactory.getTextValueOfNamedChildElementOrNull(node7, "instance");
                        }
                        contentItem = this.contentItemFactory.makeImageContentItem(null, string2, codedSequenceItem, (String)object4, (String)object3, n, n4, (String)object, string9, string10, string11, string3, string4);
                    } else if (!string.equals("waveform") && string.equals("reference")) {
                        object4 = XMLRepresentationOfStructuredReportObjectFactory.getNamedNodeAttributeOrNull(namedNodeMap, "IDREF");
                        if (object4 != null && ((String)object4).length() > 0) {
                            object4 = ((String)object4).replaceFirst(contentItemIdentiferPrefix, "");
                        }
                        contentItem = new ContentItemWithReference(null, string2, (String)object4);
                    }
                }
                if (contentItem != null) {
                    for (object4 = node.getFirstChild(); object4 != null; object4 = object4.getNextSibling()) {
                        ContentItem contentItem2;
                        NamedNodeMap namedNodeMap2;
                        object3 = object4.getNodeName();
                        if (object4.getNodeType() != 1 || object3 == null || (object2 = XMLRepresentationOfStructuredReportObjectFactory.getNamedNodeAttributeOrNull(namedNodeMap2 = object4.getAttributes(), "relationship")) == null || (contentItem2 = this.getNextContentItemFromXMLNodeSiblings((Node)object4)) == null) continue;
                        contentItem.addChild(contentItem2);
                    }
                    return contentItem;
                }
            }
            node = node.getNextSibling();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StructuredReport getStructuredReport(Document document) throws DicomException, ParserConfigurationException {
        StructuredReport structuredReport = null;
        Element element = document.getDocumentElement();
        if (element == null) throw new DicomException("DicomStructuredReport document root element missing");
        String string = element.getNodeName();
        if (string == null || element.getNodeType() != 1 || !string.equals("DicomStructuredReport")) throw new DicomException("Unexpected docoument root element - expected DicomStructuredReport - got " + string);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string2 = node.getNodeName();
            if (node.getNodeType() != 1 || string2 == null || string2.equals("DicomStructuredReportHeader")) continue;
            if (!string2.equals("DicomStructuredReportContent")) throw new DicomException("Unexpected child element of DicomStructuredReport - " + string2);
            this.contentItemFactory = new ContentItemFactory();
            ContentItem contentItem = this.getNextContentItemFromXMLNodeSiblings(node.getFirstChild());
            structuredReport = new StructuredReport(contentItem);
        }
        return structuredReport;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AttributeList getAttributeList(Document document) throws DicomException, ParserConfigurationException {
        AttributeList attributeList = new AttributeList();
        Element element = document.getDocumentElement();
        if (element == null) throw new DicomException("DicomStructuredReport document root element missing");
        String string = element.getNodeName();
        if (string == null || element.getNodeType() != 1 || !string.equals("DicomStructuredReport")) throw new DicomException("Unexpected docoument root element - expected DicomStructuredReport - got " + string);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string2 = node.getNodeName();
            if (node.getNodeType() != 1 || string2 == null) continue;
            if (string2.equals("DicomStructuredReportHeader")) {
                new XMLRepresentationOfDicomObjectFactory().addAttributesFromNodeToList(attributeList, node);
                continue;
            }
            if (!string2.equals("DicomStructuredReportContent")) throw new DicomException("Unexpected child element of DicomStructuredReport - " + string2);
            this.contentItemFactory = new ContentItemFactory();
            ContentItem contentItem = this.getNextContentItemFromXMLNodeSiblings(node.getFirstChild());
            StructuredReport structuredReport = new StructuredReport(contentItem);
            AttributeList attributeList2 = structuredReport.getAttributeList();
            attributeList.putAll(attributeList2);
        }
        return attributeList;
    }

    public AttributeList getAttributeList(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException, DicomException {
        Document document = this.db.parse(inputStream);
        return this.getAttributeList(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributeList(String string) throws IOException, SAXException, ParserConfigurationException, DicomException {
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        AttributeList attributeList = null;
        try {
            attributeList = this.getAttributeList(bufferedInputStream);
        }
        finally {
            bufferedInputStream.close();
            ((InputStream)fileInputStream).close();
        }
        return attributeList;
    }

    public static String toString(Node node, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("    ");
        }
        stringBuffer.append(node);
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                stringBuffer.append(" ");
                stringBuffer.append(node2);
            }
        }
        stringBuffer.append("\n");
        ++n;
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            stringBuffer.append(XMLRepresentationOfStructuredReportObjectFactory.toString(node3, n));
        }
        return stringBuffer.toString();
    }

    public static String toString(Node node) {
        return XMLRepresentationOfStructuredReportObjectFactory.toString(node, 0);
    }

    public static void write(OutputStream outputStream, Document document) throws IOException, TransformerConfigurationException, TransformerException {
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(outputStream);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        Properties properties = new Properties();
        properties.setProperty("method", "xml");
        properties.setProperty("indent", "yes");
        properties.setProperty("encoding", "UTF-8");
        transformer.setOutputProperties(properties);
        transformer.transform(dOMSource, streamResult);
    }

    public static void createDocumentAndWriteIt(AttributeList attributeList, OutputStream outputStream) throws IOException, DicomException {
        XMLRepresentationOfStructuredReportObjectFactory.createDocumentAndWriteIt(null, attributeList, outputStream);
    }

    public static void createDocumentAndWriteIt(StructuredReport structuredReport, OutputStream outputStream) throws IOException, DicomException {
        XMLRepresentationOfStructuredReportObjectFactory.createDocumentAndWriteIt(structuredReport, null, outputStream);
    }

    public static void createDocumentAndWriteIt(StructuredReport structuredReport, AttributeList attributeList, OutputStream outputStream) throws IOException, DicomException {
        try {
            Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport, attributeList);
            XMLRepresentationOfStructuredReportObjectFactory.write(outputStream, document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DicomException("Could not create XML document - problem creating object model from DICOM" + parserConfigurationException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new DicomException("Could not create XML document - could not instantiate transformer" + transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new DicomException("Could not create XML document - could not transform to XML" + transformerException);
        }
    }

    public static void main(String[] stringArray) {
        try {
            boolean bl = true;
            boolean bl2 = true;
            String string = null;
            if (stringArray.length == 1) {
                bl = false;
                bl2 = true;
                string = stringArray[0];
            } else if (stringArray.length == 2) {
                string = stringArray[1];
                if (stringArray[0].toLowerCase(Locale.US).equals("toxml")) {
                    bl = false;
                    bl2 = true;
                } else if (stringArray[0].toLowerCase(Locale.US).equals("todicom") || stringArray[0].toLowerCase(Locale.US).equals("todcm")) {
                    bl = false;
                    bl2 = false;
                }
            }
            if (bl) {
                System.err.println("usage: XMLRepresentationOfDicomObjectFactory [toDICOM|toXML] inputfile");
            } else if (bl2) {
                AttributeList attributeList = new AttributeList();
                attributeList.read(string, null, true, true);
                StructuredReport structuredReport = new StructuredReport(attributeList);
                Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport, attributeList);
                XMLRepresentationOfStructuredReportObjectFactory.write(System.out, document);
            } else {
                AttributeList attributeList = new XMLRepresentationOfStructuredReportObjectFactory().getAttributeList(string);
                String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SourceApplicationEntityTitle);
                attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
                attributeList.removeMetaInformationHeaderAttributes();
                FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", string2);
                attributeList.write(System.out, "1.2.840.10008.1.2.1", true, true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

