/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.PrintStream;

public class BufferedImageUtilities {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/BufferedImageUtilities.java,v 1.58 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(BufferedImageUtilities.class);
    protected static final String[] imageTypeNames = new String[]{"TYPE_CUSTOM", "TYPE_INT_RGB", "TYPE_INT_ARGB", "TYPE_INT_ARGB_PRE", "TYPE_INT_BGR", "TYPE_3BYTE_BGR", "TYPE_4BYTE_ABGR", "TYPE_4BYTE_ABGR_PRE", "TYPE_USHORT_565_RGB", "TYPE_USHORT_555_RGB", "TYPE_BYTE_GRAY", "TYPE_USHORT_GRAY", "TYPE_BYTE_BINARY", "TYPE_BYTE_INDEXED"};
    protected static final String[] bufferTypeNames = new String[]{"UBYTE", "USHORT", "short", "int", "float", "double"};
    protected static final String[] spaceTypeNames = new String[]{"XYZ", "Lab", "Luv", "YCbCr", "Yxy", "RGB", "Grayscale", "HSV", "HLS", "CMYK", "type-10", "CMY"};
    private static GraphicsConfiguration defaultGraphicsConfiguration = BufferedImageUtilities.initializeGraphicsConfiguration();
    private static ColorModel mostFavorableColorModel = BufferedImageUtilities.initializeMostFavorableColorModel();

    public static String typeName(int n) {
        return imageTypeNames[n];
    }

    public static String typeName(int n, BufferedImage bufferedImage) {
        String string = BufferedImageUtilities.typeName(n);
        if (bufferedImage == null) {
            return string;
        }
        int n2 = bufferedImage.getType();
        if (n2 == n) {
            return string;
        }
        return string + " (" + BufferedImageUtilities.typeName(n2) + ")";
    }

    public static String transferTypeName(int n) {
        if (n < 0 || n >= bufferTypeNames.length) {
            return "UNKNOWN";
        }
        return bufferTypeNames[n];
    }

    public static String typeName(ColorSpace colorSpace) {
        if (colorSpace == null) {
            return "NULL";
        }
        int n = colorSpace.getType();
        if (n < 0 || n >= spaceTypeNames.length) {
            return "UNKNOWN";
        }
        if (n >= spaceTypeNames.length) {
            return String.valueOf(n - 10) + "-color space";
        }
        return spaceTypeNames[n];
    }

    public static void describeImage(BufferedImage bufferedImage, PrintStream printStream) {
        printStream.print(BufferedImageUtilities.describeImage(bufferedImage));
    }

    public static String describeImage(BufferedImage bufferedImage) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bufferedImage == null) {
            stringBuffer.append("Image: null\n");
        } else {
            stringBuffer.append("Image: " + bufferedImage + "\n");
            stringBuffer.append("Image: width " + bufferedImage.getWidth() + "\n");
            stringBuffer.append("Image: height " + bufferedImage.getHeight() + "\n");
            stringBuffer.append(BufferedImageUtilities.describeRaster(bufferedImage.getRaster()));
            stringBuffer.append(BufferedImageUtilities.describeColorModel(bufferedImage.getColorModel()));
        }
        return stringBuffer.toString();
    }

    public static void describeRaster(Raster raster, PrintStream printStream) {
        printStream.print(BufferedImageUtilities.describeRaster(raster));
    }

    public static String describeRaster(Raster raster) {
        StringBuffer stringBuffer = new StringBuffer();
        if (raster == null) {
            stringBuffer.append("    **** Raster: null\n");
        } else {
            Object object;
            stringBuffer.append("    **** Raster: " + raster + "\n");
            stringBuffer.append("    **** Raster: " + raster.getClass().getName() + "\n");
            SampleModel sampleModel = raster.getSampleModel();
            if (sampleModel == null) {
                stringBuffer.append("    SampleModel: null\n");
            } else {
                stringBuffer.append("    SampleModel: " + sampleModel + "\n");
                stringBuffer.append("    SampleModel: " + sampleModel.getClass().getName() + " -- " + sampleModel.getNumDataElements() + " " + BufferedImageUtilities.transferTypeName(sampleModel.getTransferType()) + "s/pixel, " + sampleModel.getNumBands() + " bands");
                if (sampleModel instanceof ComponentSampleModel) {
                    int n;
                    object = (ComponentSampleModel)sampleModel;
                    stringBuffer.append(", pixel stride " + ((ComponentSampleModel)object).getPixelStride());
                    stringBuffer.append(", scanline stride " + ((ComponentSampleModel)object).getScanlineStride());
                    stringBuffer.append(", bank indices [");
                    int[] nArray = ((ComponentSampleModel)object).getBankIndices();
                    for (n = 0; n < nArray.length; ++n) {
                        if (n > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(nArray[n]);
                    }
                    stringBuffer.append("]");
                    stringBuffer.append(", band offsets [");
                    nArray = ((ComponentSampleModel)object).getBandOffsets();
                    for (n = 0; n < nArray.length; ++n) {
                        if (n > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(nArray[n]);
                    }
                    stringBuffer.append("]");
                }
                stringBuffer.append("\n");
            }
            object = raster.getDataBuffer();
            if (object == null) {
                stringBuffer.append("     DataBuffer: null\n");
            } else {
                stringBuffer.append("     DataBuffer: " + object + "\n");
                stringBuffer.append("     DataBuffer: " + object.getClass().getName() + " -- " + ((DataBuffer)object).getNumBanks() + " " + BufferedImageUtilities.transferTypeName(((DataBuffer)object).getDataType()) + " banks\n");
            }
        }
        return stringBuffer.toString();
    }

    public static void describeColorModel(ColorModel colorModel, PrintStream printStream) {
        printStream.print(BufferedImageUtilities.describeColorModel(colorModel));
    }

    public static String describeColorModel(ColorModel colorModel) {
        StringBuffer stringBuffer = new StringBuffer();
        if (colorModel == null) {
            stringBuffer.append("     ColorModel: null\n");
        } else {
            stringBuffer.append("     ColorModel: =" + colorModel + "\n");
            ColorSpace colorSpace = colorModel.getColorSpace();
            String string = "no alpha";
            if (colorModel.hasAlpha()) {
                string = colorModel.isAlphaPremultiplied() ? "premult-alpha" : "alpha";
            }
            int n = colorModel.getNumComponents();
            int n2 = colorModel.getNumColorComponents();
            String string2 = String.valueOf(n2);
            if (n != n2) {
                string2 = String.valueOf(n2) + ":" + n;
            }
            stringBuffer.append("     ColorModel: " + colorModel.getClass().getName() + " -- " + colorModel.getPixelSize() + " bits/" + string2 + "-part " + BufferedImageUtilities.transferTypeName(colorModel.getTransferType()) + " pixel, " + string + "\n");
            stringBuffer.append("     ColorSpace: " + colorSpace.getClass().getName() + " -- " + BufferedImageUtilities.typeName(colorSpace) + " space\n");
        }
        return stringBuffer.toString();
    }

    public static GraphicsConfiguration getDefaultGraphicsConfiguration() {
        return defaultGraphicsConfiguration;
    }

    private static GraphicsConfiguration initializeGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration = null;
        if (System.getProperty("java.awt.headless", "false").equals("false")) {
            try {
                graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
            catch (HeadlessException headlessException) {
                slf4jlogger.error("", headlessException);
            }
        }
        return graphicsConfiguration;
    }

    public static ColorModel getMostFavorableColorModel() {
        return mostFavorableColorModel;
    }

    private static ColorModel initializeMostFavorableColorModel() {
        ColorModel colorModel = null;
        GraphicsConfiguration graphicsConfiguration = BufferedImageUtilities.getDefaultGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            colorModel = graphicsConfiguration.getColorModel();
        }
        if (colorModel == null) {
            slf4jlogger.debug("initializeMostFavorableColorModel(): no model from getLocalGraphicsEnvironment; perhaps headless");
            if (System.getProperty("os.name", "").equals("Mac OS X")) {
                slf4jlogger.debug("initializeMostFavorableColorModel(): on Mac OS X, so assume 32 bit ARGB");
                colorModel = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
            } else {
                slf4jlogger.debug("initializeMostFavorableColorModel(): not on Mac OS X, so assume  24 bit RGB");
                colorModel = new DirectColorModel(ColorSpace.getInstance(1000), 24, 0xFF0000, 65280, 255, 0, false, 3);
            }
        }
        slf4jlogger.debug("initializeMostFavorableColorModel():");
        return colorModel;
    }

    public static final BufferedImage convertToMostFavorableImageTypeWithPixelCopy(BufferedImage bufferedImage) {
        slf4jlogger.debug("convertToMostFavorableImageTypeWithPixelCopy(): start");
        long l = System.currentTimeMillis();
        ColorModel colorModel = BufferedImageUtilities.getMostFavorableColorModel();
        if (colorModel == null) {
            slf4jlogger.info("convertToMostFavorableImageTypeWithPixelCopy(): no mostFavorableColorModel - doing nothing");
            return bufferedImage;
        }
        ColorModel colorModel2 = bufferedImage.getColorModel();
        if (colorModel.equals(colorModel2)) {
            slf4jlogger.info("convertToMostFavorableImageTypeWithPixelCopy(): already mostFavorableColorModel - doing nothing");
            return bufferedImage;
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        SampleModel sampleModel = bufferedImage.getSampleModel();
        if (sampleModel instanceof MultiPixelPackedSampleModel) {
            slf4jlogger.debug("convertToMostFavorableImageTypeWithPixelCopy(): not attempting to convert MultiPixelPackedSampleModel this way");
            return null;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n3 = writableRaster.getNumBands();
        slf4jlogger.debug("convertToMostFavorableImageTypeWithPixelCopy(): srcImage ={}", bufferedImage);
        slf4jlogger.debug("convertToMostFavorableImageTypeWithPixelCopy(): srcSampleModel ={}", sampleModel);
        if (sampleModel instanceof ComponentSampleModel) {
            slf4jlogger.debug("convertToMostFavorableImageTypeWithPixelCopy(): srcSampleModel.getPixelStride() ={}", ((ComponentSampleModel)sampleModel).getPixelStride());
        } else {
            slf4jlogger.info("convertToMostFavorableImageTypeWithPixelCopy(): srcSampleModel is not ComponentSampleModel but is {}", sampleModel.getClass().getName());
        }
        WritableRaster writableRaster2 = colorModel.createCompatibleWritableRaster(n, n2);
        DataBuffer dataBuffer2 = writableRaster2.getDataBuffer();
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster2, colorModel.isAlphaPremultiplied(), null);
        SampleModel sampleModel2 = bufferedImage2.getSampleModel();
        int n4 = writableRaster2.getNumBands();
        slf4jlogger.debug("convertToMostFavorableImageTypeWithPixelCopy(): dstImage ={}", bufferedImage2);
        slf4jlogger.debug("convertToMostFavorableImageTypeWithPixelCopy(): dstSampleModel ={}", sampleModel2);
        int[] nArray = null;
        nArray = sampleModel.getPixels(0, 0, n, n2, nArray, dataBuffer);
        int n5 = nArray.length;
        int[] nArray2 = null;
        nArray2 = sampleModel2.getPixels(0, 0, n, n2, nArray2, dataBuffer2);
        int n6 = nArray2.length;
        slf4jlogger.debug("convertToMostFavorableImageTypeWithPixelCopy() after getPixels, elapsed: {} ms", System.currentTimeMillis() - l);
        if (n3 == 1 && n4 == 4 && n5 * 4 == n6) {
            slf4jlogger.debug("convertToMostFavorableImageTypeWithPixelCopy(): converting gray to RGBA");
            int n7 = 0;
            for (int i = 0; i < n5; ++i) {
                nArray2[n7++] = nArray[i];
                nArray2[n7++] = nArray[i];
                nArray2[n7++] = nArray[i];
                nArray2[n7++] = -1;
            }
            sampleModel2.setPixels(0, 0, n, n2, nArray2, dataBuffer2);
        } else if (n3 == 1 && n4 == 3 && n5 * 3 == n6) {
            slf4jlogger.debug("convertToMostFavorableImageTypeWithPixelCopy(): converting gray to RGB");
            int n8 = 0;
            for (int i = 0; i < n5; ++i) {
                nArray2[n8++] = nArray[i];
                nArray2[n8++] = nArray[i];
                nArray2[n8++] = nArray[i];
            }
            sampleModel2.setPixels(0, 0, n, n2, nArray2, dataBuffer2);
        } else if (n3 == 3 && n4 == 4 && n5 * 4 == n6 * 3) {
            slf4jlogger.debug("convertToMostFavorableImageTypeWithPixelCopy(): converting pixel or band interleaved 3 band to RGBA");
            int n9 = 0;
            int n10 = 0;
            while (n10 < n5) {
                nArray2[n9++] = nArray[n10++];
                nArray2[n9++] = nArray[n10++];
                nArray2[n9++] = nArray[n10++];
                nArray2[n9++] = -1;
            }
            sampleModel2.setPixels(0, 0, n, n2, nArray2, dataBuffer2);
        } else if (n3 == 3 && n4 == 3 && n5 == n6) {
            slf4jlogger.debug("convertToMostFavorableImageTypeWithPixelCopy(): converting pixel or band interleaved 3 band to RGB");
            int n11 = 0;
            int n12 = 0;
            while (n12 < n5) {
                nArray2[n11++] = nArray[n12++];
                nArray2[n11++] = nArray[n12++];
                nArray2[n11++] = nArray[n12++];
            }
            sampleModel2.setPixels(0, 0, n, n2, nArray2, dataBuffer2);
        } else {
            slf4jlogger.info("convertToMostFavorableImageTypeWithPixelCopy(): No conversion supported");
            bufferedImage2 = bufferedImage;
        }
        slf4jlogger.debug("convertToMostFavorableImageTypeWithPixelCopy() elapsed: {} ms", System.currentTimeMillis() - l);
        slf4jlogger.debug("convertToMostFavorableImageTypeWithPixelCopy(): done = {}", bufferedImage2);
        return bufferedImage2;
    }

    public static final BufferedImage convertToMostFavorableImageTypeWithDataBufferCopy(BufferedImage bufferedImage) {
        int n;
        int n2;
        Object object;
        int n3;
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): start");
        long l = System.currentTimeMillis();
        ColorModel colorModel = BufferedImageUtilities.getMostFavorableColorModel();
        if (colorModel == null) {
            slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): no mostFavorableColorModel - doing nothing");
            return bufferedImage;
        }
        ColorModel colorModel2 = bufferedImage.getColorModel();
        if (colorModel.equals(colorModel2)) {
            slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): already mostFavorableColorModel - doing nothing");
            return bufferedImage;
        }
        int n4 = colorModel2.getNumComponents();
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): dstColorModelNumComponents = {}", n4);
        int n5 = colorModel.getNumComponents();
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): dstColorModelNumComponents = {}", n5);
        if (n4 != n5) {
            return null;
        }
        if (slf4jlogger.isDebugEnabled()) {
            ColorSpace colorSpace = colorModel2.getColorSpace();
            slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): srcColorSpace = {}", colorSpace);
            n3 = colorSpace.getType();
            slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): srcColorSpaceType = {}", n3);
            object = colorModel.getColorSpace();
            slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): dstColorSpace = {}", object);
            n2 = ((ColorSpace)object).getType();
            slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): dstColorSpaceType = {}", n2);
        }
        int n6 = bufferedImage.getWidth();
        n3 = bufferedImage.getHeight();
        object = bufferedImage.getSampleModel();
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): srcSampleModel = {}", object);
        n2 = ((SampleModel)object).getDataType();
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): srcDataType = {}", n2);
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n7 = dataBuffer.getDataType();
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): srcDataBufferType = {}", n7);
        int n8 = writableRaster.getNumBands();
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): srcNumBands = {}", n8);
        int n9 = n8;
        int n10 = n6 * n8;
        if (object instanceof ComponentSampleModel) {
            slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): srcSampleModel is instanceof ComponentSampleModel");
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)object;
            n9 = componentSampleModel.getPixelStride();
            n10 = componentSampleModel.getScanlineStride();
        }
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): srcPixelStride = {}", n9);
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): srcScanlineStride = {}", n10);
        int n11 = dataBuffer.getOffset();
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): srcDataBufferOffset = {}", n11);
        int n12 = n3 * n6 * n8;
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): srcFrameLength = {}", n12);
        int n13 = dataBuffer.getNumBanks();
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): srcDataBufferNumBanks = {}", n13);
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy() before creating dstRaster - elapsed: {} ms", System.currentTimeMillis() - l);
        WritableRaster writableRaster2 = colorModel.createCompatibleWritableRaster(n6, n3);
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy() before creating dstImage - elapsed: {} ms", System.currentTimeMillis() - l);
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster2, colorModel.isAlphaPremultiplied(), null);
        SampleModel sampleModel = bufferedImage2.getSampleModel();
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): dstSampleModel = {}", sampleModel);
        int n14 = sampleModel.getDataType();
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): dstDataType = {}", n14);
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy() before getting dstDataBuffer - elapsed: {} ms", System.currentTimeMillis() - l);
        DataBuffer dataBuffer2 = writableRaster2.getDataBuffer();
        int n15 = dataBuffer2.getDataType();
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): dstDataBufferType = {}", n15);
        int n16 = n = writableRaster2.getNumBands();
        int n17 = n6 * n;
        if (sampleModel instanceof ComponentSampleModel) {
            slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): dstSampleModel is instanceof ComponentSampleModel");
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            n16 = componentSampleModel.getPixelStride();
            n17 = componentSampleModel.getScanlineStride();
        }
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): dstPixelStride = {}", n16);
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): dstScanlineStride = {}", n17);
        int n18 = dataBuffer2.getOffset();
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): dstDataBufferOffset = {}", n18);
        int n19 = n3 * n6 * n;
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): dstFrameLength = {}", n19);
        int n20 = dataBuffer2.getNumBanks();
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): dstDataBufferNumBanks = {}", n20);
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy() before attempting copy - elapsed: {} ms", System.currentTimeMillis() - l);
        if (n13 == 1 && n20 == 1 && object instanceof ComponentSampleModel && sampleModel instanceof SinglePixelPackedSampleModel && n7 == 0 && n15 == 3 && dataBuffer instanceof DataBufferByte && dataBuffer2 instanceof DataBufferInt && n9 == n8 && n8 == n) {
            slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): converting {} band interleaved byte ComponentSampleModel to {} band int SinglePixelPackedSampleModel", n8, n);
            byte[][] byArray = ((DataBufferByte)dataBuffer).getBankData();
            byte[] byArray2 = byArray[0];
            int n21 = byArray2.length;
            slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): srcPixelBankLength = {}", n21);
            int[][] nArray = ((DataBufferInt)dataBuffer2).getBankData();
            int[] nArray2 = nArray[0];
            int n22 = nArray2.length;
            slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): dstPixelBankLength = {}", n22);
            int[] nArray3 = ((SinglePixelPackedSampleModel)sampleModel).getBitMasks();
            int[] nArray4 = ((SinglePixelPackedSampleModel)sampleModel).getBitOffsets();
            int n23 = n11;
            int n24 = n18;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n6; ++j) {
                    for (int k = 0; k < n8; ++k) {
                        nArray2[n24] = nArray2[n24] | byArray2[n23++] << nArray4[k] & nArray3[k];
                    }
                    ++n24;
                }
            }
        } else {
            bufferedImage2 = null;
        }
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy() elapsed: {} ms", System.currentTimeMillis() - l);
        slf4jlogger.debug("convertToMostFavorableImageTypeWithDataBufferCopy(): done = {}", bufferedImage2);
        return bufferedImage2;
    }

    public static final BufferedImage convertToMostFavorableImageTypeWithBandCombineOp(BufferedImage bufferedImage) {
        Object object;
        slf4jlogger.debug("convertToMostFavorableImageTypeWithBandCombineOp(): start");
        long l = System.currentTimeMillis();
        ColorModel colorModel = BufferedImageUtilities.getMostFavorableColorModel();
        if (colorModel == null) {
            slf4jlogger.debug("convertToMostFavorableImageTypeWithBandCombineOp(): no mostFavorableColorModel - doing nothing");
            return bufferedImage;
        }
        int n = colorModel.getNumComponents();
        int n2 = bufferedImage.getRaster().getNumBands();
        Object object2 = null;
        if (colorModel.getNumComponents() == 4) {
            if (n2 == 1) {
                object = new float[][]{{1.0f, 0.0f}, {1.0f, 0.0f}, {1.0f, 0.0f}, {0.0f, 65535.0f}};
                object2 = object;
            } else if (n2 == 3) {
                object = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 65535.0f}};
                object2 = object;
            }
        } else if (colorModel.getNumComponents() == 3) {
            if (n2 == 1) {
                object = new float[][]{{1.0f, 0.0f}, {1.0f, 0.0f}, {1.0f, 0.0f}};
                object2 = object;
            } else if (n2 == 3) {
                object = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 0.0f}};
                object2 = object;
            }
        } else {
            slf4jlogger.debug("convertToMostFavorableImageTypeWithBandCombineOp(): mostFavorableColorModel does not have 4 components - doing nothing");
            return null;
        }
        object = new BandCombineOp((float[][])object2, null);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight());
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        ((BandCombineOp)object).filter(bufferedImage.getRaster(), writableRaster);
        slf4jlogger.debug("convertToMostFavorableImageTypeWithBandCombineOp() elapsed: {} ms", System.currentTimeMillis() - l);
        slf4jlogger.debug("convertToMostFavorableImageTypeWithBandCombineOp(): done = {}", bufferedImage2);
        return bufferedImage2;
    }

    public static final BufferedImage convertToMostFavorableImageTypeWithGraphicsDraw(BufferedImage bufferedImage) {
        slf4jlogger.debug("convertToMostFavorableImageTypeWithGraphicsDraw(): start");
        long l = System.currentTimeMillis();
        BufferedImage bufferedImage2 = null;
        GraphicsConfiguration graphicsConfiguration = BufferedImageUtilities.getDefaultGraphicsConfiguration();
        slf4jlogger.debug("convertToMostFavorableImageTypeWithGraphicsDraw(): graphicsConfiguration = {}", graphicsConfiguration);
        if (graphicsConfiguration != null && (bufferedImage2 = graphicsConfiguration.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight())) != null) {
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
        }
        slf4jlogger.debug("convertToMostFavorableImageTypeWithGraphicsDraw() elapsed: {} ms", System.currentTimeMillis() - l);
        slf4jlogger.debug("convertToMostFavorableImageTypeWithGraphicsDraw(): done = {}", bufferedImage2);
        return bufferedImage2;
    }

    public static final BufferedImage convertToMostFavorableImageType(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = null;
        if (bufferedImage.getColorModel().equals(BufferedImageUtilities.getMostFavorableColorModel())) {
            slf4jlogger.debug("convertToMostFavorableImageType(): do nothing since same ColorModel");
            bufferedImage2 = bufferedImage;
        } else {
            bufferedImage2 = BufferedImageUtilities.convertToMostFavorableImageTypeWithDataBufferCopy(bufferedImage);
            if (bufferedImage2 == null) {
                slf4jlogger.debug("convertToMostFavorableImageType(): convertToMostFavorableImageTypeWithDataBufferCopy failed");
                bufferedImage2 = BufferedImageUtilities.convertToMostFavorableImageTypeWithPixelCopy(bufferedImage);
            }
            if (bufferedImage2 == null) {
                slf4jlogger.debug("convertToMostFavorableImageType(): convertToMostFavorableImageTypeWithPixelCopy failed");
                bufferedImage2 = BufferedImageUtilities.convertToMostFavorableImageTypeWithGraphicsDraw(bufferedImage);
            }
            if (bufferedImage2 == null) {
                slf4jlogger.debug("convertToMostFavorableImageType(): convertToMostFavorableImageTypeWithGraphicsDraw failed");
                slf4jlogger.debug("convertToMostFavorableImageType(): returning srcImage");
                bufferedImage2 = bufferedImage;
            }
        }
        return bufferedImage2;
    }

    public static final BufferedImage convertToThreeChannelImageTypeIfFour(BufferedImage bufferedImage) {
        slf4jlogger.debug("convertToThreeChannelImageType(): start");
        long l = System.currentTimeMillis();
        int n = bufferedImage.getRaster().getNumBands();
        if (n != 4) {
            return bufferedImage;
        }
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
        float[][] fArrayArray = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 0.0f}};
        BandCombineOp bandCombineOp = new BandCombineOp(fArrayArray, null);
        WritableRaster writableRaster = ((ColorModel)componentColorModel).createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight());
        BufferedImage bufferedImage2 = new BufferedImage(componentColorModel, writableRaster, componentColorModel.isAlphaPremultiplied(), null);
        bandCombineOp.filter(bufferedImage.getRaster(), writableRaster);
        slf4jlogger.debug("convertToThreeChannelImageType() elapsed: {} ms", System.currentTimeMillis() - l);
        slf4jlogger.debug("convertToThreeChannelImageType(): done");
        return bufferedImage2;
    }

    public final BufferedImage resample(BufferedImage bufferedImage, int n, int n2, boolean bl, int n3) {
        return this.resample(bufferedImage, bufferedImage.getWidth(), bufferedImage.getHeight(), 0, 0, n, n2, bl, n3);
    }

    public final BufferedImage resample(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7) {
        int n8 = bufferedImage.getWidth();
        int n9 = bufferedImage.getHeight();
        slf4jlogger.debug("resample():");
        slf4jlogger.debug("resample(): srcWidth = {}", n8);
        slf4jlogger.debug("resample(): srcHeight = {}", n9);
        slf4jlogger.debug("resample(): selectionWidth = {}", n);
        slf4jlogger.debug("resample(): selectionHeight = {}", n2);
        slf4jlogger.debug("resample(): selectionXOffset = {}", n3);
        slf4jlogger.debug("resample(): selectionYOffset = {}", n4);
        slf4jlogger.debug("resample(): dstWidth = {}", n5);
        slf4jlogger.debug("resample(): dstHeight = {}", n6);
        slf4jlogger.debug("resample(): signed = {}", bl);
        if (n8 == n5 && n9 == n6 && n == n8 && n2 == n6 && n3 == 0 && n4 == 0) {
            return bufferedImage;
        }
        slf4jlogger.debug("resample(): start");
        long l = System.currentTimeMillis();
        ColorModel colorModel = bufferedImage.getColorModel();
        slf4jlogger.debug("resample(): srcColorModel.getPixelSize() = {}", colorModel.getPixelSize());
        SampleModel sampleModel = bufferedImage.getSampleModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n10 = dataBuffer.getOffset();
        slf4jlogger.debug("resample(): srcDataBuffer is {}", dataBuffer.getClass().getName());
        slf4jlogger.debug("resample(): srcDataBuffer.getOffset() is {}", n10);
        int n11 = writableRaster.getNumBands();
        slf4jlogger.debug("resample(): srcNumBands = {}", n11);
        if (n11 != 1 || !(dataBuffer instanceof DataBufferUShort) && !(dataBuffer instanceof DataBufferByte) && !(dataBuffer instanceof DataBufferFloat) && !(dataBuffer instanceof DataBufferDouble) || colorModel.getPixelSize() == 1) {
            slf4jlogger.debug("resample(): not doing our own resampling");
            slf4jlogger.debug("resample(): before resampleWithGraphicsDraw elapsed = {} ms", System.currentTimeMillis() - l);
            BufferedImage bufferedImage2 = null;
            try {
                bufferedImage2 = this.resampleWithGraphicsDraw(bufferedImage, n, n2, n3, n4, n5, n6);
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
                bufferedImage2 = null;
            }
            slf4jlogger.debug("resample(): after resampleWithGraphicsDraw elapsed = {} ms", System.currentTimeMillis() - l);
            return bufferedImage2;
        }
        BufferedImage bufferedImage3 = null;
        slf4jlogger.debug("resample(): hVector");
        ResamplingVector resamplingVector = new ResamplingVector(n, n5);
        slf4jlogger.debug("resample(): vVector");
        ResamplingVector resamplingVector2 = new ResamplingVector(n2, n6);
        int n12 = 0;
        int n13 = n8 - 1;
        slf4jlogger.debug("resample(): leftSideLimit = {}", n12);
        slf4jlogger.debug("resample(): rightSideLimit = {}", n13);
        int n14 = n4 < 0 ? -n4 : 0;
        int n15 = n14 + n9 - 1;
        slf4jlogger.debug("resample(): topSideLimit = {}", n14);
        slf4jlogger.debug("resample(): bottomSideLimit = {}", n15);
        if (dataBuffer instanceof DataBufferUShort) {
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            int[] nArray;
            slf4jlogger.debug("resample(): DataBufferUShort");
            ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{16}, false, false, 1, 1);
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(1, n5, n6, 1, n5, new int[]{0});
            slf4jlogger.debug("resample(): got info = {} ms", System.currentTimeMillis() - l);
            int n23 = bl ? -1 : 65535;
            short[] sArray = ((DataBufferUShort)dataBuffer).getData();
            int n24 = sArray.length;
            slf4jlogger.debug("resample(): got srcPixels = {} ms", System.currentTimeMillis() - l);
            int n25 = n5 * n6;
            short[] sArray2 = new short[n25];
            slf4jlogger.debug("resample(): got dstPixels = {} ms", System.currentTimeMillis() - l);
            slf4jlogger.debug("resample(): single band");
            slf4jlogger.debug("resample(): single band = {} ms", System.currentTimeMillis() - l);
            int[] nArray2 = new int[n2 * n5];
            int[] nArray3 = new int[n2];
            int n26 = n10;
            int n27 = 0;
            int n28 = 0;
            slf4jlogger.debug("resample(): srcPixelOffset = {}", n26 += n4 * n8);
            int n29 = 0;
            while (n29 < n2) {
                nArray3[n29] = n28;
                n28 += n5;
                for (int i = 0; i < n5; ++i) {
                    nArray = resamplingVector.arrayOfSrcIndices[i];
                    int[] nArray4 = resamplingVector.arrayOfWeights[i];
                    n22 = resamplingVector.sumOfWeights[i];
                    n21 = resamplingVector.numberOfEntries[i];
                    n20 = 0;
                    for (n19 = 0; n19 < n21; ++n19) {
                        n18 = nArray[n19] + n3;
                        n17 = nArray4[n19];
                        if (n18 >= n12 && n18 <= n13) {
                            n16 = n26 + n18;
                            if (n16 <= 0 || n16 >= n24) continue;
                            n20 += (sArray[n16] & n23) * n17;
                            continue;
                        }
                        n20 += n7 * n17;
                    }
                    nArray2[n27++] = n20 / n22;
                }
                ++n29;
                n26 += n8;
            }
            for (n29 = 0; n29 < n6; ++n29) {
                int[] nArray5 = resamplingVector2.arrayOfSrcIndices[n29];
                nArray = resamplingVector2.arrayOfWeights[n29];
                int n30 = resamplingVector2.sumOfWeights[n29];
                n22 = resamplingVector2.numberOfEntries[n29];
                n21 = n29 * n5;
                for (n20 = 0; n20 < n5; ++n20) {
                    n19 = 0;
                    for (n18 = 0; n18 < n22; ++n18) {
                        n17 = nArray5[n18];
                        n16 = nArray[n18];
                        if (n17 >= n14 && n17 <= n15) {
                            n19 += nArray2[nArray3[n17] + n20] * n16;
                            continue;
                        }
                        n19 += n7 * n16;
                    }
                    sArray2[n21 + n20] = (short)(n19 / n30);
                }
            }
            slf4jlogger.debug("resample(): done with pixel copy = {} ms", System.currentTimeMillis() - l);
            DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray2, n5, 0);
            WritableRaster writableRaster2 = Raster.createWritableRaster(componentSampleModel, dataBufferUShort, new Point(0, 0));
            bufferedImage3 = new BufferedImage(componentColorModel, writableRaster2, true, null);
            slf4jlogger.debug("resample(): done with creating dstImage = {} ms", System.currentTimeMillis() - l);
        } else if (dataBuffer instanceof DataBufferByte) {
            int n31;
            int n32;
            int n33;
            int n34;
            int n35;
            int n36;
            int n37;
            int[] nArray;
            slf4jlogger.debug("resample(): DataBufferByte");
            ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, n5, n6, 1, n5, new int[]{0});
            slf4jlogger.debug("resample(): got info = {} ms", System.currentTimeMillis() - l);
            int n38 = bl ? -1 : 255;
            byte[] byArray = ((DataBufferByte)dataBuffer).getData();
            int n39 = byArray.length;
            slf4jlogger.debug("resample(): got srcPixels = {} ms", System.currentTimeMillis() - l);
            int n40 = n5 * n6;
            byte[] byArray2 = new byte[n40];
            slf4jlogger.debug("resample(): got dstPixels = {} ms", System.currentTimeMillis() - l);
            slf4jlogger.debug("resample(): single band");
            slf4jlogger.debug("resample(): single band = {} ms", System.currentTimeMillis() - l);
            int[] nArray6 = new int[n2 * n5];
            int[] nArray7 = new int[n2];
            int n41 = n10;
            int n42 = 0;
            int n43 = 0;
            n41 += n4 * n8;
            int n44 = 0;
            while (n44 < n2) {
                nArray7[n44] = n43;
                n43 += n5;
                for (int i = 0; i < n5; ++i) {
                    nArray = resamplingVector.arrayOfSrcIndices[i];
                    int[] nArray8 = resamplingVector.arrayOfWeights[i];
                    n37 = resamplingVector.sumOfWeights[i];
                    n36 = resamplingVector.numberOfEntries[i];
                    n35 = 0;
                    for (n34 = 0; n34 < n36; ++n34) {
                        n33 = nArray[n34] + n3;
                        slf4jlogger.trace("resample(): srcX = {}", n33);
                        n32 = nArray8[n34];
                        if (n33 >= n12 && n33 <= n13) {
                            n31 = n41 + n33;
                            if (n31 <= 0 || n31 >= n39) continue;
                            n35 += (byArray[n31] & n38) * n32;
                            continue;
                        }
                        n35 += n7 * n32;
                    }
                    nArray6[n42++] = n35 / n37;
                }
                ++n44;
                n41 += n8;
            }
            for (n44 = 0; n44 < n6; ++n44) {
                int[] nArray9 = resamplingVector2.arrayOfSrcIndices[n44];
                nArray = resamplingVector2.arrayOfWeights[n44];
                int n45 = resamplingVector2.sumOfWeights[n44];
                n37 = resamplingVector2.numberOfEntries[n44];
                n36 = n44 * n5;
                for (n35 = 0; n35 < n5; ++n35) {
                    n34 = 0;
                    for (n33 = 0; n33 < n37; ++n33) {
                        n32 = nArray9[n33];
                        n31 = nArray[n33];
                        if (n32 >= n14 && n32 <= n15) {
                            n34 += nArray6[nArray7[n32] + n35] * n31;
                            continue;
                        }
                        n34 += n7 * n31;
                    }
                    byArray2[n36 + n35] = (byte)(n34 / n45);
                }
            }
            slf4jlogger.debug("resample(): done with pixel copy = {} ms", System.currentTimeMillis() - l);
            DataBufferByte dataBufferByte = new DataBufferByte(byArray2, n5, 0);
            WritableRaster writableRaster3 = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
            bufferedImage3 = new BufferedImage(componentColorModel, writableRaster3, true, null);
            slf4jlogger.debug("resample(): done with creating dstImage = {} ms", System.currentTimeMillis() - l);
        } else if (dataBuffer instanceof DataBufferFloat) {
            int n46;
            int n47;
            int n48;
            int n49;
            int n50;
            int[] nArray;
            slf4jlogger.debug("resample(): DataBufferFloat");
            ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 4);
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(4, n5, n6, 1, n5, new int[]{0});
            slf4jlogger.debug("resample(): got info = {} ms", System.currentTimeMillis() - l);
            float[] fArray = ((DataBufferFloat)dataBuffer).getData();
            int n51 = fArray.length;
            slf4jlogger.debug("resample(): got srcPixels = {} ms", System.currentTimeMillis() - l);
            int n52 = n5 * n6;
            float[] fArray2 = new float[n52];
            slf4jlogger.debug("resample(): got dstPixels = {} ms", System.currentTimeMillis() - l);
            slf4jlogger.debug("resample(): single band");
            slf4jlogger.debug("resample(): single band = {} ms", System.currentTimeMillis() - l);
            float[] fArray3 = new float[n2 * n5];
            int[] nArray10 = new int[n2];
            int n53 = n10;
            int n54 = 0;
            int n55 = 0;
            slf4jlogger.debug("resample(): srcPixelOffset = {}", n53 += n4 * n8);
            int n56 = 0;
            while (n56 < n2) {
                nArray10[n56] = n55;
                n55 += n5;
                for (int i = 0; i < n5; ++i) {
                    nArray = resamplingVector.arrayOfSrcIndices[i];
                    int[] nArray11 = resamplingVector.arrayOfWeights[i];
                    n50 = resamplingVector.sumOfWeights[i];
                    n49 = resamplingVector.numberOfEntries[i];
                    float f = 0.0f;
                    for (int j = 0; j < n49; ++j) {
                        n48 = nArray[j] + n3;
                        n47 = nArray11[j];
                        if (n48 >= n12 && n48 <= n13) {
                            n46 = n53 + n48;
                            if (n46 <= 0 || n46 >= n51) continue;
                            slf4jlogger.trace("resample(): srcIndex = {} srcPixels[srcIndex] = {} weightX = {} dstPixel now = {}", n46, Float.valueOf(fArray[n46]), n47, Float.valueOf(f += fArray[n46] * (float)n47));
                            continue;
                        }
                        slf4jlogger.trace("resample(): backgroundValue = {} weightX = {} dstPixel now = {}", n7, n47, Float.valueOf(f += (float)(n7 * n47)));
                    }
                    slf4jlogger.trace("resample(): dstPixelOffset = {} dstRowBuffers[dstPixelOffset] was = {} dstPixel = {} sumOfWeights = {} replacing dstRowBuffers[dstPixelOffset] with dstPixel/sumOfWeights = {}", n54, Float.valueOf(fArray3[n54]), Float.valueOf(f), n50, Float.valueOf(f / (float)n50));
                    fArray3[n54++] = f / (float)n50;
                }
                ++n56;
                n53 += n8;
            }
            for (n56 = 0; n56 < n6; ++n56) {
                int[] nArray12 = resamplingVector2.arrayOfSrcIndices[n56];
                nArray = resamplingVector2.arrayOfWeights[n56];
                int n57 = resamplingVector2.sumOfWeights[n56];
                n50 = resamplingVector2.numberOfEntries[n56];
                n49 = n56 * n5;
                for (int i = 0; i < n5; ++i) {
                    float f = 0.0f;
                    for (n48 = 0; n48 < n50; ++n48) {
                        n47 = nArray12[n48];
                        n46 = nArray[n48];
                        if (n47 >= n14 && n47 <= n15) {
                            slf4jlogger.trace("resample(): srcY = {} bufferRowIndex[srcY] = {} dstX = {} dstRowBuffers[bufferRowIndex[srcY]+dstX] = {} weightY = {} dstPixel now = {}", n47, nArray10[n47], i, Float.valueOf(fArray3[nArray10[n47] + i]), n46, Float.valueOf(f += fArray3[nArray10[n47] + i] * (float)n46));
                            continue;
                        }
                        slf4jlogger.trace("resample(): backgroundValue = {} weightY = {} dstPixel now = {}", n7, n46, Float.valueOf(f += (float)(n7 * n46)));
                    }
                    fArray2[n49 + i] = f / (float)n57;
                    slf4jlogger.trace("resample(): pixelOffset = {} dstX = {} dstPixel = {} sumOfWeights = {} replacing dstPixels[pixelOffset+dstX] with dstPixel/sumOfWeights = {}", n49, i, Float.valueOf(f), n57, Float.valueOf(fArray2[n49 + i]));
                }
            }
            slf4jlogger.debug("resample(): done with pixel copy = {} ms", System.currentTimeMillis() - l);
            DataBufferFloat dataBufferFloat = new DataBufferFloat(fArray2, n5, 0);
            WritableRaster writableRaster4 = Raster.createWritableRaster(componentSampleModel, dataBufferFloat, new Point(0, 0));
            bufferedImage3 = new BufferedImage(componentColorModel, writableRaster4, true, null);
            slf4jlogger.debug("resample(): done with creating dstImage = {} ms", System.currentTimeMillis() - l);
        } else if (dataBuffer instanceof DataBufferDouble) {
            int n58;
            int n59;
            int n60;
            int n61;
            int n62;
            int[] nArray;
            slf4jlogger.debug("resample(): DataBufferDouble");
            ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 5);
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(5, n5, n6, 1, n5, new int[]{0});
            slf4jlogger.debug("resample(): got info = {} ms", System.currentTimeMillis() - l);
            double[] dArray = ((DataBufferDouble)dataBuffer).getData();
            int n63 = dArray.length;
            slf4jlogger.debug("resample(): got srcPixels = {} ms", System.currentTimeMillis() - l);
            int n64 = n5 * n6;
            double[] dArray2 = new double[n64];
            slf4jlogger.debug("resample(): got dstPixels = {} ms", System.currentTimeMillis() - l);
            slf4jlogger.debug("resample(): single band");
            slf4jlogger.debug("resample(): single band = {} ms", System.currentTimeMillis() - l);
            double[] dArray3 = new double[n2 * n5];
            int[] nArray13 = new int[n2];
            int n65 = n10;
            int n66 = 0;
            int n67 = 0;
            slf4jlogger.debug("resample(): srcPixelOffset = {}", n65 += n4 * n8);
            int n68 = 0;
            while (n68 < n2) {
                nArray13[n68] = n67;
                n67 += n5;
                for (int i = 0; i < n5; ++i) {
                    nArray = resamplingVector.arrayOfSrcIndices[i];
                    int[] nArray14 = resamplingVector.arrayOfWeights[i];
                    n62 = resamplingVector.sumOfWeights[i];
                    n61 = resamplingVector.numberOfEntries[i];
                    double d = 0.0;
                    for (int j = 0; j < n61; ++j) {
                        n60 = nArray[j] + n3;
                        n59 = nArray14[j];
                        if (n60 >= n12 && n60 <= n13) {
                            n58 = n65 + n60;
                            if (n58 <= 0 || n58 >= n63) continue;
                            d += dArray[n58] * (double)n59;
                            continue;
                        }
                        d += (double)(n7 * n59);
                    }
                    dArray3[n66++] = d / (double)n62;
                }
                ++n68;
                n65 += n8;
            }
            for (n68 = 0; n68 < n6; ++n68) {
                int[] nArray15 = resamplingVector2.arrayOfSrcIndices[n68];
                nArray = resamplingVector2.arrayOfWeights[n68];
                int n69 = resamplingVector2.sumOfWeights[n68];
                n62 = resamplingVector2.numberOfEntries[n68];
                n61 = n68 * n5;
                for (int i = 0; i < n5; ++i) {
                    double d = 0.0;
                    for (n60 = 0; n60 < n62; ++n60) {
                        n59 = nArray15[n60];
                        n58 = nArray[n60];
                        if (n59 >= n14 && n59 <= n15) {
                            d += dArray3[nArray13[n59] + i] * (double)n58;
                            continue;
                        }
                        d += (double)(n7 * n58);
                    }
                    dArray2[n61 + i] = d / (double)n69;
                }
            }
            slf4jlogger.debug("resample(): done with pixel copy = {} ms", System.currentTimeMillis() - l);
            DataBufferDouble dataBufferDouble = new DataBufferDouble(dArray2, n5, 0);
            WritableRaster writableRaster5 = Raster.createWritableRaster(componentSampleModel, dataBufferDouble, new Point(0, 0));
            bufferedImage3 = new BufferedImage(componentColorModel, writableRaster5, true, null);
            slf4jlogger.debug("resample(): done with creating dstImage = {} ms", System.currentTimeMillis() - l);
        }
        slf4jlogger.debug("resample() elapsed: " + (System.currentTimeMillis() - l) + " ms");
        return bufferedImage3;
    }

    public final BufferedImage resampleWithGraphicsDraw(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6) {
        slf4jlogger.debug("resampleWithGraphicsDraw(BufferedImage,int,int,int,int,int,int): start");
        long l = System.currentTimeMillis();
        BufferedImage bufferedImage2 = null;
        slf4jlogger.debug("resampleWithGraphicsDraw(BufferedImage,int,int,int,int,int,int): try source ColorModel");
        ColorModel colorModel = bufferedImage.getColorModel();
        bufferedImage2 = BufferedImageUtilities.resampleWithGraphicsDraw(bufferedImage, colorModel, n, n2, n3, n4, n5, n6);
        if (bufferedImage2 == null) {
            slf4jlogger.debug("resampleWithGraphicsDraw(BufferedImage,int,int,int,int,int,int): source ColorModel failed; try most favorable instead");
            colorModel = BufferedImageUtilities.getMostFavorableColorModel();
            bufferedImage2 = BufferedImageUtilities.resampleWithGraphicsDraw(bufferedImage, colorModel, n, n2, n3, n4, n5, n6);
        }
        slf4jlogger.debug("resampleWithGraphicsDraw(BufferedImage,int,int,int,int,int,int): done");
        slf4jlogger.debug("resampleWithGraphicsDraw() elapsed: " + (System.currentTimeMillis() - l) + " ms");
        return bufferedImage2;
    }

    private static final BufferedImage resampleWithGraphicsDraw(BufferedImage bufferedImage, ColorModel colorModel, int n, int n2, int n3, int n4, int n5, int n6) {
        WritableRaster writableRaster;
        slf4jlogger.debug("resampleWithGraphicsDraw(BufferedImage,ColorModel,int,int,int,int,int,int): start");
        BufferedImage bufferedImage2 = null;
        if (colorModel != null && (bufferedImage2 = new BufferedImage(colorModel, writableRaster = colorModel.createCompatibleWritableRaster(n5, n6), colorModel.isAlphaPremultiplied(), null)) != null) {
            try {
                BufferedImageUtilities.resampleWithGraphicsDraw(bufferedImage, bufferedImage2, n, n2, n3, n4, n5, n6);
            }
            catch (Exception exception) {
                bufferedImage2 = null;
            }
        }
        slf4jlogger.debug("resampleWithGraphicsDraw(BufferedImage,ColorModel,int,int,int,int,int,int): done");
        return bufferedImage2;
    }

    private static final void resampleWithGraphicsDraw(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        slf4jlogger.debug("resampleWithGraphicsDraw(BufferedImage,BufferedImage,int,int,int,int,int,int): start");
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        Object object = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
        slf4jlogger.debug("resampleWithGraphicsDraw(): renderingHintValue = {}", object);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
        int n8 = n3;
        int n9 = n4;
        int n10 = n3 + n - 1;
        int n11 = n4 + n2 - 1;
        int n12 = 0;
        int n13 = 0;
        int n14 = n5 - 1;
        int n15 = n6 - 1;
        slf4jlogger.debug("resampleWithGraphicsDraw(): requested sx1 = {}", n8);
        slf4jlogger.debug("resampleWithGraphicsDraw(): requested sy1 = {}", n9);
        slf4jlogger.debug("resampleWithGraphicsDraw(): requested sx2 = {}", n10);
        slf4jlogger.debug("resampleWithGraphicsDraw(): requested sy2 = {}", n11);
        slf4jlogger.debug("resampleWithGraphicsDraw(): requested dx1 = {}", n12);
        slf4jlogger.debug("resampleWithGraphicsDraw(): requested dy1 = {}", n13);
        slf4jlogger.debug("resampleWithGraphicsDraw(): requested dx2 = {}", n14);
        slf4jlogger.debug("resampleWithGraphicsDraw(): requested dy2 = {}", n15);
        int n16 = bufferedImage.getWidth();
        int n17 = bufferedImage.getHeight();
        if (n8 < 0) {
            n7 = (int)((double)(-n8) * (double)n5 / (double)n + 0.5);
            n12 += n7;
            n8 = 0;
        }
        if (n8 >= n16) {
            n7 = (int)((double)(n8 - n16 + 1) * (double)n5 / (double)n + 0.5);
            n12 -= n7;
            n8 = n16 - 1;
        }
        if (n10 < 0) {
            n7 = (int)((double)(-n10) * (double)n5 / (double)n + 0.5);
            n14 += n7;
            n10 = 0;
        }
        if (n10 >= n16) {
            n7 = (int)((double)(n10 - n16 + 1) * (double)n5 / (double)n + 0.5);
            n14 -= n7;
            n10 = n16 - 1;
        }
        if (n9 < 0) {
            n7 = (int)((double)(-n9) * (double)n6 / (double)n2 + 0.5);
            n13 += n7;
            n9 = 0;
        }
        if (n9 >= n17) {
            n7 = (int)((double)(n9 - n17 + 1) * (double)n6 / (double)n2 + 0.5);
            n13 -= n7;
            n9 = n17 - 1;
        }
        if (n11 < 0) {
            n7 = (int)((double)(-n11) * (double)n6 / (double)n2 + 0.5);
            n15 += n7;
            n11 = 0;
        }
        if (n11 >= n17) {
            n7 = (int)((double)(n11 - n17 + 1) * (double)n6 / (double)n2 + 0.5);
            n15 -= n7;
            n11 = n17 - 1;
        }
        slf4jlogger.debug("resampleWithGraphicsDraw(): clipped sx1 = {}", n8);
        slf4jlogger.debug("resampleWithGraphicsDraw(): clipped sy1 = {}", n9);
        slf4jlogger.debug("resampleWithGraphicsDraw(): clipped sx2 = {}", n10);
        slf4jlogger.debug("resampleWithGraphicsDraw(): clipped sy2 = {}", n11);
        slf4jlogger.debug("resampleWithGraphicsDraw(): clipped dx1 = {}", n12);
        slf4jlogger.debug("resampleWithGraphicsDraw(): clipped dy1 = {}", n13);
        slf4jlogger.debug("resampleWithGraphicsDraw(): clipped dx2 = {}", n14);
        slf4jlogger.debug("resampleWithGraphicsDraw(): clipped dy2 = {}", n15);
        graphics2D.drawImage(bufferedImage, n12, n13, n14, n15, n8, n9, n10, n11, Color.black, null);
        slf4jlogger.debug("resampleWithGraphicsDraw(BufferedImage,BufferedImage,int,int,int,int,int,int): done");
    }

    public static final BufferedImage resampleWithAffineTransformOp(BufferedImage bufferedImage, double d, double d2) {
        slf4jlogger.debug("resampleWithAffineTransformOp(): start");
        long l = System.currentTimeMillis();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        BufferedImage bufferedImage2 = affineTransformOp.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        bufferedImage2 = affineTransformOp.filter(bufferedImage, bufferedImage2);
        slf4jlogger.debug("resampleWithAffineTransformOp() elapsed: " + (System.currentTimeMillis() - l) + " ms");
        return bufferedImage2;
    }

    public static final BufferedImage resampleWithAffineTransformOp(BufferedImage bufferedImage, int n, int n2) {
        slf4jlogger.debug("resampleWithAffineTransformOp():");
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        double d = (double)n / (double)n3;
        double d2 = (double)n2 / (double)n4;
        return BufferedImageUtilities.resampleWithAffineTransformOp(bufferedImage, d, d2);
    }

    public static void flipHorizontally(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        slf4jlogger.debug("flipHorizontally(): srcDataBuffer is {}", dataBuffer.getClass().getName());
        int n3 = dataBuffer.getOffset();
        slf4jlogger.debug("flipHorizontally(): srcDataBuffer.getOffset() is {}", n3);
        int n4 = writableRaster.getNumBands();
        if (n4 == 1) {
            if (dataBuffer instanceof DataBufferUShort) {
                short[] sArray = ((DataBufferUShort)dataBuffer).getData();
                short[] sArray2 = new short[n];
                for (int i = 0; i < n2; ++i) {
                    int n5;
                    int n6 = n3 + i * n;
                    for (n5 = n - 1; n5 >= 0; --n5) {
                        sArray2[n5] = sArray[n6++];
                    }
                    n6 = n3 + i * n;
                    for (n5 = 0; n5 < n; ++n5) {
                        sArray[n6++] = sArray2[n5];
                    }
                }
            } else if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                byte[] byArray2 = new byte[n];
                for (int i = 0; i < n2; ++i) {
                    int n7;
                    int n8 = n3 + i * n;
                    for (n7 = n - 1; n7 >= 0; --n7) {
                        byArray2[n7] = byArray[n8++];
                    }
                    n8 = n3 + i * n;
                    for (n7 = 0; n7 < n; ++n7) {
                        byArray[n8++] = byArray2[n7];
                    }
                }
            } else {
                slf4jlogger.info("BufferedImageUtilities.flipHorizontally(): cannot flip unsupported DataBuffer type of {}", dataBuffer.getClass().getName());
            }
        } else {
            slf4jlogger.info("BufferedImageUtilities.flipHorizontally(): cannot flip more than one band; number of bands is {}", n4);
        }
    }

    public static void flipVertically(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        slf4jlogger.debug("flipVertically(): srcDataBuffer is {}", dataBuffer.getClass().getName());
        int n3 = dataBuffer.getOffset();
        slf4jlogger.debug("flipVertically(): srcDataBuffer.getOffset() is {}", n3);
        int n4 = writableRaster.getNumBands();
        if (n4 == 1) {
            if (dataBuffer instanceof DataBufferUShort) {
                short[] sArray = ((DataBufferUShort)dataBuffer).getData();
                short[] sArray2 = new short[n2];
                for (int i = 0; i < n; ++i) {
                    int n5 = n3 + i;
                    int n6 = 0;
                    for (int j = n2 - 1; j >= 0; --j) {
                        slf4jlogger.trace("flipVertically(): srcPixelOffset={} srcX={} srcY={} dstY={} srcPixelOffset+srcY*srcWidth={} value={}", n5, i, n6, j, n5 + n6 * n, sArray[n5 + n6 * n]);
                        sArray2[j] = sArray[n5 + n6 * n];
                        ++n6;
                    }
                    n5 = n3 + i;
                    for (n6 = 0; n6 < n2; ++n6) {
                        slf4jlogger.trace("flipVertically(): srcPixelOffset={} srcX={} y={} srcPixelOffset+y*srcWidth={} value={}", n5, i, n6, n5 + n6 * n, sArray2[n6]);
                        sArray[n5 + n6 * n] = sArray2[n6];
                    }
                }
            } else if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                byte[] byArray2 = new byte[n2];
                for (int i = 0; i < n; ++i) {
                    int n7 = n3 + i;
                    int n8 = 0;
                    for (int j = n2 - 1; j >= 0; --j) {
                        byArray2[j] = byArray[n7 + n8 * n];
                        ++n8;
                    }
                    n7 = n3 + i;
                    for (n8 = 0; n8 < n2; ++n8) {
                        byArray[n7 + n8 * n] = byArray2[n8];
                    }
                }
            } else {
                slf4jlogger.info("BufferedImageUtilities.flipVertically(): cannot flip unsupported DataBuffer type of {}", dataBuffer.getClass().getName());
            }
        } else {
            slf4jlogger.info("BufferedImageUtilities.flipVertically(): cannot flip more than one band; number of bands is{}", n4);
        }
    }

    public static BufferedImage rotateAndFlipSwappingRowsAndColumns(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        ColorModel colorModel = bufferedImage.getColorModel();
        SampleModel sampleModel = bufferedImage.getSampleModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n3 = dataBuffer.getOffset();
        slf4jlogger.debug("rotateAndFlipSwappingRowsAndColumns(): srcDataBuffer is {}", dataBuffer.getClass().getName());
        slf4jlogger.debug("rotateAndFlipSwappingRowsAndColumns(): srcDataBuffer.getOffset() is {}", n3);
        int n4 = writableRaster.getNumBands();
        if (n4 != 1 || !(dataBuffer instanceof DataBufferUShort) && !(dataBuffer instanceof DataBufferByte)) {
            slf4jlogger.info("rotateAndFlipSwappingRowsAndColumns(): cannot do our own rotating");
            return bufferedImage;
        }
        int n5 = n2;
        int n6 = n;
        BufferedImage bufferedImage2 = null;
        if (dataBuffer instanceof DataBufferUShort) {
            slf4jlogger.debug("rotateAndFlipSwappingRowsAndColumns(): DataBufferUShort");
            ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{16}, false, false, 1, 1);
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(1, n5, n6, 1, n5, new int[]{0});
            short[] sArray = ((DataBufferUShort)dataBuffer).getData();
            int n7 = sArray.length;
            int n8 = n5 * n6;
            short[] sArray2 = new short[n8];
            for (int i = 0; i < n2; ++i) {
                int n9 = n3 + i * n;
                int n10 = 0;
                int n11 = i;
                while (n10 < n) {
                    sArray2[n11] = sArray[n9 + n10];
                    ++n10;
                    n11 += n5;
                }
            }
            DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray2, n5, 0);
            WritableRaster writableRaster2 = Raster.createWritableRaster(componentSampleModel, dataBufferUShort, new Point(0, 0));
            bufferedImage2 = new BufferedImage(componentColorModel, writableRaster2, true, null);
        } else if (dataBuffer instanceof DataBufferByte) {
            slf4jlogger.debug("rotateAndFlipSwappingRowsAndColumns(): DataBufferByte");
            ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, n5, n6, 1, n5, new int[]{0});
            byte[] byArray = ((DataBufferByte)dataBuffer).getData();
            int n12 = byArray.length;
            int n13 = n5 * n6;
            byte[] byArray2 = new byte[n13];
            for (int i = 0; i < n2; ++i) {
                int n14 = n3 + i * n;
                int n15 = 0;
                int n16 = i;
                while (n15 < n) {
                    byArray2[n16] = byArray[n14 + n15];
                    ++n15;
                    n16 += n5;
                }
            }
            DataBufferByte dataBufferByte = new DataBufferByte(byArray2, n5, 0);
            WritableRaster writableRaster3 = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
            bufferedImage2 = new BufferedImage(componentColorModel, writableRaster3, true, null);
        }
        return bufferedImage2;
    }

    private static BufferedImage flipBothVerticallyAndHorizontallyWithAffineTransformOp(BufferedImage bufferedImage) {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(-1.0, -1.0);
        affineTransform.translate(-bufferedImage.getWidth(null), -bufferedImage.getHeight(null));
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
        return affineTransformOp.filter(bufferedImage, null);
    }

    public static byte[] convertYBRToRGB(byte by, byte by2, byte by3, byte[] byArray) {
        long l = by & 0xFF;
        long l2 = by2 & 0xFF;
        long l3 = by3 & 0xFF;
        long l4 = Math.round((double)l + 1.402 * (double)(l3 - 128L));
        long l5 = Math.round((double)l - 0.34414 * (double)(l2 - 128L) - 0.71414 * (double)(l3 - 128L));
        long l6 = Math.round((double)l + 1.772 * (double)(l2 - 128L));
        if (l4 < 0L) {
            l4 = 0L;
        }
        if (l4 > 255L) {
            l4 = 255L;
        }
        if (l5 < 0L) {
            l5 = 0L;
        }
        if (l5 > 255L) {
            l5 = 255L;
        }
        if (l6 < 0L) {
            l6 = 0L;
        }
        if (l6 > 255L) {
            l6 = 255L;
        }
        byArray[0] = (byte)l4;
        byArray[1] = (byte)l5;
        byArray[2] = (byte)l6;
        return byArray;
    }

    public static final BufferedImage convertYBRToRGB(BufferedImage bufferedImage) {
        ColorModel colorModel;
        slf4jlogger.debug("convertYBRToRGB(): start");
        long l = System.currentTimeMillis();
        ColorModel colorModel2 = colorModel = bufferedImage.getColorModel();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        SampleModel sampleModel = bufferedImage.getSampleModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n3 = writableRaster.getNumBands();
        slf4jlogger.debug("convertYBRToRGB(): srcImage ={}", bufferedImage);
        slf4jlogger.debug("convertYBRToRGB(): srcSampleModel ={}", sampleModel);
        if (sampleModel instanceof ComponentSampleModel) {
            slf4jlogger.debug("convertYBRToRGB(): srcSampleModel.getPixelStride() ={}", ((ComponentSampleModel)sampleModel).getPixelStride());
        } else {
            slf4jlogger.info("convertYBRToRGB(): srcSampleModel is not ComponentSampleModel but is {}", sampleModel.getClass().getName());
        }
        WritableRaster writableRaster2 = colorModel2.createCompatibleWritableRaster(n, n2);
        DataBuffer dataBuffer2 = writableRaster2.getDataBuffer();
        BufferedImage bufferedImage2 = new BufferedImage(colorModel2, writableRaster2, colorModel2.isAlphaPremultiplied(), null);
        SampleModel sampleModel2 = bufferedImage2.getSampleModel();
        int n4 = writableRaster2.getNumBands();
        slf4jlogger.debug("convertYBRToRGB(): dstImage ={}", bufferedImage2);
        slf4jlogger.debug("convertYBRToRGB(): dstSampleModel ={}", sampleModel2);
        int[] nArray = null;
        nArray = sampleModel.getPixels(0, 0, n, n2, nArray, dataBuffer);
        int n5 = nArray.length;
        int[] nArray2 = null;
        nArray2 = sampleModel2.getPixels(0, 0, n, n2, nArray2, dataBuffer2);
        int n6 = nArray2.length;
        slf4jlogger.debug("convertYBRToRGB() after getPixels, elapsed: {} ms", System.currentTimeMillis() - l);
        byte[] byArray = new byte[3];
        if (n3 == 4 && n4 == 4 && n5 == n6) {
            slf4jlogger.debug("convertYBRToRGB(): converting pixel or band interleaved 4 band YBRA to RGBA");
            int n7 = 0;
            int n8 = 0;
            while (n8 < n5) {
                byte by = (byte)nArray[n8++];
                byte by2 = (byte)nArray[n8++];
                byte by3 = (byte)nArray[n8++];
                BufferedImageUtilities.convertYBRToRGB(by, by2, by3, byArray);
                nArray2[n7++] = byArray[0];
                nArray2[n7++] = byArray[1];
                nArray2[n7++] = byArray[2];
                nArray2[n7++] = nArray[n8++];
            }
            sampleModel2.setPixels(0, 0, n, n2, nArray2, dataBuffer2);
        } else if (n3 == 3 && n4 == 3 && n5 == n6) {
            slf4jlogger.debug("convertYBRToRGB(): converting pixel or band interleaved 3 band YBR to RGB");
            int n9 = 0;
            int n10 = 0;
            while (n10 < n5) {
                byte by = (byte)nArray[n10++];
                byte by4 = (byte)nArray[n10++];
                byte by5 = (byte)nArray[n10++];
                BufferedImageUtilities.convertYBRToRGB(by, by4, by5, byArray);
                nArray2[n9++] = byArray[0];
                nArray2[n9++] = byArray[1];
                nArray2[n9++] = byArray[2];
            }
            sampleModel2.setPixels(0, 0, n, n2, nArray2, dataBuffer2);
        } else {
            slf4jlogger.info("convertYBRToRGB(): No conversion supported");
            bufferedImage2 = null;
        }
        slf4jlogger.debug("convertYBRToRGB() elapsed: {} ms", System.currentTimeMillis() - l);
        slf4jlogger.debug("convertYBRToRGB(): done = {}", bufferedImage2);
        return bufferedImage2;
    }

    public static final BufferedImage createEmptyBufferedImageOfSameTypeAndSize(BufferedImage bufferedImage) {
        ColorModel colorModel = bufferedImage.getColorModel();
        return new BufferedImage(colorModel, bufferedImage.getRaster().createCompatibleWritableRaster(), colorModel.isAlphaPremultiplied(), null);
    }

    public static final BufferedImage clipToRectangleWithGraphicsDraw(BufferedImage bufferedImage, Rectangle rectangle, Color color) {
        slf4jlogger.debug("clipToRectangleWithGraphicsDraw(): start");
        long l = System.currentTimeMillis();
        int n = bufferedImage.getType();
        BufferedImage bufferedImage2 = BufferedImageUtilities.createEmptyBufferedImageOfSameTypeAndSize(bufferedImage);
        if (bufferedImage2 != null) {
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.setBackground(color);
            graphics2D.clip(rectangle);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
        }
        slf4jlogger.debug("clipToRectangleWithGraphicsDraw() elapsed: {} ms", System.currentTimeMillis() - l);
        slf4jlogger.debug("clipToRectangleWithGraphicsDraw(): done = {}", bufferedImage2);
        return bufferedImage2;
    }

    private class ResamplingVector {
        int[][] arrayOfWeights;
        int[][] arrayOfSrcIndices;
        int[] numberOfEntries;
        int[] sumOfWeights;
        int maxNumberOfSrcSamplesPerDst;
        int divisor = 1000;

        ResamplingVector(int n, int n2) {
            slf4jlogger.debug("ResamplingVector(): divisor ={}", this.divisor);
            double d = (double)n / (double)n2;
            this.maxNumberOfSrcSamplesPerDst = (int)Math.ceil(d) + 1;
            double d2 = 0.0;
            int n3 = 0;
            this.arrayOfWeights = new int[n2][];
            this.arrayOfSrcIndices = new int[n2][];
            this.numberOfEntries = new int[n2];
            this.sumOfWeights = new int[n2];
            for (int i = 0; i < n2; ++i) {
                this.arrayOfWeights[i] = new int[this.maxNumberOfSrcSamplesPerDst];
                this.arrayOfSrcIndices[i] = new int[this.maxNumberOfSrcSamplesPerDst];
                double d3 = d;
                int n4 = 0;
                while (d3 > 1.0E-4) {
                    double d4 = Math.min(1.0 - d2, d3);
                    d3 -= d4;
                    d2 += d4;
                    slf4jlogger.trace("dstIndex ={} srcIndex={} weightForThisSrc={} *divisor={}", i, n3, d4, (int)(d4 * (double)this.divisor));
                    this.arrayOfWeights[i][n4] = (int)(d4 * (double)this.divisor);
                    int n5 = i;
                    this.sumOfWeights[n5] = this.sumOfWeights[n5] + (int)(d4 * (double)this.divisor);
                    this.arrayOfSrcIndices[i][n4] = n3++;
                    this.numberOfEntries[i] = n4 + 1;
                    if (d2 >= 1.0) {
                        d2 = 0.0;
                    }
                    ++n4;
                }
            }
            if (slf4jlogger.isDebugEnabled()) {
                this.dump();
            }
        }

        void dump() {
            for (int i = 0; i < this.arrayOfSrcIndices.length; ++i) {
                for (int j = 0; j < this.numberOfEntries[i]; ++j) {
                    slf4jlogger.debug("dstIndex ={} srcIndex={} weight={}", i, this.arrayOfSrcIndices[i][j], this.arrayOfWeights[i][j]);
                }
            }
        }
    }
}

