/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CompressedFrameDecoder;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.GeometryOfVolumeFromAttributeList;
import com.pixelmed.dicom.ModalityTransform;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.VOITransform;
import com.pixelmed.display.BufferedImageUtilities;
import com.pixelmed.display.DemographicAndTechniqueAnnotations;
import com.pixelmed.display.IconDemographicAndTechniqueAnnotations;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.SuperimposedImage;
import com.pixelmed.display.TextAnnotationPositioned;
import com.pixelmed.display.WindowCenterAndWidth;
import com.pixelmed.geometry.GeometryOfVolume;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.ColorUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public class ConsumerFormatImageMaker {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/ConsumerFormatImageMaker.java,v 1.52 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ConsumerFormatImageMaker.class);
    public static final String ALL_ANNOTATIONS = "all";
    public static final String ICON_ANNOTATIONS = "icon";
    public static final String COLOR_ANNOTATIONS = "color";
    public static final String NO_ANNOTATIONS = "none";

    public static final BufferedImage makeEightBitFrame(SourceImage sourceImage, int n, int n2) {
        slf4jlogger.warn("makeEightBitFrame(): Debug level supplied as argument ignored");
        return ConsumerFormatImageMaker.makeEightBitFrame(sourceImage, n);
    }

    public static final BufferedImage makeEightBitFrame(SourceImage sourceImage, int n) {
        slf4jlogger.trace("makeEightBitFrame(SourceImage,int):");
        BufferedImage bufferedImage = sourceImage.getBufferedImage(n);
        BufferedImage bufferedImage2 = null;
        if (bufferedImage.getColorModel().getNumComponents() == 1) {
            ModalityTransform modalityTransform = sourceImage.getModalityTransform();
            VOITransform vOITransform = sourceImage.getVOITransform();
            boolean bl = sourceImage.isSigned();
            boolean bl2 = sourceImage.isInverted();
            boolean bl3 = sourceImage.isPadded();
            int n2 = sourceImage.getPadValue();
            double d = sourceImage.getMinimum();
            double d2 = sourceImage.getMaximum();
            int n3 = sourceImage.getPaletteColorLargestGray();
            int n4 = sourceImage.getPaletteColorFirstValueMapped();
            int n5 = sourceImage.getPaletteColorNumberOfEntries();
            int n6 = sourceImage.getPaletteColorBitsPerEntry();
            short[] sArray = sourceImage.getPaletteColorRedTable();
            short[] sArray2 = sourceImage.getPaletteColorGreenTable();
            short[] sArray3 = sourceImage.getPaletteColorBlueTable();
            double d3 = 1.0;
            double d4 = 0.0;
            if (modalityTransform != null) {
                d3 = modalityTransform.getRescaleSlope(n);
                d4 = modalityTransform.getRescaleIntercept(n);
            }
            double d5 = 0.0;
            double d6 = 0.0;
            if (vOITransform != null && vOITransform.getNumberOfTransforms(n) > 0) {
                d5 = vOITransform.getWidth(n, 0);
                d6 = vOITransform.getCenter(n, 0);
            }
            if (d5 <= 0.0) {
                slf4jlogger.trace("makeEightBitFrame(): For statistically derived window: imgMin = {}", d);
                slf4jlogger.trace("makeEightBitFrame(): For statistically derived window: imgMax = {}", d2);
                double d7 = d * d3 + d4;
                double d8 = d2 * d3 + d4;
                slf4jlogger.trace("makeEightBitFrame(): For statistically derived window: rescaled min = {}", d7);
                slf4jlogger.trace("makeEightBitFrame(): For statistically derived window: rescaled min = {}", d8);
                d5 = d8 - d7;
                d6 = (d8 + d7) / 2.0;
                slf4jlogger.trace("makeEightBitFrame(): Using statistically derived center {} and width {}", d6, d5);
            }
            slf4jlogger.trace("makeEightBitFrame(): Using rescale slope {} and intercept {} and window center {} and width {}", d3, d4, d6, d5);
            boolean bl4 = false;
            bufferedImage2 = n5 == 0 || sArray == null ? (bl4 ? WindowCenterAndWidth.applyWindowCenterAndWidthLogistic(bufferedImage, d6, d5, bl, bl2, d3, d4, bl3, n2) : WindowCenterAndWidth.applyWindowCenterAndWidthLinear(bufferedImage, d6, d5, bl, bl2, d3, d4, bl3, n2)) : WindowCenterAndWidth.applyWindowCenterAndWidthWithPaletteColor(bufferedImage, d6, d5, sourceImage.isSigned(), bl2, d3, d4, bl3, n2, n3, n6, n5, sArray, sArray2, sArray3);
        } else if (bufferedImage.getColorModel().getNumComponents() == 3) {
            if (sourceImage.isYBR()) {
                bufferedImage = BufferedImageUtilities.convertYBRToRGB(bufferedImage);
            }
            VOITransform vOITransform = sourceImage.getVOITransform();
            double d = 0.0;
            double d9 = 0.0;
            if (vOITransform != null && vOITransform.getNumberOfTransforms(n) > 0) {
                d = vOITransform.getWidth(n, 0);
                d9 = vOITransform.getCenter(n, 0);
            }
            if (d <= 0.0) {
                slf4jlogger.trace("makeEightBitFrame(): Color image without windowing");
                bufferedImage2 = BufferedImageUtilities.convertToMostFavorableImageType(bufferedImage);
            } else {
                slf4jlogger.trace("makeEightBitFrame(): Color image with window center {} and width {}", d9, d);
                bufferedImage2 = WindowCenterAndWidth.applyWindowCenterAndWidthLinearToColorImage(bufferedImage, d9, d);
            }
        } else {
            try {
                bufferedImage2 = BufferedImageUtilities.convertToMostFavorableImageType(bufferedImage);
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
                bufferedImage2 = bufferedImage;
            }
        }
        return bufferedImage2;
    }

    public static final BufferedImage makeEightBitImage(AttributeList attributeList, int n) throws DicomException {
        slf4jlogger.warn("makeEightBitImage(): Debug level supplied as argument ignored");
        return ConsumerFormatImageMaker.makeEightBitImage(attributeList);
    }

    public static final BufferedImage makeEightBitImage(AttributeList attributeList) throws DicomException {
        return ConsumerFormatImageMaker.makeEightBitImages(attributeList)[0];
    }

    public static final BufferedImage[] makeEightBitImages(AttributeList attributeList, int n) throws DicomException {
        slf4jlogger.warn("makeEightBitImages(): Debug level supplied as argument ignored");
        return ConsumerFormatImageMaker.makeEightBitImages(attributeList);
    }

    public static final BufferedImage[] makeEightBitImages(AttributeList attributeList) throws DicomException {
        return ConsumerFormatImageMaker.makeEightBitImages(attributeList, null, null, null, 0, -1);
    }

    public static final BufferedImage[] makeEightBitImages(AttributeList attributeList, GeometryOfVolume geometryOfVolume, Vector<SuperimposedImage> vector, Vector<Shape>[] vectorArray, int n, int n2, int n3) throws DicomException {
        slf4jlogger.warn("makeEightBitImages(): Debug level supplied as argument ignored");
        return ConsumerFormatImageMaker.makeEightBitImages(attributeList, geometryOfVolume, vector, vectorArray, n, n2);
    }

    public static final BufferedImage[] makeEightBitImages(AttributeList attributeList, GeometryOfVolume geometryOfVolume, Vector<SuperimposedImage> vector, Vector<Shape>[] vectorArray, int n, int n2) throws DicomException {
        return ConsumerFormatImageMaker.makeEightBitImages(attributeList, geometryOfVolume, vector, 0.125, vectorArray, n, n2);
    }

    public static final BufferedImage[] makeEightBitImages(AttributeList attributeList, GeometryOfVolume geometryOfVolume, Vector<SuperimposedImage> vector, double d, Vector<Shape>[] vectorArray, int n, int n2, int n3) throws DicomException {
        slf4jlogger.warn("makeEightBitImages(): Debug level supplied as argument ignored");
        return ConsumerFormatImageMaker.makeEightBitImages(attributeList, geometryOfVolume, vector, d, vectorArray, n, n2);
    }

    public static final BufferedImage[] makeEightBitImages(AttributeList attributeList, GeometryOfVolume geometryOfVolume, Vector<SuperimposedImage> vector, double d, Vector<Shape>[] vectorArray, int n, int n2) throws DicomException {
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        if (!SOPClass.isImageStorage(string)) {
            throw new DicomException("SOP Class is not an image");
        }
        SourceImage sourceImage = new SourceImage(attributeList);
        int n3 = sourceImage.getNumberOfFrames();
        if (n2 < 0) {
            n = 0;
            n2 = n3 - 1;
        }
        BufferedImage[] bufferedImageArray = new BufferedImage[n2 - n + 1];
        for (int i = n; i <= n2; ++i) {
            Object object;
            Object object2;
            BufferedImage bufferedImage = ConsumerFormatImageMaker.makeEightBitFrame(sourceImage, i);
            if (vector != null) {
                if (geometryOfVolume == null) {
                    try {
                        geometryOfVolume = new GeometryOfVolumeFromAttributeList(attributeList);
                    }
                    catch (Exception exception) {
                        slf4jlogger.debug("", exception);
                    }
                }
                if (geometryOfVolume != null) {
                    for (SuperimposedImage superimposedImage : vector) {
                        object2 = superimposedImage.getAppliedToUnderlyingImage(geometryOfVolume, i, d);
                        if (object2 == null) continue;
                        object = ((SuperimposedImage.AppliedToUnderlyingImage)object2).getBufferedImage();
                        if (object != null) {
                            Object object3;
                            slf4jlogger.debug("makeEightBitImages(): have superimposed image for underlying frame {}", i);
                            double d2 = ((SuperimposedImage.AppliedToUnderlyingImage)object2).getRowOrigin();
                            double d3 = ((SuperimposedImage.AppliedToUnderlyingImage)object2).getColumnOrigin();
                            RescaleOp rescaleOp = null;
                            if (((BufferedImage)object).getType() == 2) {
                                Object[] objectArray;
                                object3 = superimposedImage.getIntegerScaledCIELabPCS();
                                float f = 1.0f;
                                float f2 = 1.0f;
                                float f3 = 0.0f;
                                if (object3 != null) {
                                    objectArray = ColorUtilities.getSRGBFromIntegerScaledCIELabPCS((int[])object3);
                                    f = (float)objectArray[0] / 255.0f;
                                    f2 = (float)objectArray[1] / 255.0f;
                                    f3 = (float)objectArray[2] / 255.0f;
                                }
                                objectArray = new float[]{f, f2, f3, 1.0f};
                                float[] fArray = new float[4];
                                rescaleOp = new RescaleOp((float[])objectArray, fArray, null);
                            } else {
                                slf4jlogger.info("makeEightBitImages(): not ARGB superimposed image so cannot change color and use transparency");
                            }
                            bufferedImage = BufferedImageUtilities.convertToMostFavorableImageType(bufferedImage);
                            object3 = (Graphics2D)bufferedImage.getGraphics();
                            ((Graphics2D)object3).setComposite(AlphaComposite.getInstance(3, 0.5f));
                            ((Graphics2D)object3).drawImage((BufferedImage)object, rescaleOp, (int)d3, (int)d2);
                            continue;
                        }
                        slf4jlogger.debug("makeEightBitImages(): have no superimposed image for underlying frame {}", i);
                    }
                }
            }
            if (vectorArray != null && vectorArray.length > i && vectorArray[i] != null) {
                slf4jlogger.debug("makeEightBitImages(): draw per-frame shapes");
                bufferedImage = BufferedImageUtilities.convertToMostFavorableImageType(bufferedImage);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                Color color = Color.red;
                graphics2D.setColor(color);
                object2 = vectorArray[i];
                object = ((Vector)object2).iterator();
                while (object.hasNext()) {
                    graphics2D.draw((Shape)object.next());
                }
            }
            bufferedImageArray[i - n] = bufferedImage;
        }
        return bufferedImageArray;
    }

    public static String[] convertFileToEightBitImage(String string, String string2, String string3, int n) throws DicomException, IOException {
        slf4jlogger.warn("convertFileToEightBitImage(): Debug level supplied as argument ignored");
        return ConsumerFormatImageMaker.convertFileToEightBitImage(string, string2, string3);
    }

    public static String[] convertFileToEightBitImage(String string, String string2, String string3) throws DicomException, IOException {
        return ConsumerFormatImageMaker.convertFileToEightBitImage(string, string2, string3, 0.0, 0.0, 0, 0, -1, ALL_ANNOTATIONS);
    }

    public static void replaceWindowWidthAndCenterInAttributeList(AttributeList attributeList, Attribute attribute, Attribute attribute2) {
        attributeList.put(attribute2);
        attributeList.put(attribute);
    }

    public static void replaceWindowWidthAndCenterInFunctionalGroupSequences(AttributeList attributeList, int n, Attribute attribute, Attribute attribute2) {
        AttributeList attributeList2;
        Object object = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(attributeList, TagFromName.SharedFunctionalGroupsSequence);
        if (object != null && (attributeList2 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem((AttributeList)object, TagFromName.FrameVOILUTSequence)) != null) {
            ConsumerFormatImageMaker.replaceWindowWidthAndCenterInAttributeList(attributeList2, attribute, attribute2);
        }
        if ((object = attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence)) != null && object instanceof SequenceAttribute) {
            for (int i = 0; i < n; ++i) {
                AttributeList attributeList3;
                AttributeList attributeList4 = SequenceAttribute.getAttributeListFromSelectedItemWithinSequence((SequenceAttribute)object, i);
                if (attributeList4 == null || (attributeList3 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(attributeList4, TagFromName.FrameVOILUTSequence)) == null) continue;
                ConsumerFormatImageMaker.replaceWindowWidthAndCenterInAttributeList(attributeList3, attribute, attribute2);
            }
        }
    }

    public static String[] convertFileToEightBitImage(String string, String string2, String string3, double d, double d2, int n, int n2, int n3, String string4, int n4) throws DicomException, IOException {
        slf4jlogger.warn("convertFileToEightBitImage(): Debug level supplied as argument ignored");
        return ConsumerFormatImageMaker.convertFileToEightBitImage(string, string2, string3, d, d2, n, n2, n3, string4);
    }

    public static String[] convertFileToEightBitImage(String string, String string2, String string3, double d, double d2, int n, int n2, int n3, String string4) throws DicomException, IOException {
        return ConsumerFormatImageMaker.convertFileToEightBitImage(string, string2, string3, d, d2, n, n2, 0, 0, 0, 0, 0, -1, n3, string4, (Vector<SuperimposedImage>)null, 0.125, null);
    }

    public static String[] convertFileToEightBitImage(String string, String string2, String string3, double d, double d2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, String string4, int n10) throws DicomException, IOException {
        slf4jlogger.warn("convertFileToEightBitImage(): Debug level supplied as argument ignored");
        return ConsumerFormatImageMaker.convertFileToEightBitImage(string, string2, string3, d, d2, n, n2, n3, n4, n5, n6, n7, n8, n9, string4);
    }

    public static String[] convertFileToEightBitImage(String string, String string2, String string3, double d, double d2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, String string4) throws DicomException, IOException {
        return ConsumerFormatImageMaker.convertFileToEightBitImage(string, string2, string3, d, d2, n, n2, n3, n4, n5, n6, n7, n8, n9, string4, (Vector<SuperimposedImage>)null, 0.125, null);
    }

    public static String[] convertFileToEightBitImage(String string, String string2, String string3, double d, double d2, int n, int n2, int n3, String string4, Vector<SuperimposedImage> vector, double d3, Vector<Shape>[] vectorArray, int n4) throws DicomException, IOException {
        slf4jlogger.warn("convertFileToEightBitImage(): Debug level supplied as argument ignored");
        return ConsumerFormatImageMaker.convertFileToEightBitImage(string, string2, string3, d, d2, n, n2, n3, string4, vector, d3, vectorArray);
    }

    public static String[] convertFileToEightBitImage(String string, String string2, String string3, double d, double d2, int n, int n2, int n3, String string4, Vector<SuperimposedImage> vector, double d3, Vector<Shape>[] vectorArray) throws DicomException, IOException {
        return ConsumerFormatImageMaker.convertFileToEightBitImage(string, string2, string3, d, d2, n, n2, 0, 0, 0, 0, 0, -1, n3, string4, vector, d3, vectorArray);
    }

    public static String[] convertFileToEightBitImage(String string, String string2, String string3, double d, double d2, int n, int n2, int n3, String string4, Vector<SuperimposedImage> vector, Vector<Shape>[] vectorArray, int n4) throws DicomException, IOException {
        slf4jlogger.warn("convertFileToEightBitImage(): Debug level supplied as argument ignored");
        return ConsumerFormatImageMaker.convertFileToEightBitImage(string, string2, string3, d, d2, n, n2, n3, string4, vector, vectorArray);
    }

    public static String[] convertFileToEightBitImage(String string, String string2, String string3, double d, double d2, int n, int n2, int n3, String string4, Vector<SuperimposedImage> vector, Vector<Shape>[] vectorArray) throws DicomException, IOException {
        return ConsumerFormatImageMaker.convertFileToEightBitImage(string, string2, string3, d, d2, n, n2, 0, 0, 0, 0, 0, -1, n3, string4, vector, 0.125, vectorArray);
    }

    public static String[] convertFileToEightBitImage(String string, String string2, String string3, double d, double d2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, String string4, Vector<SuperimposedImage> vector, Vector<Shape>[] vectorArray, int n10) throws DicomException, IOException {
        slf4jlogger.warn("convertFileToEightBitImage(): Debug level supplied as argument ignored");
        return ConsumerFormatImageMaker.convertFileToEightBitImage(string, string2, string3, d, d2, n, n2, n3, n4, n5, n6, n7, n8, n9, string4, vector, vectorArray);
    }

    public static String[] convertFileToEightBitImage(String string, String string2, String string3, double d, double d2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, String string4, Vector<SuperimposedImage> vector, Vector<Shape>[] vectorArray) throws DicomException, IOException {
        return ConsumerFormatImageMaker.convertFileToEightBitImage(string, string2, string3, d, d2, n, n2, n3, n4, n5, n6, n7, n8, n9, string4, vector, 0.125, vectorArray);
    }

    public static String[] convertFileToEightBitImage(String string, String string2, String string3, double d, double d2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, String string4, Vector<SuperimposedImage> vector, double d3, Vector<Shape>[] vectorArray, int n10) throws DicomException, IOException {
        slf4jlogger.warn("convertFileToEightBitImage(): Debug level supplied as argument ignored");
        return ConsumerFormatImageMaker.convertFileToEightBitImage(string, string2, string3, d, d2, n, n2, n3, n4, n5, n6, n7, n8, n9, string4, vector, d3, vectorArray);
    }

    public static String[] convertFileToEightBitImage(String string, String string2, String string3, double d, double d2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, String string4, Vector<SuperimposedImage> vector, double d3, Vector<Shape>[] vectorArray) throws DicomException, IOException {
        Object object;
        int n10;
        boolean bl = CompressedFrameDecoder.canDecompress(string);
        AttributeList attributeList = new AttributeList();
        DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
        attributeList.setDecompressPixelData(!bl);
        attributeList.read(dicomInputStream);
        dicomInputStream.close();
        int n11 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        if (n8 < 0) {
            n7 = 0;
            n8 = n11 - 1;
        }
        if ((n10 = n8 - n7 + 1) > n11) {
            throw new DicomException("Requested frame range from " + n7 + " to " + n8 + " exceeds actual number of frames " + n11);
        }
        n11 = n10;
        String[] stringArray = new String[n11];
        if (d2 != 0.0) {
            object = new DecimalStringAttribute(TagFromName.WindowWidth);
            ((Attribute)object).addValue(d2);
            DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.WindowCenter);
            ((Attribute)decimalStringAttribute).addValue(d);
            ConsumerFormatImageMaker.replaceWindowWidthAndCenterInAttributeList(attributeList, (Attribute)object, decimalStringAttribute);
            ConsumerFormatImageMaker.replaceWindowWidthAndCenterInFunctionalGroupSequences(attributeList, n11, (Attribute)object, decimalStringAttribute);
        }
        object = null;
        try {
            object = new GeometryOfVolumeFromAttributeList(attributeList);
        }
        catch (Exception exception) {
            slf4jlogger.debug("", exception);
        }
        boolean bl2 = false;
        DemographicAndTechniqueAnnotations demographicAndTechniqueAnnotations = null;
        if (string4 != null) {
            if ((string4 = string4.toLowerCase()).contains(ALL_ANNOTATIONS) || string4.contains(ICON_ANNOTATIONS)) {
                DemographicAndTechniqueAnnotations demographicAndTechniqueAnnotations2 = demographicAndTechniqueAnnotations = string4.contains(ICON_ANNOTATIONS) ? new IconDemographicAndTechniqueAnnotations(attributeList) : new DemographicAndTechniqueAnnotations(attributeList, (GeometryOfVolume)object);
            }
            if (string4.contains(COLOR_ANNOTATIONS)) {
                bl2 = true;
            }
        }
        BufferedImage[] bufferedImageArray = ConsumerFormatImageMaker.makeEightBitImages(attributeList, (GeometryOfVolume)object, vector, d3, vectorArray, n7, n8);
        if (n11 == 1) {
            stringArray[0] = string2;
            Iterator iterator = demographicAndTechniqueAnnotations == null ? null : demographicAndTechniqueAnnotations.iterator(n7);
            ConsumerFormatImageMaker.writeEightBitImageForFrame(bufferedImageArray[0], iterator, string2, string3, n, n2, n3, n4, n5, n6, n9, bl2);
        } else {
            int n12;
            String string5 = string2;
            String string6 = "";
            Serializable serializable = Pattern.compile("^(.+)[.]([a-zA-Z0-9]+)$");
            Matcher matcher = ((Pattern)serializable).matcher(string2);
            if (matcher.matches() && (n12 = matcher.groupCount()) == 2) {
                string5 = matcher.group(1);
                string6 = matcher.group(2);
            }
            slf4jlogger.trace("convertFileToEightBitImage(): frameOutputFilePrefix = {}", string5);
            slf4jlogger.trace("convertFileToEightBitImage(): frameOutputFileSuffix = {}", string6);
            serializable = new DecimalFormat("0000000000");
            for (int i = 0; i < n11; ++i) {
                String string7;
                stringArray[i] = string7 = string5 + "_" + ((NumberFormat)serializable).format(n7 + i + 1) + "." + string6;
                Iterator iterator = demographicAndTechniqueAnnotations == null ? null : demographicAndTechniqueAnnotations.iterator(i + n7);
                ConsumerFormatImageMaker.writeEightBitImageForFrame(bufferedImageArray[i], iterator, string7, string3, n, n2, n3, n4, n5, n6, n9, bl2);
            }
        }
        return stringArray;
    }

    public static void writeEightBitImageForFrame(BufferedImage bufferedImage, Iterator<TextAnnotationPositioned> iterator, String string, String string2, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, int n8) throws DicomException, IOException {
        slf4jlogger.warn("writeEightBitImageForFrame(): Debug level supplied as argument ignored");
        ConsumerFormatImageMaker.writeEightBitImageForFrame(bufferedImage, iterator, string, string2, n, n2, n3, n4, n5, n6, n7, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeEightBitImageForFrame(BufferedImage bufferedImage, Iterator<TextAnnotationPositioned> iterator, String string, String string2, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) throws DicomException, IOException {
        ImageWriteParam imageWriteParam;
        Object[] objectArray;
        if (n5 > 0 && n6 > 0) {
            bufferedImage = bufferedImage.getSubimage(n3, n4, n5, n6);
        }
        try {
            double d;
            slf4jlogger.debug("writeEightBitImageForFrame(): Requested width = {} height = {}", n, n2);
            int n8 = bufferedImage.getWidth();
            int n9 = bufferedImage.getHeight();
            slf4jlogger.trace("writeEightBitImageForFrame(): Source width = {} width = {}", n8, n9);
            if (n <= 0 && n2 > 0 && n2 != n9) {
                d = (double)n2 / (double)n9;
                slf4jlogger.trace("writeEightBitImageForFrame(): Resizing - specified desired height only and different from source, scale = {}", d);
                bufferedImage = BufferedImageUtilities.resampleWithAffineTransformOp(bufferedImage, d, d);
            } else if (n2 <= 0 && n > 0 && n != n8) {
                d = (double)n / (double)n8;
                slf4jlogger.trace("writeEightBitImageForFrame(): Resizing - specified desired width only and different from source, scale = {}", d);
                bufferedImage = BufferedImageUtilities.resampleWithAffineTransformOp(bufferedImage, d, d);
            } else if (n > 0 && n2 > 0 && (n != n8 || n2 != n9)) {
                slf4jlogger.trace("writeEightBitImageForFrame(): Resizing - specified desired width and height and different from source ");
                bufferedImage = BufferedImageUtilities.resampleWithAffineTransformOp(bufferedImage, n, n2);
            }
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("writeEightBitImageForFrame(): Resized width = {} height = {}", bufferedImage.getWidth(), bufferedImage.getHeight());
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("Could not resize", exception);
        }
        if (bl || bufferedImage.getColorModel().getNumComponents() > 1) {
            slf4jlogger.trace("writeEightBitImageForFrame(): Need color or is already color, so converting to most favorable image type");
            bufferedImage = BufferedImageUtilities.convertToMostFavorableImageType(bufferedImage);
        }
        if (iterator != null) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            String string3 = "";
            int n10 = 0;
            int n11 = 10;
            objectArray = new Font(string3, n10, n11);
            Color color = Color.pink;
            graphics2D.setColor(color);
            graphics2D.setFont((Font)objectArray);
            while (iterator.hasNext()) {
                TextAnnotationPositioned.drawPositionedString(iterator.next(), graphics2D, bufferedImage.getWidth(), bufferedImage.getHeight(), 5, 5);
            }
        }
        if (bufferedImage.getColorModel().getNumComponents() > 3) {
            slf4jlogger.trace("writeEightBitImageForFrame(): Converting RGBA to RGB");
            bufferedImage = BufferedImageUtilities.convertToThreeChannelImageTypeIfFour(bufferedImage);
        }
        slf4jlogger.trace("writeEightBitImageForFrame(): Attempting to write format = {}", string2);
        Iterator<ImageWriter> iterator2 = ImageIO.getImageWritersByFormatName(string2);
        if (iterator2 == null || !iterator2.hasNext()) throw new DicomException("Cannot find writer for format" + string2);
        ImageWriter imageWriter = iterator2.next();
        if (imageWriter == null) throw new DicomException("Cannot find writer for format" + string2);
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(new File(string));
        imageWriter.setOutput(imageOutputStream);
        try {
            imageWriteParam = imageWriter.getDefaultWriteParam();
            if (imageWriteParam.canWriteCompressed()) {
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("writeEightBitImageForFrame(): Default compression mode = {}", imageWriteParam.getCompressionMode());
                }
                objectArray = imageWriteParam.getCompressionTypes();
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("writeEightBitImageForFrame(): Compression types available = {}", Arrays.toString(objectArray));
                }
                if (n7 >= 0 && n7 <= 100) {
                    float f = (float)n7 / 100.0f;
                    slf4jlogger.trace("writeEightBitImageForFrame(): Setting quality = {}", Float.valueOf(f));
                    imageWriteParam.setCompressionMode(2);
                    imageWriteParam.setCompressionQuality(f);
                }
            }
            if (imageWriteParam.canWriteProgressive()) {
                slf4jlogger.trace("writeEightBitImageForFrame(): Setting progressive mode");
                imageWriteParam.setProgressiveMode(1);
            }
            imageWriter.getDefaultWriteParam();
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            imageWriteParam = null;
        }
        objectArray = null;
        imageWriter.write((IIOMetadata)objectArray, new IIOImage(bufferedImage, null, (IIOMetadata)objectArray), imageWriteParam);
        imageOutputStream.flush();
        imageOutputStream.close();
        try {
            slf4jlogger.trace("writeEightBitImageForFrame(): Calling dispose() on writer");
            imageWriter.dispose();
            return;
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray.length > 2 ? stringArray[2] : "jpeg";
        double d = stringArray.length > 3 ? Double.parseDouble(stringArray[3]) : 0.0;
        double d2 = stringArray.length > 4 ? Double.parseDouble(stringArray[4]) : 0.0;
        int n = stringArray.length > 5 ? Integer.parseInt(stringArray[5]) : 0;
        int n2 = stringArray.length > 6 ? Integer.parseInt(stringArray[6]) : 0;
        int n3 = stringArray.length > 7 ? Integer.parseInt(stringArray[7]) : -1;
        String string4 = stringArray.length > 8 ? stringArray[8] : "all_color";
        int n4 = stringArray.length > 12 ? Integer.parseInt(stringArray[9]) : 0;
        int n5 = stringArray.length > 12 ? Integer.parseInt(stringArray[10]) : 0;
        int n6 = stringArray.length > 12 ? Integer.parseInt(stringArray[11]) : 0;
        int n7 = stringArray.length > 12 ? Integer.parseInt(stringArray[12]) : 0;
        int n8 = stringArray.length > 14 ? Integer.parseInt(stringArray[13]) : 0;
        int n9 = stringArray.length > 14 ? Integer.parseInt(stringArray[14]) : -1;
        try {
            ConsumerFormatImageMaker.convertFileToEightBitImage(string, string2, string3, d, d2, n, n2, n4, n5, n6, n7, n8, n9, n3, string4);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

