/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.event.RegionSelectionChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.EventContext;
import com.pixelmed.geometry.GeometryOfSlice;
import com.pixelmed.geometry.GeometryOfVolume;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.SwingUtilities;

class SingleImagePanelWithRegionDetection
extends SingleImagePanel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SingleImagePanelWithRegionDetection.java,v 1.13 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SingleImagePanelWithRegionDetection.class);
    private double regionSelectionCenterX;
    private double regionSelectionCenterY;
    private double regionSelectionTLHCX;
    private double regionSelectionTLHCY;
    private double regionSelectionBRHCX;
    private double regionSelectionBRHCY;
    protected Point2D startPoint;
    static final int crossSize = 5;

    public SingleImagePanelWithRegionDetection(SourceImage sourceImage, EventContext eventContext, int[] nArray, Vector vector, Vector vector2, GeometryOfVolume geometryOfVolume) {
        super(sourceImage, eventContext, nArray, vector, vector2, geometryOfVolume);
    }

    public SingleImagePanelWithRegionDetection(SourceImage sourceImage, EventContext eventContext, GeometryOfVolume geometryOfVolume) {
        super(sourceImage, eventContext, geometryOfVolume);
    }

    public SingleImagePanelWithRegionDetection(SourceImage sourceImage, EventContext eventContext) {
        super(sourceImage, eventContext);
    }

    public SingleImagePanelWithRegionDetection(SourceImage sourceImage) {
        super(sourceImage);
    }

    private void setRegionSelection(double d, double d2, double d3, double d4, double d5, double d6) {
        this.regionSelectionCenterX = d;
        this.regionSelectionCenterY = d2;
        if (d3 < d5) {
            this.regionSelectionTLHCX = d3;
            this.regionSelectionBRHCX = d5;
        } else {
            this.regionSelectionTLHCX = d5;
            this.regionSelectionBRHCX = d3;
        }
        if (d4 < d6) {
            this.regionSelectionTLHCY = d4;
            this.regionSelectionBRHCY = d6;
        } else {
            this.regionSelectionTLHCY = d6;
            this.regionSelectionBRHCY = d4;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.dragInteractiveDrawing(mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.startInteractiveDrawing(mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.endInteractiveDrawing(mouseEvent.getX(), mouseEvent.getY());
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new RegionSelectionChangeEvent(this.typeOfPanelEventContext, this.regionSelectionCenterX, this.regionSelectionCenterY, this.regionSelectionTLHCX, this.regionSelectionTLHCY, this.regionSelectionBRHCX, this.regionSelectionBRHCY));
        } else {
            super.mouseReleased(mouseEvent);
        }
    }

    private IntegerPointWithValue[] findLongestAndShortestPaths(Collection collection, double[] dArray) throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        IntegerPointWithValue integerPointWithValue;
        double d = dArray == null ? 0.0 : (dArray[0] == dArray[1] ? dArray[0] : 0.0);
        Object[] objectArray = collection.toArray();
        int n6 = objectArray.length;
        int n7 = -1;
        int n8 = -1;
        int n9 = 0;
        for (int i = 0; i < n6; ++i) {
            integerPointWithValue = (IntegerPointWithValue)objectArray[i];
            n5 = integerPointWithValue.getX();
            n4 = integerPointWithValue.getY();
            for (n3 = i + 1; n3 < n6; ++n3) {
                int n10;
                IntegerPointWithValue integerPointWithValue2 = (IntegerPointWithValue)objectArray[n3];
                n2 = integerPointWithValue2.getX();
                int n11 = n2 - n5;
                int n12 = n11 * n11 + (n10 = (n = integerPointWithValue2.getY()) - n4) * n10;
                if (n12 <= n9) continue;
                n9 = n12;
                n7 = i;
                n8 = n3;
            }
        }
        if (n7 < 0 || n8 < 0) {
            return null;
        }
        IntegerPointWithValue integerPointWithValue3 = (IntegerPointWithValue)objectArray[n7];
        integerPointWithValue = (IntegerPointWithValue)objectArray[n8];
        n5 = integerPointWithValue3.getX();
        n4 = integerPointWithValue.getX();
        n3 = n4 - n5;
        if (n3 < 0) {
            int n13 = n7;
            n7 = n8;
            n8 = n13;
            integerPointWithValue3 = (IntegerPointWithValue)objectArray[n7];
            integerPointWithValue = (IntegerPointWithValue)objectArray[n8];
            n5 = integerPointWithValue3.getX();
            n4 = integerPointWithValue.getX();
            n3 = n4 - n5;
        }
        int n14 = integerPointWithValue3.getY();
        n2 = integerPointWithValue.getY();
        n = -(n2 - n14);
        double d2 = Math.sqrt(n3 * n3 + n * n);
        double d3 = Math.atan((double)n / (double)n3);
        slf4jlogger.info("Long axis length={} pixels ({} mm)", d2, d2 * d);
        double d4 = 0.0;
        double d5 = 0.0;
        IntegerPointWithValue integerPointWithValue4 = null;
        IntegerPointWithValue integerPointWithValue5 = null;
        IntegerPointWithValue integerPointWithValue6 = null;
        IntegerPointWithValue integerPointWithValue7 = null;
        for (int i = 0; i < n6; ++i) {
            IntegerPointWithValue integerPointWithValue8 = (IntegerPointWithValue)objectArray[i];
            int n15 = integerPointWithValue8.getX();
            int n16 = integerPointWithValue8.getY();
            int n17 = n15 - n5;
            int n18 = -(n16 - n14);
            double d6 = Math.sqrt(n17 * n17 + n18 * n18);
            double d7 = Math.atan((double)n18 / (double)n17);
            double d8 = d7 - d3;
            double d9 = d6 * Math.cos(d8);
            double d10 = d6 * Math.sin(d8);
            int n19 = (int)(d9 * Math.cos(d3));
            int n20 = (int)(d9 * Math.sin(d3));
            int n21 = n5 + n19;
            int n22 = n14 - n20;
            if (d10 < d4 && d8 <= 1.5707963267948966 && d8 >= -1.5707963267948966) {
                d4 = d10;
                integerPointWithValue4 = integerPointWithValue8;
                integerPointWithValue6 = new IntegerPointWithValue(n21, n22, 0);
            }
            if (!(d10 > d5) || !(d8 <= 1.5707963267948966) || !(d8 >= -1.5707963267948966)) continue;
            d5 = d10;
            integerPointWithValue5 = integerPointWithValue8;
            integerPointWithValue7 = new IntegerPointWithValue(n21, n22, 0);
        }
        slf4jlogger.info("Short axis most negative side length={} pixels ({} mm)", d4, d4 * d);
        slf4jlogger.info("Short axis most positive side length={} pixels ({} mm)", d5, d5 * d);
        slf4jlogger.info("Short axis total length={} pixels ({} mm)", Math.abs(d4) + Math.abs(d5), (Math.abs(d4) + Math.abs(d5)) * d);
        IntegerPointWithValue[] integerPointWithValueArray = new IntegerPointWithValue[]{integerPointWithValue3, integerPointWithValue, integerPointWithValue4, integerPointWithValue6, integerPointWithValue5, integerPointWithValue7};
        return integerPointWithValueArray;
    }

    private void detectAndDrawRegion(BufferedImage bufferedImage, double[] dArray, Vector vector, double d, double d2, double d3, double d4, double d5, double d6) throws Exception {
        Object object;
        int n;
        int n2;
        int n3;
        Object object2;
        Object object3;
        HashSet<IntegerPointWithValue> hashSet = new HashSet<IntegerPointWithValue>();
        HashSet<IntegerPointWithValue> hashSet2 = new HashSet<IntegerPointWithValue>();
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n6 = (int)d;
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 >= n4) {
            n6 = n4 - 1;
        }
        int n7 = (int)d2;
        if (n7 < 0) {
            n7 = 0;
        } else if (n7 >= n5) {
            n7 = n5 - 1;
        }
        int n8 = writableRaster.getSample(n6, n7, 0);
        hashSet2.add(new IntegerPointWithValue(n6, n7, n8));
        int n9 = 1;
        double d7 = n8;
        double d8 = 0.0;
        double d9 = 0.0;
        int n10 = 16;
        double d10 = 2.0;
        int n11 = 20;
        int n12 = n8;
        do {
            if (!(object3 = hashSet2.iterator()).hasNext()) continue;
            object2 = (IntegerPointWithValue)object3.next();
            object3.remove();
            hashSet.add((IntegerPointWithValue)object2);
            n3 = ((IntegerPointWithValue)object2).getX();
            int n13 = ((IntegerPointWithValue)object2).getY();
            n2 = writableRaster.getSample(n3, n13, 0);
            double d11 = (double)n2 - d7;
            double d12 = d7 + d11 / (double)(n9 + 1);
            d7 = d12;
            d8 = Math.sqrt((d9 += d11 * ((double)n2 - d12)) / (double)n9);
            if (++n9 > n10) {
                n11 = (int)(d8 * d10);
            } else {
                n12 = (int)d7;
            }
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    IntegerPointWithValue integerPointWithValue;
                    int n14;
                    if (i == 0 && j == 0) continue;
                    int n15 = n3 + i;
                    int n16 = n13 + j;
                    if (!((double)n15 >= d3) || !((double)n15 <= d5) || !((double)n16 >= d4) || !((double)n16 <= d6) || Math.abs(n12 - (n14 = writableRaster.getSample(n15, n16, 0))) > n11 || hashSet.contains(integerPointWithValue = new IntegerPointWithValue(n15, n16, n14))) continue;
                    hashSet2.add(integerPointWithValue);
                }
            }
        } while (!hashSet2.isEmpty());
        object3 = new int[n4];
        object2 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            object3[n3] = n5;
            object2[n3] = -1;
        }
        for (IntegerPointWithValue integerPointWithValue : hashSet) {
            n2 = integerPointWithValue.getX();
            int n17 = integerPointWithValue.getY();
            if (n17 < object3[n2]) {
                object3[n2] = n17;
            }
            if (n17 <= object2[n2]) continue;
            object2[n2] = n17;
        }
        GeneralPath generalPath = new GeneralPath();
        n2 = 0;
        int n18 = -1;
        Object object4 = -1;
        for (n = 0; n < n4; ++n) {
            object = object3[n];
            if (object >= n5) continue;
            if (n2 == 0) {
                generalPath.moveTo(n, (float)object);
                n2 = 1;
                n18 = n;
                object4 = object;
                continue;
            }
            generalPath.lineTo(n, (float)object);
        }
        for (n = n4 - 1; n >= 0; --n) {
            object = object2[n];
            if (object < 0) continue;
            if (n2 == 0) {
                generalPath.moveTo(n, (float)object);
                n2 = 1;
                n18 = n;
                object4 = object;
                continue;
            }
            generalPath.lineTo(n, (float)object);
        }
        if (n2 != 0) {
            generalPath.lineTo(n18, (float)object4);
            IntegerPointWithValue[] integerPointWithValueArray = null;
            try {
                integerPointWithValueArray = this.findLongestAndShortestPaths(hashSet, dArray);
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
            if (integerPointWithValueArray != null) {
                generalPath.moveTo(integerPointWithValueArray[0].getX(), integerPointWithValueArray[0].getY());
                generalPath.lineTo(integerPointWithValueArray[1].getX(), integerPointWithValueArray[1].getY());
                if (integerPointWithValueArray[2] != null && integerPointWithValueArray[3] != null) {
                    generalPath.moveTo(integerPointWithValueArray[2].getX(), integerPointWithValueArray[2].getY());
                    generalPath.lineTo(integerPointWithValueArray[3].getX(), integerPointWithValueArray[3].getY());
                }
                if (integerPointWithValueArray[4] != null && integerPointWithValueArray[5] != null) {
                    generalPath.moveTo(integerPointWithValueArray[4].getX(), integerPointWithValueArray[4].getY());
                    generalPath.lineTo(integerPointWithValueArray[5].getX(), integerPointWithValueArray[5].getY());
                }
                vector.add(generalPath);
            }
        }
    }

    protected void startInteractiveDrawing(int n, int n2) {
        this.startPoint = this.getImageCoordinateFromWindowCoordinate(n, n2);
    }

    protected void dragInteractiveDrawing(int n, int n2) {
        double d;
        this.interactiveDrawingShapes = new Vector();
        double d2 = this.startPoint.getX();
        double d3 = this.startPoint.getY();
        Point2D point2D = this.getImageCoordinateFromWindowCoordinate(n, n2);
        double d4 = point2D.getX();
        double d5 = point2D.getY();
        this.interactiveDrawingShapes.add(new Line2D.Double(this.startPoint, point2D));
        double d6 = (d4 - d2) * 2.0;
        if (d6 < 0.0) {
            d6 = -d6;
        }
        if ((d = (d5 - d3) * 2.0) < 0.0) {
            d = -d;
        }
        double d7 = d2 - d6 / 2.0;
        double d8 = d3 - d / 2.0;
        this.interactiveDrawingShapes.add(new Rectangle2D.Double(d7, d8, d6, d));
        this.repaint();
    }

    protected void endInteractiveDrawing(int n, int n2) {
        double d;
        this.interactiveDrawingShapes = new Vector();
        double d2 = this.startPoint.getX();
        double d3 = this.startPoint.getY();
        Point2D point2D = this.getImageCoordinateFromWindowCoordinate(n, n2);
        double d4 = point2D.getX();
        double d5 = point2D.getY();
        double d6 = (d4 - d2) * 2.0;
        if (d6 < 0.0) {
            d6 = -d6;
        }
        if ((d = (d5 - d3) * 2.0) < 0.0) {
            d = -d;
        }
        double d7 = d2 - d6 / 2.0;
        double d8 = d3 - d / 2.0;
        this.setRegionSelection(d2, d3, d7, d8, d7 + d6, d8 + d);
        try {
            int n3 = this.currentSrcImageSortOrder != null ? this.currentSrcImageSortOrder[this.currentSrcImageIndex] : this.currentSrcImageIndex;
            GeometryOfVolume geometryOfVolume = this.getImageGeometry();
            GeometryOfSlice[] geometryOfSliceArray = geometryOfVolume == null ? null : geometryOfVolume.getGeometryOfSlices();
            GeometryOfSlice geometryOfSlice = geometryOfSliceArray == null ? null : geometryOfSliceArray[n3];
            double[] dArray = geometryOfSlice == null ? null : geometryOfSlice.getVoxelSpacingArray();
            this.detectAndDrawRegion(this.sImg.getBufferedImage(n3), dArray, this.interactiveDrawingShapes, this.regionSelectionCenterX, this.regionSelectionCenterY, this.regionSelectionTLHCX, this.regionSelectionTLHCY, this.regionSelectionBRHCX, this.regionSelectionBRHCY);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
        this.repaint();
    }

    private class IntegerPointWithValue {
        private int x;
        private int y;
        private int v;

        public IntegerPointWithValue(int n, int n2, int n3) throws Exception {
            if (n > 65535 || n < 0 || n2 > 65535 || n2 < 0) {
                throw new Exception("coordinate too large");
            }
            this.x = n;
            this.y = n2;
            this.v = n3;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int getV() {
            return this.v;
        }

        public final boolean equals(Object object) {
            IntegerPointWithValue integerPointWithValue = (IntegerPointWithValue)object;
            return this.x == integerPointWithValue.x && this.y == integerPointWithValue.y;
        }

        public final int hashCode() {
            return this.x << 16 + this.y;
        }
    }
}

