/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.GeometryOfVolumeFromAttributeList;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.display.ConsumerFormatImageMaker;
import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.SourceImageSubset;
import com.pixelmed.display.SuperimposedImage;
import com.pixelmed.geometry.GeometryOfVolume;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.ColorUtilities;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JFrame;

public class SuperimposedDicomSegments {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SuperimposedDicomSegments.java,v 1.17 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SuperimposedDicomSegments.class);
    private static int[][] defaultSRGBValues = new int[][]{{Color.YELLOW.getRed(), Color.YELLOW.getGreen(), Color.YELLOW.getBlue()}, {Color.PINK.getRed(), Color.PINK.getGreen(), Color.PINK.getBlue()}, {Color.ORANGE.getRed(), Color.ORANGE.getGreen(), Color.ORANGE.getBlue()}, {Color.MAGENTA.getRed(), Color.MAGENTA.getGreen(), Color.MAGENTA.getBlue()}, {Color.GREEN.getRed(), Color.GREEN.getGreen(), Color.GREEN.getBlue()}};
    protected SortedMap<String, SegmentInformation> segmentInformationBySegmentNumber = new TreeMap<String, SegmentInformation>();
    protected SortedMap<String, SuperimposedImage> superimposedImagesBySegmentNumber = new TreeMap<String, SuperimposedImage>();
    protected SortedMap<String, SortedSet<Integer>> framesForSegmentBySegmentNumber = new TreeMap<String, SortedSet<Integer>>();

    public SuperimposedDicomSegments(AttributeList attributeList) throws DicomException {
        this.doCommonConstructorStuff(attributeList);
    }

    public SuperimposedDicomSegments(String string) throws DicomException, IOException {
        AttributeList attributeList = new AttributeList();
        long l = System.currentTimeMillis();
        attributeList.read(string);
        long l2 = System.currentTimeMillis();
        slf4jlogger.info("read(): took = {} ms", l2 - l);
        this.doCommonConstructorStuff(attributeList);
    }

    public SuperimposedDicomSegments(File file) throws DicomException, IOException {
        AttributeList attributeList = new AttributeList();
        long l = System.currentTimeMillis();
        attributeList.read(file);
        long l2 = System.currentTimeMillis();
        slf4jlogger.info("read(): took = {} ms", l2 - l);
        this.doCommonConstructorStuff(attributeList);
    }

    private int[] getDefaultCIELab(String string) {
        int[] nArray = ColorUtilities.getIntegerScaledCIELabPCSFromSRGB(defaultSRGBValues[0]);
        try {
            int n = Integer.parseInt(string);
            if (n > 0 && n < defaultSRGBValues.length) {
                nArray = ColorUtilities.getIntegerScaledCIELabPCSFromSRGB(defaultSRGBValues[n]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doCommonConstructorStuff(AttributeList attributeList) throws DicomException {
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        if (!SOPClass.isImageStorage(string)) return;
        long l = System.currentTimeMillis();
        SourceImage sourceImage = new SourceImage(attributeList);
        long l2 = System.currentTimeMillis();
        slf4jlogger.info("doCommonConstructorStuff(): make SourceImage allFramesImage = {} ms", l2 - l);
        Attribute attribute = attributeList.get(TagFromName.SegmentSequence);
        Attribute attribute2 = attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
        Attribute attribute3 = attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        int n = sourceImage.getNumberOfBufferedImages();
        if (sourceImage != null && n > 0 && attribute != null && attribute instanceof SequenceAttribute && attribute2 != null && attribute2 instanceof SequenceAttribute && attribute3 != null && attribute3 instanceof SequenceAttribute) {
            TreeSet<Integer> treeSet;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            slf4jlogger.info("doCommonConstructorStuff(): have a segmentation object with one or more frames");
            SequenceAttribute sequenceAttribute = (SequenceAttribute)attribute;
            int n2 = sequenceAttribute.getNumberOfItems();
            if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    SegmentInformation segmentInformation;
                    object4 = sequenceAttribute.getItem(i).getAttributeList();
                    object3 = Attribute.getSingleStringValueOrEmptyString((AttributeList)object4, TagFromName.SegmentNumber);
                    if (((String)object3).length() <= 0) throw new DicomException("Missing segment number");
                    int[] nArray = Attribute.getIntegerValues((AttributeList)object4, TagFromName.RecommendedDisplayCIELabValue);
                    if (nArray == null) {
                        nArray = this.getDefaultCIELab((String)object3);
                    }
                    if ((segmentInformation = (SegmentInformation)this.segmentInformationBySegmentNumber.get(object3)) != null) {
                        throw new DicomException("Duplicate segment number");
                    }
                    segmentInformation = new SegmentInformation((String)object3, nArray);
                    this.segmentInformationBySegmentNumber.put((String)object3, segmentInformation);
                }
            } else {
                slf4jlogger.warn("doCommonConstructorStuff(): No segments in segmentation object");
            }
            SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attribute2;
            object4 = (SequenceAttribute)attribute3;
            object3 = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute2, TagFromName.SegmentIdentificationSequence);
            int n3 = ((SequenceAttribute)object4).getNumberOfItems();
            if (n3 != n) throw new DicomException("Number of frames " + n + " does not match number of PerFrameFunctionalGroupsSequence items " + n3);
            l = System.currentTimeMillis();
            for (int i = 0; i < n; ++i) {
                void var19_21;
                Object object5 = object3;
                if (object5 == null) {
                    SequenceAttribute sequenceAttribute3 = (SequenceAttribute)((SequenceAttribute)object4).getItem(i).getAttributeList().get(TagFromName.SegmentIdentificationSequence);
                }
                if (var19_21 == null) throw new DicomException("Missing SegmentIdentificationSequence for frame " + i);
                object2 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem((SequenceAttribute)var19_21, TagFromName.ReferencedSegmentNumber);
                Object object6 = object = object2 == null ? "" : ((Attribute)object2).getSingleStringValueOrEmptyString();
                if (((String)object).length() <= 0) throw new DicomException("Missing ReferencedSegmentNumber for frame " + i);
                treeSet = (TreeSet<Integer>)this.framesForSegmentBySegmentNumber.get(object);
                if (treeSet == null) {
                    treeSet = new TreeSet<Integer>();
                    this.framesForSegmentBySegmentNumber.put((String)object, treeSet);
                }
                treeSet.add(new Integer(i));
            }
            l2 = System.currentTimeMillis();
            slf4jlogger.info("doCommonConstructorStuff(): process frames = {} ms", l2 - l);
            for (String string2 : this.framesForSegmentBySegmentNumber.keySet()) {
                object2 = (SortedSet)this.framesForSegmentBySegmentNumber.get(string2);
                object = new int[object2.size()];
                int n4 = 0;
                Object object7 = object2.iterator();
                while (object7.hasNext()) {
                    Integer n5 = (Integer)object7.next();
                    object[n4++] = n5;
                }
                treeSet = new SourceImageSubset(sourceImage, (int[])object);
                object7 = new GeometryOfVolumeFromAttributeList(attributeList, (int[])object);
                if (!((GeometryOfVolume)object7).isVolumeSampledRegularlyAlongFrameDimension()) {
                    slf4jlogger.warn("doCommonConstructorStuff(): Superimposed geometry is not a single regularly sampled volume for segment {}", string2);
                }
                this.superimposedImagesBySegmentNumber.put(string2, new SuperimposedImage((SourceImage)((Object)treeSet), (GeometryOfVolume)object7, ((SegmentInformation)this.segmentInformationBySegmentNumber.get((Object)string2)).cieLab));
            }
            return;
        } else {
            slf4jlogger.warn("SuperimposedDicomSegments.doCommonConstructorStuff(): Not a valid segmentation object");
        }
    }

    public Vector<SuperimposedImage> getSuperimposedImages() throws DicomException {
        Vector<SuperimposedImage> vector = new Vector<SuperimposedImage>();
        for (String string : this.superimposedImagesBySegmentNumber.keySet()) {
            vector.add((SuperimposedImage)this.superimposedImagesBySegmentNumber.get(string));
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        try {
            String string = null;
            String string2 = null;
            if (stringArray.length == 1) {
                string2 = stringArray[0];
            } else {
                string = stringArray[0];
                string2 = stringArray[1];
            }
            long l = System.currentTimeMillis();
            SuperimposedDicomSegments superimposedDicomSegments = new SuperimposedDicomSegments(string2);
            long l2 = System.currentTimeMillis();
            slf4jlogger.info("main(): SuperimposedDicomSegments took = {} ms", l2 - l);
            Vector<SuperimposedImage> vector = superimposedDicomSegments.getSuperimposedImages();
            if (stringArray.length > 2) {
                String string3 = stringArray[2];
                ConsumerFormatImageMaker.convertFileToEightBitImage(string, string3, "jpeg", 0.0, 0.0, 0, 0, 100, "all", vector, null);
            } else if (stringArray.length > 1) {
                AttributeList attributeList = new AttributeList();
                attributeList.read(string);
                SourceImage sourceImage = new SourceImage(attributeList);
                GeometryOfVolumeFromAttributeList geometryOfVolumeFromAttributeList = new GeometryOfVolumeFromAttributeList(attributeList);
                SingleImagePanel singleImagePanel = new SingleImagePanel(sourceImage, null, geometryOfVolumeFromAttributeList);
                singleImagePanel.setSuperimposedImages(vector);
                JFrame jFrame = new JFrame();
                jFrame.add(singleImagePanel);
                jFrame.setSize(sourceImage.getWidth(), sourceImage.getHeight());
                jFrame.setVisible(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected class SegmentInformation {
        String segmentNumber;
        int[] cieLab;

        public SegmentInformation(String string, int[] nArray) {
            this.segmentNumber = string;
            this.cieLab = nArray;
        }
    }
}

