/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.display.DrawingUtilities;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class TextAnnotationPositioned {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/TextAnnotationPositioned.java,v 1.17 2025/01/29 10:58:08 dclunie Exp $";
    private String string;
    private boolean fromLeft;
    private boolean fromTop;
    private int textRow;

    public TextAnnotationPositioned(String string, boolean bl, boolean bl2, int n) {
        this.string = string;
        this.fromLeft = bl;
        this.fromTop = bl2;
        this.textRow = n;
    }

    public String getString() {
        return this.string;
    }

    public boolean isLeft() {
        return this.fromLeft;
    }

    public boolean isTop() {
        return this.fromTop;
    }

    public int getTextRow() {
        return this.textRow;
    }

    public static void drawPositionedString(TextAnnotationPositioned textAnnotationPositioned, Graphics2D graphics2D, Component component, int n, int n2) {
        TextAnnotationPositioned.drawPositionedString(textAnnotationPositioned.getString(), textAnnotationPositioned.isLeft(), textAnnotationPositioned.isTop(), textAnnotationPositioned.getTextRow(), graphics2D, component, n, n2);
    }

    public static void drawPositionedString(TextAnnotationPositioned textAnnotationPositioned, Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = fontMetrics.getHeight();
        TextAnnotationPositioned.drawPositionedString(textAnnotationPositioned.getString(), textAnnotationPositioned.isLeft(), textAnnotationPositioned.isTop(), textAnnotationPositioned.getTextRow(), graphics2D, fontMetrics, n5, n, n2, n3, n4);
    }

    public static void drawPositionedString(TextAnnotationPositioned textAnnotationPositioned, Graphics2D graphics2D, FontMetrics fontMetrics, int n, int n2, int n3, int n4, int n5) {
        TextAnnotationPositioned.drawPositionedString(textAnnotationPositioned.getString(), textAnnotationPositioned.isLeft(), textAnnotationPositioned.isTop(), textAnnotationPositioned.getTextRow(), graphics2D, fontMetrics, n, n2, n3, n4, n5);
    }

    public static void drawPositionedString(String string, boolean bl, boolean bl2, int n, Graphics2D graphics2D, Component component, int n2, int n3) {
        Rectangle rectangle = component.getBounds();
        int n4 = rectangle.height;
        int n5 = rectangle.width;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n6 = fontMetrics.getHeight();
        TextAnnotationPositioned.drawPositionedString(string, bl, bl2, n, graphics2D, fontMetrics, n6, n5, n4, n2, n3);
    }

    public static void drawPositionedString(String string, boolean bl, boolean bl2, int n, Graphics2D graphics2D, FontMetrics fontMetrics, int n2, int n3, int n4, int n5, int n6) {
        int n7 = (int)fontMetrics.getStringBounds(string, graphics2D).getWidth();
        int n8 = bl ? n6 : n3 - n6 - n7;
        int n9 = bl2 ? n5 + (n + 1) * n2 : n4 - n5 - n * n2;
        DrawingUtilities.drawShadowedString(string, n8, n9, graphics2D);
    }

    public static void drawVerticallyCenteredString(String string, boolean bl, Graphics2D graphics2D, Component component, int n) {
        TextAnnotationPositioned.drawVerticallyCenteredString(string, bl, graphics2D, component, 0, n);
    }

    public static void drawVerticallyCenteredString(String string, boolean bl, Graphics2D graphics2D, Component component, int n, int n2) {
        Rectangle rectangle = component.getBounds();
        int n3 = rectangle.height;
        int n4 = rectangle.width;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = fontMetrics.getHeight();
        int n6 = (int)fontMetrics.getStringBounds(string, graphics2D).getWidth();
        int n7 = bl ? n2 : n4 - n2 - n6;
        int n8 = n3 / 2 - n5 / 2 + n * n5;
        DrawingUtilities.drawShadowedString(string, n7, n8, graphics2D);
    }

    public static void drawHorizontallyCenteredString(String string, boolean bl, Graphics2D graphics2D, Component component, int n) {
        Rectangle rectangle = component.getBounds();
        int n2 = rectangle.height;
        int n3 = rectangle.width;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n4 = fontMetrics.getHeight();
        int n5 = (int)fontMetrics.getStringBounds(string, graphics2D).getWidth();
        int n6 = n3 / 2 - n5 / 2;
        int n7 = bl ? n + n4 : n2 - n - n4;
        DrawingUtilities.drawShadowedString(string, n6, n7, graphics2D);
    }

    public static void drawShadowedString(String string, int n, int n2, Graphics2D graphics2D) {
        DrawingUtilities.drawShadowedString(string, n, n2, graphics2D);
    }
}

