/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TiledFramesIndex;
import com.pixelmed.display.SourceInstanceSortOrderPanel;
import com.pixelmed.display.event.FrameSelectionChangeEvent;
import com.pixelmed.display.event.SourceImageSelectionChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.Event;
import com.pixelmed.event.EventContext;
import com.pixelmed.event.SelfRegisteringListener;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class TiledSourceImageSortOrderPanel
extends SourceInstanceSortOrderPanel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/TiledSourceImageSortOrderPanel.java,v 1.21 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(TiledSourceImageSortOrderPanel.class);
    private OurSourceImageSelectionChangeListener ourSourceImageSelectionChangeListener;
    protected JPanel rowsSliderControlsPanel;
    protected JSlider rowsSlider;
    protected int currentRowsSliderMinimum;
    protected int currentRowsSliderMaximum;
    protected JPanel columnsSliderControlsPanel;
    protected JSlider columnsSlider;
    protected int currentColumnsSliderMinimum;
    protected int currentColumnsSliderMaximum;
    protected ChangeListener rowsSliderChangeListener;
    protected ChangeListener columnsSliderChangeListener;
    protected TiledFramesIndex tiledFramesIndex;

    public TiledFramesIndex getTiledFramesIndex() {
        return this.tiledFramesIndex;
    }

    protected void updateColumnsSlider(int n, int n2, int n3) {
        slf4jlogger.debug("updateColumnsSlider(): min = {}", n);
        slf4jlogger.debug("updateColumnsSlider(): max = {}", n2);
        slf4jlogger.debug("updateColumnsSlider(): value = {}", n3);
        slf4jlogger.debug("updateColumnsSlider(): currentColumnsSliderMinimum = {}", this.currentColumnsSliderMinimum);
        slf4jlogger.debug("updateColumnsSlider(): currentColumnsSliderMaximum = {}", this.currentColumnsSliderMaximum);
        if (n != this.currentColumnsSliderMinimum || n2 != this.currentColumnsSliderMaximum) {
            slf4jlogger.debug("updateColumnsSlider(): removing and rebuilding slider (if needed)");
            this.columnsSliderControlsPanel.removeAll();
            if (n2 > n) {
                this.columnsSlider = new JSlider(n, n2, n3);
                this.columnsSlider.setLabelTable(this.columnsSlider.createStandardLabels(n2 - 1, n));
                this.columnsSlider.setPaintLabels(true);
                this.columnsSliderControlsPanel.add(new JLabel("Column:"));
                this.columnsSliderControlsPanel.add(this.columnsSlider);
                this.columnsSlider.addChangeListener(this.columnsSliderChangeListener);
            } else {
                slf4jlogger.debug("updateColumnsSlider(): slider not needed");
                this.columnsSlider = null;
            }
            this.currentColumnsSliderMinimum = n;
            this.currentColumnsSliderMaximum = n2;
        }
        if (this.columnsSlider != null && this.columnsSlider.getValue() != n3) {
            this.columnsSlider.setValue(n3);
        }
    }

    protected void updateColumnsSlider(int n) {
        slf4jlogger.debug("updateColumnsSlider(): value = {}", n);
        if (this.columnsSlider != null && this.columnsSlider.getValue() != n) {
            this.columnsSlider.setValue(n);
        }
    }

    protected void updateRowsSlider(int n, int n2, int n3) {
        slf4jlogger.debug("updateRowsSlider(): min = {}", n);
        slf4jlogger.debug("updateRowsSlider(): max = {}", n2);
        slf4jlogger.debug("updateRowsSlider(): value = {}", n3);
        slf4jlogger.debug("updateRowsSlider(): currentRowsSliderMinimum = {}", this.currentRowsSliderMinimum);
        slf4jlogger.debug("updateRowsSlider(): currentRowsSliderMaximum = {}", this.currentRowsSliderMaximum);
        if (n != this.currentRowsSliderMinimum || n2 != this.currentRowsSliderMaximum) {
            slf4jlogger.debug("updateRowsSlider(): removing and rebuilding slider (if needed)");
            this.rowsSliderControlsPanel.removeAll();
            if (n2 > n) {
                this.rowsSlider = new JSlider(n, n2, n3);
                this.rowsSlider.setLabelTable(this.rowsSlider.createStandardLabels(n2 - 1, n));
                this.rowsSlider.setPaintLabels(true);
                this.rowsSliderControlsPanel.add(new JLabel("Row:"));
                this.rowsSliderControlsPanel.add(this.rowsSlider);
                this.rowsSlider.addChangeListener(this.rowsSliderChangeListener);
            } else {
                slf4jlogger.debug("updateRowsSlider(): slider not needed");
                this.rowsSlider = null;
            }
            this.currentRowsSliderMinimum = n;
            this.currentRowsSliderMaximum = n2;
        }
        if (this.rowsSlider != null && this.rowsSlider.getValue() != n3) {
            this.rowsSlider.setValue(n3);
        }
    }

    protected void updateRowsSlider(int n) {
        slf4jlogger.debug("updateRowsSlider(): value = {}", n);
        if (this.rowsSlider != null && this.rowsSlider.getValue() != n) {
            this.rowsSlider.setValue(n);
        }
    }

    public TiledSourceImageSortOrderPanel(EventContext eventContext) {
        super(eventContext);
        this.ourFrameSelectionChangeListener = new TiledSourceImageFrameSelectionChangeListener(eventContext);
        this.rowsSliderControlsPanel = new JPanel();
        this.add(this.rowsSliderControlsPanel);
        this.rowsSliderChangeListener = new RowsSliderChangeListener();
        this.columnsSliderControlsPanel = new JPanel();
        this.add(this.columnsSliderControlsPanel);
        this.columnsSliderChangeListener = new ColumnsSliderChangeListener();
        this.ourSourceImageSelectionChangeListener = new OurSourceImageSelectionChangeListener(eventContext);
    }

    private class ColumnsSliderChangeListener
    implements ChangeListener {
        private ColumnsSliderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n = TiledSourceImageSortOrderPanel.this.rowsSlider == null ? 0 : TiledSourceImageSortOrderPanel.this.rowsSlider.getValue() - 1;
            int n2 = TiledSourceImageSortOrderPanel.this.columnsSlider == null ? 0 : TiledSourceImageSortOrderPanel.this.columnsSlider.getValue() - 1;
            slf4jlogger.debug("ColumnsSliderChangeListener.stateChanged(): wantRow = {}", n);
            slf4jlogger.debug("ColumnsSliderChangeListener.stateChanged(): wantColumn = {}", n2);
            int n3 = TiledSourceImageSortOrderPanel.this.tiledFramesIndex.getFrameNumber(n, n2);
            slf4jlogger.debug("ColumnsSliderChangeListener.stateChanged(): tiledFramesIndex.getFrameNumber() = {}", n3);
            if (n3 > 0) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new FrameSelectionChangeEvent(TiledSourceImageSortOrderPanel.this.typeOfPanelEventContext, n3 - 1));
            } else {
                slf4jlogger.warn("ColumnsSliderChangeListener.stateChanged(): request for unencoded tile row {} column {} in sparse matrix ", n, n2);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new FrameSelectionChangeEvent(TiledSourceImageSortOrderPanel.this.typeOfPanelEventContext, -1));
            }
        }
    }

    private class RowsSliderChangeListener
    implements ChangeListener {
        private RowsSliderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n = TiledSourceImageSortOrderPanel.this.rowsSlider == null ? 0 : TiledSourceImageSortOrderPanel.this.rowsSlider.getValue() - 1;
            int n2 = TiledSourceImageSortOrderPanel.this.columnsSlider == null ? 0 : TiledSourceImageSortOrderPanel.this.columnsSlider.getValue() - 1;
            slf4jlogger.debug("RowsSliderChangeListener.stateChanged(): wantRow = {}", n);
            slf4jlogger.debug("RowsSliderChangeListener.stateChanged(): wantColumn = {}", n2);
            int n3 = TiledSourceImageSortOrderPanel.this.tiledFramesIndex.getFrameNumber(n, n2);
            slf4jlogger.debug("RowsSliderChangeListener.stateChanged(): tiledFramesIndex.getFrameNumber() = {}", n3);
            if (n3 > 0) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new FrameSelectionChangeEvent(TiledSourceImageSortOrderPanel.this.typeOfPanelEventContext, n3 - 1));
            } else {
                slf4jlogger.warn("RowsSliderChangeListener.stateChanged(): request for unencoded tile row {} column {} in sparse matrix ", n, n2);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new FrameSelectionChangeEvent(TiledSourceImageSortOrderPanel.this.typeOfPanelEventContext, -1));
            }
        }
    }

    class TiledSourceImageFrameSelectionChangeListener
    extends SourceInstanceSortOrderPanel.OurFrameSelectionChangeListener {
        public TiledSourceImageFrameSelectionChangeListener(EventContext eventContext) {
            super(eventContext);
            slf4jlogger.debug("TiledSourceImageFrameSelectionChangeListener():");
        }

        @Override
        public void changed(Event event) {
            if (TiledSourceImageSortOrderPanel.this.active) {
                super.changed(event);
                FrameSelectionChangeEvent frameSelectionChangeEvent = (FrameSelectionChangeEvent)event;
                if (slf4jlogger.isDebugEnabled()) {
                    slf4jlogger.debug("TiledSourceImageFrameSelectionChangeListener.changed(): event={}", frameSelectionChangeEvent.toString());
                }
                int n = frameSelectionChangeEvent.getIndex();
                slf4jlogger.debug("TiledSourceImageFrameSelectionChangeListener.changed(): currentSrcInstanceIndex = {}", n);
                try {
                    if (n != -1 && TiledSourceImageSortOrderPanel.this.tiledFramesIndex != null) {
                        slf4jlogger.debug("TiledSourceImageFrameSelectionChangeListener.changed(): updating row and column sliders");
                        int n2 = TiledSourceImageSortOrderPanel.this.tiledFramesIndex.getRow(n + 1);
                        int n3 = TiledSourceImageSortOrderPanel.this.tiledFramesIndex.getColumn(n + 1);
                        TiledSourceImageSortOrderPanel.this.updateRowsSlider(n2 + 1);
                        TiledSourceImageSortOrderPanel.this.updateColumnsSlider(n3 + 1);
                    }
                }
                catch (Exception exception) {
                    slf4jlogger.error("Failed to update row and column sliders", exception);
                }
            }
        }
    }

    class OurSourceImageSelectionChangeListener
    extends SelfRegisteringListener {
        public OurSourceImageSelectionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.SourceImageSelectionChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            if (TiledSourceImageSortOrderPanel.this.active) {
                SourceImageSelectionChangeEvent sourceImageSelectionChangeEvent = (SourceImageSelectionChangeEvent)event;
                TiledSourceImageSortOrderPanel.this.byFrameOrderButton.setSelected(true);
                TiledSourceImageSortOrderPanel.this.nSrcInstances = sourceImageSelectionChangeEvent.getNumberOfBufferedImages();
                TiledSourceImageSortOrderPanel.this.currentSrcInstanceAttributeList = sourceImageSelectionChangeEvent.getAttributeList();
                TiledSourceImageSortOrderPanel.this.replaceListOfDimensions(TiledSourceImageSortOrderPanel.this.buildListOfDimensionsFromAttributeList(TiledSourceImageSortOrderPanel.this.currentSrcInstanceAttributeList));
                TiledSourceImageSortOrderPanel.this.currentSrcInstanceSortOrder = sourceImageSelectionChangeEvent.getSortOrder();
                TiledSourceImageSortOrderPanel.this.currentSrcInstanceIndex = sourceImageSelectionChangeEvent.getIndex();
                TiledSourceImageSortOrderPanel.this.updateCineSlider(1, TiledSourceImageSortOrderPanel.this.nSrcInstances, TiledSourceImageSortOrderPanel.this.currentSrcInstanceIndex + 1);
                String string = Attribute.getSingleStringValueOrEmptyString(TiledSourceImageSortOrderPanel.this.currentSrcInstanceAttributeList, TagFromName.SOPClassUID);
                if (SOPClass.isTiledImageStorage(string)) {
                    try {
                        TiledSourceImageSortOrderPanel.this.tiledFramesIndex = new TiledFramesIndex(TiledSourceImageSortOrderPanel.this.currentSrcInstanceAttributeList, true, true, false);
                        if (slf4jlogger.isDebugEnabled()) {
                            slf4jlogger.debug("\n{}", TiledSourceImageSortOrderPanel.this.tiledFramesIndex.toString());
                        }
                        TiledSourceImageSortOrderPanel.this.updateRowsSlider(1, TiledSourceImageSortOrderPanel.this.tiledFramesIndex.getNumberOfRowsOfTiles(), 1);
                        TiledSourceImageSortOrderPanel.this.updateColumnsSlider(1, TiledSourceImageSortOrderPanel.this.tiledFramesIndex.getNumberOfColumnsOfTiles(), 1);
                    }
                    catch (DicomException dicomException) {
                        slf4jlogger.error("Failed to build index of tiled frames ", dicomException);
                    }
                }
            }
        }
    }
}

