/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.HexDump;
import com.pixelmed.utils.UUIDBasedOID;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public class DeviceParticipant {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dose/DeviceParticipant.java,v 1.17 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DeviceParticipant.class);
    protected String manufacturer;
    protected String modelName;
    protected String serialNumber;
    protected String uid;
    private static final UUID nameSpaceForType3UIDForDeviceObserverUID = UUID.fromString("71E7C730-7EA2-11E1-9CFD-7CD04824019B");

    public DeviceParticipant(String string, String string2, String string3) {
        this.manufacturer = string;
        this.modelName = string2;
        this.serialNumber = string3;
        this.uid = null;
    }

    public DeviceParticipant(String string, String string2, String string3, String string4) {
        this.manufacturer = string;
        this.modelName = string2;
        this.serialNumber = string3;
        this.uid = string4;
    }

    public DeviceParticipant(ContentItem contentItem) {
        ContentItem contentItem2 = contentItem.getNamedChild("DCM", "113876");
        if (contentItem2 != null && contentItem2 instanceof ContentItemFactory.CodeContentItem && ((ContentItemFactory.CodeContentItem)contentItem2).contentItemValueMatchesCodeValueAndCodingSchemeDesignator("113859", "DCM")) {
            this.manufacturer = ContentItem.getSingleStringValueOrNullOfNamedChild(contentItem2, "DCM", "113878");
            this.modelName = ContentItem.getSingleStringValueOrNullOfNamedChild(contentItem2, "DCM", "113879");
            this.serialNumber = ContentItem.getSingleStringValueOrNullOfNamedChild(contentItem2, "DCM", "113880");
            this.uid = ContentItem.getSingleStringValueOrNullOfNamedChild(contentItem2, "DCM", "121012");
        }
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getUID() {
        return this.uid;
    }

    public ContentItem getStructuredReportFragment() throws DicomException {
        ContentItemFactory contentItemFactory;
        ContentItemFactory contentItemFactory2 = contentItemFactory = new ContentItemFactory();
        contentItemFactory2.getClass();
        ContentItemFactory.CodeContentItem codeContentItem = contentItemFactory2.new ContentItemFactory.CodeContentItem(null, "CONTAINS", new CodedSequenceItem("113876", "DCM", "Device Role in Procedure"), new CodedSequenceItem("113859", "DCM", "Irradiating Device"));
        if (this.manufacturer != null && this.manufacturer.trim().length() > 0) {
            ContentItemFactory contentItemFactory3 = contentItemFactory;
            contentItemFactory3.getClass();
            contentItemFactory3.new ContentItemFactory.TextContentItem(codeContentItem, "HAS PROPERTIES", new CodedSequenceItem("113878", "DCM", "Device Manufacturer"), this.manufacturer);
        }
        if (this.modelName != null && this.modelName.trim().length() > 0) {
            ContentItemFactory contentItemFactory4 = contentItemFactory;
            contentItemFactory4.getClass();
            contentItemFactory4.new ContentItemFactory.TextContentItem(codeContentItem, "HAS PROPERTIES", new CodedSequenceItem("113879", "DCM", "Device Model Name"), this.modelName);
        }
        if (this.serialNumber != null && this.serialNumber.trim().length() > 0) {
            ContentItemFactory contentItemFactory5 = contentItemFactory;
            contentItemFactory5.getClass();
            contentItemFactory5.new ContentItemFactory.TextContentItem(codeContentItem, "HAS PROPERTIES", new CodedSequenceItem("113880", "DCM", "Device Serial Number"), this.serialNumber);
        }
        if (this.uid != null && this.uid.trim().length() > 0) {
            ContentItemFactory contentItemFactory6 = contentItemFactory;
            contentItemFactory6.getClass();
            contentItemFactory6.new ContentItemFactory.UIDContentItem(codeContentItem, "HAS PROPERTIES", new CodedSequenceItem("121012", "DCM", "Device Observer UID"), this.uid);
        }
        return codeContentItem;
    }

    public static String getDeviceSerialNumberOrSuitableAlternative(AttributeList attributeList, boolean bl) {
        String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.DeviceSerialNumber);
        if (string == null || string.trim().length() == 0) {
            String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.InstitutionName);
            String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StationName);
            if (string2.length() > 0 || string3.length() > 0) {
                try {
                    byte[] byArray = (string2 + "|" + string3).getBytes("UTF8");
                    string = HexDump.byteArrayToHexString(MessageDigest.getInstance("SHA").digest(byArray));
                    if (bl) {
                        LongStringAttribute longStringAttribute = new LongStringAttribute(TagFromName.DeviceSerialNumber);
                        ((Attribute)longStringAttribute).addValue(string);
                        attributeList.put(longStringAttribute);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    slf4jlogger.error("", unsupportedEncodingException);
                    string = null;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    slf4jlogger.error("", noSuchAlgorithmException);
                    string = null;
                }
                catch (DicomException dicomException) {
                    slf4jlogger.error("", dicomException);
                }
            }
        }
        return string;
    }

    public static String getDeviceObserverUIDOrSuitableAlternative(AttributeList attributeList) {
        String string = null;
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.DeviceSerialNumber);
        String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.InstitutionName);
        String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StationName);
        String string5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Manufacturer);
        String string6 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.ManufacturerModelName);
        if (string2.length() > 0 || string3.length() > 0 || string4.length() > 0 || string5.length() > 0 || string6.length() > 0) {
            try {
                byte[] byArray = (string2 + "|" + string3 + "|" + string4 + "|" + string5 + "|" + string6).getBytes("UTF8");
                string = new UUIDBasedOID(nameSpaceForType3UIDForDeviceObserverUID, byArray).getOID();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                slf4jlogger.error("", unsupportedEncodingException);
                string = null;
            }
        }
        return string;
    }
}

