/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.event;

import com.pixelmed.event.Event;
import com.pixelmed.event.EventContext;
import com.pixelmed.event.EventDispatcher;
import com.pixelmed.event.Listener;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Vector;

public class ApplicationEventDispatcher
implements EventDispatcher {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/event/ApplicationEventDispatcher.java,v 1.20 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ApplicationEventDispatcher.class);
    private static ApplicationEventDispatcher applicationEventDispatcher;
    private Vector listeners = new Vector();

    public static synchronized ApplicationEventDispatcher getApplicationEventDispatcher() {
        if (applicationEventDispatcher == null) {
            applicationEventDispatcher = new ApplicationEventDispatcher();
        }
        if (applicationEventDispatcher == null) {
            throw new RuntimeException("Internal error - cannot make new ApplicationEventDispatcher");
        }
        return applicationEventDispatcher;
    }

    private ApplicationEventDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Listener listener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(new WeakReference<Listener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Listener listener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                if (weakReference == null) {
                    slf4jlogger.info("removeListener(): tidy up weak reference that was nulled - this should not happen");
                    iterator.remove();
                    continue;
                }
                Listener listener2 = (Listener)weakReference.get();
                if (listener2 == null) {
                    slf4jlogger.info("removeListener(): tidy up weak reference that was nulled - this should not happen");
                    iterator.remove();
                    continue;
                }
                if (!listener2.equals(listener)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllListenersForEventContext(EventContext eventContext) {
        if (eventContext != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    WeakReference weakReference = (WeakReference)iterator.next();
                    if (weakReference == null) {
                        slf4jlogger.info("removeAllListenersForEventContext(): tidy up weak reference that was nulled - this should not happen");
                        iterator.remove();
                        continue;
                    }
                    Listener listener = (Listener)weakReference.get();
                    if (listener == null) {
                        slf4jlogger.info("removeAllListenersForEventContext(): tidy up weak reference that was nulled - this should not happen");
                        iterator.remove();
                        continue;
                    }
                    if (listener.getEventContext() != eventContext) continue;
                    iterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void processEvent(Event event) {
        Class<?> clazz = event.getClass();
        EventContext eventContext = event.getEventContext();
        Vector vector = this.listeners;
        synchronized (vector) {
            for (WeakReference weakReference : this.listeners) {
                Listener listener;
                if (weakReference == null || (listener = (Listener)weakReference.get()) == null) continue;
                EventContext eventContext2 = listener.getEventContext();
                if (listener.getClassOfEventHandled() != clazz || eventContext != null && eventContext2 != null && eventContext2 != eventContext) continue;
                listener.changed(event);
            }
        }
    }
}

