/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.utils.ByteArray;

class AAbortPDU {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/AAbortPDU.java,v 1.18 2025/01/29 10:58:08 dclunie Exp $";
    private byte[] b;
    private int pduType;
    private int pduLength;
    private int source;
    private int reason;

    public AAbortPDU(int n, int n2) throws DicomNetworkException {
        this.pduType = 7;
        this.source = n;
        this.reason = n2;
        this.b = new byte[10];
        this.b[0] = (byte)this.pduType;
        this.b[1] = 0;
        this.pduLength = 4;
        this.b[2] = (byte)(this.pduLength >> 24);
        this.b[3] = (byte)(this.pduLength >> 16);
        this.b[4] = (byte)(this.pduLength >> 8);
        this.b[5] = (byte)this.pduLength;
        this.b[6] = 0;
        this.b[7] = 0;
        this.b[8] = (byte)n;
        this.b[9] = (byte)n2;
    }

    public AAbortPDU(byte[] byArray) throws DicomNetworkException {
        this.b = byArray;
        this.pduType = this.b[0] & 0xFF;
        this.pduLength = ByteArray.bigEndianToUnsignedInt(this.b, 2, 4);
        this.source = this.b[8] & 0xFF;
        this.reason = this.b[9] & 0xFF;
    }

    public byte[] getBytes() {
        return this.b;
    }

    public String getInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.source == 0) {
            stringBuffer.append("by DICOM UL Service User");
        } else if (this.source == 2) {
            stringBuffer.append("by DICOM UL Service Provider");
        }
        if (this.source == 2) {
            if (this.reason == 0) {
                stringBuffer.append(", reason not specified");
            } else if (this.reason == 1) {
                stringBuffer.append(", unrecognized PDU");
            } else if (this.reason == 2) {
                stringBuffer.append(", unexpected PDU");
            } else if (this.reason == 4) {
                stringBuffer.append(", unrecognized PDU parameter");
            } else if (this.reason == 5) {
                stringBuffer.append(", unexpected PDU parameter");
            } else if (this.reason == 6) {
                stringBuffer.append(", invalid PDU parameter value");
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PDU Type: 0x");
        stringBuffer.append(this.pduType);
        stringBuffer.append(this.pduType == 7 ? " (A-ABORT)" : " unrecognized");
        stringBuffer.append("\n");
        stringBuffer.append("Length: 0x");
        stringBuffer.append(Integer.toHexString(this.pduLength));
        stringBuffer.append("\n");
        stringBuffer.append("Source: 0x");
        stringBuffer.append(Integer.toHexString(this.source));
        if (this.source == 1) {
            stringBuffer.append(" (DICOM UL Service User)");
        } else if (this.source == 2) {
            stringBuffer.append(" (DICOM UL Service Provider)");
        }
        stringBuffer.append("\n");
        stringBuffer.append("Reason: 0x");
        stringBuffer.append(Integer.toHexString(this.reason));
        if (this.source == 2) {
            if (this.reason == 0) {
                stringBuffer.append(" (reason not specified)");
            } else if (this.reason == 1) {
                stringBuffer.append(" (unrecognized PDU)");
            } else if (this.reason == 2) {
                stringBuffer.append(" (unexpected PDU)");
            } else if (this.reason == 4) {
                stringBuffer.append(" (unrecognized PDU parameter)");
            } else if (this.reason == 5) {
                stringBuffer.append(" (unexpected PDU parameter)");
            } else if (this.reason == 6) {
                stringBuffer.append(" (invalid PDU parameter value)");
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

