/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.PresentationContext;
import com.pixelmed.network.SCUSCPRoleSelection;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.ByteArray;
import com.pixelmed.utils.HexDump;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

class AssociateRequestAcceptPDU {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/AssociateRequestAcceptPDU.java,v 1.35 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(AssociateRequestAcceptPDU.class);
    private byte[] b;
    protected int pduType;
    private int pduLength;
    private int protocolVersion;
    private String calledAETitle;
    private String callingAETitle;
    private LinkedList itemList;
    private int maximumLengthReceived;

    private static void writeAETToPDU(String string, ByteArrayOutputStream byteArrayOutputStream, String string2) throws DicomNetworkException, UnsupportedEncodingException {
        byte[] byArray = string.getBytes("ASCII");
        int n = byArray.length;
        if (n > 16) {
            throw new DicomNetworkException(string2 + " AET too long (>16)");
        }
        byteArrayOutputStream.write(byArray, 0, n);
        while (n++ < 16) {
            byteArrayOutputStream.write(32);
        }
    }

    private static final byte[] makeByteArrayOfSyntaxSubItem(int n, String string) throws DicomNetworkException, UnsupportedEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byteArrayOutputStream.write(n);
        byteArrayOutputStream.write(0);
        byte[] byArray = string.getBytes("ASCII");
        int n2 = byArray.length;
        byteArrayOutputStream.write((byte)(n2 >> 8));
        byteArrayOutputStream.write((byte)n2);
        byteArrayOutputStream.write(byArray, 0, n2);
        return byteArrayOutputStream.toByteArray();
    }

    private static final byte[] makeByteArrayOfPresentationContextItem(int n, PresentationContext presentationContext) throws DicomNetworkException, UnsupportedEncodingException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byteArrayOutputStream.write((byte)n);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(presentationContext.getIdentifier() & 0xFF);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(n == 32 ? (byte)0 : presentationContext.getResultReason());
        byteArrayOutputStream.write(0);
        String string = presentationContext.getAbstractSyntaxUID();
        if (string != null && string.length() > 0) {
            object = AssociateRequestAcceptPDU.makeByteArrayOfSyntaxSubItem(48, string);
            byteArrayOutputStream.write((byte[])object, 0, ((Object)object).length);
        }
        object = presentationContext.getTransferSyntaxUIDs().listIterator();
        while (object.hasNext()) {
            byte[] byArray = AssociateRequestAcceptPDU.makeByteArrayOfSyntaxSubItem(64, (String)object.next());
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
        int n2 = byteArrayOutputStream.size() - 4;
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byArray[2] = (byte)(n2 >> 8);
        byArray[3] = (byte)n2;
        return byArray;
    }

    private static final byte[] makeByteArrayOfSCUSCPRoleSelection(SCUSCPRoleSelection sCUSCPRoleSelection) throws DicomNetworkException, UnsupportedEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byteArrayOutputStream.write(84);
        byteArrayOutputStream.write(0);
        byte[] byArray = sCUSCPRoleSelection.getAbstractSyntaxUID().getBytes("ASCII");
        int n = byArray.length;
        int n2 = n + 2 + 2;
        byteArrayOutputStream.write((byte)(n2 >> 8));
        byteArrayOutputStream.write((byte)n2);
        byteArrayOutputStream.write((byte)(n >> 8));
        byteArrayOutputStream.write((byte)n);
        byteArrayOutputStream.write(byArray, 0, n);
        byteArrayOutputStream.write(sCUSCPRoleSelection.isSCURoleSupported() ? 1 : 0);
        byteArrayOutputStream.write(sCUSCPRoleSelection.isSCPRoleSupported() ? 1 : 0);
        return byteArrayOutputStream.toByteArray();
    }

    private final byte[] makeByteArrayOfSCUSCPRoleSelections(LinkedList linkedList, LinkedList linkedList2) throws DicomNetworkException, UnsupportedEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        if (linkedList != null) {
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                SCUSCPRoleSelection sCUSCPRoleSelection = (SCUSCPRoleSelection)listIterator.next();
                byte[] byArray = AssociateRequestAcceptPDU.makeByteArrayOfSCUSCPRoleSelection(sCUSCPRoleSelection);
                byteArrayOutputStream.write(byArray, 0, byArray.length);
                SCUSCPRoleSelectionUserInformationSubItem sCUSCPRoleSelectionUserInformationSubItem = new SCUSCPRoleSelectionUserInformationSubItem(84, byArray.length, sCUSCPRoleSelection);
                linkedList2.add(sCUSCPRoleSelectionUserInformationSubItem);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public AssociateRequestAcceptPDU(int n, String string, String string2, String string3, String string4, int n2, LinkedList linkedList) throws DicomNetworkException {
        this.doCommonConstructorStuff(n, string, string2, string3, string4, n2, linkedList, null, 0, null, null, null);
    }

    public AssociateRequestAcceptPDU(int n, String string, String string2, String string3, String string4, int n2, LinkedList linkedList, LinkedList linkedList2, int n3, String string5, String string6) throws DicomNetworkException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (n3 > 0) {
            try {
                if (string5 != null) {
                    byArray = string5.getBytes("UTF8");
                    slf4jlogger.info("userIdentityPrimaryField = {}", string5);
                    if (slf4jlogger.isInfoEnabled()) {
                        slf4jlogger.info("userIdentityPrimaryFieldBytes = " + HexDump.dump(byArray));
                    }
                }
                if (string6 != null) {
                    byArray2 = string6.getBytes("UTF8");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new DicomNetworkException("Internal error - cannot convert UTF8 primary or secondary field" + unsupportedEncodingException);
            }
        }
        this.doCommonConstructorStuff(n, string, string2, string3, string4, n2, linkedList, linkedList2, n3, byArray, byArray2, null);
    }

    public AssociateRequestAcceptPDU(int n, String string, String string2, String string3, String string4, int n2, LinkedList linkedList, LinkedList linkedList2, int n3, byte[] byArray, byte[] byArray2) throws DicomNetworkException {
        this.doCommonConstructorStuff(n, string, string2, string3, string4, n2, linkedList, linkedList2, n3, byArray, byArray2, null);
    }

    public AssociateRequestAcceptPDU(int n, String string, String string2, String string3, String string4, int n2, LinkedList linkedList, LinkedList linkedList2) throws DicomNetworkException {
        this.doCommonConstructorStuff(n, string, string2, string3, string4, n2, linkedList, linkedList2, 0, null, null, null);
    }

    public AssociateRequestAcceptPDU(int n, String string, String string2, String string3, String string4, int n2, LinkedList linkedList, LinkedList linkedList2, byte[] byArray) throws DicomNetworkException {
        this.doCommonConstructorStuff(n, string, string2, string3, string4, n2, linkedList, linkedList2, 0, null, null, byArray);
    }

    void doCommonConstructorStuff(int n, String string, String string2, String string3, String string4, int n2, LinkedList linkedList, LinkedList linkedList2, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3) throws DicomNetworkException {
        try {
            UserInformationSubItem userInformationSubItem;
            byte[] byArray4;
            this.pduType = n;
            this.protocolVersion = 1;
            this.calledAETitle = string;
            this.callingAETitle = string2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byteArrayOutputStream.write((byte)n);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(1);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            AssociateRequestAcceptPDU.writeAETToPDU(string, byteArrayOutputStream, "Called");
            AssociateRequestAcceptPDU.writeAETToPDU(string2, byteArrayOutputStream, "Calling");
            for (int i = 0; i < 32; ++i) {
                byteArrayOutputStream.write(0);
            }
            this.itemList = new LinkedList();
            byteArrayOutputStream.write(16);
            byteArrayOutputStream.write(0);
            String string5 = "1.2.840.10008.3.1.1.1";
            byte[] byArray5 = string5.getBytes("ASCII");
            int n4 = byArray5.length;
            byteArrayOutputStream.write((byte)(n4 >> 8));
            byteArrayOutputStream.write((byte)n4);
            byteArrayOutputStream.write(byArray5, 0, n4);
            ApplicationContextItem applicationContextItem = new ApplicationContextItem(16, n4, string5);
            this.itemList.add(applicationContextItem);
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                int n5 = n == 1 ? 32 : 33;
                PresentationContext presentationContext = (PresentationContext)listIterator.next();
                byArray4 = AssociateRequestAcceptPDU.makeByteArrayOfPresentationContextItem(n5, presentationContext);
                byteArrayOutputStream.write(byArray4, 0, byArray4.length);
                PresentationContextItem presentationContextItem = new PresentationContextItem(n5, byArray4.length, presentationContext);
                this.itemList.add(presentationContextItem);
            }
            byte[] byArray6 = string3.getBytes("ASCII");
            int n6 = byArray6.length;
            byArray4 = string4.getBytes("ASCII");
            int n7 = byArray4.length;
            LinkedList linkedList3 = new LinkedList();
            byte[] byArray7 = this.makeByteArrayOfSCUSCPRoleSelections(linkedList2, linkedList3);
            int n8 = byArray7.length;
            int n9 = byArray == null ? 0 : byArray.length;
            int n10 = byArray2 == null ? 0 : byArray2.length;
            int n11 = n3 == 3 ? 1 : 0;
            int n12 = 0;
            if (n == 1 && n3 > 0) {
                n12 = 4 + n9 + 2 + n10;
            }
            int n13 = byArray3 == null ? 0 : byArray3.length;
            int n14 = 0;
            if (n == 2 && byArray3 != null) {
                n14 = 2 + n13;
            }
            byteArrayOutputStream.write(80);
            byteArrayOutputStream.write(0);
            int n15 = 12 + n6 + 2 + 2 + n7 + (n12 > 0 ? 4 + n12 : 0) + n8;
            byteArrayOutputStream.write((byte)(n15 >> 8));
            byteArrayOutputStream.write((byte)n15);
            byteArrayOutputStream.write(81);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(4);
            byteArrayOutputStream.write((byte)(n2 >> 24));
            byteArrayOutputStream.write((byte)(n2 >> 16));
            byteArrayOutputStream.write((byte)(n2 >> 8));
            byteArrayOutputStream.write((byte)n2);
            byteArrayOutputStream.write(82);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write((byte)(n6 >> 8));
            byteArrayOutputStream.write((byte)n6);
            byteArrayOutputStream.write(byArray6, 0, n6);
            if (n8 > 0) {
                byteArrayOutputStream.write(byArray7, 0, n8);
            }
            byteArrayOutputStream.write(85);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write((byte)(n7 >> 8));
            byteArrayOutputStream.write((byte)n7);
            byteArrayOutputStream.write(byArray4, 0, n7);
            if (n12 > 0) {
                byteArrayOutputStream.write(88);
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write((byte)(n12 >> 8));
                byteArrayOutputStream.write((byte)n12);
                byteArrayOutputStream.write((byte)n3);
                byteArrayOutputStream.write((byte)n11);
                byteArrayOutputStream.write((byte)(n9 >> 8));
                byteArrayOutputStream.write((byte)n9);
                if (n9 > 0) {
                    byteArrayOutputStream.write(byArray, 0, n9);
                }
                byteArrayOutputStream.write((byte)(n10 >> 8));
                byteArrayOutputStream.write((byte)n10);
                if (n10 > 0) {
                    byteArrayOutputStream.write(byArray2, 0, n10);
                }
            }
            if (n14 > 0) {
                byteArrayOutputStream.write(89);
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write((byte)(n14 >> 8));
                byteArrayOutputStream.write((byte)n14);
                byteArrayOutputStream.write((byte)(n9 >> 8));
                byteArrayOutputStream.write((byte)n9);
                if (n13 > 0) {
                    byteArrayOutputStream.write(byArray3, 0, n13);
                }
            }
            UserInformationItem userInformationItem = new UserInformationItem(80, n15);
            this.itemList.add(userInformationItem);
            MaximumLengthReceivedUserInformationSubItem maximumLengthReceivedUserInformationSubItem = new MaximumLengthReceivedUserInformationSubItem(81, 4, n2);
            userInformationItem.subItemList.add(maximumLengthReceivedUserInformationSubItem);
            ImplementationClassUIDUserInformationSubItem implementationClassUIDUserInformationSubItem = new ImplementationClassUIDUserInformationSubItem(82, n6, string3);
            userInformationItem.subItemList.add(implementationClassUIDUserInformationSubItem);
            userInformationItem.subItemList.addAll(linkedList3);
            ImplementationVersionNameUserInformationSubItem implementationVersionNameUserInformationSubItem = new ImplementationVersionNameUserInformationSubItem(85, n7, string4);
            userInformationItem.subItemList.add(implementationVersionNameUserInformationSubItem);
            if (n12 > 0) {
                userInformationSubItem = new UserIdentityNegotiationRequestUserInformationSubItem(88, n12, n3, n11, n9, byArray, n10, byArray2);
                userInformationItem.subItemList.add(userInformationSubItem);
            }
            if (n14 > 0) {
                userInformationSubItem = new UserIdentityNegotiationAcceptUserInformationSubItem(89, n14, n13, byArray3);
                userInformationItem.subItemList.add(userInformationSubItem);
            }
            this.pduLength = byteArrayOutputStream.size() - 6;
            this.b = byteArrayOutputStream.toByteArray();
            this.b[2] = (byte)(this.pduLength >> 24);
            this.b[3] = (byte)(this.pduLength >> 16);
            this.b[4] = (byte)(this.pduLength >> 8);
            this.b[5] = (byte)this.pduLength;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DicomNetworkException("Unsupported encoding generated exception " + unsupportedEncodingException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AssociateRequestAcceptPDU(byte[] byArray) throws DicomNetworkException {
        try {
            this.b = byArray;
            this.pduType = this.b[0] & 0xFF;
            this.pduLength = ByteArray.bigEndianToUnsignedInt(this.b, 2, 4);
            this.protocolVersion = ByteArray.bigEndianToUnsignedInt(this.b, 6, 2);
            this.calledAETitle = new String(this.b, 10, 16);
            this.callingAETitle = new String(this.b, 26, 16);
            this.itemList = new LinkedList();
            int n = 74;
            while (n + 3 < this.b.length) {
                int n2;
                int n3 = this.b[n++] & 0xFF;
                int n4 = ByteArray.bigEndianToUnsignedInt(this.b, ++n, 2);
                n += 2;
                if (n3 == 16) {
                    ApplicationContextItem applicationContextItem = new ApplicationContextItem(n3, n4, new String(this.b, n, n4));
                    this.itemList.add(applicationContextItem);
                    n += n4;
                    continue;
                }
                if (n3 == 32 || n3 == 33) {
                    byte by = this.b[n];
                    n4 -= 2;
                    n2 = this.b[n += 2];
                    n += 2;
                    PresentationContextItem presentationContextItem = new PresentationContextItem(n3, n4 -= 2, by, (byte)n2);
                    this.itemList.add(presentationContextItem);
                    while (n4 > 0) {
                        int n5 = this.b[n++] & 0xFF;
                        --n4;
                        --n4;
                        int n6 = ByteArray.bigEndianToUnsignedInt(this.b, ++n, 2);
                        n += 2;
                        n4 -= 2;
                        if (n5 == 48) {
                            presentationContextItem.pc.setAbstractSyntaxUID(new String(this.b, n, n6));
                        } else {
                            if (n5 != 64) throw new DicomNetworkException("Unrecognized sub-item type " + Integer.toHexString(n5) + " in Presentation Context Item");
                            presentationContextItem.pc.addTransferSyntaxUID(new String(this.b, n, n6));
                        }
                        n += n6;
                        n4 -= n6;
                    }
                    continue;
                }
                if (n3 == 80) {
                    UserInformationItem userInformationItem = new UserInformationItem(n3, n4);
                    this.itemList.add(userInformationItem);
                    while (n4 > 0) {
                        int n7;
                        int n8;
                        n2 = this.b[n++] & 0xFF;
                        --n4;
                        --n4;
                        int n9 = ByteArray.bigEndianToUnsignedInt(this.b, ++n, 2);
                        n += 2;
                        n4 -= 2;
                        if (n2 == 81) {
                            if (n9 != 4) throw new DicomNetworkException("Maximum length sub-item wrong length (" + n9 + " dec) in User Information Item");
                            this.maximumLengthReceived = ByteArray.bigEndianToUnsignedInt(this.b, n, 4);
                            userInformationItem.subItemList.add(new MaximumLengthReceivedUserInformationSubItem(n2, n9, this.maximumLengthReceived));
                        } else if (n2 == 82) {
                            String string = new String(this.b, n, n9, "ASCII");
                            userInformationItem.subItemList.add(new ImplementationClassUIDUserInformationSubItem(n2, n9, string));
                        } else if (n2 == 84) {
                            int n10 = ByteArray.bigEndianToUnsignedInt(this.b, n, 2);
                            String string = new String(this.b, n + 2, n10, "ASCII");
                            n8 = this.b[n + 2 + n10] != 0 ? 1 : 0;
                            n7 = this.b[n + 2 + n10 + 1] != 0 ? 1 : 0;
                            userInformationItem.subItemList.add(new SCUSCPRoleSelectionUserInformationSubItem(n2, n9, new SCUSCPRoleSelection(string, n8 != 0, n7 != 0)));
                        } else if (n2 == 85) {
                            String string = new String(this.b, n, n9, "ASCII");
                            userInformationItem.subItemList.add(new ImplementationVersionNameUserInformationSubItem(n2, n9, string));
                        } else if (n2 == 86) {
                            int n11 = ByteArray.bigEndianToUnsignedInt(this.b, n, 2);
                            String string = new String(this.b, n + 2, n11, "ASCII");
                            byte[] byArray2 = ByteArray.extractBytes(this.b, n + 2 + n11, n9 - 2 - n11);
                            userInformationItem.subItemList.add(new SOPClassExtendedNegotiationUserInformationSubItem(n2, n9, n11, string, byArray2));
                        } else if (n2 == 88) {
                            int n12 = n;
                            int n13 = this.b[n12++] & 0xFF;
                            n8 = this.b[n12++] & 0xFF;
                            n7 = ByteArray.bigEndianToUnsignedInt(this.b, n12, 2);
                            byte[] byArray3 = n7 > 0 ? ByteArray.extractBytes(this.b, n12 += 2, n7) : null;
                            int n14 = ByteArray.bigEndianToUnsignedInt(this.b, n12 += n7, 2);
                            byte[] byArray4 = n14 > 0 ? ByteArray.extractBytes(this.b, n12 += 2, n14) : null;
                            userInformationItem.subItemList.add(new UserIdentityNegotiationRequestUserInformationSubItem(n2, n9, n13, n8, n7, byArray3, n14, byArray4));
                        } else if (n2 == 89) {
                            int n15 = ByteArray.bigEndianToUnsignedInt(this.b, n, 2);
                            byte[] byArray5 = n15 > 0 ? ByteArray.extractBytes(this.b, n + 2, n15) : null;
                            userInformationItem.subItemList.add(new UserIdentityNegotiationAcceptUserInformationSubItem(n2, n9, n15, byArray5));
                        }
                        n += n9;
                        n4 -= n9;
                    }
                    continue;
                }
                n += n4;
            }
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DicomNetworkException("Unsupported encoding generated exception " + unsupportedEncodingException);
        }
    }

    public byte[] getBytes() {
        return this.b;
    }

    public LinkedList getAcceptedPresentationContextsWithAbstractSyntaxIncludedFromRequest(LinkedList linkedList) throws DicomNetworkException {
        LinkedList<PresentationContext> linkedList2 = new LinkedList<PresentationContext>();
        ListIterator listIterator = this.itemList.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            PresentationContext presentationContext;
            AssociationItem associationItem = (AssociationItem)listIterator.next();
            if (associationItem.type != 33 || (presentationContext = ((PresentationContextItem)associationItem).pc).getResultReason() != 0) continue;
            byte by = presentationContext.getIdentifier();
            String string = null;
            List list = null;
            ListIterator listIterator2 = linkedList.listIterator();
            while (listIterator2.hasNext()) {
                object = (PresentationContext)listIterator2.next();
                if (((PresentationContext)object).getIdentifier() != by) continue;
                string = ((PresentationContext)object).getAbstractSyntaxUID();
                list = ((PresentationContext)object).getTransferSyntaxUIDs();
                break;
            }
            if (string == null) {
                throw new DicomNetworkException("Accepted Presentation Context ID " + Integer.toHexString(by) + " was not requested");
            }
            object = presentationContext.getTransferSyntaxUID();
            if (list != null && list.contains(object)) {
                linkedList2.add(new PresentationContext(by, string, (String)object));
                continue;
            }
            slf4jlogger.warn("getAcceptedPresentationContextsWithAbstractSyntaxIncludedFromRequest(): encountered Presentation Context ID {} for Abstract Syntax {} with Transfer Syntax {} that was not amongst those requested - treating it as rejected", Integer.toHexString(by), string, object);
        }
        return linkedList2;
    }

    public LinkedList getRequestedPresentationContexts() throws DicomNetworkException {
        LinkedList<PresentationContext> linkedList = new LinkedList<PresentationContext>();
        ListIterator listIterator = this.itemList.listIterator();
        while (listIterator.hasNext()) {
            AssociationItem associationItem = (AssociationItem)listIterator.next();
            if (associationItem.type != 32) continue;
            linkedList.add(((PresentationContextItem)associationItem).pc);
        }
        return linkedList;
    }

    public LinkedList getSCUSCPRoleSelections() throws DicomNetworkException {
        LinkedList<SCUSCPRoleSelection> linkedList = new LinkedList<SCUSCPRoleSelection>();
        ListIterator listIterator = this.itemList.listIterator();
        while (listIterator.hasNext()) {
            AssociationItem associationItem = (AssociationItem)listIterator.next();
            if (associationItem.type != 80) continue;
            UserInformationItem userInformationItem = (UserInformationItem)associationItem;
            LinkedList linkedList2 = userInformationItem.subItemList;
            ListIterator listIterator2 = linkedList2.listIterator();
            while (listIterator2.hasNext()) {
                UserInformationSubItem userInformationSubItem = (UserInformationSubItem)listIterator2.next();
                if (userInformationSubItem.type != 84) continue;
                SCUSCPRoleSelectionUserInformationSubItem sCUSCPRoleSelectionUserInformationSubItem = (SCUSCPRoleSelectionUserInformationSubItem)userInformationSubItem;
                SCUSCPRoleSelection sCUSCPRoleSelection = sCUSCPRoleSelectionUserInformationSubItem.selection;
                linkedList.add(sCUSCPRoleSelection);
            }
        }
        return linkedList;
    }

    public int getMaximumLengthReceived() {
        return this.maximumLengthReceived;
    }

    public String getCallingAETitle() {
        return this.callingAETitle;
    }

    public String getCalledAETitle() {
        return this.calledAETitle;
    }

    public String toString() {
        return this.toStringFromObjectContents();
    }

    public String toStringFromObjectContents() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HexDump.dump(this.b));
        stringBuffer.append("PDU Type: 0x");
        stringBuffer.append(this.pduType);
        stringBuffer.append(this.b[0] == 1 ? " (A-ASSOCIATE-RQ)" : (this.b[0] == 2 ? " (A-ASSOCIATE-AC)" : " unrecognized"));
        stringBuffer.append("\n");
        stringBuffer.append("Length: 0x");
        stringBuffer.append(Integer.toHexString(this.pduLength));
        stringBuffer.append("\n");
        stringBuffer.append("Protocol Version: 0x");
        stringBuffer.append(Integer.toHexString(this.protocolVersion));
        stringBuffer.append("\n");
        stringBuffer.append("Called AET:  ");
        stringBuffer.append(this.calledAETitle);
        stringBuffer.append("\n");
        stringBuffer.append("Calling AET: ");
        stringBuffer.append(this.callingAETitle);
        stringBuffer.append("\n");
        ListIterator listIterator = this.itemList.listIterator();
        while (listIterator.hasNext()) {
            AssociationItem associationItem = (AssociationItem)listIterator.next();
            stringBuffer.append(associationItem);
        }
        return stringBuffer.toString();
    }

    public String toStringFromRawPDUBytes() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HexDump.dump(this.b));
        stringBuffer.append("PDU Type: 0x");
        stringBuffer.append(Integer.toHexString(this.b[0] & 0xFF));
        stringBuffer.append(this.b[0] == 1 ? " (A-ASSOCIATE-RQ)" : (this.b[0] == 2 ? " (A-ASSOCIATE-AC)" : " unrecognized"));
        stringBuffer.append("\n");
        stringBuffer.append("Length: 0x");
        stringBuffer.append(Integer.toHexString(ByteArray.bigEndianToUnsignedInt(this.b, 2, 4)));
        stringBuffer.append("\n");
        stringBuffer.append("Protocol Version: 0x");
        stringBuffer.append(Integer.toHexString(ByteArray.bigEndianToUnsignedInt(this.b, 6, 2)));
        stringBuffer.append("\n");
        stringBuffer.append("Called AET:  ");
        stringBuffer.append(new String(this.b, 10, 16));
        stringBuffer.append("\n");
        stringBuffer.append("Calling AET: ");
        stringBuffer.append(new String(this.b, 26, 16));
        stringBuffer.append("\n");
        int n = 74;
        while (n + 3 < this.b.length) {
            int n2 = this.b[n++] & 0xFF;
            int n3 = ByteArray.bigEndianToUnsignedInt(this.b, ++n, 2);
            n += 2;
            stringBuffer.append("Item Type: 0x");
            stringBuffer.append(Integer.toHexString(n2));
            stringBuffer.append(" (length 0x");
            stringBuffer.append(Integer.toHexString(n3));
            stringBuffer.append(")");
            if (n2 == 16) {
                stringBuffer.append(" (Application Context)\n\t");
                stringBuffer.append(new String(this.b, n, n3));
                stringBuffer.append("\n");
                n += n3;
                continue;
            }
            if (n2 == 32 || n2 == 33) {
                stringBuffer.append(" (Presentation Context)\n");
                stringBuffer.append("\tID: 0x");
                stringBuffer.append(Integer.toHexString(this.b[n] & 0xFF));
                stringBuffer.append("\n");
                n += 4;
                n3 -= 4;
                while (n3 > 0) {
                    int n4 = this.b[n++] & 0xFF;
                    --n3;
                    --n3;
                    int n5 = ByteArray.bigEndianToUnsignedInt(this.b, ++n, 2);
                    n += 2;
                    n3 -= 2;
                    stringBuffer.append("\tSub-Item Type: 0x");
                    stringBuffer.append(Integer.toHexString(n4));
                    stringBuffer.append(" (length 0x");
                    stringBuffer.append(Integer.toHexString(n5));
                    stringBuffer.append(")");
                    if (n4 == 48) {
                        stringBuffer.append(" (Abstract Syntax)\n\t\t");
                        stringBuffer.append(new String(this.b, n, n5));
                        stringBuffer.append("\n");
                    } else if (n4 == 64) {
                        stringBuffer.append(" (Transfer Syntax)\n\t\t");
                        stringBuffer.append(new String(this.b, n, n5));
                        stringBuffer.append("\n");
                    } else {
                        stringBuffer.append(" (unrecognized)\n");
                    }
                    n += n5;
                    n3 -= n5;
                }
                continue;
            }
            stringBuffer.append(" (unrecognized)\n");
            n += n3;
        }
        return stringBuffer.toString();
    }

    private class PresentationContextItem
    extends AssociationItem {
        PresentationContext pc;

        PresentationContextItem(int n, int n2, byte by, byte by2) {
            super(n, n2);
            this.pc = new PresentationContext(by, by2);
        }

        PresentationContextItem(int n, int n2, PresentationContext presentationContext) {
            super(n, n2);
            this.pc = presentationContext;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" (Presentation Context)\n\t");
            stringBuffer.append(this.pc);
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }

    private class UserIdentityNegotiationAcceptUserInformationSubItem
    extends UserInformationSubItem {
        int serverResponseLength;
        byte[] serverResponse;

        UserIdentityNegotiationAcceptUserInformationSubItem(int n, int n2, int n3, byte[] byArray) {
            super(n, n2);
            this.serverResponseLength = n3;
            this.serverResponse = byArray;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" (User Identity Negotiation Accept ");
            stringBuffer.append("\n\t\tServer Response: ");
            stringBuffer.append("[0x");
            stringBuffer.append(Integer.toHexString(this.serverResponseLength));
            stringBuffer.append("] ");
            if (this.serverResponseLength > 0) {
                stringBuffer.append(HexDump.dump(this.serverResponse));
                stringBuffer.append("\n\t\t");
            }
            stringBuffer.append(")\n\t");
            return stringBuffer.toString();
        }
    }

    private class UserIdentityNegotiationRequestUserInformationSubItem
    extends UserInformationSubItem {
        int userIdentityType;
        int positiveResponseRequired;
        int primaryFieldLength;
        byte[] primaryField;
        int secondaryFieldLength;
        byte[] secondaryField;

        UserIdentityNegotiationRequestUserInformationSubItem(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6, byte[] byArray2) {
            super(n, n2);
            this.userIdentityType = n3;
            this.positiveResponseRequired = n4;
            this.primaryFieldLength = n5;
            this.primaryField = byArray;
            this.secondaryFieldLength = n6;
            this.secondaryField = byArray2;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" (User Identity Negotiation Request ");
            stringBuffer.append("\n\t\tUser Identity Type: ");
            stringBuffer.append(Integer.toString(this.userIdentityType));
            stringBuffer.append(" ");
            switch (this.userIdentityType) {
                case 1: {
                    stringBuffer.append("Username");
                    break;
                }
                case 2: {
                    stringBuffer.append("Username and passcode");
                    break;
                }
                case 3: {
                    stringBuffer.append("Kerberos Service ticket");
                    break;
                }
                case 4: {
                    stringBuffer.append("SAML Assertion");
                    break;
                }
                default: {
                    stringBuffer.append("Unrecognized");
                }
            }
            stringBuffer.append("\n\t\tPositive Response Required: ");
            stringBuffer.append(Integer.toString(this.positiveResponseRequired));
            stringBuffer.append("\n\t\tPrimary Field: ");
            stringBuffer.append("[0x");
            stringBuffer.append(Integer.toHexString(this.primaryFieldLength));
            stringBuffer.append("] ");
            if (this.primaryFieldLength > 0) {
                if (this.userIdentityType == 1 || this.userIdentityType == 2 || this.userIdentityType == 4) {
                    try {
                        stringBuffer.append(new String(this.primaryField, "UTF8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        stringBuffer.append(HexDump.dump(this.primaryField));
                    }
                } else {
                    stringBuffer.append(HexDump.dump(this.primaryField));
                }
            }
            stringBuffer.append("\n\t\tSecondary Field: ");
            stringBuffer.append("[0x");
            stringBuffer.append(Integer.toHexString(this.secondaryFieldLength));
            stringBuffer.append("] ");
            if (this.secondaryFieldLength > 0) {
                if (this.userIdentityType == 2) {
                    stringBuffer.append(this.secondaryField);
                } else {
                    stringBuffer.append(HexDump.dump(this.secondaryField));
                }
            }
            stringBuffer.append(")\n\t");
            return stringBuffer.toString();
        }
    }

    private class SCUSCPRoleSelectionUserInformationSubItem
    extends UserInformationSubItem {
        SCUSCPRoleSelection selection;

        SCUSCPRoleSelectionUserInformationSubItem(int n, int n2, SCUSCPRoleSelection sCUSCPRoleSelection) {
            super(n, n2);
            this.selection = sCUSCPRoleSelection;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" (SCU/SCP Role Selection ");
            stringBuffer.append("[0x");
            stringBuffer.append(Integer.toHexString(this.selection.getAbstractSyntaxUID().length()));
            stringBuffer.append("] ");
            stringBuffer.append(this.selection.getAbstractSyntaxUID());
            stringBuffer.append("\n\t\tSCU Role supported: ");
            stringBuffer.append(this.selection.isSCURoleSupported());
            stringBuffer.append("\n\t\tSCP Role supported: ");
            stringBuffer.append(this.selection.isSCPRoleSupported());
            stringBuffer.append(")\n\t");
            return stringBuffer.toString();
        }
    }

    private class SOPClassExtendedNegotiationUserInformationSubItem
    extends UserInformationSubItem {
        int sopClassUIDLength;
        String sopClassUID;
        byte[] info;

        SOPClassExtendedNegotiationUserInformationSubItem(int n, int n2, int n3, String string, byte[] byArray) {
            super(n, n2);
            this.sopClassUIDLength = n3;
            this.sopClassUID = string;
            this.info = byArray;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" (SOP Class Extended Negotiation ");
            stringBuffer.append("[0x");
            stringBuffer.append(Integer.toHexString(this.sopClassUIDLength));
            stringBuffer.append("] ");
            stringBuffer.append(this.sopClassUID);
            stringBuffer.append("\n\t\t");
            stringBuffer.append(HexDump.dump(this.info));
            stringBuffer.append(")\n\t");
            return stringBuffer.toString();
        }
    }

    private class ImplementationVersionNameUserInformationSubItem
    extends UserInformationSubItem {
        String implementationVersionName;

        ImplementationVersionNameUserInformationSubItem(int n, int n2, String string) {
            super(n, n2);
            this.implementationVersionName = string;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" (Implementation Version Name ");
            stringBuffer.append(this.implementationVersionName);
            stringBuffer.append(")\n\t");
            return stringBuffer.toString();
        }
    }

    private class ImplementationClassUIDUserInformationSubItem
    extends UserInformationSubItem {
        String implementationClassUID;

        ImplementationClassUIDUserInformationSubItem(int n, int n2, String string) {
            super(n, n2);
            this.implementationClassUID = string;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" (Implementation Class UID ");
            stringBuffer.append(this.implementationClassUID);
            stringBuffer.append(")\n\t");
            return stringBuffer.toString();
        }
    }

    private class MaximumLengthReceivedUserInformationSubItem
    extends UserInformationSubItem {
        int maximumLengthReceived;

        MaximumLengthReceivedUserInformationSubItem(int n, int n2, int n3) {
            super(n, n2);
            this.maximumLengthReceived = n3;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" (Maximum Length Received 0x");
            stringBuffer.append(Integer.toHexString(this.maximumLengthReceived));
            stringBuffer.append(")\n\t");
            return stringBuffer.toString();
        }
    }

    private class UserInformationSubItem {
        int type;
        int length;

        UserInformationSubItem(int n, int n2) {
            this.type = n;
            this.length = n2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("User Information Sub Item Type: 0x");
            stringBuffer.append(Integer.toHexString(this.type));
            stringBuffer.append(" (length 0x");
            stringBuffer.append(Integer.toHexString(this.length));
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    private class UserInformationItem
    extends AssociationItem {
        LinkedList subItemList;

        UserInformationItem(int n, int n2) {
            super(n, n2);
            this.subItemList = new LinkedList();
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" (User Information)\n\t");
            ListIterator listIterator = this.subItemList.listIterator();
            while (listIterator.hasNext()) {
                UserInformationSubItem userInformationSubItem = (UserInformationSubItem)listIterator.next();
                stringBuffer.append(userInformationSubItem);
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }

    private class ApplicationContextItem
    extends AssociationItem {
        String applicationContextName;

        ApplicationContextItem(int n, int n2, String string) {
            super(n, n2);
            this.applicationContextName = string;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" (Application Context)\n\t");
            stringBuffer.append(this.applicationContextName);
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }

    private class AssociationItem {
        int type;
        int length;

        AssociationItem(int n, int n2) {
            this.type = n;
            this.length = n2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Item Type: 0x");
            stringBuffer.append(Integer.toHexString(this.type));
            stringBuffer.append(" (length 0x");
            stringBuffer.append(Integer.toHexString(this.length));
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }
}

