/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.network.Association;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.PDataPDU;
import com.pixelmed.network.PresentationDataValue;
import com.pixelmed.network.ReceivedDataHandler;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.ByteArray;
import com.pixelmed.utils.HexDump;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;

public abstract class CompositeResponseHandler
extends ReceivedDataHandler {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/CompositeResponseHandler.java,v 1.29 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(CompositeResponseHandler.class);
    protected byte[] commandReceived = null;
    protected byte[] dataReceived = null;
    protected boolean success = false;
    protected boolean allowData;
    protected int status;

    public CompositeResponseHandler(int n) {
        this();
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public CompositeResponseHandler() {
        this.done = false;
        this.allowData = false;
    }

    public static AttributeList getAttributeListFromCommandOrData(byte[] byArray, String string, int n) throws DicomNetworkException, DicomException, IOException {
        slf4jlogger.warn("Debug level supplied as argument ignored");
        return CompositeResponseHandler.getAttributeListFromCommandOrData(byArray, string);
    }

    public static AttributeList getAttributeListFromCommandOrData(byte[] byArray, String string) throws DicomNetworkException, DicomException, IOException {
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace(HexDump.dump(byArray));
        }
        AttributeList attributeList = new AttributeList();
        attributeList.read(new DicomInputStream(new ByteArrayInputStream(byArray), string, false));
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace(attributeList.toString());
        }
        return attributeList;
    }

    public static String dumpAttributeListFromCommandOrData(byte[] byArray, String string) throws DicomNetworkException, DicomException, IOException {
        String string2 = null;
        try {
            AttributeList attributeList = new AttributeList();
            attributeList.read(new DicomInputStream(new ByteArrayInputStream(byArray), string, false));
            string2 = attributeList.toString();
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            string2 = null;
        }
        return string2;
    }

    @Override
    public void sendPDataIndication(PDataPDU pDataPDU, Association association) throws DicomNetworkException, DicomException, IOException {
        slf4jlogger.debug("sendPDataIndication():");
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug(super.dumpPDVListToString(pDataPDU.getPDVList()));
        }
        LinkedList linkedList = pDataPDU.getPDVList();
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            AttributeList attributeList;
            PresentationDataValue presentationDataValue = (PresentationDataValue)listIterator.next();
            if (presentationDataValue.isCommand()) {
                this.commandReceived = ByteArray.concatenate(this.commandReceived, presentationDataValue.getValue());
                if (!presentationDataValue.isLastFragment()) continue;
                slf4jlogger.debug("sendPDataIndication(): last fragment of command seen");
                attributeList = CompositeResponseHandler.getAttributeListFromCommandOrData(this.commandReceived, "1.2.840.10008.1.2");
                this.commandReceived = null;
                this.evaluateStatusAndSetSuccess(attributeList);
                continue;
            }
            if (this.allowData) {
                this.dataReceived = ByteArray.concatenate(this.dataReceived, presentationDataValue.getValue());
                if (!presentationDataValue.isLastFragment()) continue;
                slf4jlogger.debug("sendPDataIndication(): last fragment of data seen");
                attributeList = CompositeResponseHandler.getAttributeListFromCommandOrData(this.dataReceived, association.getTransferSyntaxForPresentationContextID(presentationDataValue.getPresentationContextID()));
                this.makeUseOfDataSet(attributeList);
                this.dataReceived = null;
                continue;
            }
            throw new DicomNetworkException("Unexpected data fragment in response PDU");
        }
    }

    protected abstract void evaluateStatusAndSetSuccess(AttributeList var1);

    protected void makeUseOfDataSet(AttributeList attributeList) {
    }

    public boolean wasSuccessful() {
        return this.success;
    }

    public int getStatus() {
        return this.status;
    }
}

