/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.network.AReleaseException;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationFactory;
import com.pixelmed.network.CFindRequestCommandMessage;
import com.pixelmed.network.CompositeResponseHandler;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.IdentifierHandler;
import com.pixelmed.network.IdentifierMessage;
import com.pixelmed.network.PresentationContext;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.LinkedList;

public class FindSOPClassSCU
extends SOPClass {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/FindSOPClassSCU.java,v 1.37 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(FindSOPClassSCU.class);

    public static Association getSuitableAssociation(String string, int n, String string2, String string3, String string4, int n2) throws DicomNetworkException, DicomException, IOException {
        slf4jlogger.warn("Debug level supplied as argument ignored");
        return FindSOPClassSCU.getSuitableAssociation(string, n, string2, string3, string4);
    }

    public static Association getSuitableAssociation(String string, int n, String string2, String string3, String string4) throws DicomNetworkException, DicomException, IOException {
        LinkedList<PresentationContext> linkedList = new LinkedList<PresentationContext>();
        Object object = new LinkedList<String>();
        ((LinkedList)object).add("1.2.840.10008.1.2");
        ((LinkedList)object).add("1.2.840.10008.1.2.1");
        linkedList.add(new PresentationContext(1, string4, (LinkedList)object));
        linkedList.add(new PresentationContext(3, string4, "1.2.840.10008.1.2"));
        linkedList.add(new PresentationContext(5, string4, "1.2.840.10008.1.2.1"));
        object = AssociationFactory.createNewAssociation(string, n, string2, string3, linkedList, null, false);
        slf4jlogger.debug(((Association)object).toString());
        return object;
    }

    public void performFind(Association association, String string, AttributeList attributeList) throws DicomNetworkException, DicomException, IOException, AReleaseException {
        slf4jlogger.debug("request identifier\n{}", attributeList);
        byte by = association.getSuitablePresentationContextID(string);
        slf4jlogger.debug("Using context ID {}", by);
        byte[] byArray = new CFindRequestCommandMessage(string).getBytes();
        byte[] byArray2 = new IdentifierMessage(attributeList, association.getTransferSyntaxForPresentationContextID(by)).getBytes();
        association.send(by, byArray, null);
        association.send(by, null, byArray2);
        slf4jlogger.debug("waiting for PDUs");
        association.waitForPDataPDUsUntilHandlerReportsDone();
        slf4jlogger.debug("got PDU");
    }

    public FindSOPClassSCU(Association association, String string, AttributeList attributeList, IdentifierHandler identifierHandler, int n) throws DicomNetworkException, DicomException, IOException {
        this(association, string, attributeList, identifierHandler);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public FindSOPClassSCU(Association association, String string, AttributeList attributeList, IdentifierHandler identifierHandler) throws DicomNetworkException, DicomException, IOException {
        CFindResponseHandler cFindResponseHandler = new CFindResponseHandler(identifierHandler);
        association.setReceivedDataHandler(cFindResponseHandler);
        try {
            this.performFind(association, string, attributeList);
        }
        catch (AReleaseException aReleaseException) {
            association = null;
        }
        if (!cFindResponseHandler.wasSuccessful()) {
            throw new DicomNetworkException("C-FIND reports failure status 0x" + Integer.toString(cFindResponseHandler.getStatus() & 0xFFFF, 16));
        }
    }

    public FindSOPClassSCU(String string, int n, String string2, String string3, String string4, AttributeList attributeList, IdentifierHandler identifierHandler, int n2) throws DicomNetworkException, DicomException, IOException {
        this(string, n, string2, string3, string4, attributeList, identifierHandler);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public FindSOPClassSCU(String string, int n, String string2, String string3, String string4, AttributeList attributeList, IdentifierHandler identifierHandler) throws DicomNetworkException, DicomException, IOException {
        Association association = FindSOPClassSCU.getSuitableAssociation(string, n, string2, string3, string4);
        CFindResponseHandler cFindResponseHandler = new CFindResponseHandler(identifierHandler);
        association.setReceivedDataHandler(cFindResponseHandler);
        try {
            this.performFind(association, string4, attributeList);
            slf4jlogger.debug("releasing association");
            association.release();
        }
        catch (AReleaseException aReleaseException) {
            association = null;
        }
        if (!cFindResponseHandler.wasSuccessful()) {
            throw new DicomNetworkException("C-FIND reports failure status 0x" + Integer.toString(cFindResponseHandler.getStatus() & 0xFFFF, 16));
        }
    }

    public static void main(String[] stringArray) {
        try {
            SpecificCharacterSet specificCharacterSet = new SpecificCharacterSet((String[])null);
            AttributeList attributeList = new AttributeList();
            boolean bl = true;
            if (!bl) {
                attributeList.putNewAttribute(TagFromName.QueryRetrieveLevel).addValue("STUDY");
                attributeList.putNewAttribute(TagFromName.PatientName, specificCharacterSet);
                attributeList.putNewAttribute(TagFromName.PatientID, specificCharacterSet);
                attributeList.putNewAttribute(TagFromName.PatientBirthDate);
                attributeList.putNewAttribute(TagFromName.PatientSex);
                attributeList.putNewAttribute(TagFromName.StudyInstanceUID);
                attributeList.putNewAttribute(TagFromName.ReferringPhysicianName, specificCharacterSet);
                attributeList.putNewAttribute(TagFromName.ModalitiesInStudy);
                attributeList.putNewAttribute(TagFromName.StudyDescription, specificCharacterSet);
                attributeList.putNewAttribute(TagFromName.StudyID, specificCharacterSet);
                attributeList.putNewAttribute(TagFromName.AccessionNumber, specificCharacterSet);
                attributeList.putNewAttribute(TagFromName.QueryRetrieveLevel).addValue("SERIES");
                UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
                ((Attribute)uniqueIdentifierAttribute).addValue("1.2.840.113704.1.111.5740.1224249944.1");
                attributeList.put(uniqueIdentifierAttribute);
                attributeList.putNewAttribute(TagFromName.SeriesInstanceUID);
            } else {
                attributeList.putNewAttribute(TagFromName.QueryRetrieveLevel).addValue("IMAGE");
                UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
                ((Attribute)uniqueIdentifierAttribute).addValue("1.2.840.113619.2.5.1762386977.1328.985934491.590");
                attributeList.put(uniqueIdentifierAttribute);
                uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
                ((Attribute)uniqueIdentifierAttribute).addValue("1.2.840.113619.2.5.1762386977.1328.985934491.643");
                attributeList.put(uniqueIdentifierAttribute);
                attributeList.putNewAttribute(TagFromName.SOPInstanceUID);
                attributeList.putNewAttribute(TagFromName.AlternateRepresentationSequence);
                attributeList.putNewAttribute(TagFromName.InstanceNumber);
            }
            new FindSOPClassSCU(stringArray[0], Integer.parseInt(stringArray[1]), stringArray[2], stringArray[3], "1.2.840.10008.5.1.4.1.2.2.1", attributeList, new IdentifierHandler());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }

    private class CFindResponseHandler
    extends CompositeResponseHandler {
        private IdentifierHandler identifierHandler;

        CFindResponseHandler(IdentifierHandler identifierHandler) {
            this.identifierHandler = identifierHandler;
            this.allowData = true;
        }

        @Override
        protected void evaluateStatusAndSetSuccess(AttributeList attributeList) {
            slf4jlogger.debug("evaluateStatusAndSetSuccess:\n{}", attributeList);
            this.status = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Status, 65535);
            slf4jlogger.debug("CFindResponseHandler.evaluateStatusAndSetSuccess: status = 0x{}", Integer.toHexString(this.status));
            boolean bl = this.success = this.status == 0;
            if (this.status != 65280 && this.status != 65281) {
                slf4jlogger.debug("CFindResponseHandler.evaluateStatusAndSetSuccess: status no longer pending, so stop");
                this.setDone(true);
            }
        }

        @Override
        protected void makeUseOfDataSet(AttributeList attributeList) {
            slf4jlogger.debug("CFindResponseHandler.makeUseOfDataSet:\n,{}", attributeList);
            try {
                this.identifierHandler.doSomethingWithIdentifier(attributeList);
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("Ignoring exception", dicomException);
            }
        }
    }
}

