/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.ApplicationEntity;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkConfigurationSource;
import com.pixelmed.network.PresentationAddress;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;

public class NetworkConfigurationFromMulticastDNS
extends NetworkConfigurationSource {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/NetworkConfigurationFromMulticastDNS.java,v 1.23 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(NetworkConfigurationFromMulticastDNS.class);
    private static final String DICOMServiceName = "_dicom._tcp.local.";
    private static final String ACRNEMAServiceName = "_acr-nema._tcp.local.";
    private static final String DICOMTLSServiceName = "_dicom-tls._tcp.local.";
    private static final String AETTXTRecordPropertyName = "AET";
    private static final String PrimaryDeviceTypeTXTRecordPropertyName = "PrimaryDeviceType";
    private static final String AETTXTRecordPropertyNameAsLowerCase = "AET".toLowerCase(Locale.US);
    private static final String PrimaryDeviceTypeTXTRecordPropertyNameAsLowerCase = "PrimaryDeviceType".toLowerCase(Locale.US);
    private static final String WADOServiceName = "_http._tcp.local.";
    private static final String WADOPathTXTRecordPropertyName = "path";
    protected JmDNS jmDNS;

    @Override
    public void activateDiscovery(int n) {
        slf4jlogger.trace("activateDNSSelfDiscovery():");
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("javax.jmdns.JmDNS");
            Class[] classArray = new Class[]{};
            Method method = clazz.getDeclaredMethod("create", classArray);
            Object[] objectArray = new Object[]{};
            this.jmDNS = (JmDNS)method.invoke(null, objectArray);
            slf4jlogger.trace("activateDNSSelfDiscovery(): created jmDNS = {}", this.jmDNS);
            OurJmDNSServiceListener ourJmDNSServiceListener = new OurJmDNSServiceListener();
            ServiceListener serviceListener = (ServiceListener)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ServiceListener.class}, (InvocationHandler)ourJmDNSServiceListener);
            this.jmDNS.addServiceListener(DICOMServiceName, serviceListener);
            this.jmDNS.addServiceListener(ACRNEMAServiceName, serviceListener);
            this.jmDNS.addServiceListener(DICOMTLSServiceName, serviceListener);
        }
        catch (ClassNotFoundException classNotFoundException) {
            slf4jlogger.debug("activateDNSSelfDiscovery(): DNS Self Discovery not available (Could not load JmDNS class)", classNotFoundException);
            this.jmDNS = null;
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            this.jmDNS = null;
        }
    }

    @Override
    public void deActivateDiscovery() {
        slf4jlogger.trace("deActivateDiscovery():");
        if (this.jmDNS != null) {
            this.jmDNS.unregisterAllServices();
            try {
                this.jmDNS.close();
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
                this.jmDNS = null;
            }
        }
    }

    public NetworkConfigurationFromMulticastDNS(int n) {
        this();
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public NetworkConfigurationFromMulticastDNS() {
    }

    public void unregisterAllServices() {
        slf4jlogger.trace("unRegisterAllServices():");
        if (this.jmDNS != null) {
            this.jmDNS.unregisterAllServices();
        }
    }

    public void registerDicomService(String string, int n, String string2) {
        slf4jlogger.trace("registerDicomService():");
        if (this.jmDNS != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (string != null && string.length() > 0) {
                hashMap.put(AETTXTRecordPropertyName, string);
            }
            if (string2 != null && string2.length() > 0) {
                hashMap.put(PrimaryDeviceTypeTXTRecordPropertyName, string2);
            }
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("javax.jmdns.ServiceInfo");
                Class[] classArray = new Class[]{String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Map.class};
                Method method = clazz.getDeclaredMethod("create", classArray);
                Object[] objectArray = new Object[]{DICOMServiceName, string, n, 0, 0, hashMap};
                ServiceInfo serviceInfo = (ServiceInfo)method.invoke(null, objectArray);
                slf4jlogger.trace("registerDicomService(): created ServiceInfo = {}", serviceInfo);
                this.jmDNS.registerService(serviceInfo);
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
    }

    public void registerWADOService(String string, int n, String string2) {
        if (this.jmDNS != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (string2 != null && string2.length() > 0) {
                if (!string2.startsWith("/")) {
                    string2 = "/" + string2;
                }
                hashMap.put(WADOPathTXTRecordPropertyName, string2);
            }
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("javax.jmdns.ServiceInfo");
                Class[] classArray = new Class[]{String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Map.class};
                Method method = clazz.getDeclaredMethod("create", classArray);
                Object[] objectArray = new Object[]{WADOServiceName, string, n, 0, 0, hashMap};
                ServiceInfo serviceInfo = (ServiceInfo)method.invoke(null, objectArray);
                slf4jlogger.trace("registerWADOService(): created ServiceInfo = {}", serviceInfo);
                this.jmDNS.registerService(serviceInfo);
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
    }

    public static void main(String[] stringArray) {
        NetworkConfigurationFromMulticastDNS networkConfigurationFromMulticastDNS = new NetworkConfigurationFromMulticastDNS();
        networkConfigurationFromMulticastDNS.activateDiscovery();
        if (stringArray.length > 1) {
            networkConfigurationFromMulticastDNS.registerDicomService(stringArray[0], Integer.parseInt(stringArray[1]), stringArray.length > 2 ? stringArray[2] : null);
        }
        networkConfigurationFromMulticastDNS.activateDumper();
        Thread thread = Thread.currentThread();
        try {
            while (true) {
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException interruptedException) {
            networkConfigurationFromMulticastDNS.close();
            return;
        }
    }

    protected class OurJmDNSServiceListener
    implements InvocationHandler {
        protected OurJmDNSServiceListener() {
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Class<?> clazz = method.getDeclaringClass();
            slf4jlogger.trace("OurJmDNSServiceListener.invoke(): class = {}", clazz);
            String string = method.getName();
            slf4jlogger.trace("OurJmDNSServiceListener.invoke(): methodName = {}", string);
            if (clazz == ServiceListener.class) {
                if (string.equals("serviceAdded")) {
                    this.serviceAdded((ServiceEvent)objectArray[0]);
                } else if (string.equals("serviceRemoved")) {
                    this.serviceRemoved((ServiceEvent)objectArray[0]);
                } else if (string.equals("serviceResolved")) {
                    this.serviceResolved((ServiceEvent)objectArray[0]);
                }
            } else {
                if (string.equals("hashCode")) {
                    return new Integer(System.identityHashCode(object));
                }
                if (string.equals("equals")) {
                    return object == objectArray[0] ? Boolean.TRUE : Boolean.FALSE;
                }
                if (string.equals("toString")) {
                    return object.getClass().getName() + '@' + Integer.toHexString(object.hashCode());
                }
            }
            return null;
        }

        public void serviceAdded(ServiceEvent serviceEvent) {
            String string = serviceEvent.getName();
            slf4jlogger.trace("OurJmDNSServiceListener: Service added   : Name = {}", string);
            String string2 = serviceEvent.getType();
            slf4jlogger.trace("OurJmDNSServiceListener: Service added   : Type = {}", string2);
            ServiceInfo serviceInfo = serviceEvent.getInfo();
            slf4jlogger.trace("OurJmDNSServiceListener: Service added   : Info = {}", serviceInfo);
            slf4jlogger.trace("OurJmDNSServiceListener: issuing request for info");
            NetworkConfigurationFromMulticastDNS.this.jmDNS.requestServiceInfo(string2, string, true);
            slf4jlogger.trace("OurJmDNSServiceListener: back from issuing request for info");
        }

        public void serviceRemoved(ServiceEvent serviceEvent) {
            String string = serviceEvent.getName();
            slf4jlogger.trace("OurJmDNSServiceListener: Service removed : Name = {}", string);
            String string2 = serviceEvent.getType();
            slf4jlogger.trace("OurJmDNSServiceListener: Service removed : Type = {}", string2);
            ServiceInfo serviceInfo = serviceEvent.getInfo();
            slf4jlogger.trace("OurJmDNSServiceListener: Service removed : Info = {}", serviceInfo);
            NetworkConfigurationFromMulticastDNS.this.getNetworkApplicationInformation().remove(string);
        }

        public void serviceResolved(ServiceEvent serviceEvent) {
            Object object;
            Object object2;
            String string = serviceEvent.getName();
            slf4jlogger.trace("OurJmDNSServiceListener: Service resolved: Name = {}", string);
            String string2 = serviceEvent.getType();
            slf4jlogger.trace("OurJmDNSServiceListener: Service resolved: Type = {}", string2);
            ServiceInfo serviceInfo = serviceEvent.getInfo();
            slf4jlogger.trace("OurJmDNSServiceListener: Service resolved: Info = {}", serviceInfo);
            String string3 = null;
            String string4 = null;
            String string5 = null;
            int n = -1;
            if (serviceInfo != null) {
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("OurJmDNSServiceListener: Service resolved: Info getServer() = {}", serviceInfo.getServer());
                }
                string5 = serviceInfo.getHostAddress();
                n = serviceInfo.getPort();
                object2 = serviceInfo.getPropertyNames();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    if (object == null) continue;
                    String string6 = serviceInfo.getPropertyString((String)object);
                    String string7 = ((String)object).toLowerCase(Locale.US);
                    if (string7.equals(AETTXTRecordPropertyNameAsLowerCase)) {
                        string3 = string6;
                        continue;
                    }
                    if (string7.equals(PrimaryDeviceTypeTXTRecordPropertyNameAsLowerCase)) {
                        string4 = string6;
                        continue;
                    }
                    slf4jlogger.trace("OurJmDNSServiceListener: Service resolved: Unrecognized property name = {} value = {}", object, string6);
                }
            }
            if (string3 == null) {
                string3 = string;
            }
            slf4jlogger.trace("OurJmDNSServiceListener: Service resolved: hostname = {}", string5);
            slf4jlogger.trace("OurJmDNSServiceListener: Service resolved: port = {}", n);
            slf4jlogger.trace("OurJmDNSServiceListener: Service resolved: aet = {}", string3);
            slf4jlogger.trace("OurJmDNSServiceListener: Service resolved: primaryDeviceType = {}", string4);
            if (string != null && string.length() > 0 && string5 != null && string5.length() > 0 && string3 != null && string3.length() > 0 && n != -1) {
                object2 = new PresentationAddress(string5, n);
                object = new ApplicationEntity(string3, (PresentationAddress)object2, null, string4);
                try {
                    NetworkConfigurationFromMulticastDNS.this.getNetworkApplicationInformation().add(string, (ApplicationEntity)object);
                }
                catch (DicomNetworkException dicomNetworkException) {
                    slf4jlogger.error("", dicomNetworkException);
                }
            }
        }
    }
}

