/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.PresentationContext;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CapabilitiesAvailable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class PresentationContextListFactory {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/PresentationContextListFactory.java,v 1.31 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(PresentationContextListFactory.class);
    private static final int presentationContextIDStart = 1;
    private static final int presentationContextIDIncrement = 2;
    private static final int presentationContextIDMaximum = 255;
    private static boolean haveBzip2Support = CapabilitiesAvailable.haveBzip2Support();
    private static String[][] supportedTransferSyntaxes = new String[][]{{"1.2.840.10008.1.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2"}, {"1.2.840.10008.1.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2", "1.2.840.10008.1.2.1.99"}, {"1.2.840.10008.1.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2", "1.3.6.1.4.1.5962.300.1", "1.2.840.10008.1.2.1.99"}, {"1.2.840.10008.1.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2", "1.3.6.1.4.1.5962.300.1", "1.2.840.10008.1.2.1.99", "1.2.840.10008.1.2.4.57", "1.2.840.10008.1.2.4.70", "1.2.840.10008.1.2.4.80", "1.2.840.10008.1.2.4.90", "1.2.840.10008.1.2.5"}, {"1.2.840.10008.1.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2", "1.3.6.1.4.1.5962.300.1", "1.2.840.10008.1.2.1.99", "1.2.840.10008.1.2.4.57", "1.2.840.10008.1.2.4.70", "1.2.840.10008.1.2.4.80", "1.2.840.10008.1.2.4.90", "1.2.840.10008.1.2.5", "1.2.840.10008.1.2.4.50", "1.2.840.10008.1.2.4.51", "1.2.840.10008.1.2.4.81", "1.2.840.10008.1.2.4.91", "1.2.840.10008.1.2.4.100", "1.2.840.10008.1.2.4.101", "1.2.840.10008.1.2.4.102", "1.2.840.10008.1.2.4.103", "1.2.840.10008.1.2.4.104", "1.2.840.10008.1.2.4.105", "1.2.840.10008.1.2.4.106"}};
    private static Set<String> canConvertFromTransferSyntax = new HashSet<String>();

    private static final byte incrementPresentationContextID(byte by) throws DicomNetworkException {
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("incrementPresentationContextID(): starting with {}", by & 0xFF);
        }
        if ((by & 0xFF) >= 255) {
            throw new DicomNetworkException("Too many presentation contexts");
        }
        return (byte)(by + 2);
    }

    public static boolean haveBzip2Support() {
        return CapabilitiesAvailable.haveBzip2Support();
    }

    public static LinkedList createNewPresentationContextList(String string, String string2, int n, boolean bl, boolean bl2, boolean bl3) throws DicomNetworkException {
        if (!(haveBzip2Support || n != 2 || string2 != null && string2.equals("1.3.6.1.4.1.5962.300.1"))) {
            n = 1;
        }
        LinkedList linkedList = new LinkedList();
        byte by = 1;
        by = PresentationContextListFactory.addPresentationContextsForAbstractSyntax(linkedList, by, string, string2, n, bl, bl2, bl3);
        return linkedList;
    }

    public static LinkedList createNewPresentationContextList(String string, String string2, int n) throws DicomNetworkException {
        return PresentationContextListFactory.createNewPresentationContextList(string, string2, n, true, true, true);
    }

    public static LinkedList createNewPresentationContextList(Set<String> set, int n, boolean bl, boolean bl2) throws DicomNetworkException {
        slf4jlogger.debug("createNewPresentationContextList():");
        if (!haveBzip2Support && n == 2) {
            n = 1;
        }
        LinkedList linkedList = new LinkedList();
        byte by = 1;
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("createNewPresentationContextList(): setOfSOPClassUIDs.size() = " + set.size());
        }
        for (String string : set) {
            slf4jlogger.debug("createNewPresentationContextList(): doing sopClassUID = {}", string);
            by = PresentationContextListFactory.addPresentationContextsForAbstractSyntax(linkedList, by, string, null, n, bl, bl2, false);
        }
        return linkedList;
    }

    public static LinkedList createNewPresentationContextList(Set<String> set, int n) throws DicomNetworkException {
        return PresentationContextListFactory.createNewPresentationContextList(set, n, true, true);
    }

    public static LinkedList createNewPresentationContextList(SetOfDicomFiles setOfDicomFiles, int n, boolean bl, boolean bl2, boolean bl3) throws DicomNetworkException {
        Object object2;
        if (!haveBzip2Support && n == 2) {
            n = 1;
        }
        HashMap<Object, HashSet<String>> hashMap = new HashMap<Object, HashSet<String>>();
        for (Object object2 : setOfDicomFiles) {
            if (slf4jlogger.isDebugEnabled()) {
                slf4jlogger.debug("createNewPresentationContextList(): file = " + ((SetOfDicomFiles.DicomFile)object2).getFileName());
            }
            String string = ((SetOfDicomFiles.DicomFile)object2).getTransferSyntaxUID();
            slf4jlogger.debug("createNewPresentationContextList(): TransferSyntax = " + string);
            String string2 = ((SetOfDicomFiles.DicomFile)object2).getSOPClassUID();
            slf4jlogger.debug("createNewPresentationContextList(): AbstractSyntax = " + string);
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                Set<String> set = (Set)hashMap.get(string2);
                if (set == null) {
                    set = new HashSet<String>();
                    hashMap.put(string2, (HashSet<String>)set);
                }
                set.add(string);
                continue;
            }
            throw new DicomNetworkException("Cannot get Abstract or Transfer Syntax to build Presentation Context from file " + ((SetOfDicomFiles.DicomFile)object2).getFileName());
        }
        object2 = new LinkedList();
        byte by = 1;
        for (Set<String> set : hashMap.keySet()) {
            for (String string : (Set)hashMap.get(set)) {
                by = PresentationContextListFactory.addPresentationContextsForAbstractSyntax((LinkedList)object2, by, (String)((Object)set), string, n, bl, bl2, bl3);
            }
        }
        return object2;
    }

    public static LinkedList createNewPresentationContextList(SetOfDicomFiles setOfDicomFiles, int n) throws DicomNetworkException {
        return PresentationContextListFactory.createNewPresentationContextList(setOfDicomFiles, n, true, true, true);
    }

    private static byte addPresentationContextsForAbstractSyntax(LinkedList linkedList, byte by, String string, String string2, int n, boolean bl, boolean bl2, boolean bl3) throws DicomNetworkException {
        slf4jlogger.debug("addPresentationContextsForAbstractSyntax(): presentationContextID = " + by);
        slf4jlogger.debug("addPresentationContextsForAbstractSyntax(): abstractSyntax = " + string);
        slf4jlogger.debug("addPresentationContextsForAbstractSyntax(): transferSyntax = " + string2);
        slf4jlogger.debug("addPresentationContextsForAbstractSyntax(): compressionLevel = " + n);
        slf4jlogger.debug("addPresentationContextsForAbstractSyntax(): theirChoice = " + bl);
        slf4jlogger.debug("addPresentationContextsForAbstractSyntax(): ourChoice = " + bl2);
        slf4jlogger.debug("addPresentationContextsForAbstractSyntax(): asEncoded = " + bl3);
        int n2 = linkedList.size();
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("addPresentationContextsForAbstractSyntax(): starting presentationContextID = " + (by & 0xFF));
        }
        slf4jlogger.debug("addPresentationContextsForAbstractSyntax(): transferSyntax = " + string2);
        if (bl) {
            slf4jlogger.debug("addPresentationContextsForAbstractSyntax(): theirChoice");
            LinkedList<String> linkedList2 = new LinkedList<String>();
            if (string2 != null && string2.length() > 0) {
                linkedList2.add(string2);
            }
            if (string2 == null || canConvertFromTransferSyntax.contains(string2)) {
                for (int i = 0; i < supportedTransferSyntaxes[n].length; ++i) {
                    if (string2 != null && string2.equals(supportedTransferSyntaxes[n][i])) continue;
                    linkedList2.add(supportedTransferSyntaxes[n][i]);
                }
            }
            if (!linkedList2.isEmpty()) {
                linkedList.add(new PresentationContext(by, string, linkedList2));
                by = PresentationContextListFactory.incrementPresentationContextID(by);
            }
        }
        if (bl3 && string2 != null && string2.length() > 0) {
            slf4jlogger.debug("addPresentationContextsForAbstractSyntax(): asEncoded and not null or empty");
            linkedList.add(new PresentationContext(by, string, string2));
            by = PresentationContextListFactory.incrementPresentationContextID(by);
        }
        if (bl2 && (string2 == null || canConvertFromTransferSyntax.contains(string2))) {
            slf4jlogger.debug("addPresentationContextsForAbstractSyntax(): ourChoice and can convert");
            for (int i = 0; i < supportedTransferSyntaxes[n].length; ++i) {
                if (string2 != null && string2.equals(supportedTransferSyntaxes[n][i])) continue;
                linkedList.add(new PresentationContext(by, string, supportedTransferSyntaxes[n][i]));
                by = PresentationContextListFactory.incrementPresentationContextID(by);
            }
        }
        if (linkedList.size() <= n2) {
            throw new DicomNetworkException("Failed to created any Presentation Contexts for Abstract Syntax " + string);
        }
        return by;
    }

    static {
        if (haveBzip2Support) {
            canConvertFromTransferSyntax.addAll(Arrays.asList(supportedTransferSyntaxes[2]));
        } else {
            canConvertFromTransferSyntax.addAll(Arrays.asList(supportedTransferSyntaxes[1]));
        }
    }
}

