/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.AsynchronousOutputStream;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.network.AReleaseException;
import com.pixelmed.network.ApplicationEntityMap;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationAcceptor;
import com.pixelmed.network.AssociationFactory;
import com.pixelmed.network.AssociationStatusHandler;
import com.pixelmed.network.CEchoRequestCommandMessage;
import com.pixelmed.network.CEchoResponseCommandMessage;
import com.pixelmed.network.CFindRequestCommandMessage;
import com.pixelmed.network.CFindResponseCommandMessage;
import com.pixelmed.network.CGetRequestCommandMessage;
import com.pixelmed.network.CGetResponseCommandMessage;
import com.pixelmed.network.CMoveRequestCommandMessage;
import com.pixelmed.network.CMoveResponseCommandMessage;
import com.pixelmed.network.CStoreRequestCommandMessage;
import com.pixelmed.network.CStoreResponseCommandMessage;
import com.pixelmed.network.CompositeResponseHandler;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.IdentifierMessage;
import com.pixelmed.network.MessageServiceElementCommand;
import com.pixelmed.network.MultipleInstanceTransferStatusHandler;
import com.pixelmed.network.NetworkDefaultValues;
import com.pixelmed.network.PDataPDU;
import com.pixelmed.network.PresentationAddress;
import com.pixelmed.network.PresentationContextSelectionPolicy;
import com.pixelmed.network.PresentationDataValue;
import com.pixelmed.network.ProbeCapability;
import com.pixelmed.network.ReceivedDataHandler;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.ResponseStatus;
import com.pixelmed.network.StorageSOPClassSCU;
import com.pixelmed.network.VerificationSOPClassSCU;
import com.pixelmed.query.QueryResponseGenerator;
import com.pixelmed.query.QueryResponseGeneratorFactory;
import com.pixelmed.query.RetrieveResponseGenerator;
import com.pixelmed.query.RetrieveResponseGeneratorFactory;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.ByteArray;
import com.pixelmed.utils.CopyStream;
import com.pixelmed.utils.FileUtilities;
import com.pixelmed.utils.HexDump;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;

public class StorageSOPClassSCP
extends SOPClass
implements Runnable {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/StorageSOPClassSCP.java,v 1.87 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(StorageSOPClassSCP.class);
    private static final int bufferedOutputStreamSizeForCStoreFileWrite = 65536;
    private static final boolean useBufferedOutputStreamForCStoreFileWrite = false;
    private static final boolean useAsynchronousOutputStreamForCStoreFileWrite = true;
    private Socket socket;
    private String calledAETitle;
    private int ourMaximumLengthReceived;
    private int socketReceiveBufferSize;
    private int socketSendBufferSize;
    private File savedImagesFolder;
    protected StoredFilePathStrategy storedFilePathStrategy;
    private ReceivedObjectHandler receivedObjectHandler;
    private AssociationStatusHandler associationStatusHandler;
    private QueryResponseGeneratorFactory queryResponseGeneratorFactory;
    private RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory;
    private ApplicationEntityMap applicationEntityMap;
    private PresentationContextSelectionPolicy presentationContextSelectionPolicy;

    private boolean receiveAndProcessOneRequestMessage(Association association) throws AReleaseException, DicomNetworkException, DicomException, IOException {
        boolean bl;
        slf4jlogger.debug("receiveAndProcessOneRequestMessage(): start");
        long l = System.currentTimeMillis();
        CompositeCommandReceivedPDUHandler compositeCommandReceivedPDUHandler = new CompositeCommandReceivedPDUHandler(this.savedImagesFolder, this.queryResponseGeneratorFactory, this.retrieveResponseGeneratorFactory);
        association.setReceivedDataHandler(compositeCommandReceivedPDUHandler);
        slf4jlogger.debug("receiveAndProcessOneRequestMessage(): waitForPDataPDUsUntilHandlerReportsDone");
        association.waitForPDataPDUsUntilHandlerReportsDone();
        slf4jlogger.debug("receiveAndProcessOneRequestMessage(): back from waitForPDataPDUsUntilHandlerReportsDone");
        Object object = compositeCommandReceivedPDUHandler.getReceivedFileName();
        if (object != null) {
            byte by = compositeCommandReceivedPDUHandler.getPresentationContextIDUsed();
            String string = association.getTransferSyntaxForPresentationContextID(by);
            String string2 = association.getCallingAETitle();
            this.receivedObjectHandler.sendReceivedObjectIndication((String)object, string, string2);
            slf4jlogger.debug("receiveAndProcessOneRequestMessage(): received file {} from {} in {}", object, string2, string);
        }
        long l2 = System.currentTimeMillis();
        slf4jlogger.debug("receiveAndProcessOneRequestMessage(): took {} seconds", (double)(l2 - l) / 1000.0);
        slf4jlogger.debug("receiveAndProcessOneRequestMessage(): sending (final) response");
        object = compositeCommandReceivedPDUHandler.getResponse();
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("receiveAndProcessOneRequestMessage(): response = {}", CompositeResponseHandler.dumpAttributeListFromCommandOrData((byte[])object, "1.2.840.10008.1.2"));
        }
        association.send(compositeCommandReceivedPDUHandler.getPresentationContextIDUsed(), (byte[])object, null);
        slf4jlogger.debug("receiveAndProcessOneRequestMessage(): end");
        if (compositeCommandReceivedPDUHandler.isToBeReleased()) {
            slf4jlogger.debug("receiveAndProcessOneRequestMessage(): explicitly releasing association");
            association.release();
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public StorageSOPClassSCP(Socket socket, String string, int n, int n2, int n3, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler, AssociationStatusHandler associationStatusHandler, QueryResponseGeneratorFactory queryResponseGeneratorFactory, RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory, ApplicationEntityMap applicationEntityMap, PresentationContextSelectionPolicy presentationContextSelectionPolicy, int n4) throws DicomNetworkException, DicomException, IOException {
        this(socket, string, n, n2, n3, file, storedFilePathStrategy, receivedObjectHandler, associationStatusHandler, queryResponseGeneratorFactory, retrieveResponseGeneratorFactory, applicationEntityMap, presentationContextSelectionPolicy);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public StorageSOPClassSCP(Socket socket, String string, int n, int n2, int n3, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler, AssociationStatusHandler associationStatusHandler, QueryResponseGeneratorFactory queryResponseGeneratorFactory, RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory, ApplicationEntityMap applicationEntityMap, PresentationContextSelectionPolicy presentationContextSelectionPolicy) throws DicomNetworkException, DicomException, IOException {
        this.socket = socket;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = n;
        this.socketReceiveBufferSize = n2;
        this.socketSendBufferSize = n3;
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = storedFilePathStrategy;
        this.receivedObjectHandler = receivedObjectHandler;
        this.associationStatusHandler = associationStatusHandler;
        this.queryResponseGeneratorFactory = queryResponseGeneratorFactory;
        this.retrieveResponseGeneratorFactory = retrieveResponseGeneratorFactory;
        this.applicationEntityMap = applicationEntityMap;
        this.presentationContextSelectionPolicy = presentationContextSelectionPolicy;
    }

    @Override
    public void run() {
        try {
            AssociationAcceptor associationAcceptor = AssociationFactory.createNewAssociation(this.socket, this.calledAETitle, this.ourMaximumLengthReceived, this.socketReceiveBufferSize, this.socketSendBufferSize, this.presentationContextSelectionPolicy);
            slf4jlogger.debug("Association received {}", associationAcceptor.getEndpointDescription());
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace(((Association)associationAcceptor).toString());
            }
            try {
                while (this.receiveAndProcessOneRequestMessage(associationAcceptor)) {
                }
            }
            catch (AReleaseException aReleaseException) {
                if (this.associationStatusHandler != null) {
                    this.associationStatusHandler.sendAssociationReleaseIndication(associationAcceptor);
                }
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    private class CompositeCommandReceivedPDUHandler
    extends ReceivedDataHandler {
        private int command = 0;
        private byte[] commandReceived = null;
        private AttributeList commandList = null;
        private byte[] dataReceived = null;
        private AttributeList dataList = null;
        private OutputStream out = null;
        private CStoreRequestCommandMessage csrq = null;
        private CEchoRequestCommandMessage cerq;
        private CFindRequestCommandMessage cfrq;
        private CMoveRequestCommandMessage cmrq;
        private CGetRequestCommandMessage cgrq;
        private byte[] response;
        private byte presentationContextIDUsed;
        private File receivedFile = null;
        private File temporaryReceivedFile;
        private File savedImagesFolder;
        private QueryResponseGeneratorFactory queryResponseGeneratorFactory;
        private RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory;

        private void buildCEchoResponse() throws DicomException, IOException {
            this.response = new CEchoResponseCommandMessage(this.cerq.getAffectedSOPClassUID(), this.cerq.getMessageID(), ResponseStatus.Success).getBytes();
        }

        private void buildCStoreResponse() throws DicomException, IOException {
            this.response = new CStoreResponseCommandMessage(this.csrq.getAffectedSOPClassUID(), this.csrq.getAffectedSOPInstanceUID(), this.csrq.getMessageID(), ResponseStatus.Success).getBytes();
        }

        public CompositeCommandReceivedPDUHandler(File file, QueryResponseGeneratorFactory queryResponseGeneratorFactory, RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory) {
            this.savedImagesFolder = file;
            this.queryResponseGeneratorFactory = queryResponseGeneratorFactory;
            this.retrieveResponseGeneratorFactory = retrieveResponseGeneratorFactory;
        }

        @Override
        public void sendPDataIndication(PDataPDU pDataPDU, Association association) throws DicomNetworkException, DicomException, IOException {
            slf4jlogger.trace("CompositeCommandReceivedPDUHandler.sendPDataIndication(): sendPDataIndication()");
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace(super.dumpPDVListToString(pDataPDU.getPDVList()));
            }
            slf4jlogger.trace("CompositeCommandReceivedPDUHandler.sendPDataIndication(): finished dumping PDV list from PDU");
            LinkedList linkedList = pDataPDU.getPDVList();
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler;
                Object object;
                Object object2;
                Object object3;
                slf4jlogger.trace("CompositeCommandReceivedPDUHandler.sendPDataIndication(): have another fragment");
                PresentationDataValue presentationDataValue = (PresentationDataValue)listIterator.next();
                this.presentationContextIDUsed = presentationDataValue.getPresentationContextID();
                if (presentationDataValue.isCommand()) {
                    this.receivedFile = null;
                    this.commandReceived = ByteArray.concatenate(this.commandReceived, presentationDataValue.getValue());
                    if (!presentationDataValue.isLastFragment()) continue;
                    slf4jlogger.trace("CompositeCommandReceivedPDUHandler.sendPDataIndication(): last fragment of data seen");
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace(HexDump.dump(this.commandReceived));
                    }
                    this.commandList = new AttributeList();
                    this.commandList.read(new DicomInputStream(new ByteArrayInputStream(this.commandReceived), "1.2.840.10008.1.2", false));
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace(this.commandList.toString());
                    }
                    this.command = Attribute.getSingleIntegerValueOrDefault(this.commandList, TagFromName.CommandField, 65535);
                    if (this.command == 48) {
                        slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): C-ECHO-RQ between {}", association.getEndpointDescription());
                        this.cerq = new CEchoRequestCommandMessage(this.commandList);
                        this.buildCEchoResponse();
                        this.setDone(true);
                        this.setRelease(false);
                    } else if (this.command == 1) {
                        slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): C-STORE-RQ between {}", association.getEndpointDescription());
                        this.csrq = new CStoreRequestCommandMessage(this.commandList);
                    } else if (this.command == 32 && this.queryResponseGeneratorFactory != null) {
                        slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): C-FIND-RQ between {}", association.getEndpointDescription());
                        this.cfrq = new CFindRequestCommandMessage(this.commandList);
                    } else if (this.command == 33 && this.retrieveResponseGeneratorFactory != null) {
                        slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): C-MOVE-RQ between {}", association.getEndpointDescription());
                        this.cmrq = new CMoveRequestCommandMessage(this.commandList);
                    } else if (this.command == 16 && this.retrieveResponseGeneratorFactory != null) {
                        slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): C-GET-RQ between {}", association.getEndpointDescription());
                        this.cgrq = new CGetRequestCommandMessage(this.commandList);
                    } else {
                        throw new DicomNetworkException("Unexpected command 0x" + Integer.toHexString(this.command) + " " + MessageServiceElementCommand.toString(this.command));
                    }
                    if (!slf4jlogger.isTraceEnabled() || !listIterator.hasNext()) continue;
                    slf4jlogger.trace("CompositeCommandReceivedPDUHandler: Data after command in same PDU");
                    continue;
                }
                if (this.command == 1) {
                    Object object4;
                    slf4jlogger.trace("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Storing data fragment");
                    if (this.out == null && this.savedImagesFolder != null) {
                        object4 = new FileMetaInformation(this.csrq.getAffectedSOPClassUID(), this.csrq.getAffectedSOPInstanceUID(), association.getTransferSyntaxForPresentationContextID(this.presentationContextIDUsed), association.getCallingAETitle());
                        this.temporaryReceivedFile = new File(this.savedImagesFolder, FileUtilities.makeTemporaryFileName());
                        slf4jlogger.trace("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Receiving and storing into temporary {}", this.temporaryReceivedFile);
                        this.out = new FileOutputStream(this.temporaryReceivedFile);
                        object3 = new DicomOutputStream(this.out, "1.2.840.10008.1.2.1", null);
                        ((FileMetaInformation)object4).getAttributeList().write((DicomOutputStream)object3);
                        ((FilterOutputStream)object3).flush();
                        slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Using AsynchronousOutputStream for C-STORE file write");
                        this.out = new AsynchronousOutputStream(this.out);
                    }
                    if (this.out != null) {
                        object4 = presentationDataValue.getValue();
                        this.out.write((byte[])object4);
                    }
                    if (!presentationDataValue.isLastFragment()) continue;
                    slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Last fragment received so finished storing data");
                    if (this.out != null) {
                        slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Closing the output file");
                        this.out.close();
                        slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Finished closing the output file");
                        boolean bl = false;
                        if (bl) {
                            slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): no attempt to move file");
                            this.receivedFile = this.temporaryReceivedFile;
                        } else {
                            slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): attempting to rename file");
                            this.receivedFile = StorageSOPClassSCP.this.storedFilePathStrategy.makeReliableStoredFilePathWithFoldersCreated(this.savedImagesFolder, this.csrq.getAffectedSOPInstanceUID());
                            if (!this.temporaryReceivedFile.renameTo(this.receivedFile)) {
                                slf4jlogger.warn("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Could not move temporary file into place ... copying instead");
                                CopyStream.copy(this.temporaryReceivedFile, this.receivedFile);
                                if (!this.temporaryReceivedFile.delete()) {
                                    slf4jlogger.error("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Could not delete temporary file after copying");
                                }
                            }
                            slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): rename or copy of file done");
                        }
                        this.out = null;
                    }
                    this.buildCStoreResponse();
                    this.setDone(true);
                    this.setRelease(false);
                    continue;
                }
                if (this.command == 32 && this.queryResponseGeneratorFactory != null) {
                    QueryResponseGenerator queryResponseGenerator = this.queryResponseGeneratorFactory.newInstance();
                    this.dataReceived = ByteArray.concatenate(this.dataReceived, presentationDataValue.getValue());
                    if (!presentationDataValue.isLastFragment()) continue;
                    slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): last fragment of data seen");
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("Query identifier is\n{}", HexDump.dump(this.dataReceived));
                    }
                    this.dataList = new AttributeList();
                    this.dataList.read(new DicomInputStream(new ByteArrayInputStream(this.dataReceived), association.getTransferSyntaxForPresentationContextID(this.presentationContextIDUsed), false));
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("Query identifier is\n{}", this.dataList.toString());
                    }
                    queryResponseGenerator.performQuery(this.cfrq.getAffectedSOPClassUID(), this.dataList, false);
                    int n = queryResponseGenerator.getStatus();
                    if (n != ResponseStatus.Success) {
                        slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Query failed, status = 0x{}", Integer.toHexString(n));
                        this.response = new CFindResponseCommandMessage(this.cfrq.getAffectedSOPClassUID(), this.cfrq.getMessageID(), n, false, queryResponseGenerator.getOffendingElement(), null).getBytes();
                        queryResponseGenerator.close();
                    } else {
                        AttributeList attributeList;
                        while ((attributeList = queryResponseGenerator.next()) != null) {
                            if (slf4jlogger.isDebugEnabled()) {
                                slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Building and sending pending response\n{}", attributeList.toString());
                            }
                            byte by = association.getSuitablePresentationContextID(this.cfrq.getAffectedSOPClassUID());
                            slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Using context ID for response {}", by);
                            object2 = new CFindResponseCommandMessage(this.cfrq.getAffectedSOPClassUID(), this.cfrq.getMessageID(), queryResponseGenerator.allOptionalKeysSuppliedWereSupported() ? ResponseStatus.MatchesAreContinuingOptionalKeysSupported : ResponseStatus.MatchesAreContinuingOptionalKeysNotSupported, true).getBytes();
                            object = new IdentifierMessage(attributeList, association.getTransferSyntaxForPresentationContextID(by)).getBytes();
                            association.send(by, (byte[])object2, null);
                            association.send(by, null, (byte[])object);
                        }
                        queryResponseGenerator.close();
                        slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Bulding final C-FIND success response");
                        this.response = new CFindResponseCommandMessage(this.cfrq.getAffectedSOPClassUID(), this.cfrq.getMessageID(), ResponseStatus.Success, false).getBytes();
                    }
                    this.setDone(true);
                    this.setRelease(false);
                    continue;
                }
                if (this.command == 33 && this.retrieveResponseGeneratorFactory != null && StorageSOPClassSCP.this.applicationEntityMap != null) {
                    RetrieveResponseGenerator retrieveResponseGenerator = this.retrieveResponseGeneratorFactory.newInstance();
                    this.dataReceived = ByteArray.concatenate(this.dataReceived, presentationDataValue.getValue());
                    if (!presentationDataValue.isLastFragment()) continue;
                    slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): last fragment of data seen");
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace(HexDump.dump(this.dataReceived));
                    }
                    this.dataList = new AttributeList();
                    this.dataList.read(new DicomInputStream(new ByteArrayInputStream(this.dataReceived), association.getTransferSyntaxForPresentationContextID(this.presentationContextIDUsed), false));
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace(this.dataList.toString());
                    }
                    retrieveResponseGenerator.performRetrieve(this.cmrq.getAffectedSOPClassUID(), this.dataList, false);
                    object3 = retrieveResponseGenerator.getDicomFiles();
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("CompositeCommandReceivedPDUHandler.sendPDataIndication(): dicomFiles={}", object3);
                    }
                    int n = retrieveResponseGenerator.getStatus();
                    retrieveResponseGenerator.close();
                    if (n != ResponseStatus.Success || object3 == null || ((HashSet)object3).isEmpty()) {
                        slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): retrieve failed or contains nothing, status = 0x{}", Integer.toHexString(n));
                        this.response = new CMoveResponseCommandMessage(this.cmrq.getAffectedSOPClassUID(), this.cmrq.getMessageID(), n, false, retrieveResponseGenerator.getOffendingElement(), null).getBytes();
                    } else {
                        String string;
                        multipleInstanceTransferStatusHandler = new CMovePendingResponseSender(association, this.cmrq);
                        ((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nRemaining = ((HashSet)object3).size();
                        object2 = this.cmrq.getMoveDestination();
                        object = StorageSOPClassSCP.this.applicationEntityMap.getPresentationAddress((String)object2);
                        if (object == null && ((String)object2).equals(association.getCallingAETitle()) && (string = association.getCallingAEHostName()) != null && string.length() > 0) {
                            slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): unrecognized moveDestinationAETitle={} but matches callingAETitle so trying some likely ports on host {}", object2, string);
                            for (int n2 : NetworkDefaultValues.commonPortNumbers) {
                                slf4jlogger.trace("CompositeCommandReceivedPDUHandler.sendPDataIndication(): trying guessed port number {}", n2);
                                try {
                                    int n3 = 5000;
                                    slf4jlogger.trace("CompositeCommandReceivedPDUHandler.sendPDataIndication(): testing ability to connect socket to port {} with timeout {} ms", n2, n3);
                                    if (!ProbeCapability.canConnectToPort(string, n2, n3)) continue;
                                    new VerificationSOPClassSCU(string, n2, (String)object2, association.getCalledAETitle(), false);
                                    slf4jlogger.trace("CompositeCommandReceivedPDUHandler.sendPDataIndication(): successful C-ECHO to guessed port number {}", n2);
                                    object = new PresentationAddress(string, n2);
                                    break;
                                }
                                catch (Exception exception) {
                                    slf4jlogger.error("", exception);
                                }
                            }
                        }
                        if (object == null) {
                            n = ResponseStatus.RefusedMoveDestinationUnknown;
                            slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Unrecognized move destination {}, status = 0x{}", object2, Integer.toHexString(n));
                            this.response = new CMoveResponseCommandMessage(this.cmrq.getAffectedSOPClassUID(), this.cmrq.getMessageID(), n, false, null, (String)object2).getBytes();
                        } else if (((String)object2).equals(StorageSOPClassSCP.this.calledAETitle)) {
                            n = ResponseStatus.RefusedMoveDestinationUnknown;
                            slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Refusing to move to ourselves as destination (moveDestinationAETitle and calledAETitle both {}), status = 0x{}", object2, Integer.toHexString(n));
                            this.response = new CMoveResponseCommandMessage(this.cmrq.getAffectedSOPClassUID(), this.cmrq.getMessageID(), n, false, null, (String)object2).getBytes();
                        } else {
                            string = ((PresentationAddress)object).getHostname();
                            int n4 = ((PresentationAddress)object).getPort();
                            slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): moveDestinationAETitle={}", object2);
                            slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): moveDestinationHostname={}", string);
                            slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): moveDestinationPort={}", n4);
                            new StorageSOPClassSCU(string, n4, (String)object2, StorageSOPClassSCP.this.calledAETitle, (SetOfDicomFiles)object3, 0, multipleInstanceTransferStatusHandler, StorageSOPClassSCP.this.calledAETitle, this.cmrq.getMessageID());
                            slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): after all stored: nRemaining={} nCompleted={} nFailed={} nWarning={}", ((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nRemaining, ((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nCompleted, ((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nFailed, ((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nWarning);
                            if (((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nRemaining > 0) {
                                ((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nFailed += ((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nRemaining;
                                ((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nRemaining = 0;
                            }
                            slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): after setting remaining to zero: nRemaining={} nCompleted={} nFailed={} nWarning={}", ((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nRemaining, ((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nCompleted, ((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nFailed, ((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nWarning);
                            slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Bulding final C-MOVE success response");
                            this.response = new CMoveResponseCommandMessage(this.cmrq.getAffectedSOPClassUID(), this.cmrq.getMessageID(), ((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nFailed > 0 ? ResponseStatus.SubOperationsCompleteOneOrMoreFailures : ResponseStatus.SubOperationsCompleteNoFailures, false, ((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nRemaining, ((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nCompleted, ((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nFailed, ((CMovePendingResponseSender)multipleInstanceTransferStatusHandler).nWarning).getBytes();
                        }
                    }
                    this.setDone(true);
                    this.setRelease(false);
                    continue;
                }
                if (this.command == 16 && this.retrieveResponseGeneratorFactory != null) {
                    RetrieveResponseGenerator retrieveResponseGenerator = this.retrieveResponseGeneratorFactory.newInstance();
                    this.dataReceived = ByteArray.concatenate(this.dataReceived, presentationDataValue.getValue());
                    if (!presentationDataValue.isLastFragment()) continue;
                    slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): last fragment of data seen");
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace(HexDump.dump(this.dataReceived));
                    }
                    this.dataList = new AttributeList();
                    this.dataList.read(new DicomInputStream(new ByteArrayInputStream(this.dataReceived), association.getTransferSyntaxForPresentationContextID(this.presentationContextIDUsed), false));
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace(this.dataList.toString());
                    }
                    retrieveResponseGenerator.performRetrieve(this.cgrq.getAffectedSOPClassUID(), this.dataList, false);
                    object3 = retrieveResponseGenerator.getDicomFiles();
                    int n = retrieveResponseGenerator.getStatus();
                    retrieveResponseGenerator.close();
                    if (n != ResponseStatus.Success || object3 == null) {
                        slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): retrieve failed or contains nothing, status = 0x{}", Integer.toHexString(n));
                        this.response = new CGetResponseCommandMessage(this.cgrq.getAffectedSOPClassUID(), this.cgrq.getMessageID(), n, false, retrieveResponseGenerator.getOffendingElement(), null).getBytes();
                    } else {
                        multipleInstanceTransferStatusHandler = new CGetPendingResponseSender(association, this.cgrq);
                        multipleInstanceTransferStatusHandler.nRemaining = ((HashSet)object3).size();
                        new StorageSOPClassSCU(association, (SetOfDicomFiles)object3, multipleInstanceTransferStatusHandler);
                        association.setReceivedDataHandler(this);
                        slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): after all stored: nRemaining={} nCompleted={} nFailed={} nWarning={}", multipleInstanceTransferStatusHandler.nRemaining, multipleInstanceTransferStatusHandler.nCompleted, multipleInstanceTransferStatusHandler.nFailed, multipleInstanceTransferStatusHandler.nWarning);
                        if (multipleInstanceTransferStatusHandler.nRemaining > 0) {
                            multipleInstanceTransferStatusHandler.nFailed += multipleInstanceTransferStatusHandler.nRemaining;
                            multipleInstanceTransferStatusHandler.nRemaining = 0;
                        }
                        slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): after setting remaining to zero: nRemaining={} nCompleted={} nFailed={} nWarning={}", multipleInstanceTransferStatusHandler.nRemaining, multipleInstanceTransferStatusHandler.nCompleted, multipleInstanceTransferStatusHandler.nFailed, multipleInstanceTransferStatusHandler.nWarning);
                        slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Bulding final C-GET success response");
                        this.response = new CGetResponseCommandMessage(this.cgrq.getAffectedSOPClassUID(), this.cgrq.getMessageID(), multipleInstanceTransferStatusHandler.nFailed > 0 ? ResponseStatus.SubOperationsCompleteOneOrMoreFailures : ResponseStatus.SubOperationsCompleteNoFailures, false, multipleInstanceTransferStatusHandler.nRemaining, multipleInstanceTransferStatusHandler.nCompleted, multipleInstanceTransferStatusHandler.nFailed, multipleInstanceTransferStatusHandler.nWarning).getBytes();
                    }
                    slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Setting done flag for C-GET response");
                    this.setDone(true);
                    this.setRelease(false);
                    continue;
                }
                if (!slf4jlogger.isDebugEnabled()) continue;
                slf4jlogger.debug("CompositeCommandReceivedPDUHandler.sendPDataIndication(): Unexpected data fragment for command 0x{} {} - ignoring", Integer.toHexString(this.command), MessageServiceElementCommand.toString(this.command));
            }
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("CompositeCommandReceivedPDUHandler.sendPDataIndication(): finished; isDone()={}", this.isDone());
            }
        }

        public AttributeList getCommandList() {
            return this.commandList;
        }

        public byte[] getResponse() {
            return this.response;
        }

        public byte getPresentationContextIDUsed() {
            return this.presentationContextIDUsed;
        }

        public File getReceivedFile() {
            return this.receivedFile;
        }

        public String getReceivedFileName() {
            return this.receivedFile == null ? null : this.receivedFile.getPath();
        }

        private class CGetPendingResponseSender
        extends MultipleInstanceTransferStatusHandler {
            private Association association;
            private CGetRequestCommandMessage cgrq;
            int nRemaining;
            int nCompleted;
            int nFailed;
            int nWarning;

            CGetPendingResponseSender(Association association, CGetRequestCommandMessage cGetRequestCommandMessage) {
                this.association = association;
                this.cgrq = cGetRequestCommandMessage;
                this.nRemaining = 0;
                this.nCompleted = 0;
                this.nFailed = 0;
                this.nWarning = 0;
            }

            @Override
            public void updateStatus(int n, int n2, int n3, int n4, String string) {
                this.nRemaining = n;
                this.nCompleted = n2;
                this.nFailed = n3;
                this.nWarning = n4;
                slf4jlogger.debug("CompositeCommandReceivedPDUHandler.CGetPendingResponseSender.updateStatus(): Bulding C-GET pending response");
                if (n > 0) {
                    try {
                        byte[] byArray = new CGetResponseCommandMessage(this.cgrq.getAffectedSOPClassUID(), this.cgrq.getMessageID(), ResponseStatus.SubOperationsAreContinuing, false, n, n2, n3, n4).getBytes();
                        slf4jlogger.debug("CompositeCommandReceivedPDUHandler.CGetPendingResponseSender.updateStatus(): C-GET pending response = {}", CompositeResponseHandler.dumpAttributeListFromCommandOrData(byArray, "1.2.840.10008.1.2"));
                        byte by = this.association.getSuitablePresentationContextID(this.cgrq.getAffectedSOPClassUID());
                        this.association.send(by, byArray, null);
                    }
                    catch (DicomNetworkException dicomNetworkException) {
                        slf4jlogger.error("", dicomNetworkException);
                    }
                    catch (DicomException dicomException) {
                        slf4jlogger.error("", dicomException);
                    }
                    catch (IOException iOException) {
                        slf4jlogger.error("", iOException);
                    }
                }
            }
        }

        private class CMovePendingResponseSender
        extends MultipleInstanceTransferStatusHandler {
            private Association association;
            private CMoveRequestCommandMessage cmrq;
            int nRemaining;
            int nCompleted;
            int nFailed;
            int nWarning;

            CMovePendingResponseSender(Association association, CMoveRequestCommandMessage cMoveRequestCommandMessage) {
                this.association = association;
                this.cmrq = cMoveRequestCommandMessage;
                this.nRemaining = 0;
                this.nCompleted = 0;
                this.nFailed = 0;
                this.nWarning = 0;
            }

            @Override
            public void updateStatus(int n, int n2, int n3, int n4, String string) {
                this.nRemaining = n;
                this.nCompleted = n2;
                this.nFailed = n3;
                this.nWarning = n4;
                slf4jlogger.debug("CompositeCommandReceivedPDUHandler.CMovePendingResponseSender.updateStatus(): Bulding C-MOVE pending response");
                if (n > 0) {
                    try {
                        byte[] byArray = new CMoveResponseCommandMessage(this.cmrq.getAffectedSOPClassUID(), this.cmrq.getMessageID(), ResponseStatus.SubOperationsAreContinuing, false, n, n2, n3, n4).getBytes();
                        if (slf4jlogger.isDebugEnabled()) {
                            slf4jlogger.debug("CompositeCommandReceivedPDUHandler.CMovePendingResponseSender.updateStatus(): C-MOVE pending response = {}", CompositeResponseHandler.dumpAttributeListFromCommandOrData(byArray, "1.2.840.10008.1.2"));
                        }
                        byte by = this.association.getSuitablePresentationContextID(this.cmrq.getAffectedSOPClassUID());
                        this.association.send(by, byArray, null);
                    }
                    catch (DicomNetworkException dicomNetworkException) {
                        slf4jlogger.error("", dicomNetworkException);
                    }
                    catch (DicomException dicomException) {
                        slf4jlogger.error("", dicomException);
                    }
                    catch (IOException iOException) {
                        slf4jlogger.error("", iOException);
                    }
                }
            }
        }
    }
}

