/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.scpecg;

import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.scpecg.SCPTreeRecord;
import com.pixelmed.scpecg.Section0;
import com.pixelmed.scpecg.Section1;
import com.pixelmed.scpecg.Section10;
import com.pixelmed.scpecg.Section2;
import com.pixelmed.scpecg.Section3;
import com.pixelmed.scpecg.Section4;
import com.pixelmed.scpecg.Section5Or6;
import com.pixelmed.scpecg.Section7;
import com.pixelmed.scpecg.Section8Or11;
import com.pixelmed.scpecg.SectionHeader;
import java.io.IOException;
import java.util.TreeMap;

public class Section {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/scpecg/Section.java,v 1.24 2025/01/29 10:58:09 dclunie Exp $";
    protected SectionHeader header;
    protected long bytesRead;
    protected long sectionBytesRemaining;
    protected SCPTreeRecord tree;

    public SectionHeader getSectionHeader() {
        return this.header;
    }

    public Section(SectionHeader sectionHeader) {
        this.header = sectionHeader;
        this.bytesRead = 0L;
        this.sectionBytesRemaining = sectionHeader.getSectionLength() - sectionHeader.getBytesRead();
    }

    public long read(BinaryInputStream binaryInputStream) throws IOException {
        this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
        return this.bytesRead;
    }

    protected long skipToEndOfSectionIfNotAlreadyThere(BinaryInputStream binaryInputStream) throws IOException {
        long l = this.sectionBytesRemaining;
        if (this.sectionBytesRemaining > 0L) {
            this.bytesRead += this.sectionBytesRemaining;
            binaryInputStream.skipInsistently(this.sectionBytesRemaining);
            this.sectionBytesRemaining = 0L;
        }
        return l;
    }

    public String toString() {
        return "\n";
    }

    public String validate() {
        return "";
    }

    public String getSectionName() {
        return "";
    }

    public static Section makeSection(SectionHeader sectionHeader, TreeMap treeMap) {
        Section section = null;
        switch (sectionHeader.getSectionIDNumber()) {
            case 0: {
                section = new Section0(sectionHeader);
                break;
            }
            case 1: {
                section = new Section1(sectionHeader);
                break;
            }
            case 2: {
                section = new Section2(sectionHeader);
                break;
            }
            case 3: {
                section = new Section3(sectionHeader);
                break;
            }
            case 4: {
                section = new Section4(sectionHeader);
                break;
            }
            case 5: 
            case 6: {
                Section3 section3 = (Section3)treeMap.get(new Integer(3));
                int n = section3 == null ? 0 : section3.getNumberOfLeads();
                section = new Section5Or6(sectionHeader, n);
                break;
            }
            case 7: {
                section = new Section7(sectionHeader);
                break;
            }
            case 8: 
            case 11: {
                section = new Section8Or11(sectionHeader);
                break;
            }
            case 10: {
                section = new Section10(sectionHeader);
                break;
            }
            default: {
                section = new Section(sectionHeader);
            }
        }
        return section;
    }

    protected String getValueForSectionNodeInTree() {
        return Integer.toString(this.header.getSectionIDNumber()) + " " + this.getSectionName();
    }

    protected void addSectionHeaderToTree(SCPTreeRecord sCPTreeRecord) {
        this.header.getTree(sCPTreeRecord);
    }

    public SCPTreeRecord getTree() {
        return this.tree;
    }

    public SCPTreeRecord getTree(SCPTreeRecord sCPTreeRecord) {
        if (this.tree == null) {
            SCPTreeRecord sCPTreeRecord2 = new SCPTreeRecord(sCPTreeRecord, "Section", this.getValueForSectionNodeInTree());
            this.addSectionHeaderToTree(sCPTreeRecord2);
        }
        return this.tree;
    }

    public static String describeMissingValues(int n) {
        String string = "";
        if (n == 29999) {
            string = "Measurement not computed by the program";
        } else if (n == 29998) {
            string = "Measurement result not found due to rejection of the lead by measurement program";
        } else if (n == 19999) {
            string = "Measurement not found because wave was not present in the corresponding lead";
        }
        return string;
    }

    protected static void addNodeOfDecimalAndHex(SCPTreeRecord sCPTreeRecord, String string, int n) {
        new SCPTreeRecord(sCPTreeRecord, string, Integer.toString(n) + " dec (0x" + Integer.toHexString(n) + ")");
    }

    protected static void addNodeOfDecimalWithMissingValues(SCPTreeRecord sCPTreeRecord, String string, int n) {
        new SCPTreeRecord(sCPTreeRecord, string, Integer.toString(n) + " dec " + Section.describeMissingValues(n));
    }

    public static String makeStringFromByteArrayRemovingAnyNulls(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) continue;
            stringBuffer.append((char)(byArray[i] & 0xFF));
        }
        return stringBuffer.toString();
    }
}

