/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.utils.DateUtilities;
import java.text.ParseException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestAgeCalculation
extends TestCase {
    EarlierLaterAge[] valid = new EarlierLaterAge[]{new EarlierLaterAge("19610625", "20120624", "050Y"), new EarlierLaterAge("19610625", "20120625", "051Y"), new EarlierLaterAge("19610714", "20120625", "050Y"), new EarlierLaterAge("20120103", "20120625", "005M"), new EarlierLaterAge("20120525", "20120625", "001M"), new EarlierLaterAge("20120526", "20120625", "004W"), new EarlierLaterAge("20120611", "20120625", "002W"), new EarlierLaterAge("20120612", "20120625", "001W"), new EarlierLaterAge("20120618", "20120625", "001W"), new EarlierLaterAge("20120622", "20120625", "003D"), new EarlierLaterAge("20000229", "20110301", "011Y"), new EarlierLaterAge("20000229", "20110228", "010Y"), new EarlierLaterAge("20000229", "20120228", "011Y"), new EarlierLaterAge("20000229", "20120229", "012Y"), new EarlierLaterAge("20000229", "20120301", "012Y"), new EarlierLaterAge("20000228", "20120228", "012Y"), new EarlierLaterAge("20000228", "20120229", "012Y")};
    EarlierLaterAge[] invalid = new EarlierLaterAge[]{new EarlierLaterAge("19610625", "20120631", "051Y"), new EarlierLaterAge("20000231", "20110231", "011Y"), new EarlierLaterAge("20000230", "20110230", "011Y"), new EarlierLaterAge("20000229", "20110229", "011Y")};

    public TestAgeCalculation(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestAgeCalculation");
        testSuite.addTest((Test)new TestAgeCalculation("TestAgeCalculation_Valid"));
        testSuite.addTest((Test)new TestAgeCalculation("TestAgeCalculation_InvalidSwapped"));
        testSuite.addTest((Test)new TestAgeCalculation("TestAgeCalculation_Invalid"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestAgeCalculation_Valid() throws Exception {
        for (EarlierLaterAge earlierLaterAge : this.valid) {
            TestAgeCalculation.assertEquals((String)("Test age between " + earlierLaterAge.earlier + " and " + earlierLaterAge.later), (String)earlierLaterAge.age, (String)DateUtilities.getAgeBetweenAsDICOMAgeString(earlierLaterAge.earlier, earlierLaterAge.later));
        }
    }

    public void TestAgeCalculation_InvalidSwapped() throws Exception {
        for (EarlierLaterAge earlierLaterAge : this.valid) {
            try {
                DateUtilities.getAgeBetweenAsDICOMAgeString(earlierLaterAge.later, earlierLaterAge.earlier);
                TestAgeCalculation.fail((String)("getAgeBetweenAsDICOMAgeString() should have thrown an exception for age between " + earlierLaterAge.later + " and " + earlierLaterAge.earlier));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Exception exception) {
                TestAgeCalculation.fail((String)("getAgeBetweenAsDICOMAgeString() should have thrown an IllegalArgumentException for age between " + earlierLaterAge.later + " and " + earlierLaterAge.earlier + ", but threw instead " + exception));
            }
        }
    }

    public void TestAgeCalculation_Invalid() throws Exception {
        for (EarlierLaterAge earlierLaterAge : this.invalid) {
            try {
                DateUtilities.getAgeBetweenAsDICOMAgeString(earlierLaterAge.earlier, earlierLaterAge.later);
                TestAgeCalculation.fail((String)("getAgeBetweenAsDICOMAgeString() should have thrown an exception for age between " + earlierLaterAge.earlier + " and " + earlierLaterAge.later));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (ParseException parseException) {
            }
            catch (Exception exception) {
                TestAgeCalculation.fail((String)("getAgeBetweenAsDICOMAgeString() should have thrown an IllegalArgumentException for age between " + earlierLaterAge.earlier + " and " + earlierLaterAge.later + ", but threw instead " + exception));
            }
        }
    }

    private class EarlierLaterAge {
        String earlier;
        String later;
        String age;

        EarlierLaterAge(String string, String string2, String string3) {
            this.earlier = string;
            this.later = string2;
            this.age = string3;
        }
    }
}

