/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationStatusHandler;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkUtilities;
import com.pixelmed.network.PresentationContext;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.network.StorageSOPClassSCU;
import com.pixelmed.network.TransferSyntaxSelectionPolicy;
import com.pixelmed.network.UnencapsulatedExplicitStoreFindMoveGetPresentationContextSelectionPolicy;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCStore
extends TestCase {
    protected static final int waitIntervalWhenSleeping = 10;
    protected static final String scpAET = "TESTSTORESCP";
    protected static final String scuAET = "TESTSTORESCU";
    protected volatile String lastReceivedDicomFileName;
    protected volatile boolean associationReleased;

    public TestCStore(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCStore");
        testSuite.addTest((Test)new TestCStore("TestCStore_SendOneNotOfSetToDefaultSCPPresentationContextSelectionPolicySuccessfully"));
        testSuite.addTest((Test)new TestCStore("TestCStore_SendOneOfSetToDefaultSCPPresentationContextSelectionPolicySuccessfully"));
        testSuite.addTest((Test)new TestCStore("TestCStore_SendOneOfSetToDefaultSCPPresentationContextSelectionPolicyUnsuccessfully_RLE"));
        testSuite.addTest((Test)new TestCStore("TestCStore_SendOneOfSetToLastRecognizedSCPPresentationContextSelectionPolicySuccessfully_RLE"));
        testSuite.addTest((Test)new TestCStore("TestCStore_SendOneOfSetToDefaultSCPPresentationContextSelectionPolicyUnsuccessfully_MPEG"));
        testSuite.addTest((Test)new TestCStore("TestCStore_SendOneOfSetToLastRecognizedSCPPresentationContextSelectionPolicySuccessfully_MPEG"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestCStore_SendOneNotOfSetToDefaultSCPPresentationContextSelectionPolicySuccessfully() throws Exception {
        System.err.println("TestCStore_SendOneNotOfSetToDefaultSCPPresentationContextSelectionPolicySuccessfully():");
        File file = new File("./receivedfiles");
        int n = NetworkUtilities.getRandomUnusedPortToListenOnLocally();
        StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, scpAET, file, null, new OurReceivedObjectHandler(), new OurAssociationStatusHandler(), null, null, null, null, false);
        Thread thread = new Thread(storageSOPClassSCPDispatcher);
        thread.start();
        while (thread.getState() != Thread.State.RUNNABLE) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        new StorageSOPClassSCU("localhost", n, scpAET, scuAET, "testnetworkfile_scevrle.dcm", null, null, 0);
        while (this.lastReceivedDicomFileName == null) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!this.associationReleased) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        storageSOPClassSCPDispatcher.shutdown();
        while (storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
    }

    public void TestCStore_SendOneOfSetToDefaultSCPPresentationContextSelectionPolicySuccessfully() throws Exception {
        System.err.println("TestCStore_SendOneOfSetToDefaultSCPPresentationContextSelectionPolicySuccessfully():");
        File file = new File("./receivedfiles");
        int n = NetworkUtilities.getRandomUnusedPortToListenOnLocally();
        StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, scpAET, file, null, new OurReceivedObjectHandler(), new OurAssociationStatusHandler(), null, null, null, null, false);
        Thread thread = new Thread(storageSOPClassSCPDispatcher);
        thread.start();
        while (thread.getState() != Thread.State.RUNNABLE) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        SetOfDicomFiles setOfDicomFiles = new SetOfDicomFiles();
        setOfDicomFiles.add("testnetworkfile_scevrle.dcm");
        new StorageSOPClassSCU("localhost", n, scpAET, scuAET, setOfDicomFiles, 0, null);
        while (this.lastReceivedDicomFileName == null) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!this.associationReleased) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        storageSOPClassSCPDispatcher.shutdown();
        while (storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
    }

    public void TestCStore_SendOneOfSetToDefaultSCPPresentationContextSelectionPolicyUnsuccessfully_RLE() throws Exception {
        System.err.println("TestCStore_SendOneOfSetToDefaultSCPPresentationContextSelectionPolicyUnsuccessfully_RLE():");
        File file = new File("./receivedfiles");
        int n = NetworkUtilities.getRandomUnusedPortToListenOnLocally();
        StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, scpAET, file, null, new OurReceivedObjectHandler(), new OurAssociationStatusHandler(), null, null, null, null, false);
        Thread thread = new Thread(storageSOPClassSCPDispatcher);
        thread.start();
        while (thread.getState() != Thread.State.RUNNABLE) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        SetOfDicomFiles setOfDicomFiles = new SetOfDicomFiles();
        setOfDicomFiles.add("testnetworkfile_usrle.dcm");
        StorageSOPClassSCU storageSOPClassSCU = new StorageSOPClassSCU("localhost", n, scpAET, scuAET, setOfDicomFiles, 0, null);
        if (!storageSOPClassSCU.encounteredTrappedExceptions()) {
            TestCStore.fail((String)"new StorageSOPClassSCU() should have thrown a DicomNetworkException for No presentation context for Abstract Syntax");
            while (this.lastReceivedDicomFileName == null) {
                Thread.currentThread();
                Thread.sleep(10L);
            }
            while (!this.associationReleased) {
                Thread.currentThread();
                Thread.sleep(10L);
            }
        }
        storageSOPClassSCPDispatcher.shutdown();
        while (storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
    }

    public void TestCStore_SendOneOfSetToLastRecognizedSCPPresentationContextSelectionPolicySuccessfully_RLE() throws Exception {
        System.err.println("TestCStore_SendOneOfSetToLastRecognizedSCPPresentationContextSelectionPolicySuccessfully_RLE():");
        File file = new File("./receivedfiles");
        int n = NetworkUtilities.getRandomUnusedPortToListenOnLocally();
        StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, scpAET, file, null, new OurReceivedObjectHandler(), new OurAssociationStatusHandler(), null, null, null, new OurLastRecognizedPresentationContextSelectionPolicy(), false);
        Thread thread = new Thread(storageSOPClassSCPDispatcher);
        thread.start();
        while (thread.getState() != Thread.State.RUNNABLE) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        SetOfDicomFiles setOfDicomFiles = new SetOfDicomFiles();
        setOfDicomFiles.add("testnetworkfile_scevrle.dcm");
        new StorageSOPClassSCU("localhost", n, scpAET, scuAET, setOfDicomFiles, 0, null);
        while (this.lastReceivedDicomFileName == null) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!this.associationReleased) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        storageSOPClassSCPDispatcher.shutdown();
        while (storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
    }

    public void TestCStore_SendOneOfSetToDefaultSCPPresentationContextSelectionPolicyUnsuccessfully_MPEG() throws Exception {
        System.err.println("TestCStore_SendOneOfSetToDefaultSCPPresentationContextSelectionPolicyUnsuccessfully_MPEG():");
        File file = new File("./receivedfiles");
        int n = NetworkUtilities.getRandomUnusedPortToListenOnLocally();
        StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, scpAET, file, null, new OurReceivedObjectHandler(), new OurAssociationStatusHandler(), null, null, null, null, false);
        Thread thread = new Thread(storageSOPClassSCPDispatcher);
        thread.start();
        while (thread.getState() != Thread.State.RUNNABLE) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        SetOfDicomFiles setOfDicomFiles = new SetOfDicomFiles();
        setOfDicomFiles.add("testnetworkfile_endompeg.dcm");
        StorageSOPClassSCU storageSOPClassSCU = new StorageSOPClassSCU("localhost", n, scpAET, scuAET, setOfDicomFiles, 0, null);
        if (!storageSOPClassSCU.encounteredTrappedExceptions()) {
            TestCStore.fail((String)"new StorageSOPClassSCU() should have thrown a DicomNetworkException for No presentation context for Abstract Syntax");
            while (this.lastReceivedDicomFileName == null) {
                Thread.currentThread();
                Thread.sleep(10L);
            }
            while (!this.associationReleased) {
                Thread.currentThread();
                Thread.sleep(10L);
            }
        }
        storageSOPClassSCPDispatcher.shutdown();
        while (storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
    }

    public void TestCStore_SendOneOfSetToLastRecognizedSCPPresentationContextSelectionPolicySuccessfully_MPEG() throws Exception {
        System.err.println("TestCStore_SendOneOfSetToLastRecognizedSCPPresentationContextSelectionPolicySuccessfully_MPEG():");
        File file = new File("./receivedfiles");
        int n = NetworkUtilities.getRandomUnusedPortToListenOnLocally();
        StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, scpAET, file, null, new OurReceivedObjectHandler(), new OurAssociationStatusHandler(), null, null, null, new OurLastRecognizedPresentationContextSelectionPolicy(), false);
        Thread thread = new Thread(storageSOPClassSCPDispatcher);
        thread.start();
        while (thread.getState() != Thread.State.RUNNABLE) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        SetOfDicomFiles setOfDicomFiles = new SetOfDicomFiles();
        setOfDicomFiles.add("testnetworkfile_endompeg.dcm");
        new StorageSOPClassSCU("localhost", n, scpAET, scuAET, setOfDicomFiles, 0, null);
        while (this.lastReceivedDicomFileName == null) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!this.associationReleased) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        storageSOPClassSCPDispatcher.shutdown();
        while (storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
    }

    private class OurLastRecognizedTransferSyntaxSelectionPolicy
    extends TransferSyntaxSelectionPolicy {
        private OurLastRecognizedTransferSyntaxSelectionPolicy() {
        }

        @Override
        public LinkedList applyTransferSyntaxSelectionPolicy(LinkedList linkedList, int n) {
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                PresentationContext presentationContext = (PresentationContext)listIterator.next();
                String string = null;
                List list = presentationContext.getTransferSyntaxUIDs();
                ListIterator listIterator2 = list.listIterator();
                while (listIterator2.hasNext()) {
                    String string2 = (String)listIterator2.next();
                    if (!new TransferSyntax(string2).isRecognized()) continue;
                    string = string2;
                }
                presentationContext.newTransferSyntaxUIDs();
                if (string != null) {
                    presentationContext.addTransferSyntaxUID(string);
                    continue;
                }
                presentationContext.setResultReason((byte)4);
            }
            return linkedList;
        }
    }

    private class OurLastRecognizedPresentationContextSelectionPolicy
    extends UnencapsulatedExplicitStoreFindMoveGetPresentationContextSelectionPolicy {
        OurLastRecognizedPresentationContextSelectionPolicy() {
            this.transferSyntaxSelectionPolicy = new OurLastRecognizedTransferSyntaxSelectionPolicy();
        }
    }

    private class OurAssociationStatusHandler
    extends AssociationStatusHandler {
        private OurAssociationStatusHandler() {
        }

        @Override
        public void sendAssociationReleaseIndication(Association association) throws DicomNetworkException, DicomException, IOException {
            if (association != null) {
                // empty if block
            }
            TestCStore.this.associationReleased = true;
        }
    }

    protected class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        protected OurReceivedObjectHandler() {
        }

        @Override
        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            TestCStore.this.lastReceivedDicomFileName = string;
        }
    }
}

