/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationStatusHandler;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkUtilities;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.network.StorageSOPClassSCU;
import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCStore_ConvertTransferSyntaxes
extends TestCase {
    protected static final int waitIntervalWhenSleeping = 10;
    protected static final String scpAET = "TESTSTORESCP";
    protected static final String scuAET = "TESTSTORESCU";
    private String patientName = "Smith^Mary";
    private String patientID = "3764913624";
    private String patientBirthDate = "19600101";
    private String patientAge = "041Y";
    private String patientWeight = "68";
    private String patientSize = "1.55";
    private String patientSex = "F";
    private String studyID = "612386812";
    private String seriesNumber = "12";
    private String instanceNumber = "38";
    private String referringPhysicianName = "Jones^Harriet";
    private String studyDate = "20010203";
    private String studyTime = "043000";
    protected volatile String lastReceivedDicomFileName;
    protected volatile boolean associationReleased;

    public TestCStore_ConvertTransferSyntaxes(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCStore_ConvertTransferSyntaxes");
        testSuite.addTest((Test)new TestCStore_ConvertTransferSyntaxes("TestCStore_ConvertTransferSyntaxes_SendImplicitVROriginalToDefaultSCPPresentationContextSelectionPolicySuccessfully"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private AttributeList makeAttributeList() {
        AttributeList attributeList = new AttributeList();
        try {
            UIDGenerator uIDGenerator = new UIDGenerator("9999");
            String string = uIDGenerator.getNewSOPInstanceUID(this.studyID, this.seriesNumber, this.instanceNumber);
            String string2 = uIDGenerator.getNewSeriesInstanceUID(this.studyID, this.seriesNumber);
            String string3 = uIDGenerator.getNewStudyInstanceUID(this.studyID);
            StringAttribute stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
            ((Attribute)stringAttribute).addValue("1.2.840.10008.5.1.4.1.1.2");
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
            ((Attribute)stringAttribute).addValue(string);
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
            ((Attribute)stringAttribute).addValue(string2);
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
            ((Attribute)stringAttribute).addValue(string3);
            attributeList.put(stringAttribute);
            stringAttribute = new PersonNameAttribute(TagFromName.PatientName);
            ((Attribute)stringAttribute).addValue(this.patientName);
            attributeList.put(stringAttribute);
            stringAttribute = new LongStringAttribute(TagFromName.PatientID);
            ((Attribute)stringAttribute).addValue(this.patientID);
            attributeList.put(stringAttribute);
            stringAttribute = new DateAttribute(TagFromName.PatientBirthDate);
            ((Attribute)stringAttribute).addValue(this.patientBirthDate);
            attributeList.put(stringAttribute);
            stringAttribute = new AgeStringAttribute(TagFromName.PatientAge);
            ((Attribute)stringAttribute).addValue(this.patientAge);
            attributeList.put(stringAttribute);
            stringAttribute = new CodeStringAttribute(TagFromName.PatientSex);
            ((Attribute)stringAttribute).addValue(this.patientSex);
            attributeList.put(stringAttribute);
            stringAttribute = new DecimalStringAttribute(TagFromName.PatientWeight);
            ((Attribute)stringAttribute).addValue(this.patientWeight);
            attributeList.put(stringAttribute);
            stringAttribute = new DecimalStringAttribute(TagFromName.PatientSize);
            ((Attribute)stringAttribute).addValue(this.patientSize);
            attributeList.put(stringAttribute);
            stringAttribute = new ShortStringAttribute(TagFromName.StudyID);
            ((Attribute)stringAttribute).addValue(this.studyID);
            attributeList.put(stringAttribute);
            stringAttribute = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
            ((Attribute)stringAttribute).addValue(this.referringPhysicianName);
            attributeList.put(stringAttribute);
            stringAttribute = new IntegerStringAttribute(TagFromName.SeriesNumber);
            ((Attribute)stringAttribute).addValue(this.seriesNumber);
            attributeList.put(stringAttribute);
            stringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
            ((Attribute)stringAttribute).addValue(this.instanceNumber);
            attributeList.put(stringAttribute);
            stringAttribute = new LongStringAttribute(TagFromName.Manufacturer);
            attributeList.put(stringAttribute);
            stringAttribute = new DateAttribute(TagFromName.StudyDate);
            ((Attribute)stringAttribute).addValue(this.studyDate);
            attributeList.put(stringAttribute);
            stringAttribute = new TimeAttribute(TagFromName.StudyTime);
            ((Attribute)stringAttribute).addValue(this.studyTime);
            attributeList.put(stringAttribute);
            stringAttribute = new DecimalStringAttribute(TagFromName.DVHData);
            attributeList.put(stringAttribute);
            String string4 = "1.369547";
            for (int i = 0; i < 9000; ++i) {
                ((Attribute)stringAttribute).addValue(string4);
            }
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        return attributeList;
    }

    public void TestCStore_ConvertTransferSyntaxes_SendImplicitVROriginalToDefaultSCPPresentationContextSelectionPolicySuccessfully() throws Exception {
        System.err.println("TestCStore_ConvertTransferSyntaxes_SendImplicitVROriginalToDefaultSCPPresentationContextSelectionPolicySuccessfully():");
        File file = new File("./receivedfiles");
        int n = NetworkUtilities.getRandomUnusedPortToListenOnLocally();
        StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, scpAET, file, null, new OurReceivedObjectHandler(), new OurAssociationStatusHandler(), null, null, null, null, false);
        Thread thread = new Thread(storageSOPClassSCPDispatcher);
        thread.start();
        while (thread.getState() != Thread.State.RUNNABLE) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        File file2 = File.createTempFile("TestCStore_ConvertTransferSyntaxes_SendImplicitVROriginalToDefaultSCPPresentationContextSelectionPolicySuccessfully", ".dcm");
        file2.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2", "OURAETITLE");
        attributeList.write(file2, "1.2.840.10008.1.2", true, true);
        attributeList.removeMetaInformationHeaderAttributes();
        new StorageSOPClassSCU("localhost", n, scpAET, scuAET, file2.getCanonicalPath(), null, null, 0);
        while (this.lastReceivedDicomFileName == null) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!this.associationReleased) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        storageSOPClassSCPDispatcher.shutdown();
        while (storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        AttributeList attributeList2 = new AttributeList();
        attributeList2.read(this.lastReceivedDicomFileName);
        TestCStore_ConvertTransferSyntaxes.assertEquals((String)"Received TransferSyntax is Explicit VR Little Endian", (String)"1.2.840.10008.1.2.1", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.TransferSyntaxUID));
        attributeList2.removeMetaInformationHeaderAttributes();
        TestCStore_ConvertTransferSyntaxes.assertTrue((String)"AttributeLists received OK", (boolean)attributeList.equals(attributeList2));
    }

    private class OurAssociationStatusHandler
    extends AssociationStatusHandler {
        private OurAssociationStatusHandler() {
        }

        @Override
        public void sendAssociationReleaseIndication(Association association) throws DicomNetworkException, DicomException, IOException {
            if (association != null) {
                // empty if block
            }
            TestCStore_ConvertTransferSyntaxes.this.associationReleased = true;
        }
    }

    protected class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        protected OurReceivedObjectHandler() {
        }

        @Override
        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            TestCStore_ConvertTransferSyntaxes.this.lastReceivedDicomFileName = string;
        }
    }
}

