/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dose.CTPhantomType;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCTPhantomType
extends TestCase {
    public TestCTPhantomType(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCTPhantomType");
        testSuite.addTest((Test)new TestCTPhantomType("TestCTPhantomType_Head16_Description"));
        testSuite.addTest((Test)new TestCTPhantomType("TestCTPhantomType_Head16_Equality"));
        testSuite.addTest((Test)new TestCTPhantomType("TestCTPhantomType_Body32_Description"));
        testSuite.addTest((Test)new TestCTPhantomType("TestCTPhantomType_Body32_Equality"));
        testSuite.addTest((Test)new TestCTPhantomType("TestCTPhantomType_Head16_Body32_Inequality"));
        testSuite.addTest((Test)new TestCTPhantomType("TestCTPhantomType_SelectFromDescription"));
        testSuite.addTest((Test)new TestCTPhantomType("TestCTPhantomType_SelectFromCode"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestCTPhantomType_Head16_Description() {
        TestCTPhantomType.assertEquals((String)"Checking HEAD16 description", (String)CTPhantomType.HEAD16.toString(), (String)"HEAD16");
    }

    public void TestCTPhantomType_Body32_Description() {
        TestCTPhantomType.assertEquals((String)"Checking BODY32 description", (String)CTPhantomType.BODY32.toString(), (String)"BODY32");
    }

    public void TestCTPhantomType_Head16_Equality() throws Exception {
        TestCTPhantomType.assertEquals((String)"Checking HEAD16 equality", (Object)CTPhantomType.HEAD16, (Object)CTPhantomType.HEAD16);
        TestCTPhantomType.assertEquals((String)"Checking HEAD16 content item hashCode equality", (int)CTPhantomType.getCodedSequenceItem(CTPhantomType.HEAD16).hashCode(), (int)CTPhantomType.getCodedSequenceItem(CTPhantomType.HEAD16).hashCode());
        TestCTPhantomType.assertEquals((String)"Checking HEAD16 content item equality", (Object)CTPhantomType.getCodedSequenceItem(CTPhantomType.HEAD16), (Object)CTPhantomType.getCodedSequenceItem(CTPhantomType.HEAD16));
    }

    public void TestCTPhantomType_Body32_Equality() throws Exception {
        TestCTPhantomType.assertEquals((String)"Checking BODY32 equality", (Object)CTPhantomType.BODY32, (Object)CTPhantomType.BODY32);
        TestCTPhantomType.assertEquals((String)"Checking BODY32 content item hashCode equality", (int)CTPhantomType.getCodedSequenceItem(CTPhantomType.BODY32).hashCode(), (int)CTPhantomType.getCodedSequenceItem(CTPhantomType.BODY32).hashCode());
        TestCTPhantomType.assertEquals((String)"Checking BODY32 content item equality", (Object)CTPhantomType.getCodedSequenceItem(CTPhantomType.BODY32), (Object)CTPhantomType.getCodedSequenceItem(CTPhantomType.BODY32));
    }

    public void TestCTPhantomType_Head16_Body32_Inequality() throws Exception {
        TestCTPhantomType.assertTrue((String)"Checking HEAD16 versus BODY32 inequality", (!CTPhantomType.HEAD16.equals(CTPhantomType.BODY32) ? 1 : 0) != 0);
        TestCTPhantomType.assertFalse((String)"Checking HEAD16 versus BODY32 content item hashCode inequality", (CTPhantomType.getCodedSequenceItem(CTPhantomType.HEAD16).hashCode() == CTPhantomType.getCodedSequenceItem(CTPhantomType.BODY32).hashCode() ? 1 : 0) != 0);
        TestCTPhantomType.assertFalse((String)"Checking HEAD16 versus BODY32 content item inequality", (boolean)CTPhantomType.getCodedSequenceItem(CTPhantomType.HEAD16).equals(CTPhantomType.getCodedSequenceItem(CTPhantomType.BODY32)));
    }

    public void TestCTPhantomType_SelectFromDescription() throws Exception {
        TestCTPhantomType.assertTrue((String)"Checking select HEAD16", (boolean)CTPhantomType.selectFromDescription("HEAD16").equals(CTPhantomType.HEAD16));
        TestCTPhantomType.assertTrue((String)"Checking select BODY32", (boolean)CTPhantomType.selectFromDescription("BODY32").equals(CTPhantomType.BODY32));
        TestCTPhantomType.assertTrue((String)"Checking select HEAD", (boolean)CTPhantomType.selectFromDescription("HEAD").equals(CTPhantomType.HEAD16));
        TestCTPhantomType.assertTrue((String)"Checking select BODY", (boolean)CTPhantomType.selectFromDescription("BODY").equals(CTPhantomType.BODY32));
        TestCTPhantomType.assertTrue((String)"Checking select BLA finds nothing", (CTPhantomType.selectFromDescription("BLA") == null ? 1 : 0) != 0);
    }

    public void TestCTPhantomType_SelectFromCode() throws Exception {
        TestCTPhantomType.assertTrue((String)"Checking select HEAD16", (boolean)CTPhantomType.selectFromCode(new CodedSequenceItem("113690", "DCM", "IEC Head Dosimetry Phantom")).equals(CTPhantomType.HEAD16));
        TestCTPhantomType.assertTrue((String)"Checking select BODY32", (boolean)CTPhantomType.selectFromCode(new CodedSequenceItem("113691", "DCM", "IEC Body Dosimetry Phantom")).equals(CTPhantomType.BODY32));
        TestCTPhantomType.assertTrue((String)"Checking select BLA finds nothing", (CTPhantomType.selectFromCode(new CodedSequenceItem("43643432", "99BLA", "Strange Phantom")) == null ? 1 : 0) != 0);
    }
}

