/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.display.DicomCleaner;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.network.StorageSOPClassSCU;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.test.UserInterfaceUtilities;
import com.pixelmed.utils.JTreeWithAdditionalKeyStrokeActions;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCleanerReceiveAndClean
extends TestCase {
    private static final Logger slf4jlogger = LoggerFactory.getLogger(TestCleanerReceiveAndClean.class);
    protected static final String ourCallingAET = "TESTCALLINGAET";
    protected static final String localNameOfUnitTestSCP = "UNITTEST";
    protected static final String savedImagesFolderName = "./tmp/TestCleanerReceiveAndClean";
    protected static final String existingTestFileToBeCleaned = "testcleanerfile.dcm";
    protected static final int waitIntervalWhenSleeping = 10;
    ExpectedResult[] expectedResults = new ExpectedResult[]{new ExpectedResult(TagFromName.PatientName, false, true, "Test^OriginalName", "NAME^NONE"), new ExpectedResult(TagFromName.PatientID, false, true, "TESTORIGINALID", "NOID"), new ExpectedResult(TagFromName.AccessionNumber, false, true, "TESTORIGINALNUM", null), new ExpectedResult(TagFromName.StudyID, false, true, "TESTORIGINALID", null), new ExpectedResult(TagFromName.InstitutionName, false, false, "Original Institution", ""), new ExpectedResult(TagFromName.DeviceSerialNumber, false, false, "Original Serial Number", ""), new ExpectedResult(TagFromName.PatientWeight, false, false, "57.5", ""), new ExpectedResult(TagFromName.PatientSize, false, false, "175", ""), new ExpectedResult(TagFromName.PatientSex, false, false, "F", ""), new ExpectedResult(TagFromName.PatientAge, false, false, "041Y", ""), new ExpectedResult(TagFromName.PatientBirthDate, false, true, "19700214", null), new ExpectedResult(TagFromName.StudyDescription, false, false, "Original Study Description", ""), new ExpectedResult(TagFromName.SeriesDescription, false, false, "Original Series Description", ""), new ExpectedResult(TagFromName.ImageComments, false, false, "Original Image Comment", ""), new ExpectedResult(TagFromName.SOPInstanceUID, true, true, "1.3.6.1.4.1.5962.1.1.0.0.0.1298308902.23788.0", null), new ExpectedResult(TagFromName.SeriesInstanceUID, true, true, "1.3.6.1.4.1.5962.1.3.0.0.1298308902.23788.0", null), new ExpectedResult(TagFromName.StudyInstanceUID, true, true, "1.3.6.1.4.1.5962.1.2.0.1298308902.23788.0", null), new ExpectedResult(TagFromName.ClinicalTrialProtocolID, false, false, "TESTORIGINALID", ""), new ExpectedResult(new AttributeTag(41, 16), false, true, "SIEMENS MED DISPLAY", null), new ExpectedResult(new AttributeTag(41, 4249), false, true, "UnsafeOriginalPrivateValue", null), new ExpectedResult(new AttributeTag(481, 16), false, false, "ELSCINT1", null), new ExpectedResult(new AttributeTag(481, 4134), false, false, "SAFEPHANTOMTYPE", null)};
    protected static String removeIdentityLabelText = "Remove all unreplaced identities";
    protected static String removeDescriptionsLabelText = "Remove descriptions";
    protected static String removeSeriesDescriptionsLabelText = "Remove series description";
    protected static String removeCharacteristicsLabelText = "Remove patient characteristics";
    protected static String removeDeviceIdentityLabelText = "Remove device identifiers";
    protected static String removeInstitutionIdentityLabelText = "Remove institution identifiers";
    protected static String cleanUIDsLabelText = "Replace all UIDs";
    protected static String removePrivateLabelText = "Remove unsafe private attributes";
    protected static String addContributingEquipmentLabelText = "Add contributing equipment";
    protected static String removeClinicalTrialAttributesLabelText = "Remove clinical trial attributes";
    protected static String zipExportLabelText = "Zip exported files";
    protected static String hierarchicalExportLabelText = "Hierarchical names in export";
    protected static String acceptAnyTransferSyntaxLabelText = "Accept any Transfer Syntax";
    protected volatile DicomCleaner application;
    protected volatile String lastReceivedDicomFileName;

    public TestCleanerReceiveAndClean(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCleanerReceiveAndClean");
        testSuite.addTest((Test)new TestCleanerReceiveAndClean("TestCleanerReceiveAndClean_ReceiveAndCleanWithDefaults"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    protected void checkAllAreAsExpected(AttributeList attributeList) {
        for (ExpectedResult expectedResult : this.expectedResults) {
            expectedResult.checkIsAsExpected(attributeList);
        }
    }

    public void TestCleanerReceiveAndClean_ReceiveAndCleanWithDefaults() throws Exception {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    TestCleanerReceiveAndClean.this.application = new DicomCleaner();
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
            }
        };
        thread.start();
        while (this.application == null) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        UserInterfaceUtilities.registerWindowOpeningAndClosingListenerToTrackDialogs();
        Object object = this.application.getPropertyInsistently("Dicom.RemoteAEs.UNITTEST.HostNameOrIPAddress");
        int n = Integer.parseInt(this.application.getPropertyInsistently("Dicom.RemoteAEs.UNITTEST.Port"));
        String string = this.application.getPropertyInsistently("Dicom.RemoteAEs.UNITTEST.CalledAETitle");
        TestCleanerReceiveAndClean.assertTrue((String)"Have receiving UNITTEST hostname", (object != null && ((String)object).length() > 0 ? 1 : 0) != 0);
        TestCleanerReceiveAndClean.assertTrue((String)"Have receiving UNITTEST port", (n > 0 ? 1 : 0) != 0);
        TestCleanerReceiveAndClean.assertTrue((String)"Have receiving UNITTEST AET", (string != null && string.length() > 0 ? 1 : 0) != 0);
        Object object2 = new StorageSOPClassSCPDispatcher(n, string, new File(savedImagesFolderName), StoredFilePathStrategy.BYSOPINSTANCEUIDINSINGLEFOLDER, new OurReceivedObjectHandler());
        Thread thread2 = new Thread((Runnable)object2);
        thread2.start();
        while (thread2.getState() != Thread.State.RUNNABLE) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!((StorageSOPClassSCPDispatcher)object2).isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (Frame.getFrames().length == 0) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (UserInterfaceUtilities.findComponentsOfClassWithTextValue("javax.swing.JCheckBox", removeIdentityLabelText).length == 0) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        TestCleanerReceiveAndClean.assertTrue((String)(removeIdentityLabelText + " is not selected by default"), (boolean)((JCheckBox)UserInterfaceUtilities.findComponentsOfClassWithTextValue("javax.swing.JCheckBox", removeIdentityLabelText)[0]).isSelected());
        TestCleanerReceiveAndClean.assertTrue((String)(removeDescriptionsLabelText + " is not selected by default"), (!((JCheckBox)UserInterfaceUtilities.findComponentsOfClassWithTextValue("javax.swing.JCheckBox", removeDescriptionsLabelText)[0]).isSelected() ? 1 : 0) != 0);
        TestCleanerReceiveAndClean.assertTrue((String)(removeSeriesDescriptionsLabelText + " is not selected by default"), (!((JCheckBox)UserInterfaceUtilities.findComponentsOfClassWithTextValue("javax.swing.JCheckBox", removeSeriesDescriptionsLabelText)[0]).isSelected() ? 1 : 0) != 0);
        TestCleanerReceiveAndClean.assertTrue((String)(removeCharacteristicsLabelText + " is not selected by default"), (!((JCheckBox)UserInterfaceUtilities.findComponentsOfClassWithTextValue("javax.swing.JCheckBox", removeCharacteristicsLabelText)[0]).isSelected() ? 1 : 0) != 0);
        TestCleanerReceiveAndClean.assertTrue((String)(cleanUIDsLabelText + " is     selected by default"), (boolean)((JCheckBox)UserInterfaceUtilities.findComponentsOfClassWithTextValue("javax.swing.JCheckBox", cleanUIDsLabelText)[0]).isSelected());
        TestCleanerReceiveAndClean.assertTrue((String)(removePrivateLabelText + " is     selected by default"), (boolean)((JCheckBox)UserInterfaceUtilities.findComponentsOfClassWithTextValue("javax.swing.JCheckBox", removePrivateLabelText)[0]).isSelected());
        TestCleanerReceiveAndClean.assertTrue((String)(removeDeviceIdentityLabelText + " is not selected by default"), (!((JCheckBox)UserInterfaceUtilities.findComponentsOfClassWithTextValue("javax.swing.JCheckBox", removeDeviceIdentityLabelText)[0]).isSelected() ? 1 : 0) != 0);
        TestCleanerReceiveAndClean.assertTrue((String)(removeInstitutionIdentityLabelText + " is not selected by default"), (!((JCheckBox)UserInterfaceUtilities.findComponentsOfClassWithTextValue("javax.swing.JCheckBox", removeInstitutionIdentityLabelText)[0]).isSelected() ? 1 : 0) != 0);
        TestCleanerReceiveAndClean.assertTrue((String)(removeClinicalTrialAttributesLabelText + " is not selected by default"), (!((JCheckBox)UserInterfaceUtilities.findComponentsOfClassWithTextValue("javax.swing.JCheckBox", removeClinicalTrialAttributesLabelText)[0]).isSelected() ? 1 : 0) != 0);
        TestCleanerReceiveAndClean.assertTrue((String)(addContributingEquipmentLabelText + " is     selected by default"), (boolean)((JCheckBox)UserInterfaceUtilities.findComponentsOfClassWithTextValue("javax.swing.JCheckBox", addContributingEquipmentLabelText)[0]).isSelected());
        TestCleanerReceiveAndClean.assertTrue((String)(zipExportLabelText + " is not selected by default"), (!((JCheckBox)UserInterfaceUtilities.findComponentsOfClassWithTextValue("javax.swing.JCheckBox", zipExportLabelText)[0]).isSelected() ? 1 : 0) != 0);
        TestCleanerReceiveAndClean.assertTrue((String)(hierarchicalExportLabelText + " is not selected by default"), (!((JCheckBox)UserInterfaceUtilities.findComponentsOfClassWithTextValue("javax.swing.JCheckBox", hierarchicalExportLabelText)[0]).isSelected() ? 1 : 0) != 0);
        TestCleanerReceiveAndClean.assertTrue((String)(acceptAnyTransferSyntaxLabelText + " is not selected by default"), (!((JCheckBox)UserInterfaceUtilities.findComponentsOfClassWithTextValue("javax.swing.JCheckBox", acceptAnyTransferSyntaxLabelText)[0]).isSelected() ? 1 : 0) != 0);
        object = new SetOfDicomFiles();
        ((SetOfDicomFiles)object).add(existingTestFileToBeCleaned);
        Object object3 = "localhost";
        int n2 = Integer.parseInt(this.application.getPropertyInsistently("Dicom.ListeningPort"));
        object2 = this.application.getPropertyInsistently("Dicom.CalledAETitle");
        new StorageSOPClassSCU((String)object3, n2, (String)object2, ourCallingAET, (SetOfDicomFiles)object, 0, null, null, 0);
        object = null;
        while (object == null || ((JTree)object).getRowCount() < 2) {
            Thread.currentThread();
            Thread.sleep(10L);
            object3 = UserInterfaceUtilities.findComponentsOfClass("com.pixelmed.utils.JTreeWithAdditionalKeyStrokeActions");
            if (((Component[])object3).length <= 0) continue;
            object = (JTreeWithAdditionalKeyStrokeActions)object3[0];
        }
        ((JTree)object).setSelectionRow(1);
        ((JButton)UserInterfaceUtilities.findComponentsOfClassWithTextValue("javax.swing.JButton", "Clean")[0]).doClick();
        object3 = null;
        while (object3 == null || object3.getRowCount() < 2) {
            Thread.currentThread();
            Thread.sleep(10L);
            Component[] componentArray = UserInterfaceUtilities.findComponentsOfClass("com.pixelmed.utils.JTreeWithAdditionalKeyStrokeActions");
            if (componentArray.length <= 1) continue;
            object3 = (JTreeWithAdditionalKeyStrokeActions)componentArray[1];
        }
        object3.setSelectionRow(1);
        Object object4 = new Thread(){

            @Override
            public void run() {
                try {
                    ((JButton)UserInterfaceUtilities.findComponentsOfClassWithTextValue("javax.swing.JButton", "Send")[0]).doClick();
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
            }
        };
        ((Thread)object4).start();
        while (((Thread)object4).getState() != Thread.State.RUNNABLE) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        object4 = null;
        while ((object4 = UserInterfaceUtilities.getOpenDialogByTitle("Send ...")) == null) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        ((JButton)UserInterfaceUtilities.findComponentsOfClassWithTextValue((Component)object4, "javax.swing.JButton", "OK")[0]).doClick();
        while (this.lastReceivedDicomFileName == null) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        object4 = new AttributeList();
        ((AttributeList)object4).read(this.lastReceivedDicomFileName);
        this.checkAllAreAsExpected((AttributeList)object4);
    }

    protected class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        protected OurReceivedObjectHandler() {
        }

        @Override
        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            TestCleanerReceiveAndClean.this.lastReceivedDicomFileName = string;
        }
    }

    protected class ExpectedResult {
        AttributeTag tag;
        boolean handleAsUID;
        boolean cleaned;
        String originalValue;
        String cleanedValueIfCleaned;

        public ExpectedResult(AttributeTag attributeTag, boolean bl, boolean bl2, String string, String string2) {
            this.tag = attributeTag;
            this.handleAsUID = bl;
            this.cleaned = bl2;
            this.originalValue = string;
            this.cleanedValueIfCleaned = string2;
        }

        public void checkIsAsExpected(AttributeList attributeList) {
            if (this.handleAsUID) {
                if (this.cleaned) {
                    Assert.assertTrue((String)("Cleaned " + DicomDictionary.StandardDictionary.getFullNameFromTag(this.tag)), (!this.originalValue.equals(Attribute.getSingleStringValueOrNull(attributeList, this.tag)) ? 1 : 0) != 0);
                } else {
                    Assert.assertEquals((String)("Not Cleaned " + DicomDictionary.StandardDictionary.getFullNameFromTag(this.tag)), (String)this.originalValue, (String)Attribute.getSingleStringValueOrNull(attributeList, this.tag));
                }
            } else {
                Assert.assertEquals((String)((this.cleaned ? "" : "Not ") + "Cleaned " + DicomDictionary.StandardDictionary.getFullNameFromTag(this.tag)), (String)(this.cleaned ? this.cleanedValueIfCleaned : this.originalValue), (String)Attribute.getSingleStringValueOrNull(attributeList, this.tag));
            }
        }
    }
}

