/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.CompositeInstanceContext;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCompositeInstanceContext
extends TestCase {
    public TestCompositeInstanceContext(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCompositeInstanceContext");
        testSuite.addTest((Test)new TestCompositeInstanceContext("TestCompositeInstanceContext_Constructor"));
        testSuite.addTest((Test)new TestCompositeInstanceContext("TestCompositeInstanceContext_RemoveAllButPatient"));
        testSuite.addTest((Test)new TestCompositeInstanceContext("TestCompositeInstanceContext_RemoveAllButPatientAndStudy"));
        testSuite.addTest((Test)new TestCompositeInstanceContext("TestCompositeInstanceContext_RemoveAllButPatientAndStudyUsingSelectorSelected"));
        testSuite.addTest((Test)new TestCompositeInstanceContext("TestCompositeInstanceContext_RemoveAllButPatientAndStudyUsingSelectorUnselected"));
        testSuite.addTest((Test)new TestCompositeInstanceContext("TestCompositeInstanceContext_Equality"));
        testSuite.addTest((Test)new TestCompositeInstanceContext("TestCompositeInstanceContext_SRSpecificRequestAndProcedure"));
        testSuite.addTest((Test)new TestCompositeInstanceContext("TestCompositeInstanceContext_SRSpecificRequestAndProcedure_Default"));
        testSuite.addTest((Test)new TestCompositeInstanceContext("TestCompositeInstanceContext_WithoutSRSpecificRequestAndProcedure"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestCompositeInstanceContext_Constructor() throws Exception {
        String string = "Smith^Mary";
        String string2 = "3764913624";
        String string3 = "19600101";
        String string4 = "F";
        String string5 = "612386812";
        String string6 = "12";
        String string7 = "38";
        String string8 = "Jones^Harriet";
        String string9 = "20100324";
        String string10 = "142211";
        String string11 = "20100325";
        String string12 = "142238";
        String string13 = "4652945";
        String string14 = "TP4";
        String string15 = "42";
        UIDGenerator uIDGenerator = new UIDGenerator("9999");
        String string16 = uIDGenerator.getNewSOPInstanceUID(string5, string6, string7);
        String string17 = uIDGenerator.getNewSeriesInstanceUID(string5, string6);
        String string18 = uIDGenerator.getNewStudyInstanceUID(string5);
        String string19 = "1.2.840.10008.5.1.4.1.1.1";
        AttributeList attributeList = new AttributeList();
        Object object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue(string19);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(string16);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(string17);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue(string18);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.PatientID);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.PatientBirthDate);
        ((Attribute)object).addValue(string3);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        ((Attribute)object).addValue(string4);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(string5);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
        ((Attribute)object).addValue(string8);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.AccessionNumber);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(string6);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object).addValue(string7);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientOrientation);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Laterality);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object).addValue(string9);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)object).addValue(string10);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)object).addValue(string11);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.ContentTime);
        ((Attribute)object).addValue(string12);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.ClinicalTrialSubjectID);
        ((Attribute)object).addValue(string13);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.ClinicalTrialTimePointID);
        ((Attribute)object).addValue(string14);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.ClinicalTrialSeriesID);
        ((Attribute)object).addValue(string15);
        attributeList.put((Attribute)object);
        object = new CompositeInstanceContext(attributeList, true);
        AttributeList attributeList2 = ((CompositeInstanceContext)object).getAttributeList();
        TestCompositeInstanceContext.assertEquals((String)"Checking SOPClassUID", (String)string19, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SOPClassUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking SOPInstanceUID", (String)string16, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SOPInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesInstanceUID", (String)string17, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SeriesInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyInstanceUID", (String)string18, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientName", (String)string, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientName));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientID", (String)string2, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientID));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientBirthDate", (String)string3, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientBirthDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientSex", (String)string4, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientSex));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyID", (String)string5, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyID));
        TestCompositeInstanceContext.assertEquals((String)"Checking ReferringPhysicianName", (String)string8, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ReferringPhysicianName));
        TestCompositeInstanceContext.assertEquals((String)"Checking AccessionNumber", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.AccessionNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesNumber", (String)string6, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SeriesNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking InstanceNumber", (String)string7, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.InstanceNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking Manufacturer", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.Manufacturer));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientOrientation", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientOrientation));
        TestCompositeInstanceContext.assertEquals((String)"Checking Laterality", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.Laterality));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyDate", (String)string9, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyTime", (String)string10, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyTime));
        TestCompositeInstanceContext.assertEquals((String)"Checking ContentDate", (String)string11, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ContentDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking ContentTime", (String)string12, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ContentTime));
        TestCompositeInstanceContext.assertEquals((String)"Checking ClinicalTrialSubjectID", (String)string13, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ClinicalTrialSubjectID));
        TestCompositeInstanceContext.assertEquals((String)"Checking ClinicalTrialTimePointID", (String)string14, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ClinicalTrialTimePointID));
        TestCompositeInstanceContext.assertEquals((String)"Checking ClinicalTrialSeriesID", (String)string15, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ClinicalTrialSeriesID));
        ((CompositeInstanceContext)object).removeSeries();
        attributeList2 = ((CompositeInstanceContext)object).getAttributeList();
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesInstanceUID", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SeriesInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesNumber", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SeriesNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking Laterality", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.Laterality));
        Object object2 = new AttributeList();
        IntegerStringAttribute integerStringAttribute = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)integerStringAttribute).addValue(string6);
        ((AttributeList)object2).put(integerStringAttribute);
        ((CompositeInstanceContext)object).putAll((AttributeList)object2);
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesNumber", (String)string6, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SeriesNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking ClinicalTrialSeriesID", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ClinicalTrialSeriesID));
        ((CompositeInstanceContext)object).removeInstance();
        TestCompositeInstanceContext.assertEquals((String)"Checking ContentDate", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ContentDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking ContentTime", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ContentTime));
        TestCompositeInstanceContext.assertEquals((String)"Checking SOPInstanceUID", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SOPInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking InstanceNumber", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.InstanceNumber));
        object2 = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object2).addValue(string7);
        ((CompositeInstanceContext)object).put((Attribute)object2);
        TestCompositeInstanceContext.assertEquals((String)"Checking InstanceNumber", (String)string7, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.InstanceNumber));
        ((CompositeInstanceContext)object).removeStudy();
        attributeList2 = ((CompositeInstanceContext)object).getAttributeList();
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyID", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyID));
        TestCompositeInstanceContext.assertEquals((String)"Checking ClinicalTrialTimePointID", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ClinicalTrialTimePointID));
        ((CompositeInstanceContext)object).removePatient();
        attributeList2 = ((CompositeInstanceContext)object).getAttributeList();
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientID", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientID));
        TestCompositeInstanceContext.assertEquals((String)"Checking ClinicalTrialSubjectID", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ClinicalTrialSubjectID));
    }

    public void TestCompositeInstanceContext_RemoveAllButPatient() throws Exception {
        String string = "Smith^Mary";
        String string2 = "3764913624";
        String string3 = "19600101";
        String string4 = "F";
        String string5 = "612386812";
        String string6 = "12";
        String string7 = "38";
        String string8 = "Jones^Harriet";
        String string9 = "20100324";
        String string10 = "142211";
        String string11 = "20100325";
        String string12 = "142238";
        String string13 = "4652945";
        String string14 = "TP4";
        String string15 = "42";
        String string16 = "1.2.840.10008.5.1.4.1.1.1";
        UIDGenerator uIDGenerator = new UIDGenerator("9999");
        String string17 = uIDGenerator.getNewSOPInstanceUID(string5, string6, string7);
        String string18 = uIDGenerator.getNewSeriesInstanceUID(string5, string6);
        String string19 = uIDGenerator.getNewStudyInstanceUID(string5);
        AttributeList attributeList = new AttributeList();
        Object object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue(string16);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(string17);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(string18);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue(string19);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.PatientID);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.PatientBirthDate);
        ((Attribute)object).addValue(string3);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        ((Attribute)object).addValue(string4);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(string5);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
        ((Attribute)object).addValue(string8);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.AccessionNumber);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(string6);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object).addValue(string7);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientOrientation);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Laterality);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object).addValue(string9);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)object).addValue(string10);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)object).addValue(string11);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.ContentTime);
        ((Attribute)object).addValue(string12);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.ClinicalTrialSubjectID);
        ((Attribute)object).addValue(string13);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.ClinicalTrialTimePointID);
        ((Attribute)object).addValue(string14);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.ClinicalTrialSeriesID);
        ((Attribute)object).addValue(string15);
        attributeList.put((Attribute)object);
        object = new CompositeInstanceContext(attributeList, true);
        ((CompositeInstanceContext)object).removeAllButPatient();
        AttributeList attributeList2 = ((CompositeInstanceContext)object).getAttributeList();
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientName", (String)string, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientName));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientID", (String)string2, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientID));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientBirthDate", (String)string3, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientBirthDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientSex", (String)string4, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientSex));
        TestCompositeInstanceContext.assertEquals((String)"Checking ClinicalTrialSubjectID", (String)string13, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ClinicalTrialSubjectID));
        TestCompositeInstanceContext.assertTrue((String)"Checking SOPClassUID", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.SOPClassUID) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking SOPInstanceUID", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.SOPInstanceUID) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking SeriesInstanceUID", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.SeriesInstanceUID) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking StudyInstanceUID", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.StudyInstanceUID) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking StudyID", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.StudyID) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking ReferringPhysicianName", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.ReferringPhysicianName) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking AccessionNumber", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.AccessionNumber) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking SeriesNumber", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.SeriesNumber) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking InstanceNumber", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.InstanceNumber) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking Manufacturer", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.Manufacturer) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking PatientOrientation", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.PatientOrientation) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking Laterality", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.Laterality) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking StudyDate", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.StudyDate) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking StudyTime", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.StudyTime) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking ContentDate", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.ContentDate) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking ContentTime", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.ContentTime) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking ClinicalTrialTimePointID", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.ClinicalTrialTimePointID) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking ClinicalTrialSeriesID", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.ClinicalTrialSeriesID) == null ? 1 : 0) != 0);
    }

    public void TestCompositeInstanceContext_RemoveAllButPatientAndStudy() throws Exception {
        String string = "Smith^Mary";
        String string2 = "3764913624";
        String string3 = "19600101";
        String string4 = "F";
        String string5 = "612386812";
        String string6 = "12";
        String string7 = "38";
        String string8 = "Jones^Harriet";
        String string9 = "20100324";
        String string10 = "142211";
        String string11 = "20100325";
        String string12 = "142238";
        String string13 = "1.2.840.10008.5.1.4.1.1.1";
        UIDGenerator uIDGenerator = new UIDGenerator("9999");
        String string14 = uIDGenerator.getNewSOPInstanceUID(string5, string6, string7);
        String string15 = uIDGenerator.getNewSeriesInstanceUID(string5, string6);
        String string16 = uIDGenerator.getNewStudyInstanceUID(string5);
        AttributeList attributeList = new AttributeList();
        Object object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue(string13);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(string14);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(string15);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue(string16);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.PatientID);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.PatientBirthDate);
        ((Attribute)object).addValue(string3);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        ((Attribute)object).addValue(string4);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(string5);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
        ((Attribute)object).addValue(string8);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.AccessionNumber);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(string6);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object).addValue(string7);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientOrientation);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Laterality);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object).addValue(string9);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)object).addValue(string10);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)object).addValue(string11);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.ContentTime);
        ((Attribute)object).addValue(string12);
        attributeList.put((Attribute)object);
        object = new CompositeInstanceContext(attributeList, true);
        ((CompositeInstanceContext)object).removeAllButPatientAndStudy();
        AttributeList attributeList2 = ((CompositeInstanceContext)object).getAttributeList();
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientName", (String)string, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientName));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientID", (String)string2, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientID));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientBirthDate", (String)string3, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientBirthDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientSex", (String)string4, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientSex));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyInstanceUID", (String)string16, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyID", (String)string5, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyID));
        TestCompositeInstanceContext.assertEquals((String)"Checking ReferringPhysicianName", (String)string8, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ReferringPhysicianName));
        TestCompositeInstanceContext.assertEquals((String)"Checking AccessionNumber", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.AccessionNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyDate", (String)string9, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyTime", (String)string10, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyTime));
        TestCompositeInstanceContext.assertTrue((String)"Checking SOPClassUID", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.SOPClassUID) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking SOPInstanceUID", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.SOPInstanceUID) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking SeriesInstanceUID", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.SeriesInstanceUID) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking SeriesNumber", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.SeriesNumber) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking InstanceNumber", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.InstanceNumber) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking Manufacturer", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.Manufacturer) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking PatientOrientation", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.PatientOrientation) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking Laterality", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.Laterality) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking ContentDate", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.ContentDate) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking ContentTime", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.ContentTime) == null ? 1 : 0) != 0);
    }

    public void TestCompositeInstanceContext_RemoveAllButPatientAndStudyUsingSelectorSelected() throws Exception {
        String string = "Smith^Mary";
        String string2 = "3764913624";
        String string3 = "19600101";
        String string4 = "F";
        String string5 = "612386812";
        String string6 = "12";
        String string7 = "38";
        String string8 = "Jones^Harriet";
        String string9 = "20100324";
        String string10 = "142211";
        String string11 = "20100325";
        String string12 = "142238";
        String string13 = "1.2.840.10008.5.1.4.1.1.1";
        UIDGenerator uIDGenerator = new UIDGenerator("9999");
        String string14 = uIDGenerator.getNewSOPInstanceUID(string5, string6, string7);
        String string15 = uIDGenerator.getNewSeriesInstanceUID(string5, string6);
        String string16 = uIDGenerator.getNewStudyInstanceUID(string5);
        AttributeList attributeList = new AttributeList();
        Object object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue(string13);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(string14);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(string15);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue(string16);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.PatientID);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.PatientBirthDate);
        ((Attribute)object).addValue(string3);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        ((Attribute)object).addValue(string4);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(string5);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
        ((Attribute)object).addValue(string8);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.AccessionNumber);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(string6);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object).addValue(string7);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientOrientation);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Laterality);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object).addValue(string9);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)object).addValue(string10);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)object).addValue(string11);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.ContentTime);
        ((Attribute)object).addValue(string12);
        attributeList.put((Attribute)object);
        object = new CompositeInstanceContext(attributeList, true);
        CompositeInstanceContext.Selector selector = new CompositeInstanceContext.Selector(true);
        selector.patient = false;
        selector.study = false;
        ((CompositeInstanceContext)object).removeAllSelected(selector);
        AttributeList attributeList2 = ((CompositeInstanceContext)object).getAttributeList();
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientName", (String)string, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientName));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientID", (String)string2, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientID));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientBirthDate", (String)string3, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientBirthDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientSex", (String)string4, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientSex));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyInstanceUID", (String)string16, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyID", (String)string5, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyID));
        TestCompositeInstanceContext.assertEquals((String)"Checking ReferringPhysicianName", (String)string8, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ReferringPhysicianName));
        TestCompositeInstanceContext.assertEquals((String)"Checking AccessionNumber", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.AccessionNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyDate", (String)string9, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyTime", (String)string10, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyTime));
        TestCompositeInstanceContext.assertTrue((String)"Checking SOPClassUID", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.SOPClassUID) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking SOPInstanceUID", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.SOPInstanceUID) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking SeriesInstanceUID", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.SeriesInstanceUID) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking SeriesNumber", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.SeriesNumber) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking InstanceNumber", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.InstanceNumber) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking Manufacturer", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.Manufacturer) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking PatientOrientation", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.PatientOrientation) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking Laterality", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.Laterality) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking ContentDate", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.ContentDate) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking ContentTime", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.ContentTime) == null ? 1 : 0) != 0);
    }

    public void TestCompositeInstanceContext_RemoveAllButPatientAndStudyUsingSelectorUnselected() throws Exception {
        String string = "Smith^Mary";
        String string2 = "3764913624";
        String string3 = "19600101";
        String string4 = "F";
        String string5 = "612386812";
        String string6 = "12";
        String string7 = "38";
        String string8 = "Jones^Harriet";
        String string9 = "20100324";
        String string10 = "142211";
        String string11 = "20100325";
        String string12 = "142238";
        String string13 = "1.2.840.10008.5.1.4.1.1.1";
        UIDGenerator uIDGenerator = new UIDGenerator("9999");
        String string14 = uIDGenerator.getNewSOPInstanceUID(string5, string6, string7);
        String string15 = uIDGenerator.getNewSeriesInstanceUID(string5, string6);
        String string16 = uIDGenerator.getNewStudyInstanceUID(string5);
        AttributeList attributeList = new AttributeList();
        Object object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue(string13);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(string14);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(string15);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue(string16);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.PatientID);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.PatientBirthDate);
        ((Attribute)object).addValue(string3);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        ((Attribute)object).addValue(string4);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(string5);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
        ((Attribute)object).addValue(string8);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.AccessionNumber);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(string6);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object).addValue(string7);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientOrientation);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Laterality);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object).addValue(string9);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)object).addValue(string10);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)object).addValue(string11);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.ContentTime);
        ((Attribute)object).addValue(string12);
        attributeList.put((Attribute)object);
        object = new CompositeInstanceContext(attributeList, true);
        CompositeInstanceContext.Selector selector = new CompositeInstanceContext.Selector(false);
        selector.patient = true;
        selector.study = true;
        ((CompositeInstanceContext)object).removeAllButSelected(selector);
        AttributeList attributeList2 = ((CompositeInstanceContext)object).getAttributeList();
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientName", (String)string, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientName));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientID", (String)string2, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientID));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientBirthDate", (String)string3, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientBirthDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientSex", (String)string4, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.PatientSex));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyInstanceUID", (String)string16, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyID", (String)string5, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyID));
        TestCompositeInstanceContext.assertEquals((String)"Checking ReferringPhysicianName", (String)string8, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ReferringPhysicianName));
        TestCompositeInstanceContext.assertEquals((String)"Checking AccessionNumber", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.AccessionNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyDate", (String)string9, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyTime", (String)string10, (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyTime));
        TestCompositeInstanceContext.assertTrue((String)"Checking SOPClassUID", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.SOPClassUID) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking SOPInstanceUID", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.SOPInstanceUID) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking SeriesInstanceUID", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.SeriesInstanceUID) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking SeriesNumber", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.SeriesNumber) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking InstanceNumber", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.InstanceNumber) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking Manufacturer", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.Manufacturer) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking PatientOrientation", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.PatientOrientation) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking Laterality", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.Laterality) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking ContentDate", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.ContentDate) == null ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking ContentTime", (Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.ContentTime) == null ? 1 : 0) != 0);
    }

    public void TestCompositeInstanceContext_Equality() throws Exception {
        String string = "Smith^Mary";
        String string2 = "3764913624";
        String string3 = "19600101";
        String string4 = "F";
        String string5 = "612386812";
        String string6 = "12";
        String string7 = "38";
        String string8 = "Jones^Harriet";
        String string9 = "20100324";
        String string10 = "142211";
        String string11 = "20100325";
        String string12 = "142238";
        String string13 = "1.2.840.10008.5.1.4.1.1.1";
        UIDGenerator uIDGenerator = new UIDGenerator("9999");
        String string14 = uIDGenerator.getNewSOPInstanceUID(string5, string6, string7);
        String string15 = uIDGenerator.getNewSeriesInstanceUID(string5, string6);
        String string16 = uIDGenerator.getNewStudyInstanceUID(string5);
        AttributeList attributeList = new AttributeList();
        Object object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue(string13);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(string14);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(string15);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue(string16);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.PatientID);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.PatientBirthDate);
        ((Attribute)object).addValue(string3);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        ((Attribute)object).addValue(string4);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(string5);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
        ((Attribute)object).addValue(string8);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.AccessionNumber);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(string6);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object).addValue(string7);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientOrientation);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Laterality);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object).addValue(string9);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)object).addValue(string10);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)object).addValue(string11);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.ContentTime);
        ((Attribute)object).addValue(string12);
        attributeList.put((Attribute)object);
        TestCompositeInstanceContext.assertEquals((String)"Checking AttributeList equality with self", (Object)attributeList, (Object)attributeList);
        object = new CompositeInstanceContext(attributeList, true);
        CompositeInstanceContext compositeInstanceContext = new CompositeInstanceContext(attributeList, true);
        TestCompositeInstanceContext.assertEquals((String)"Checking CompositeInstanceContext.getAttributeList() equality", (Object)((CompositeInstanceContext)object).getAttributeList(), (Object)compositeInstanceContext.getAttributeList());
        TestCompositeInstanceContext.assertEquals((String)"Checking CompositeInstanceContext equality", (Object)object, (Object)compositeInstanceContext);
        TestCompositeInstanceContext.assertEquals((String)"Checking CompositeInstanceContext hashCode", (int)((CompositeInstanceContext)object).hashCode(), (int)compositeInstanceContext.hashCode());
        compositeInstanceContext.removeInstance();
        TestCompositeInstanceContext.assertTrue((String)"Checking CompositeInstanceContext different inequality", (!((CompositeInstanceContext)object).equals(compositeInstanceContext) ? 1 : 0) != 0);
        TestCompositeInstanceContext.assertTrue((String)"Checking CompositeInstanceContext differenthashCode", (((CompositeInstanceContext)object).hashCode() != compositeInstanceContext.hashCode() ? 1 : 0) != 0);
    }

    public void TestCompositeInstanceContext_SRSpecificRequestAndProcedure() throws Exception {
        String string = "Smith^Mary";
        String string2 = "3764913624";
        String string3 = "19600101";
        String string4 = "F";
        String string5 = "612386812";
        String string6 = "12";
        String string7 = "38";
        String string8 = "Jones^Harriet";
        String string9 = "20100324";
        String string10 = "142211";
        String string11 = "20100325";
        String string12 = "142238";
        UIDGenerator uIDGenerator = new UIDGenerator("9999");
        String string13 = uIDGenerator.getNewSOPInstanceUID(string5, string6, string7);
        String string14 = uIDGenerator.getNewSeriesInstanceUID(string5, string6);
        String string15 = uIDGenerator.getNewStudyInstanceUID(string5);
        String string16 = "1.2.840.10008.5.1.4.1.1.1";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("CTCAP", "99BLA", "CT C/A/P");
        AttributeList attributeList = new AttributeList();
        Object object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue(string16);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(string13);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(string14);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue(string15);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.PatientID);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.PatientBirthDate);
        ((Attribute)object).addValue(string3);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        ((Attribute)object).addValue(string4);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(string5);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
        ((Attribute)object).addValue(string8);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.AccessionNumber);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(string6);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object).addValue(string7);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientOrientation);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Laterality);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object).addValue(string9);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)object).addValue(string10);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)object).addValue(string11);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.ContentTime);
        ((Attribute)object).addValue(string12);
        attributeList.put((Attribute)object);
        object = new SequenceAttribute(TagFromName.ProcedureCodeSequence);
        ((SequenceAttribute)object).addItem(codedSequenceItem.getAttributeList());
        attributeList.put((Attribute)object);
        object = new AttributeList();
        Object object2 = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object2).addValue(string15);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.AccessionNumber);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new SequenceAttribute(TagFromName.RequestedProcedureCodeSequence);
        ((SequenceAttribute)object2).addItem(codedSequenceItem.getAttributeList());
        ((AttributeList)object).put((Attribute)object2);
        object2 = new SequenceAttribute(TagFromName.RequestAttributesSequence);
        ((SequenceAttribute)object2).addItem((AttributeList)object);
        attributeList.put((Attribute)object2);
        object = new CompositeInstanceContext(attributeList, true);
        object2 = ((CompositeInstanceContext)object).getAttributeList();
        TestCompositeInstanceContext.assertEquals((String)"Checking SOPClassUID", (String)string16, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SOPClassUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking SOPInstanceUID", (String)string13, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SOPInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesInstanceUID", (String)string14, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SeriesInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyInstanceUID", (String)string15, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.StudyInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientName", (String)string, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.PatientName));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientID", (String)string2, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.PatientID));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientBirthDate", (String)string3, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.PatientBirthDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientSex", (String)string4, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.PatientSex));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyID", (String)string5, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.StudyID));
        TestCompositeInstanceContext.assertEquals((String)"Checking ReferringPhysicianName", (String)string8, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.ReferringPhysicianName));
        TestCompositeInstanceContext.assertEquals((String)"Checking AccessionNumber", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.AccessionNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesNumber", (String)string6, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SeriesNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking InstanceNumber", (String)string7, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.InstanceNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking Manufacturer", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.Manufacturer));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientOrientation", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.PatientOrientation));
        TestCompositeInstanceContext.assertEquals((String)"Checking Laterality", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.Laterality));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyDate", (String)string9, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.StudyDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyTime", (String)string10, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.StudyTime));
        TestCompositeInstanceContext.assertEquals((String)"Checking ContentDate", (String)string11, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.ContentDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking ContentTime", (String)string12, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.ContentTime));
        TestCompositeInstanceContext.assertEquals((String)"Checking ProcedureCodeSequence", (Object)codedSequenceItem, (Object)CodedSequenceItem.getSingleCodedSequenceItemOrNull((AttributeList)object2, TagFromName.ProcedureCodeSequence));
        TestCompositeInstanceContext.assertEquals((String)"Checking PerformedProcedureCodeSequence", (Object)codedSequenceItem, (Object)CodedSequenceItem.getSingleCodedSequenceItemOrNull((AttributeList)object2, TagFromName.PerformedProcedureCodeSequence));
        TestCompositeInstanceContext.assertEquals((String)"Checking RequestAttributesSequence StudyInstanceUID", (String)string15, (String)SequenceAttribute.getArrayOfSingleStringValueOrEmptyStringOfNamedAttributeWithinSequenceItems((AttributeList)object2, TagFromName.RequestAttributesSequence, TagFromName.StudyInstanceUID)[0]);
        TestCompositeInstanceContext.assertEquals((String)"Checking RequestAttributesSequence AccessionNumber", (String)"", (String)SequenceAttribute.getArrayOfSingleStringValueOrEmptyStringOfNamedAttributeWithinSequenceItems((AttributeList)object2, TagFromName.RequestAttributesSequence, TagFromName.AccessionNumber)[0]);
        TestCompositeInstanceContext.assertEquals((String)"Checking RequestAttributes RequestedProcedureCodeSequence", (Object)codedSequenceItem, (Object)CodedSequenceItem.getSingleCodedSequenceItemOrNull((SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem((AttributeList)object2, TagFromName.RequestAttributesSequence, TagFromName.RequestedProcedureCodeSequence)));
        TestCompositeInstanceContext.assertEquals((String)"Checking ReferencedRequestSequence StudyInstanceUID", (String)string15, (String)SequenceAttribute.getArrayOfSingleStringValueOrEmptyStringOfNamedAttributeWithinSequenceItems((AttributeList)object2, TagFromName.ReferencedRequestSequence, TagFromName.StudyInstanceUID)[0]);
        TestCompositeInstanceContext.assertEquals((String)"Checking ReferencedRequestSequence AccessionNumber", (String)"", (String)SequenceAttribute.getArrayOfSingleStringValueOrEmptyStringOfNamedAttributeWithinSequenceItems((AttributeList)object2, TagFromName.ReferencedRequestSequence, TagFromName.AccessionNumber)[0]);
        TestCompositeInstanceContext.assertEquals((String)"Checking ReferencedRequestSequence RequestedProcedureCodeSequence", (Object)codedSequenceItem, (Object)CodedSequenceItem.getSingleCodedSequenceItemOrNull((SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem((AttributeList)object2, TagFromName.ReferencedRequestSequence, TagFromName.RequestedProcedureCodeSequence)));
        ((CompositeInstanceContext)object).removeSeries();
        object2 = ((CompositeInstanceContext)object).getAttributeList();
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesInstanceUID", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SeriesInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesNumber", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SeriesNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking Laterality", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.Laterality));
        Object object3 = new AttributeList();
        IntegerStringAttribute integerStringAttribute = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)integerStringAttribute).addValue(string6);
        ((AttributeList)object3).put(integerStringAttribute);
        ((CompositeInstanceContext)object).putAll((AttributeList)object3);
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesNumber", (String)string6, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SeriesNumber));
        ((CompositeInstanceContext)object).removeInstance();
        TestCompositeInstanceContext.assertEquals((String)"Checking ContentDate", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.ContentDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking ContentTime", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.ContentTime));
        TestCompositeInstanceContext.assertEquals((String)"Checking SOPInstanceUID", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SOPInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking InstanceNumber", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.InstanceNumber));
        object3 = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object3).addValue(string7);
        ((CompositeInstanceContext)object).put((Attribute)object3);
        TestCompositeInstanceContext.assertEquals((String)"Checking InstanceNumber", (String)string7, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.InstanceNumber));
    }

    public void TestCompositeInstanceContext_SRSpecificRequestAndProcedure_Default() throws Exception {
        String string = "Smith^Mary";
        String string2 = "3764913624";
        String string3 = "19600101";
        String string4 = "F";
        String string5 = "612386812";
        String string6 = "12";
        String string7 = "38";
        String string8 = "Jones^Harriet";
        String string9 = "20100324";
        String string10 = "142211";
        String string11 = "20100325";
        String string12 = "142238";
        UIDGenerator uIDGenerator = new UIDGenerator("9999");
        String string13 = uIDGenerator.getNewSOPInstanceUID(string5, string6, string7);
        String string14 = uIDGenerator.getNewSeriesInstanceUID(string5, string6);
        String string15 = uIDGenerator.getNewStudyInstanceUID(string5);
        String string16 = "1.2.840.10008.5.1.4.1.1.1";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("CTCAP", "99BLA", "CT C/A/P");
        AttributeList attributeList = new AttributeList();
        Object object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue(string16);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(string13);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(string14);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue(string15);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.PatientID);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.PatientBirthDate);
        ((Attribute)object).addValue(string3);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        ((Attribute)object).addValue(string4);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(string5);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
        ((Attribute)object).addValue(string8);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.AccessionNumber);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(string6);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object).addValue(string7);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientOrientation);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Laterality);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object).addValue(string9);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)object).addValue(string10);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)object).addValue(string11);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.ContentTime);
        ((Attribute)object).addValue(string12);
        attributeList.put((Attribute)object);
        object = new SequenceAttribute(TagFromName.ProcedureCodeSequence);
        ((SequenceAttribute)object).addItem(codedSequenceItem.getAttributeList());
        attributeList.put((Attribute)object);
        object = new AttributeList();
        Object object2 = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object2).addValue(string15);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.AccessionNumber);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new SequenceAttribute(TagFromName.RequestedProcedureCodeSequence);
        ((SequenceAttribute)object2).addItem(codedSequenceItem.getAttributeList());
        ((AttributeList)object).put((Attribute)object2);
        object2 = new SequenceAttribute(TagFromName.RequestAttributesSequence);
        ((SequenceAttribute)object2).addItem((AttributeList)object);
        attributeList.put((Attribute)object2);
        object = new CompositeInstanceContext(attributeList);
        object2 = ((CompositeInstanceContext)object).getAttributeList();
        TestCompositeInstanceContext.assertEquals((String)"Checking SOPClassUID", (String)string16, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SOPClassUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking SOPInstanceUID", (String)string13, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SOPInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesInstanceUID", (String)string14, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SeriesInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyInstanceUID", (String)string15, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.StudyInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientName", (String)string, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.PatientName));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientID", (String)string2, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.PatientID));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientBirthDate", (String)string3, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.PatientBirthDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientSex", (String)string4, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.PatientSex));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyID", (String)string5, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.StudyID));
        TestCompositeInstanceContext.assertEquals((String)"Checking ReferringPhysicianName", (String)string8, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.ReferringPhysicianName));
        TestCompositeInstanceContext.assertEquals((String)"Checking AccessionNumber", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.AccessionNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesNumber", (String)string6, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SeriesNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking InstanceNumber", (String)string7, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.InstanceNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking Manufacturer", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.Manufacturer));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientOrientation", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.PatientOrientation));
        TestCompositeInstanceContext.assertEquals((String)"Checking Laterality", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.Laterality));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyDate", (String)string9, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.StudyDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyTime", (String)string10, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.StudyTime));
        TestCompositeInstanceContext.assertEquals((String)"Checking ContentDate", (String)string11, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.ContentDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking ContentTime", (String)string12, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.ContentTime));
        TestCompositeInstanceContext.assertEquals((String)"Checking ProcedureCodeSequence", (Object)codedSequenceItem, (Object)CodedSequenceItem.getSingleCodedSequenceItemOrNull((AttributeList)object2, TagFromName.ProcedureCodeSequence));
        TestCompositeInstanceContext.assertEquals((String)"Checking PerformedProcedureCodeSequence", (Object)codedSequenceItem, (Object)CodedSequenceItem.getSingleCodedSequenceItemOrNull((AttributeList)object2, TagFromName.PerformedProcedureCodeSequence));
        TestCompositeInstanceContext.assertEquals((String)"Checking RequestAttributesSequence StudyInstanceUID", (String)string15, (String)SequenceAttribute.getArrayOfSingleStringValueOrEmptyStringOfNamedAttributeWithinSequenceItems((AttributeList)object2, TagFromName.RequestAttributesSequence, TagFromName.StudyInstanceUID)[0]);
        TestCompositeInstanceContext.assertEquals((String)"Checking RequestAttributesSequence AccessionNumber", (String)"", (String)SequenceAttribute.getArrayOfSingleStringValueOrEmptyStringOfNamedAttributeWithinSequenceItems((AttributeList)object2, TagFromName.RequestAttributesSequence, TagFromName.AccessionNumber)[0]);
        TestCompositeInstanceContext.assertEquals((String)"Checking RequestAttributes RequestedProcedureCodeSequence", (Object)codedSequenceItem, (Object)CodedSequenceItem.getSingleCodedSequenceItemOrNull((SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem((AttributeList)object2, TagFromName.RequestAttributesSequence, TagFromName.RequestedProcedureCodeSequence)));
        TestCompositeInstanceContext.assertEquals((String)"Checking ReferencedRequestSequence StudyInstanceUID", (String)string15, (String)SequenceAttribute.getArrayOfSingleStringValueOrEmptyStringOfNamedAttributeWithinSequenceItems((AttributeList)object2, TagFromName.ReferencedRequestSequence, TagFromName.StudyInstanceUID)[0]);
        TestCompositeInstanceContext.assertEquals((String)"Checking ReferencedRequestSequence AccessionNumber", (String)"", (String)SequenceAttribute.getArrayOfSingleStringValueOrEmptyStringOfNamedAttributeWithinSequenceItems((AttributeList)object2, TagFromName.ReferencedRequestSequence, TagFromName.AccessionNumber)[0]);
        TestCompositeInstanceContext.assertEquals((String)"Checking ReferencedRequestSequence RequestedProcedureCodeSequence", (Object)codedSequenceItem, (Object)CodedSequenceItem.getSingleCodedSequenceItemOrNull((SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem((AttributeList)object2, TagFromName.ReferencedRequestSequence, TagFromName.RequestedProcedureCodeSequence)));
        ((CompositeInstanceContext)object).removeSeries();
        object2 = ((CompositeInstanceContext)object).getAttributeList();
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesInstanceUID", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SeriesInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesNumber", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SeriesNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking Laterality", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.Laterality));
        Object object3 = new AttributeList();
        IntegerStringAttribute integerStringAttribute = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)integerStringAttribute).addValue(string6);
        ((AttributeList)object3).put(integerStringAttribute);
        ((CompositeInstanceContext)object).putAll((AttributeList)object3);
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesNumber", (String)string6, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SeriesNumber));
        ((CompositeInstanceContext)object).removeInstance();
        TestCompositeInstanceContext.assertEquals((String)"Checking ContentDate", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.ContentDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking ContentTime", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.ContentTime));
        TestCompositeInstanceContext.assertEquals((String)"Checking SOPInstanceUID", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SOPInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking InstanceNumber", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.InstanceNumber));
        object3 = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object3).addValue(string7);
        ((CompositeInstanceContext)object).put((Attribute)object3);
        TestCompositeInstanceContext.assertEquals((String)"Checking InstanceNumber", (String)string7, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.InstanceNumber));
    }

    public void TestCompositeInstanceContext_WithoutSRSpecificRequestAndProcedure() throws Exception {
        String string = "Smith^Mary";
        String string2 = "3764913624";
        String string3 = "19600101";
        String string4 = "F";
        String string5 = "612386812";
        String string6 = "12";
        String string7 = "38";
        String string8 = "Jones^Harriet";
        String string9 = "20100324";
        String string10 = "142211";
        String string11 = "20100325";
        String string12 = "142238";
        UIDGenerator uIDGenerator = new UIDGenerator("9999");
        String string13 = uIDGenerator.getNewSOPInstanceUID(string5, string6, string7);
        String string14 = uIDGenerator.getNewSeriesInstanceUID(string5, string6);
        String string15 = uIDGenerator.getNewStudyInstanceUID(string5);
        String string16 = "1.2.840.10008.5.1.4.1.1.1";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("CTCAP", "99BLA", "CT C/A/P");
        AttributeList attributeList = new AttributeList();
        Object object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue(string16);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(string13);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(string14);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue(string15);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.PatientID);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.PatientBirthDate);
        ((Attribute)object).addValue(string3);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        ((Attribute)object).addValue(string4);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(string5);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
        ((Attribute)object).addValue(string8);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.AccessionNumber);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(string6);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object).addValue(string7);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientOrientation);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Laterality);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object).addValue(string9);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)object).addValue(string10);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)object).addValue(string11);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.ContentTime);
        ((Attribute)object).addValue(string12);
        attributeList.put((Attribute)object);
        object = new SequenceAttribute(TagFromName.ProcedureCodeSequence);
        ((SequenceAttribute)object).addItem(codedSequenceItem.getAttributeList());
        attributeList.put((Attribute)object);
        object = new AttributeList();
        Object object2 = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object2).addValue(string15);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.AccessionNumber);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new SequenceAttribute(TagFromName.RequestedProcedureCodeSequence);
        ((SequenceAttribute)object2).addItem(codedSequenceItem.getAttributeList());
        ((AttributeList)object).put((Attribute)object2);
        object2 = new SequenceAttribute(TagFromName.RequestAttributesSequence);
        ((SequenceAttribute)object2).addItem((AttributeList)object);
        attributeList.put((Attribute)object2);
        object = new CompositeInstanceContext(attributeList, false);
        object2 = ((CompositeInstanceContext)object).getAttributeList();
        TestCompositeInstanceContext.assertEquals((String)"Checking SOPClassUID", (String)string16, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SOPClassUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking SOPInstanceUID", (String)string13, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SOPInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesInstanceUID", (String)string14, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SeriesInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyInstanceUID", (String)string15, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.StudyInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientName", (String)string, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.PatientName));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientID", (String)string2, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.PatientID));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientBirthDate", (String)string3, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.PatientBirthDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientSex", (String)string4, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.PatientSex));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyID", (String)string5, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.StudyID));
        TestCompositeInstanceContext.assertEquals((String)"Checking ReferringPhysicianName", (String)string8, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.ReferringPhysicianName));
        TestCompositeInstanceContext.assertEquals((String)"Checking AccessionNumber", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.AccessionNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesNumber", (String)string6, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SeriesNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking InstanceNumber", (String)string7, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.InstanceNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking Manufacturer", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.Manufacturer));
        TestCompositeInstanceContext.assertEquals((String)"Checking PatientOrientation", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.PatientOrientation));
        TestCompositeInstanceContext.assertEquals((String)"Checking Laterality", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.Laterality));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyDate", (String)string9, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.StudyDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking StudyTime", (String)string10, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.StudyTime));
        TestCompositeInstanceContext.assertEquals((String)"Checking ContentDate", (String)string11, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.ContentDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking ContentTime", (String)string12, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.ContentTime));
        TestCompositeInstanceContext.assertEquals((String)"Checking ProcedureCodeSequence", (Object)codedSequenceItem, (Object)CodedSequenceItem.getSingleCodedSequenceItemOrNull((AttributeList)object2, TagFromName.ProcedureCodeSequence));
        TestCompositeInstanceContext.assertEquals((String)"Checking PerformedProcedureCodeSequence", null, (Object)CodedSequenceItem.getSingleCodedSequenceItemOrNull((AttributeList)object2, TagFromName.PerformedProcedureCodeSequence));
        TestCompositeInstanceContext.assertEquals((String)"Checking RequestAttributesSequence StudyInstanceUID", (String)string15, (String)SequenceAttribute.getArrayOfSingleStringValueOrEmptyStringOfNamedAttributeWithinSequenceItems((AttributeList)object2, TagFromName.RequestAttributesSequence, TagFromName.StudyInstanceUID)[0]);
        TestCompositeInstanceContext.assertEquals((String)"Checking RequestAttributesSequence AccessionNumber", (String)"", (String)SequenceAttribute.getArrayOfSingleStringValueOrEmptyStringOfNamedAttributeWithinSequenceItems((AttributeList)object2, TagFromName.RequestAttributesSequence, TagFromName.AccessionNumber)[0]);
        TestCompositeInstanceContext.assertEquals((String)"Checking RequestAttributes RequestedProcedureCodeSequence", (Object)codedSequenceItem, (Object)CodedSequenceItem.getSingleCodedSequenceItemOrNull((SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem((AttributeList)object2, TagFromName.RequestAttributesSequence, TagFromName.RequestedProcedureCodeSequence)));
        TestCompositeInstanceContext.assertEquals((String)"Checking ReferencedRequestSequence", null, (Object)((AttributeList)object2).get(TagFromName.ReferencedRequestSequence));
        ((CompositeInstanceContext)object).removeSeries();
        object2 = ((CompositeInstanceContext)object).getAttributeList();
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesInstanceUID", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SeriesInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesNumber", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SeriesNumber));
        TestCompositeInstanceContext.assertEquals((String)"Checking Laterality", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.Laterality));
        Object object3 = new AttributeList();
        IntegerStringAttribute integerStringAttribute = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)integerStringAttribute).addValue(string6);
        ((AttributeList)object3).put(integerStringAttribute);
        ((CompositeInstanceContext)object).putAll((AttributeList)object3);
        TestCompositeInstanceContext.assertEquals((String)"Checking SeriesNumber", (String)string6, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SeriesNumber));
        ((CompositeInstanceContext)object).removeInstance();
        TestCompositeInstanceContext.assertEquals((String)"Checking ContentDate", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.ContentDate));
        TestCompositeInstanceContext.assertEquals((String)"Checking ContentTime", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.ContentTime));
        TestCompositeInstanceContext.assertEquals((String)"Checking SOPInstanceUID", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.SOPInstanceUID));
        TestCompositeInstanceContext.assertEquals((String)"Checking InstanceNumber", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.InstanceNumber));
        object3 = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object3).addValue(string7);
        ((CompositeInstanceContext)object).put((Attribute)object3);
        TestCompositeInstanceContext.assertEquals((String)"Checking InstanceNumber", (String)string7, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object2, TagFromName.InstanceNumber));
    }
}

