/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.database.StudySeriesInstanceModel;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import java.util.ArrayList;
import java.util.TreeMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDatabaseDateTimeConversionInsertion
extends TestCase {
    String studyID;
    String seriesNumber;
    String instanceNumber;
    UIDGenerator u;

    public TestDatabaseDateTimeConversionInsertion(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestDatabaseDateTimeConversionInsertion");
        testSuite.addTest((Test)new TestDatabaseDateTimeConversionInsertion("TestDatabaseDateTimeConversionInsertion_ValidDateOnly"));
        testSuite.addTest((Test)new TestDatabaseDateTimeConversionInsertion("TestDatabaseDateTimeConversionInsertion_ValidDateTime"));
        testSuite.addTest((Test)new TestDatabaseDateTimeConversionInsertion("TestDatabaseDateTimeConversionInsertion_InvalidDateValidTime"));
        return testSuite;
    }

    protected void setUp() {
        this.studyID = "612386812";
        this.seriesNumber = "12";
        this.instanceNumber = "38";
        this.u = new UIDGenerator("9999");
    }

    protected void tearDown() {
    }

    public void TestDatabaseDateTimeConversionInsertion_ValidDateOnly() throws Exception {
        StudySeriesInstanceModel studySeriesInstanceModel = new StudySeriesInstanceModel("mem:test1");
        String string = "20121230";
        String string2 = "2012-12-30 00:00:00.000000";
        String string3 = this.u.getNewSOPInstanceUID(this.studyID, this.seriesNumber, this.instanceNumber);
        AttributeList attributeList = new AttributeList();
        Object object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(string3);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        studySeriesInstanceModel.insertObject(attributeList, "Dummy", "R");
        object = studySeriesInstanceModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedUID(InformationEntity.INSTANCE, string3);
        TestDatabaseDateTimeConversionInsertion.assertEquals((String)"Checking SOPInstanceUID", (String)string3, (String)((String)((TreeMap)((ArrayList)object).get(0)).get("SOPINSTANCEUID")));
        TestDatabaseDateTimeConversionInsertion.assertEquals((String)"Checking ContentDate", (String)string, (String)((String)((TreeMap)((ArrayList)object).get(0)).get("CONTENTDATE")));
        TestDatabaseDateTimeConversionInsertion.assertEquals((String)"Checking derivedContentDateTime", (String)string2, (String)((String)((TreeMap)((ArrayList)object).get(0)).get("PM_CONTENTDATETIME")));
    }

    public void TestDatabaseDateTimeConversionInsertion_ValidDateTime() throws Exception {
        StudySeriesInstanceModel studySeriesInstanceModel = new StudySeriesInstanceModel("mem:test2");
        String string = "20121230";
        String string2 = "143752.46";
        String string3 = "2012-12-30 14:37:52.460000";
        String string4 = this.u.getNewSOPInstanceUID(this.studyID, this.seriesNumber, this.instanceNumber);
        AttributeList attributeList = new AttributeList();
        Object object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(string4);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.ContentTime);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        studySeriesInstanceModel.insertObject(attributeList, "Dummy", "R");
        object = studySeriesInstanceModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedUID(InformationEntity.INSTANCE, string4);
        TestDatabaseDateTimeConversionInsertion.assertEquals((String)"Checking SOPInstanceUID", (String)string4, (String)((String)((TreeMap)((ArrayList)object).get(0)).get("SOPINSTANCEUID")));
        TestDatabaseDateTimeConversionInsertion.assertEquals((String)"Checking ContentDate", (String)string, (String)((String)((TreeMap)((ArrayList)object).get(0)).get("CONTENTDATE")));
        TestDatabaseDateTimeConversionInsertion.assertEquals((String)"Checking ContentTime", (String)string2, (String)((String)((TreeMap)((ArrayList)object).get(0)).get("CONTENTTIME")));
        TestDatabaseDateTimeConversionInsertion.assertEquals((String)"Checking derivedContentDateTime", (String)string3, (String)((String)((TreeMap)((ArrayList)object).get(0)).get("PM_CONTENTDATETIME")));
    }

    public void TestDatabaseDateTimeConversionInsertion_InvalidDateValidTime() throws Exception {
        StudySeriesInstanceModel studySeriesInstanceModel = new StudySeriesInstanceModel("mem:test3");
        String string = "99999999";
        String string2 = "143752.46";
        String string3 = null;
        String string4 = this.u.getNewSOPInstanceUID(this.studyID, this.seriesNumber, this.instanceNumber);
        AttributeList attributeList = new AttributeList();
        Object object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(string4);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.ContentTime);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        studySeriesInstanceModel.insertObject(attributeList, "Dummy", "R");
        object = studySeriesInstanceModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedUID(InformationEntity.INSTANCE, string4);
        TestDatabaseDateTimeConversionInsertion.assertEquals((String)"Checking SOPInstanceUID", (String)string4, (String)((String)((TreeMap)((ArrayList)object).get(0)).get("SOPINSTANCEUID")));
        TestDatabaseDateTimeConversionInsertion.assertEquals((String)"Checking ContentDate", (String)string, (String)((String)((TreeMap)((ArrayList)object).get(0)).get("CONTENTDATE")));
        TestDatabaseDateTimeConversionInsertion.assertEquals((String)"Checking ContentTime", (String)string2, (String)((String)((TreeMap)((ArrayList)object).get(0)).get("CONTENTTIME")));
        TestDatabaseDateTimeConversionInsertion.assertEquals((String)"Checking derivedContentDateTime", string3, (String)((String)((TreeMap)((ArrayList)object).get(0)).get("PM_CONTENTDATETIME")));
    }
}

