/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.TagFromName;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDecompressedImagePixelModuleAndLossyImageCompressionHistory
extends TestCase {
    private static final String filenameJPEGBaseline = "testcstorefile_jpegbaseline.dcm";
    private static final long compressionRatioJPEGBaseline = 13L;

    public TestDecompressedImagePixelModuleAndLossyImageCompressionHistory(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCStore");
        testSuite.addTest((Test)new TestDecompressedImagePixelModuleAndLossyImageCompressionHistory("TestDecompressedImagePixelModuleAndLossyImageCompressionHistory_ReadJPEGBaseline_Decompressing"));
        testSuite.addTest((Test)new TestDecompressedImagePixelModuleAndLossyImageCompressionHistory("TestDecompressedImagePixelModuleAndLossyImageCompressionHistory_ReadJPEGBaseline_NotDecompressing"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestDecompressedImagePixelModuleAndLossyImageCompressionHistory_ReadJPEGBaseline_Decompressing() throws Exception {
        System.err.println("TestDecompressedImagePixelModuleAndLossyImageCompressionHistory_ReadJPEGBaseline_Decompressing():");
        AttributeList attributeList = new AttributeList();
        attributeList.setDecompressPixelData(true);
        attributeList.read(filenameJPEGBaseline);
        TestDecompressedImagePixelModuleAndLossyImageCompressionHistory.assertEquals((String)"Before PhotometricInterpretation", (String)"YBR_FULL_422", (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PhotometricInterpretation));
        attributeList.remove(TagFromName.LossyImageCompression);
        attributeList.remove(TagFromName.LossyImageCompressionMethod);
        attributeList.remove(TagFromName.LossyImageCompressionRatio);
        attributeList.remove(TagFromName.PlanarConfiguration);
        attributeList.correctDecompressedImagePixelModule();
        attributeList.insertLossyImageCompressionHistoryIfDecompressed();
        TestDecompressedImagePixelModuleAndLossyImageCompressionHistory.assertEquals((String)"After PhotometricInterpretation", (String)"RGB", (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PhotometricInterpretation));
        TestDecompressedImagePixelModuleAndLossyImageCompressionHistory.assertEquals((String)"After PlanarConfiguration", (int)0, (int)Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PlanarConfiguration, -1));
        TestDecompressedImagePixelModuleAndLossyImageCompressionHistory.assertEquals((String)"After LossyImageCompression", (String)"01", (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.LossyImageCompression));
        TestDecompressedImagePixelModuleAndLossyImageCompressionHistory.assertEquals((String)"After LossyImageCompressionMethod", (String)"ISO_10918_1", (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.LossyImageCompressionMethod));
        TestDecompressedImagePixelModuleAndLossyImageCompressionHistory.assertTrue((String)"After LossyImageCompressionRatio", (Math.round(Double.parseDouble(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.LossyImageCompressionRatio))) == 13L ? 1 : 0) != 0);
    }

    public void TestDecompressedImagePixelModuleAndLossyImageCompressionHistory_ReadJPEGBaseline_NotDecompressing() throws Exception {
        System.err.println("TestDecompressedImagePixelModuleAndLossyImageCompressionHistory_ReadJPEGBaseline_Decompressing():");
        AttributeList attributeList = new AttributeList();
        attributeList.setDecompressPixelData(false);
        attributeList.read(filenameJPEGBaseline);
        TestDecompressedImagePixelModuleAndLossyImageCompressionHistory.assertEquals((String)"Before PhotometricInterpretation", (String)"YBR_FULL_422", (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PhotometricInterpretation));
        attributeList.remove(TagFromName.LossyImageCompression);
        attributeList.remove(TagFromName.LossyImageCompressionMethod);
        attributeList.remove(TagFromName.LossyImageCompressionRatio);
        attributeList.remove(TagFromName.PlanarConfiguration);
        attributeList.correctDecompressedImagePixelModule(true);
        attributeList.insertLossyImageCompressionHistoryIfDecompressed(true);
        TestDecompressedImagePixelModuleAndLossyImageCompressionHistory.assertEquals((String)"After PhotometricInterpretation", (String)"RGB", (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PhotometricInterpretation));
        TestDecompressedImagePixelModuleAndLossyImageCompressionHistory.assertEquals((String)"After PlanarConfiguration", (int)0, (int)Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PlanarConfiguration, -1));
        TestDecompressedImagePixelModuleAndLossyImageCompressionHistory.assertEquals((String)"After LossyImageCompression", (String)"01", (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.LossyImageCompression));
        TestDecompressedImagePixelModuleAndLossyImageCompressionHistory.assertEquals((String)"After LossyImageCompressionMethod", (String)"ISO_10918_1", (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.LossyImageCompressionMethod));
        TestDecompressedImagePixelModuleAndLossyImageCompressionHistory.assertTrue((String)"After LossyImageCompressionRatio", (Math.round(Double.parseDouble(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.LossyImageCompressionRatio))) == 13L ? 1 : 0) != 0);
    }
}

