/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DicomDirectory;
import com.pixelmed.dicom.DicomDirectoryRecord;
import com.pixelmed.dicom.DicomDirectoryRecordFactory;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDicomDirectoryRecordSortOrder
extends TestCase {
    public TestDicomDirectoryRecordSortOrder(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestDicomDirectoryRecordSortOrder");
        testSuite.addTest((Test)new TestDicomDirectoryRecordSortOrder("TestDicomDirectoryRecordSortOrder_IdenticalUnrecognizedRecord"));
        testSuite.addTest((Test)new TestDicomDirectoryRecordSortOrder("TestDicomDirectoryRecordSortOrder_IdenticalSeriesRecord"));
        testSuite.addTest((Test)new TestDicomDirectoryRecordSortOrder("TestDicomDirectoryRecordSortOrder_IdenticalStudyRecord"));
        testSuite.addTest((Test)new TestDicomDirectoryRecordSortOrder("TestDicomDirectoryRecordSortOrder_SameStringDifferentUIDStudyRecord"));
        testSuite.addTest((Test)new TestDicomDirectoryRecordSortOrder("TestDicomDirectoryRecordSortOrder_IdenticalPatientRecord"));
        testSuite.addTest((Test)new TestDicomDirectoryRecordSortOrder("TestDicomDirectoryRecordSortOrder_DifferentRecordTypesString"));
        testSuite.addTest((Test)new TestDicomDirectoryRecordSortOrder("TestDicomDirectoryRecordSortOrder_DifferentRecordTypesInteger"));
        testSuite.addTest((Test)new TestDicomDirectoryRecordSortOrder("TestDicomDirectoryRecordSortOrder_IdenticalPatientStudySeriesAttributes"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestDicomDirectoryRecordSortOrder_IdenticalUnrecognizedRecord() throws Exception {
        AttributeList attributeList = new AttributeList();
        AttributeList attributeList2 = new AttributeList();
        DicomDirectoryRecordFactory dicomDirectoryRecordFactory = new DicomDirectoryRecordFactory();
        DicomDirectoryRecordFactory.TopDirectoryRecord topDirectoryRecord = dicomDirectoryRecordFactory.getNewTopDirectoryRecord();
        DicomDirectoryRecord dicomDirectoryRecord = dicomDirectoryRecordFactory.getNewDicomDirectoryRecord(topDirectoryRecord, attributeList);
        topDirectoryRecord.addChild(dicomDirectoryRecord);
        DicomDirectoryRecord dicomDirectoryRecord2 = dicomDirectoryRecordFactory.getNewDicomDirectoryRecord(topDirectoryRecord, attributeList2);
        topDirectoryRecord.addChild(dicomDirectoryRecord2);
        TestDicomDirectoryRecordSortOrder.assertEquals((String)"Checking two children", (int)2, (int)topDirectoryRecord.getChildCount());
    }

    public void TestDicomDirectoryRecordSortOrder_IdenticalSeriesRecord() throws Exception {
        String string = "SERIES";
        String string2 = "1.2.3.4.5.6.7";
        String string3 = "001";
        AttributeList attributeList = new AttributeList();
        Object object = new CodeStringAttribute(TagFromName.DirectoryRecordType);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(string3);
        attributeList.put((Attribute)object);
        object = new AttributeList();
        Object object2 = new CodeStringAttribute(TagFromName.DirectoryRecordType);
        ((Attribute)object2).addValue(string);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object2).addValue(string2);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object2).addValue(string3);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DicomDirectoryRecordFactory();
        DicomDirectoryRecordFactory.TopDirectoryRecord topDirectoryRecord = ((DicomDirectoryRecordFactory)object2).getNewTopDirectoryRecord();
        DicomDirectoryRecord dicomDirectoryRecord = ((DicomDirectoryRecordFactory)object2).getNewDicomDirectoryRecord(topDirectoryRecord, attributeList);
        topDirectoryRecord.addChild(dicomDirectoryRecord);
        DicomDirectoryRecord dicomDirectoryRecord2 = ((DicomDirectoryRecordFactory)object2).getNewDicomDirectoryRecord(topDirectoryRecord, (AttributeList)object);
        topDirectoryRecord.addChild(dicomDirectoryRecord2);
        TestDicomDirectoryRecordSortOrder.assertEquals((String)"Checking two children", (int)2, (int)topDirectoryRecord.getChildCount());
    }

    public void TestDicomDirectoryRecordSortOrder_IdenticalStudyRecord() throws Exception {
        String string = "STUDY";
        String string2 = "1.2.3.4.5.6.7";
        String string3 = "20110904";
        String string4 = "567891";
        String string5 = "Same study description";
        AttributeList attributeList = new AttributeList();
        Object object = new CodeStringAttribute(TagFromName.DirectoryRecordType);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object).addValue(string3);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(string4);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.StudyDescription);
        ((Attribute)object).addValue(string5);
        attributeList.put((Attribute)object);
        object = new AttributeList();
        Object object2 = new CodeStringAttribute(TagFromName.DirectoryRecordType);
        ((Attribute)object2).addValue(string);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object2).addValue(string2);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object2).addValue(string3);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object2).addValue(string4);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new LongStringAttribute(TagFromName.StudyDescription);
        ((Attribute)object2).addValue(string5);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DicomDirectoryRecordFactory();
        DicomDirectoryRecordFactory.TopDirectoryRecord topDirectoryRecord = ((DicomDirectoryRecordFactory)object2).getNewTopDirectoryRecord();
        DicomDirectoryRecord dicomDirectoryRecord = ((DicomDirectoryRecordFactory)object2).getNewDicomDirectoryRecord(topDirectoryRecord, attributeList);
        topDirectoryRecord.addChild(dicomDirectoryRecord);
        DicomDirectoryRecord dicomDirectoryRecord2 = ((DicomDirectoryRecordFactory)object2).getNewDicomDirectoryRecord(topDirectoryRecord, (AttributeList)object);
        topDirectoryRecord.addChild(dicomDirectoryRecord2);
        TestDicomDirectoryRecordSortOrder.assertEquals((String)"Checking two children", (int)2, (int)topDirectoryRecord.getChildCount());
    }

    public void TestDicomDirectoryRecordSortOrder_SameStringDifferentUIDStudyRecord() throws Exception {
        String string = "STUDY";
        String string2 = "20110904";
        String string3 = "567891";
        String string4 = "Same study description";
        AttributeList attributeList = new AttributeList();
        Object object = new CodeStringAttribute(TagFromName.DirectoryRecordType);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue("1.2.3.4.5.6.7");
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(string3);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.StudyDescription);
        ((Attribute)object).addValue(string4);
        attributeList.put((Attribute)object);
        object = new AttributeList();
        Object object2 = new CodeStringAttribute(TagFromName.DirectoryRecordType);
        ((Attribute)object2).addValue(string);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object2).addValue("1.2.3.4.5.6.8");
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object2).addValue(string2);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object2).addValue(string3);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new LongStringAttribute(TagFromName.StudyDescription);
        ((Attribute)object2).addValue(string4);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DicomDirectoryRecordFactory();
        DicomDirectoryRecordFactory.TopDirectoryRecord topDirectoryRecord = ((DicomDirectoryRecordFactory)object2).getNewTopDirectoryRecord();
        DicomDirectoryRecord dicomDirectoryRecord = ((DicomDirectoryRecordFactory)object2).getNewDicomDirectoryRecord(topDirectoryRecord, attributeList);
        topDirectoryRecord.addChild(dicomDirectoryRecord);
        DicomDirectoryRecord dicomDirectoryRecord2 = ((DicomDirectoryRecordFactory)object2).getNewDicomDirectoryRecord(topDirectoryRecord, (AttributeList)object);
        topDirectoryRecord.addChild(dicomDirectoryRecord2);
        TestDicomDirectoryRecordSortOrder.assertEquals((String)"Checking two children", (int)2, (int)topDirectoryRecord.getChildCount());
    }

    public void TestDicomDirectoryRecordSortOrder_IdenticalPatientRecord() throws Exception {
        String string = "PATIENT";
        String string2 = "Smith^John";
        String string3 = "123456";
        AttributeList attributeList = new AttributeList();
        Object object = new CodeStringAttribute(TagFromName.DirectoryRecordType);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(string3);
        attributeList.put((Attribute)object);
        object = new AttributeList();
        Object object2 = new CodeStringAttribute(TagFromName.DirectoryRecordType);
        ((Attribute)object2).addValue(string);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object2).addValue(string2);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new ShortStringAttribute(TagFromName.PatientName);
        ((Attribute)object2).addValue(string3);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DicomDirectoryRecordFactory();
        DicomDirectoryRecordFactory.TopDirectoryRecord topDirectoryRecord = ((DicomDirectoryRecordFactory)object2).getNewTopDirectoryRecord();
        DicomDirectoryRecord dicomDirectoryRecord = ((DicomDirectoryRecordFactory)object2).getNewDicomDirectoryRecord(topDirectoryRecord, attributeList);
        topDirectoryRecord.addChild(dicomDirectoryRecord);
        DicomDirectoryRecord dicomDirectoryRecord2 = ((DicomDirectoryRecordFactory)object2).getNewDicomDirectoryRecord(topDirectoryRecord, (AttributeList)object);
        topDirectoryRecord.addChild(dicomDirectoryRecord2);
        TestDicomDirectoryRecordSortOrder.assertEquals((String)"Checking two children", (int)2, (int)topDirectoryRecord.getChildCount());
    }

    public void TestDicomDirectoryRecordSortOrder_DifferentRecordTypesString() throws Exception {
        AttributeList attributeList = new AttributeList();
        Object object = new CodeStringAttribute(TagFromName.DirectoryRecordType);
        ((Attribute)object).addValue("PATIENT");
        attributeList.put((Attribute)object);
        object = new AttributeList();
        Object object2 = new CodeStringAttribute(TagFromName.DirectoryRecordType);
        ((Attribute)object2).addValue("STUDY");
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DicomDirectoryRecordFactory();
        DicomDirectoryRecordFactory.TopDirectoryRecord topDirectoryRecord = ((DicomDirectoryRecordFactory)object2).getNewTopDirectoryRecord();
        DicomDirectoryRecord dicomDirectoryRecord = ((DicomDirectoryRecordFactory)object2).getNewDicomDirectoryRecord(topDirectoryRecord, attributeList);
        topDirectoryRecord.addChild(dicomDirectoryRecord);
        DicomDirectoryRecord dicomDirectoryRecord2 = ((DicomDirectoryRecordFactory)object2).getNewDicomDirectoryRecord(topDirectoryRecord, (AttributeList)object);
        topDirectoryRecord.addChild(dicomDirectoryRecord2);
        TestDicomDirectoryRecordSortOrder.assertEquals((String)"Checking two children", (int)2, (int)topDirectoryRecord.getChildCount());
    }

    public void TestDicomDirectoryRecordSortOrder_DifferentRecordTypesInteger() throws Exception {
        AttributeList attributeList = new AttributeList();
        Object object = new CodeStringAttribute(TagFromName.DirectoryRecordType);
        ((Attribute)object).addValue("SERIES");
        attributeList.put((Attribute)object);
        object = new AttributeList();
        Object object2 = new CodeStringAttribute(TagFromName.DirectoryRecordType);
        ((Attribute)object2).addValue("IMAGE");
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DicomDirectoryRecordFactory();
        DicomDirectoryRecordFactory.TopDirectoryRecord topDirectoryRecord = ((DicomDirectoryRecordFactory)object2).getNewTopDirectoryRecord();
        DicomDirectoryRecord dicomDirectoryRecord = ((DicomDirectoryRecordFactory)object2).getNewDicomDirectoryRecord(topDirectoryRecord, attributeList);
        topDirectoryRecord.addChild(dicomDirectoryRecord);
        DicomDirectoryRecord dicomDirectoryRecord2 = ((DicomDirectoryRecordFactory)object2).getNewDicomDirectoryRecord(topDirectoryRecord, (AttributeList)object);
        topDirectoryRecord.addChild(dicomDirectoryRecord2);
        TestDicomDirectoryRecordSortOrder.assertEquals((String)"Checking two children", (int)2, (int)topDirectoryRecord.getChildCount());
    }

    public void TestDicomDirectoryRecordSortOrder_IdenticalPatientStudySeriesAttributes() throws Exception {
        String string = "PATIENT";
        String string2 = "Smith^John";
        String string3 = "123456";
        String string4 = "1.2.3.4.5.6.7";
        String string5 = "20110904";
        String string6 = "567891";
        String string7 = "Same study description";
        String string8 = "1.2.3.4.5.6.7.8";
        String string9 = "001";
        String string10 = "1.2.840.10008.5.1.4.1.1.7";
        AttributeList attributeList = new AttributeList();
        Object object = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(string3);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue(string4);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object).addValue(string5);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(string6);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.StudyDescription);
        ((Attribute)object).addValue(string7);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(string8);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(string9);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue("1.2.3.4.5.6.7.8.9");
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue(string10);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object).addValue(1);
        attributeList.put((Attribute)object);
        object = new AttributeList();
        Object object2 = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object2).addValue(string2);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new ShortStringAttribute(TagFromName.PatientName);
        ((Attribute)object2).addValue(string3);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object2).addValue(string4);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object2).addValue(string5);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object2).addValue(string6);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new LongStringAttribute(TagFromName.StudyDescription);
        ((Attribute)object2).addValue(string7);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object2).addValue(string8);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object2).addValue(string9);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object2).addValue("1.2.3.4.5.6.7.8.10");
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object2).addValue(string10);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object2).addValue(2);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DicomDirectory();
        ((DicomDirectory)object2).addAttributeListFromDicomFileToDirectory(attributeList, "FILE1");
        ((DicomDirectory)object2).addAttributeListFromDicomFileToDirectory((AttributeList)object, "FILE2");
        DicomDirectoryRecord dicomDirectoryRecord = (DicomDirectoryRecord)((DicomDirectory)object2).getRoot();
        TestDicomDirectoryRecordSortOrder.assertTrue((boolean)(dicomDirectoryRecord instanceof DicomDirectoryRecordFactory.TopDirectoryRecord));
        TestDicomDirectoryRecordSortOrder.assertEquals((String)"Checking parent has one patient child", (int)1, (int)dicomDirectoryRecord.getChildCount());
        DicomDirectoryRecord dicomDirectoryRecord2 = (DicomDirectoryRecord)dicomDirectoryRecord.getChildAt(0);
        TestDicomDirectoryRecordSortOrder.assertTrue((boolean)(dicomDirectoryRecord2 instanceof DicomDirectoryRecordFactory.PatientDirectoryRecord));
        TestDicomDirectoryRecordSortOrder.assertEquals((String)"Checking patient has one study child", (int)1, (int)dicomDirectoryRecord2.getChildCount());
        DicomDirectoryRecord dicomDirectoryRecord3 = (DicomDirectoryRecord)dicomDirectoryRecord2.getChildAt(0);
        TestDicomDirectoryRecordSortOrder.assertTrue((boolean)(dicomDirectoryRecord3 instanceof DicomDirectoryRecordFactory.StudyDirectoryRecord));
        TestDicomDirectoryRecordSortOrder.assertEquals((String)"Checking study has one series child", (int)1, (int)dicomDirectoryRecord3.getChildCount());
        DicomDirectoryRecord dicomDirectoryRecord4 = (DicomDirectoryRecord)dicomDirectoryRecord3.getChildAt(0);
        TestDicomDirectoryRecordSortOrder.assertTrue((boolean)(dicomDirectoryRecord4 instanceof DicomDirectoryRecordFactory.SeriesDirectoryRecord));
        TestDicomDirectoryRecordSortOrder.assertEquals((String)"Checking series has two image children", (int)2, (int)dicomDirectoryRecord4.getChildCount());
        TestDicomDirectoryRecordSortOrder.assertTrue((boolean)(dicomDirectoryRecord4.getChildAt(0) instanceof DicomDirectoryRecordFactory.ImageDirectoryRecord));
        TestDicomDirectoryRecordSortOrder.assertTrue((boolean)(dicomDirectoryRecord4.getChildAt(1) instanceof DicomDirectoryRecordFactory.ImageDirectoryRecord));
    }
}

