/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.geometry.GeometryOfSlice;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestGeometryOfSlice
extends TestCase {
    public TestGeometryOfSlice(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestGeometryOfSlice");
        testSuite.addTest((Test)new TestGeometryOfSlice("TestGeometryOfSlice_3D2DConversions1"));
        testSuite.addTest((Test)new TestGeometryOfSlice("TestGeometryOfSlice_3D2DConversions2"));
        testSuite.addTest((Test)new TestGeometryOfSlice("TestGeometryOfSlice_3D2DConversions3"));
        testSuite.addTest((Test)new TestGeometryOfSlice("TestGeometryOfSlice_NormalDirection_Transverse_FromBelow_RowTowardsLeft_ColTowardsBack"));
        testSuite.addTest((Test)new TestGeometryOfSlice("TestGeometryOfSlice_NormalDirection_Transverse_FromAbove_RowTowardsRight_ColTowardsBack_OriginalEMIScanner"));
        testSuite.addTest((Test)new TestGeometryOfSlice("TestGeometryOfSlice_NormalDirection_Transverse_FromAbove_RowTowardsLeft_ColTowardsFront_Neurosurgery"));
        testSuite.addTest((Test)new TestGeometryOfSlice("TestGeometryOfSlice_NormalDirection_Coronal_FromFront_RowTowardsLeft_ColTowardsFeet"));
        testSuite.addTest((Test)new TestGeometryOfSlice("TestGeometryOfSlice_NormalDirection_Sagittal_FromLeftSide_RowTowardsBack_ColTowardsFeet"));
        testSuite.addTest((Test)new TestGeometryOfSlice("TestGeometryOfSlice_NormalDirection_Sagittal_FromRightSide_RowTowardsFront_ColTowardsFeet"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    protected boolean epsilonEquals(double d, double d2, double d3) {
        return Math.abs(d - d2) < d3;
    }

    protected boolean epsilonEquals(double[] dArray, double[] dArray2, double d) {
        boolean bl = true;
        if (dArray == null) {
            bl = false;
        } else if (dArray2 == null) {
            bl = false;
        } else if (dArray.length != dArray2.length) {
            bl = false;
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                if (this.epsilonEquals(dArray[i], dArray2[i], d)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    protected void check3D2DConversion(GeometryOfSlice geometryOfSlice, double d, double d2, double d3, double d4, double d5) {
        double[] dArray = geometryOfSlice.lookupImageCoordinate(d, d2);
        TestGeometryOfSlice.assertTrue((String)("Lookup 2d(" + d + "," + d2 + ")"), (boolean)this.epsilonEquals(d3, dArray[0], 1.0E-4));
        TestGeometryOfSlice.assertTrue((String)("Lookup 2d(" + d + "," + d2 + ")"), (boolean)this.epsilonEquals(d4, dArray[1], 1.0E-4));
        TestGeometryOfSlice.assertTrue((String)("Lookup 2d(" + d + "," + d2 + ")"), (boolean)this.epsilonEquals(d5, dArray[2], 1.0E-4));
        double[] dArray2 = geometryOfSlice.lookupImageCoordinate(dArray);
        TestGeometryOfSlice.assertTrue((String)("Round trip 2d(" + d + "," + d2 + ") column"), (boolean)this.epsilonEquals(d, dArray2[0], 1.0E-4));
        TestGeometryOfSlice.assertTrue((String)("Round trip 2d(" + d + "," + d2 + ") row"), (boolean)this.epsilonEquals(d2, dArray2[1], 1.0E-4));
    }

    public void TestGeometryOfSlice_3D2DConversions1() throws Exception {
        double[] dArray = new double[]{1.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 1.0, 0.0};
        double[] dArray3 = new double[]{1.0, 1.0, 1.0};
        double[] dArray4 = new double[]{1.0, 1.0, 1.0};
        double d = 1.0;
        double[] dArray5 = new double[]{512.0, 512.0, 1.0};
        GeometryOfSlice geometryOfSlice = new GeometryOfSlice(dArray, dArray2, dArray3, dArray4, d, dArray5);
        this.check3D2DConversion(geometryOfSlice, 0.0, 0.0, 0.5, 0.5, 1.0);
        this.check3D2DConversion(geometryOfSlice, 0.5, 0.5, 1.0, 1.0, 1.0);
        this.check3D2DConversion(geometryOfSlice, 1.0, 1.0, 1.5, 1.5, 1.0);
        this.check3D2DConversion(geometryOfSlice, 511.0, 511.0, 511.5, 511.5, 1.0);
        this.check3D2DConversion(geometryOfSlice, 511.5, 511.5, 512.0, 512.0, 1.0);
        this.check3D2DConversion(geometryOfSlice, 512.0, 512.0, 512.5, 512.5, 1.0);
    }

    public void TestGeometryOfSlice_3D2DConversions2() throws Exception {
        double[] dArray = new double[]{1.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 1.0, 0.0};
        double[] dArray3 = new double[]{0.0, 0.0, 0.0};
        double[] dArray4 = new double[]{1.0, 1.0, 1.0};
        double d = 1.0;
        double[] dArray5 = new double[]{512.0, 512.0, 1.0};
        GeometryOfSlice geometryOfSlice = new GeometryOfSlice(dArray, dArray2, dArray3, dArray4, d, dArray5);
        this.check3D2DConversion(geometryOfSlice, 0.0, 0.0, -0.5, -0.5, 0.0);
        this.check3D2DConversion(geometryOfSlice, 0.5, 0.5, 0.0, 0.0, 0.0);
        this.check3D2DConversion(geometryOfSlice, 1.0, 1.0, 0.5, 0.5, 0.0);
        this.check3D2DConversion(geometryOfSlice, 511.0, 511.0, 510.5, 510.5, 0.0);
        this.check3D2DConversion(geometryOfSlice, 511.5, 511.5, 511.0, 511.0, 0.0);
        this.check3D2DConversion(geometryOfSlice, 512.0, 512.0, 511.5, 511.5, 0.0);
    }

    public void TestGeometryOfSlice_3D2DConversions3() throws Exception {
        double[] dArray = new double[]{1.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 1.0, 0.0};
        double[] dArray3 = new double[]{0.0, 0.0, 0.0};
        double[] dArray4 = new double[]{0.4, 0.4, 0.4};
        double d = 1.0;
        double[] dArray5 = new double[]{512.0, 512.0, 1.0};
        GeometryOfSlice geometryOfSlice = new GeometryOfSlice(dArray, dArray2, dArray3, dArray4, d, dArray5);
        this.check3D2DConversion(geometryOfSlice, 0.0, 0.0, -0.2, -0.2, 0.0);
        this.check3D2DConversion(geometryOfSlice, 0.5, 0.5, 0.0, 0.0, 0.0);
        this.check3D2DConversion(geometryOfSlice, 1.0, 1.0, 0.2, 0.2, 0.0);
        this.check3D2DConversion(geometryOfSlice, 511.0, 511.0, 204.2, 204.2, 0.0);
        this.check3D2DConversion(geometryOfSlice, 511.5, 511.5, 204.4, 204.4, 0.0);
        this.check3D2DConversion(geometryOfSlice, 512.0, 512.0, 204.6, 204.6, 0.0);
    }

    public void TestGeometryOfSlice_NormalDirection_Transverse_FromBelow_RowTowardsLeft_ColTowardsBack() throws Exception {
        double[] dArray = new double[]{1.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 1.0, 0.0};
        double[] dArray3 = new double[]{0.0, 0.0, 0.0};
        double[] dArray4 = new double[]{1.0, 1.0, 1.0};
        double d = 1.0;
        double[] dArray5 = new double[]{512.0, 512.0, 1.0};
        GeometryOfSlice geometryOfSlice = new GeometryOfSlice(dArray, dArray2, dArray3, dArray4, d, dArray5);
        double[] dArray6 = new double[]{0.0, 0.0, 1.0};
        double[] dArray7 = geometryOfSlice.getNormalArray();
        TestGeometryOfSlice.assertTrue((String)"Normal not as expected", (boolean)this.epsilonEquals(dArray6, dArray7, 1.0E-4));
    }

    public void TestGeometryOfSlice_NormalDirection_Transverse_FromAbove_RowTowardsRight_ColTowardsBack_OriginalEMIScanner() throws Exception {
        double[] dArray = new double[]{-1.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 1.0, 0.0};
        double[] dArray3 = new double[]{0.0, 0.0, 0.0};
        double[] dArray4 = new double[]{1.0, 1.0, 1.0};
        double d = 1.0;
        double[] dArray5 = new double[]{512.0, 512.0, 1.0};
        GeometryOfSlice geometryOfSlice = new GeometryOfSlice(dArray, dArray2, dArray3, dArray4, d, dArray5);
        double[] dArray6 = new double[]{0.0, 0.0, -1.0};
        double[] dArray7 = geometryOfSlice.getNormalArray();
        TestGeometryOfSlice.assertTrue((String)"Normal not as expected", (boolean)this.epsilonEquals(dArray6, dArray7, 1.0E-4));
    }

    public void TestGeometryOfSlice_NormalDirection_Transverse_FromAbove_RowTowardsLeft_ColTowardsFront_Neurosurgery() throws Exception {
        double[] dArray = new double[]{1.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, -1.0, 0.0};
        double[] dArray3 = new double[]{0.0, 0.0, 0.0};
        double[] dArray4 = new double[]{1.0, 1.0, 1.0};
        double d = 1.0;
        double[] dArray5 = new double[]{512.0, 512.0, 1.0};
        GeometryOfSlice geometryOfSlice = new GeometryOfSlice(dArray, dArray2, dArray3, dArray4, d, dArray5);
        double[] dArray6 = new double[]{0.0, 0.0, -1.0};
        double[] dArray7 = geometryOfSlice.getNormalArray();
        TestGeometryOfSlice.assertTrue((String)"Normal not as expected", (boolean)this.epsilonEquals(dArray6, dArray7, 1.0E-4));
    }

    public void TestGeometryOfSlice_NormalDirection_Coronal_FromFront_RowTowardsLeft_ColTowardsFeet() throws Exception {
        double[] dArray = new double[]{1.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, -1.0};
        double[] dArray3 = new double[]{0.0, 0.0, 0.0};
        double[] dArray4 = new double[]{1.0, 1.0, 1.0};
        double d = 1.0;
        double[] dArray5 = new double[]{512.0, 512.0, 1.0};
        GeometryOfSlice geometryOfSlice = new GeometryOfSlice(dArray, dArray2, dArray3, dArray4, d, dArray5);
        double[] dArray6 = new double[]{0.0, 1.0, 0.0};
        double[] dArray7 = geometryOfSlice.getNormalArray();
        TestGeometryOfSlice.assertTrue((String)"Normal not as expected", (boolean)this.epsilonEquals(dArray6, dArray7, 1.0E-4));
    }

    public void TestGeometryOfSlice_NormalDirection_Sagittal_FromLeftSide_RowTowardsBack_ColTowardsFeet() throws Exception {
        double[] dArray = new double[]{0.0, 1.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, -1.0};
        double[] dArray3 = new double[]{0.0, 0.0, 0.0};
        double[] dArray4 = new double[]{1.0, 1.0, 1.0};
        double d = 1.0;
        double[] dArray5 = new double[]{512.0, 512.0, 1.0};
        GeometryOfSlice geometryOfSlice = new GeometryOfSlice(dArray, dArray2, dArray3, dArray4, d, dArray5);
        double[] dArray6 = new double[]{-1.0, 0.0, 0.0};
        double[] dArray7 = geometryOfSlice.getNormalArray();
        TestGeometryOfSlice.assertTrue((String)"Normal not as expected", (boolean)this.epsilonEquals(dArray6, dArray7, 1.0E-4));
    }

    public void TestGeometryOfSlice_NormalDirection_Sagittal_FromRightSide_RowTowardsFront_ColTowardsFeet() throws Exception {
        double[] dArray = new double[]{0.0, -1.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, -1.0};
        double[] dArray3 = new double[]{0.0, 0.0, 0.0};
        double[] dArray4 = new double[]{1.0, 1.0, 1.0};
        double d = 1.0;
        double[] dArray5 = new double[]{512.0, 512.0, 1.0};
        GeometryOfSlice geometryOfSlice = new GeometryOfSlice(dArray, dArray2, dArray3, dArray4, d, dArray5);
        double[] dArray6 = new double[]{1.0, 0.0, 0.0};
        double[] dArray7 = geometryOfSlice.getNormalArray();
        TestGeometryOfSlice.assertTrue((String)"Normal not as expected", (boolean)this.epsilonEquals(dArray6, dArray7, 1.0E-4));
    }
}

