/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPatientAgeWhenRemoveIdentifyingAttributes
extends TestCase {
    protected String ageEncoded = "015Y";
    protected String ageDerived = "050Y";
    protected String dob = "19610714";
    protected String currentDate = "20120625";
    protected AttributeList list;

    public TestPatientAgeWhenRemoveIdentifyingAttributes(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestPatientAgeWhenRemoveIdentifyingAttributes");
        testSuite.addTest((Test)new TestPatientAgeWhenRemoveIdentifyingAttributes("TestPatientAgeWhenRemoveIdentifyingAttributes_DoNotKeepIdentifyingAttributes"));
        testSuite.addTest((Test)new TestPatientAgeWhenRemoveIdentifyingAttributes("TestPatientAgeWhenRemoveIdentifyingAttributes_KeepIdentifyingAttributesAgeAlreadyPresent"));
        testSuite.addTest((Test)new TestPatientAgeWhenRemoveIdentifyingAttributes("TestPatientAgeWhenRemoveIdentifyingAttributes_KeepIdentifyingAttributesAgeAbsent"));
        testSuite.addTest((Test)new TestPatientAgeWhenRemoveIdentifyingAttributes("TestPatientAgeWhenRemoveIdentifyingAttributes_KeepIdentifyingAttributesAgeZeroLength"));
        testSuite.addTest((Test)new TestPatientAgeWhenRemoveIdentifyingAttributes("TestPatientAgeWhenRemoveIdentifyingAttributes_KeepIdentifyingAttributesAgeZeroLengthAndStudyDateZeroLength"));
        testSuite.addTest((Test)new TestPatientAgeWhenRemoveIdentifyingAttributes("TestPatientAgeWhenRemoveIdentifyingAttributes_KeepIdentifyingAttributesAgeZeroLengthAndStudySeriesDateZeroLength"));
        testSuite.addTest((Test)new TestPatientAgeWhenRemoveIdentifyingAttributes("TestPatientAgeWhenRemoveIdentifyingAttributes_KeepIdentifyingAttributesAgeZeroLengthAndStudySeriesAcquisitionDateZeroLength"));
        testSuite.addTest((Test)new TestPatientAgeWhenRemoveIdentifyingAttributes("TestPatientAgeWhenRemoveIdentifyingAttributes_KeepIdentifyingAttributesAgeZeroLengthAndStudySeriesAcquisitionContentDateZeroLength"));
        return testSuite;
    }

    protected void setUp() throws DicomException {
        this.list = new AttributeList();
        StringAttribute stringAttribute = new AgeStringAttribute(TagFromName.PatientAge);
        ((Attribute)stringAttribute).addValue(this.ageEncoded);
        this.list.put(stringAttribute);
        stringAttribute = new DateAttribute(TagFromName.PatientBirthDate);
        ((Attribute)stringAttribute).addValue(this.dob);
        this.list.put(stringAttribute);
        stringAttribute = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)stringAttribute).addValue(this.currentDate);
        this.list.put(stringAttribute);
        stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(this.currentDate);
        this.list.put(stringAttribute);
        stringAttribute = new DateAttribute(TagFromName.AcquisitionDate);
        ((Attribute)stringAttribute).addValue(this.currentDate);
        this.list.put(stringAttribute);
        stringAttribute = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)stringAttribute).addValue(this.currentDate);
        this.list.put(stringAttribute);
        stringAttribute = new DateAttribute(TagFromName.InstanceCreationDate);
        ((Attribute)stringAttribute).addValue(this.currentDate);
        this.list.put(stringAttribute);
    }

    protected void tearDown() {
    }

    public void TestPatientAgeWhenRemoveIdentifyingAttributes_DoNotKeepIdentifyingAttributes() throws Exception {
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(this.list, true, true, false);
        Attribute attribute = this.list.get(TagFromName.PatientAge);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertTrue((String)"Checking PatientAge is zero length", (attribute == null || attribute.getVL() == 0L ? 1 : 0) != 0);
        attribute = this.list.get(TagFromName.PatientBirthDate);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertTrue((String)"Checking PatientBirthDate is zero length", (attribute == null || attribute.getVL() == 0L ? 1 : 0) != 0);
    }

    public void TestPatientAgeWhenRemoveIdentifyingAttributes_KeepIdentifyingAttributesAgeAlreadyPresent() throws Exception {
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(this.list, true, true, true);
        Attribute attribute = this.list.get(TagFromName.PatientAge);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertEquals((String)"Checking PatientAge", (String)this.ageEncoded, (String)Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.PatientAge));
        attribute = this.list.get(TagFromName.PatientBirthDate);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertTrue((String)"Checking PatientBirthDate is zero length", (attribute == null || attribute.getVL() == 0L ? 1 : 0) != 0);
    }

    public void TestPatientAgeWhenRemoveIdentifyingAttributes_KeepIdentifyingAttributesAgeAbsent() throws Exception {
        this.list.remove(TagFromName.PatientAge);
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(this.list, true, true, true);
        Attribute attribute = this.list.get(TagFromName.PatientAge);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertEquals((String)"Checking PatientAge", (String)this.ageDerived, (String)Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.PatientAge));
        attribute = this.list.get(TagFromName.PatientBirthDate);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertTrue((String)"Checking PatientBirthDate is zero length", (attribute == null || attribute.getVL() == 0L ? 1 : 0) != 0);
    }

    public void TestPatientAgeWhenRemoveIdentifyingAttributes_KeepIdentifyingAttributesAgeZeroLength() throws Exception {
        this.list.put(new AgeStringAttribute(TagFromName.PatientAge));
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(this.list, true, true, true);
        Attribute attribute = this.list.get(TagFromName.PatientAge);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertEquals((String)"Checking PatientAge", (String)this.ageDerived, (String)Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.PatientAge));
        attribute = this.list.get(TagFromName.PatientBirthDate);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertTrue((String)"Checking PatientBirthDate is zero length", (attribute == null || attribute.getVL() == 0L ? 1 : 0) != 0);
    }

    public void TestPatientAgeWhenRemoveIdentifyingAttributes_KeepIdentifyingAttributesAgeZeroLengthAndStudyDateZeroLength() throws Exception {
        this.list.put(new DateAttribute(TagFromName.StudyDate));
        this.list.put(new AgeStringAttribute(TagFromName.PatientAge));
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(this.list, true, true, true);
        Attribute attribute = this.list.get(TagFromName.PatientAge);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertEquals((String)"Checking PatientAge", (String)this.ageDerived, (String)Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.PatientAge));
        attribute = this.list.get(TagFromName.PatientBirthDate);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertTrue((String)"Checking PatientBirthDate is zero length", (attribute == null || attribute.getVL() == 0L ? 1 : 0) != 0);
    }

    public void TestPatientAgeWhenRemoveIdentifyingAttributes_KeepIdentifyingAttributesAgeZeroLengthAndStudySeriesDateZeroLength() throws Exception {
        this.list.put(new DateAttribute(TagFromName.StudyDate));
        this.list.put(new DateAttribute(TagFromName.SeriesDate));
        this.list.put(new AgeStringAttribute(TagFromName.PatientAge));
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(this.list, true, true, true);
        Attribute attribute = this.list.get(TagFromName.PatientAge);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertEquals((String)"Checking PatientAge", (String)this.ageDerived, (String)Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.PatientAge));
        attribute = this.list.get(TagFromName.PatientBirthDate);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertTrue((String)"Checking PatientBirthDate is zero length", (attribute == null || attribute.getVL() == 0L ? 1 : 0) != 0);
    }

    public void TestPatientAgeWhenRemoveIdentifyingAttributes_KeepIdentifyingAttributesAgeZeroLengthAndStudySeriesAcquisitionDateZeroLength() throws Exception {
        this.list.put(new DateAttribute(TagFromName.StudyDate));
        this.list.put(new DateAttribute(TagFromName.SeriesDate));
        this.list.put(new DateAttribute(TagFromName.AcquisitionDate));
        this.list.put(new AgeStringAttribute(TagFromName.PatientAge));
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(this.list, true, true, true);
        Attribute attribute = this.list.get(TagFromName.PatientAge);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertEquals((String)"Checking PatientAge", (String)this.ageDerived, (String)Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.PatientAge));
        attribute = this.list.get(TagFromName.PatientBirthDate);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertTrue((String)"Checking PatientBirthDate is zero length", (attribute == null || attribute.getVL() == 0L ? 1 : 0) != 0);
    }

    public void TestPatientAgeWhenRemoveIdentifyingAttributes_KeepIdentifyingAttributesAgeZeroLengthAndStudySeriesAcquisitionContentDateZeroLength() throws Exception {
        this.list.put(new DateAttribute(TagFromName.StudyDate));
        this.list.put(new DateAttribute(TagFromName.SeriesDate));
        this.list.put(new DateAttribute(TagFromName.AcquisitionDate));
        this.list.put(new DateAttribute(TagFromName.ContentDate));
        this.list.put(new AgeStringAttribute(TagFromName.PatientAge));
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(this.list, true, true, true);
        Attribute attribute = this.list.get(TagFromName.PatientAge);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertTrue((String)"Checking PatientAge is zero length", (attribute == null || attribute.getVL() == 0L ? 1 : 0) != 0);
        attribute = this.list.get(TagFromName.PatientBirthDate);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertTrue((String)"Checking PatientBirthDate is zero length", (attribute == null || attribute.getVL() == 0L ? 1 : 0) != 0);
    }

    public void TestPatientAgeWhenRemoveIdentifyingAttributes_KeepIdentifyingAttributesAgeZeroLengthAndStudySeriesAcquisitionDateAbsent() throws Exception {
        this.list.remove(TagFromName.StudyDate);
        this.list.remove(TagFromName.SeriesDate);
        this.list.remove(TagFromName.AcquisitionDate);
        this.list.put(new AgeStringAttribute(TagFromName.PatientAge));
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(this.list, true, true, true);
        Attribute attribute = this.list.get(TagFromName.PatientAge);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertEquals((String)"Checking PatientAge", (String)this.ageDerived, (String)Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.PatientAge));
        attribute = this.list.get(TagFromName.PatientBirthDate);
        TestPatientAgeWhenRemoveIdentifyingAttributes.assertTrue((String)"Checking PatientBirthDate is zero length", (attribute == null || attribute.getVL() == 0L ? 1 : 0) != 0);
    }
}

