/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeFactory;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.SequenceAttribute;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRemoveIdentifyingAttributes
extends TestCase {
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;
    private AttributeTag[] toBeRetained = new AttributeTag[]{dictionary.getTagFromName("ProtocolName"), dictionary.getTagFromName("SeriesDescription"), dictionary.getTagFromName("StudyDescription")};
    private AttributeTag[] toBeDummied = new AttributeTag[]{dictionary.getTagFromName("DetectorID"), dictionary.getTagFromName("DeviceSerialNumber"), dictionary.getTagFromName("ContentCreatorName"), dictionary.getTagFromName("VerifyingObserverName"), dictionary.getTagFromName("VerifyingOrganization")};
    private AttributeTag[] toBeZeroed = new AttributeTag[]{dictionary.getTagFromName("AccessionNumber"), dictionary.getTagFromName("FillerOrderNumberImagingServiceRequest"), dictionary.getTagFromName("PatientBirthDate"), dictionary.getTagFromName("PatientID"), dictionary.getTagFromName("PatientName"), dictionary.getTagFromName("PlacerOrderNumberImagingServiceRequest"), dictionary.getTagFromName("ReferringPhysicianName"), dictionary.getTagFromName("StudyID"), dictionary.getTagFromName("VerifyingObserverIdentificationCodeSequence")};
    private AttributeTag[] toBeRemoved = new AttributeTag[]{dictionary.getTagFromName("ActualHumanPerformersSequence"), dictionary.getTagFromName("ActualHumanPerformersSequence"), dictionary.getTagFromName("AdditionalPatientHistory"), dictionary.getTagFromName("AdmissionID"), dictionary.getTagFromName("AdmittingDate"), dictionary.getTagFromName("AdmittingTime"), dictionary.getTagFromName("Allergies"), dictionary.getTagFromName("Arbitrary"), dictionary.getTagFromName("AuthorObserverSequence"), dictionary.getTagFromName("BranchOfService"), dictionary.getTagFromName("CassetteID"), dictionary.getTagFromName("ConfidentialityConstraintOnPatientDataDescription"), dictionary.getTagFromName("ContentCreatorIdentificationCodeSequence"), dictionary.getTagFromName("ContributionDescription"), dictionary.getTagFromName("CountryOfResidence"), dictionary.getTagFromName("CurrentPatientLocation"), dictionary.getTagFromName("CustodialOrganizationSequence"), dictionary.getTagFromName("DataSetTrailingPadding"), dictionary.getTagFromName("DeviceUID"), dictionary.getTagFromName("DistributionAddress"), dictionary.getTagFromName("DistributionName"), dictionary.getTagFromName("GantryID"), dictionary.getTagFromName("GeneratorID"), dictionary.getTagFromName("HumanPerformerName"), dictionary.getTagFromName("HumanPerformerOrganization"), dictionary.getTagFromName("IconImageSequence"), dictionary.getTagFromName("IdentifyingComments"), dictionary.getTagFromName("InstitutionAddress"), dictionary.getTagFromName("InstitutionalDepartmentName"), dictionary.getTagFromName("InstitutionCodeSequence"), dictionary.getTagFromName("InstitutionName"), dictionary.getTagFromName("InsurancePlanIdentification"), dictionary.getTagFromName("IntendedRecipientsOfResultsIdentificationSequence"), dictionary.getTagFromName("InterpretationApproverSequence"), dictionary.getTagFromName("InterpretationAuthor"), dictionary.getTagFromName("InterpretationIDIssuer"), dictionary.getTagFromName("InterpretationRecorder"), dictionary.getTagFromName("InterpretationTranscriber"), dictionary.getTagFromName("IssuerOfAccessionNumberSequence"), dictionary.getTagFromName("IssuerOfAdmissionID"), dictionary.getTagFromName("IssuerOfAdmissionIDSequence"), dictionary.getTagFromName("IssuerOfPatientID"), dictionary.getTagFromName("IssuerOfPatientIDQualifiersSequence"), dictionary.getTagFromName("IssuerOfServiceEpisodeID"), dictionary.getTagFromName("IssuerOfServiceEpisodeIDSequence"), dictionary.getTagFromName("LastMenstrualDate"), dictionary.getTagFromName("MedicalAlerts"), dictionary.getTagFromName("MedicalRecordLocator"), dictionary.getTagFromName("MilitaryRank"), dictionary.getTagFromName("ModifyingDeviceID"), dictionary.getTagFromName("ModifyingDeviceManufacturer"), dictionary.getTagFromName("NameOfPhysiciansReadingStudy"), dictionary.getTagFromName("NamesOfIntendedRecipientsOfResults"), dictionary.getTagFromName("Occupation"), dictionary.getTagFromName("OperatorIdentificationSequence"), dictionary.getTagFromName("OperatorsName"), dictionary.getTagFromName("OrderCallbackPhoneNumber"), dictionary.getTagFromName("OrderEnteredBy"), dictionary.getTagFromName("OrderEntererLocation"), dictionary.getTagFromName("OtherPatientIDs"), dictionary.getTagFromName("OtherPatientIDsSequence"), dictionary.getTagFromName("OtherPatientNames"), dictionary.getTagFromName("ParticipantSequence"), dictionary.getTagFromName("PatientAddress"), dictionary.getTagFromName("PatientBirthName"), dictionary.getTagFromName("PatientBirthTime"), dictionary.getTagFromName("PatientComments"), dictionary.getTagFromName("PatientInsurancePlanCodeSequence"), dictionary.getTagFromName("PatientMotherBirthName"), dictionary.getTagFromName("PatientPrimaryLanguageCodeSequence"), dictionary.getTagFromName("PatientReligiousPreference"), dictionary.getTagFromName("PatientState"), dictionary.getTagFromName("PatientTelephoneNumbers"), dictionary.getTagFromName("PerformedLocation"), dictionary.getTagFromName("PerformedProcedureStepID"), dictionary.getTagFromName("PerformedStationAETitle"), dictionary.getTagFromName("PerformedStationGeographicLocationCodeSequence"), dictionary.getTagFromName("PerformedStationName"), dictionary.getTagFromName("PerformedStationNameCodeSequence"), dictionary.getTagFromName("PerformingPhysicianIdentificationSequence"), dictionary.getTagFromName("PerformingPhysicianName"), dictionary.getTagFromName("PersonAddress"), dictionary.getTagFromName("PersonIdentificationCodeSequence"), dictionary.getTagFromName("PersonName"), dictionary.getTagFromName("PersonTelephoneNumbers"), dictionary.getTagFromName("PhysicianApprovingInterpretation"), dictionary.getTagFromName("PhysiciansOfRecord"), dictionary.getTagFromName("PhysiciansOfRecordIdentificationSequence"), dictionary.getTagFromName("PhysiciansReadingStudyIdentificationSequence"), dictionary.getTagFromName("PlateID"), dictionary.getTagFromName("PreMedication"), dictionary.getTagFromName("ReferencedPatientAliasSequence"), dictionary.getTagFromName("ReferencedPatientSequence"), dictionary.getTagFromName("ReferencedStudySequence"), dictionary.getTagFromName("ReferringPhysicianAddress"), dictionary.getTagFromName("ReferringPhysicianIdentificationSequence"), dictionary.getTagFromName("ReferringPhysicianTelephoneNumbers"), dictionary.getTagFromName("RegionOfResidence"), dictionary.getTagFromName("RequestAttributesSequence"), dictionary.getTagFromName("RequestedProcedureID"), dictionary.getTagFromName("RequestedProcedureLocation"), dictionary.getTagFromName("RequestingPhysician"), dictionary.getTagFromName("RequestingService"), dictionary.getTagFromName("ResponsibleOrganization"), dictionary.getTagFromName("ResponsiblePerson"), dictionary.getTagFromName("ResultsDistributionListSequence"), dictionary.getTagFromName("ResultsIDIssuer"), dictionary.getTagFromName("ScheduledHumanPerformersSequence"), dictionary.getTagFromName("ScheduledPatientInstitutionResidence"), dictionary.getTagFromName("ScheduledPerformingPhysicianIdentificationSequence"), dictionary.getTagFromName("ScheduledPerformingPhysicianName"), dictionary.getTagFromName("ScheduledProcedureStepLocation"), dictionary.getTagFromName("ScheduledStationAETitle"), dictionary.getTagFromName("ScheduledStationGeographicLocationCodeSequence"), dictionary.getTagFromName("ScheduledStationName"), dictionary.getTagFromName("ScheduledStationNameCodeSequence"), dictionary.getTagFromName("ScheduledStudyLocation"), dictionary.getTagFromName("ScheduledStudyLocationAETitle"), dictionary.getTagFromName("ServiceEpisodeID"), dictionary.getTagFromName("SpecialNeeds"), dictionary.getTagFromName("StationName"), dictionary.getTagFromName("StudyIDIssuer"), dictionary.getTagFromName("StudyPriorityID"), dictionary.getTagFromName("StudyStatusID"), dictionary.getTagFromName("TextComments"), dictionary.getTagFromName("TextString"), dictionary.getTagFromName("TopicAuthor"), dictionary.getTagFromName("TopicKeywords"), dictionary.getTagFromName("TopicSubject"), dictionary.getTagFromName("TopicTitle")};

    public TestRemoveIdentifyingAttributes(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestRemoveIdentifyingAttributes");
        testSuite.addTest((Test)new TestRemoveIdentifyingAttributes("TestRemoveIdentifyingAttributes_FromList"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestRemoveIdentifyingAttributes_FromList() throws Exception {
        Attribute attribute;
        String string = "REPLACEMEPLEASE";
        AttributeList attributeList = new AttributeList();
        for (AttributeTag attributeTag : this.toBeDummied) {
            Attribute object2 = AttributeFactory.newAttribute(attributeTag);
            attributeList.put(object2);
            object2.addValue(string);
        }
        for (AttributeTag attributeTag : this.toBeZeroed) {
            Attribute attribute2 = AttributeFactory.newAttribute(attributeTag);
            attributeList.put(attribute2);
        }
        for (AttributeTag attributeTag : this.toBeRemoved) {
            Attribute attribute3 = AttributeFactory.newAttribute(attributeTag);
            attributeList.put(attribute3);
        }
        for (AttributeTag attributeTag : this.toBeRetained) {
            Attribute attribute4 = AttributeFactory.newAttribute(attributeTag);
            attributeList.put(attribute4);
        }
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, true, true, true);
        DicomDictionary dicomDictionary = DicomDictionary.StandardDictionary;
        for (AttributeTag attributeTag : this.toBeDummied) {
            attribute = attributeList.get(attributeTag);
            TestRemoveIdentifyingAttributes.assertTrue((String)("Checking " + dicomDictionary.getNameFromTag(attributeTag) + " is not removed"), (attribute != null ? 1 : 0) != 0);
            String string2 = attribute.getSingleStringValueOrNull();
            TestRemoveIdentifyingAttributes.assertTrue((String)("Checking " + dicomDictionary.getNameFromTag(attributeTag) + " is not null value"), (string2 != null ? 1 : 0) != 0);
            TestRemoveIdentifyingAttributes.assertTrue((String)("Checking " + dicomDictionary.getNameFromTag(attributeTag) + " has been replaced "), (!string.equals(string2) ? 1 : 0) != 0);
        }
        for (AttributeTag attributeTag : this.toBeZeroed) {
            attribute = attributeList.get(attributeTag);
            TestRemoveIdentifyingAttributes.assertTrue((String)("Checking " + dicomDictionary.getNameFromTag(attributeTag) + " is not removed"), (attribute != null ? 1 : 0) != 0);
            TestRemoveIdentifyingAttributes.assertTrue((String)("Checking " + dicomDictionary.getNameFromTag(attributeTag) + " is zero length"), (boolean)(attribute instanceof SequenceAttribute ? ((SequenceAttribute)attribute).getNumberOfItems() == 0 : attribute.getVL() == 0L));
        }
        for (AttributeTag attributeTag : this.toBeRemoved) {
            TestRemoveIdentifyingAttributes.assertTrue((String)("Checking " + dicomDictionary.getNameFromTag(attributeTag) + " is removed"), (attributeList.get(attributeTag) == null ? 1 : 0) != 0);
        }
        for (AttributeTag attributeTag : this.toBeRetained) {
            TestRemoveIdentifyingAttributes.assertTrue((String)("Checking " + dicomDictionary.getNameFromTag(attributeTag) + " is retained"), (attributeList.get(attributeTag) != null ? 1 : 0) != 0);
        }
    }
}

