/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.LongStringAttribute;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSafePrivatePhilipsPETRelated
extends TestCase {
    public TestSafePrivatePhilipsPETRelated(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestSafePrivatePhilipsPETRelated");
        testSuite.addTest((Test)new TestSafePrivatePhilipsPETRelated("TestSafePrivatePhilipsPETRelated_ScaleFactors_FromTag"));
        testSuite.addTest((Test)new TestSafePrivatePhilipsPETRelated("TestSafePrivatePhilipsPETRelated_ScaleFactors_FromList"));
        testSuite.addTest((Test)new TestSafePrivatePhilipsPETRelated("TestSafePrivatePhilipsPETRelated_ScaleFactors_FromFile"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestSafePrivatePhilipsPETRelated_ScaleFactors_FromTag() throws Exception {
        TestSafePrivatePhilipsPETRelated.assertTrue((String)"Checking SUV Factor is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("Philips PET Private Group", new AttributeTag(28755, 4096)));
        TestSafePrivatePhilipsPETRelated.assertTrue((String)"Checking Activity Concentration Factor is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("Philips PET Private Group", new AttributeTag(28755, 4105)));
    }

    public void TestSafePrivatePhilipsPETRelated_ScaleFactors_FromList() throws Exception {
        AttributeList attributeList = new AttributeList();
        LongStringAttribute longStringAttribute = new LongStringAttribute(new AttributeTag(28755, 16));
        ((Attribute)longStringAttribute).addValue("Philips PET Private Group");
        attributeList.put(longStringAttribute);
        TestSafePrivatePhilipsPETRelated.assertTrue((String)"Checking SUV Factor is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(28755, 4096), attributeList));
        TestSafePrivatePhilipsPETRelated.assertTrue((String)"Checking Activity Concentration Factor is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(28755, 4105), attributeList));
    }

    public void TestSafePrivatePhilipsPETRelated_ScaleFactors_FromFile() throws Exception {
        AttributeList attributeList = new AttributeList();
        String string = System.getProperty("com.pixelmed.test.filepath");
        attributeList.read(new File(string, "philipssuvandactivityscalefactors.dcm"));
        attributeList.removeUnsafePrivateAttributes();
        TestSafePrivatePhilipsPETRelated.assertTrue((String)"Checking Creator is not removed", (attributeList.get(new AttributeTag(28755, 16)) != null ? 1 : 0) != 0);
        TestSafePrivatePhilipsPETRelated.assertTrue((String)"Checking SUV Factor is not removed", (attributeList.get(new AttributeTag(28755, 4096)) != null ? 1 : 0) != 0);
        TestSafePrivatePhilipsPETRelated.assertTrue((String)"Checking Activity Concentration Factor is not removed", (attributeList.get(new AttributeTag(28755, 4105)) != null ? 1 : 0) != 0);
    }
}

