/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.XMLRepresentationOfStructuredReportObjectFactory;
import java.util.Locale;
import javax.xml.xpath.XPathFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.w3c.dom.Document;

public class TestSpatialCoordinates3DContentItemLocaleEffect
extends TestCase {
    ContentItemFactory cf;

    public TestSpatialCoordinates3DContentItemLocaleEffect(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestSpatialCoordinates3DContentItemLocaleEffect");
        testSuite.addTest((Test)new TestSpatialCoordinates3DContentItemLocaleEffect("TestSpatialCoordinates3DContentItemLocaleEffect_AllAvailableLocales"));
        return testSuite;
    }

    protected void setUp() {
        this.cf = new ContentItemFactory();
    }

    protected void tearDown() {
    }

    public void TestSpatialCoordinates3DContentItemLocaleEffect_AllAvailableLocales() throws Exception {
        Locale[] localeArray;
        String string = "111010";
        String string2 = "DCM";
        String string3 = "Center";
        String string4 = "1.2.3.4";
        float f = -39.76f;
        float f2 = 7.384f;
        float f3 = 42.13f;
        float[] fArray = new float[]{f, f2, f3};
        String string5 = "CONTAINS: SCOORD3D: Center = POINT (-39.759998321533,7.38399982452393,42.1300010681152) (FoR 1.2.3.4)";
        for (Locale locale : localeArray = Locale.getAvailableLocales()) {
            Locale.setDefault(locale);
            ContentItemFactory contentItemFactory = this.cf;
            contentItemFactory.getClass();
            ContentItemFactory.ContainerContentItem containerContentItem = contentItemFactory.new ContentItemFactory.ContainerContentItem(null, null, null, true, "", "");
            ContentItemFactory.SpatialCoordinates3DContentItem spatialCoordinates3DContentItem = this.cf.makeSpatialCoordinates3DContentItem(containerContentItem, "CONTAINS", new CodedSequenceItem(string, string2, string3), "POINT", fArray, string4);
            TestSpatialCoordinates3DContentItemLocaleEffect.assertEquals((String)locale.toString(), (String)string5, (String)spatialCoordinates3DContentItem.toString());
            String string6 = spatialCoordinates3DContentItem.toString().replace("CONTAINS: SCOORD3D: Center = POINT (", "").replace(" (FoR 1.2.3.4)", "").replace(")", "");
            String[] stringArray = string6.split(",");
            TestSpatialCoordinates3DContentItemLocaleEffect.assertEquals((String)(locale.toString() + ": x in content item"), (Object)Float.valueOf(f), (Object)Float.valueOf(Float.valueOf(stringArray[0]).floatValue()));
            TestSpatialCoordinates3DContentItemLocaleEffect.assertEquals((String)(locale.toString() + ": y in content item"), (Object)Float.valueOf(f2), (Object)Float.valueOf(Float.valueOf(stringArray[1]).floatValue()));
            TestSpatialCoordinates3DContentItemLocaleEffect.assertEquals((String)(locale.toString() + ": z in content item"), (Object)Float.valueOf(f3), (Object)Float.valueOf(Float.valueOf(stringArray[2]).floatValue()));
            StructuredReport structuredReport = new StructuredReport(containerContentItem);
            Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            TestSpatialCoordinates3DContentItemLocaleEffect.assertEquals((String)(locale.toString() + ": x in XML"), (Object)Float.valueOf(f), (Object)Float.valueOf(Float.valueOf(xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container/scoord3d/point/x", document)).floatValue()));
            TestSpatialCoordinates3DContentItemLocaleEffect.assertEquals((String)(locale.toString() + ": y in XML"), (Object)Float.valueOf(f2), (Object)Float.valueOf(Float.valueOf(xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container/scoord3d/point/y", document)).floatValue()));
            TestSpatialCoordinates3DContentItemLocaleEffect.assertEquals((String)(locale.toString() + ": z in XML"), (Object)Float.valueOf(f3), (Object)Float.valueOf(Float.valueOf(xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container/scoord3d/point/z", document)).floatValue()));
            AttributeList attributeList = new XMLRepresentationOfStructuredReportObjectFactory().getAttributeList(document);
            StructuredReport structuredReport2 = new StructuredReport(attributeList);
            ContentItem contentItem = (ContentItem)structuredReport2.getRoot();
            ContentItemFactory.SpatialCoordinates3DContentItem spatialCoordinates3DContentItem2 = (ContentItemFactory.SpatialCoordinates3DContentItem)contentItem.getChildAt(0);
            TestSpatialCoordinates3DContentItemLocaleEffect.assertEquals((String)"Round trip XML SCOORD3D content item", (String)spatialCoordinates3DContentItem.toString(), (String)spatialCoordinates3DContentItem2.toString());
        }
    }
}

