/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.XMLRepresentationOfStructuredReportObjectFactory;
import java.util.Locale;
import javax.xml.xpath.XPathFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.w3c.dom.Document;

public class TestSpatialCoordinatesContentItemLocaleEffect
extends TestCase {
    ContentItemFactory cf;

    public TestSpatialCoordinatesContentItemLocaleEffect(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestSpatialCoordinatesContentItemLocaleEffect");
        testSuite.addTest((Test)new TestSpatialCoordinatesContentItemLocaleEffect("TestSpatialCoordinatesContentItemLocaleEffect_AllAvailableLocales"));
        return testSuite;
    }

    protected void setUp() {
        this.cf = new ContentItemFactory();
    }

    protected void tearDown() {
    }

    public void TestSpatialCoordinatesContentItemLocaleEffect_AllAvailableLocales() throws Exception {
        Locale[] localeArray;
        String string = "111010";
        String string2 = "DCM";
        String string3 = "Center";
        float f = -39.76f;
        float f2 = 7.384f;
        float[] fArray = new float[]{f, f2};
        String string4 = "CONTAINS: SCOORD: Center = POINT (-39.759998321533,7.38399982452393)";
        for (Locale locale : localeArray = Locale.getAvailableLocales()) {
            Locale.setDefault(locale);
            ContentItemFactory contentItemFactory = this.cf;
            contentItemFactory.getClass();
            ContentItemFactory.ContainerContentItem containerContentItem = contentItemFactory.new ContentItemFactory.ContainerContentItem(null, null, null, true, "", "");
            ContentItemFactory.SpatialCoordinatesContentItem spatialCoordinatesContentItem = this.cf.makeSpatialCoordinatesContentItem(containerContentItem, "CONTAINS", new CodedSequenceItem(string, string2, string3), "POINT", fArray);
            TestSpatialCoordinatesContentItemLocaleEffect.assertEquals((String)locale.toString(), (String)string4, (String)spatialCoordinatesContentItem.toString());
            String string5 = spatialCoordinatesContentItem.toString().replace("CONTAINS: SCOORD: Center = POINT (", "").replace(")", "");
            String[] stringArray = string5.split(",");
            TestSpatialCoordinatesContentItemLocaleEffect.assertEquals((String)(locale.toString() + ": x in content item"), (Object)Float.valueOf(f), (Object)Float.valueOf(Float.valueOf(stringArray[0]).floatValue()));
            TestSpatialCoordinatesContentItemLocaleEffect.assertEquals((String)(locale.toString() + ": y in content item"), (Object)Float.valueOf(f2), (Object)Float.valueOf(Float.valueOf(stringArray[1]).floatValue()));
            StructuredReport structuredReport = new StructuredReport(containerContentItem);
            Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            TestSpatialCoordinatesContentItemLocaleEffect.assertEquals((String)(locale.toString() + ": x in XML"), (Object)Float.valueOf(f), (Object)Float.valueOf(Float.valueOf(xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container/scoord/point/x", document)).floatValue()));
            TestSpatialCoordinatesContentItemLocaleEffect.assertEquals((String)(locale.toString() + ": y in XML"), (Object)Float.valueOf(f2), (Object)Float.valueOf(Float.valueOf(xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container/scoord/point/y", document)).floatValue()));
            AttributeList attributeList = new XMLRepresentationOfStructuredReportObjectFactory().getAttributeList(document);
            StructuredReport structuredReport2 = new StructuredReport(attributeList);
            ContentItem contentItem = (ContentItem)structuredReport2.getRoot();
            ContentItemFactory.SpatialCoordinatesContentItem spatialCoordinatesContentItem2 = (ContentItemFactory.SpatialCoordinatesContentItem)contentItem.getChildAt(0);
            TestSpatialCoordinatesContentItemLocaleEffect.assertEquals((String)"Round trip XML SCOORD content item", (String)spatialCoordinatesContentItem.toString(), (String)spatialCoordinatesContentItem2.toString());
        }
    }
}

