/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.utils;

import com.pixelmed.utils.HexDump;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ByteArray {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/utils/ByteArray.java,v 1.25 2025/01/29 10:58:09 dclunie Exp $";

    private ByteArray() {
    }

    public static final byte[] readFully(String string) throws IOException {
        byte[] byArray = null;
        File file = new File(string);
        int n = (int)file.length();
        if (n > 0) {
            byArray = new byte[n];
            FileInputStream fileInputStream = new FileInputStream(file);
            int n2 = n;
            int n3 = 0;
            while (n2 > 0) {
                int n4 = fileInputStream.read(byArray, n3, n2);
                if (n4 == -1) {
                    throw new IOException("read failed with " + n2 + " bytes remaining to be read, wanted " + n);
                }
                n2 -= n4;
                n3 += n4;
            }
        }
        return byArray;
    }

    public static final int bigEndianToUnsignedInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n2-- > 0) {
            n3 = n3 << 8 | byArray[n++] & 0xFF;
        }
        return n3;
    }

    public static final int bigEndianToUnsignedInt(byte[] byArray) {
        return ByteArray.bigEndianToUnsignedInt(byArray, 0, byArray.length);
    }

    public static final byte[] intToBigEndianArray(int n, int n2) {
        byte[] byArray = new byte[n2];
        while (--n2 >= 0) {
            byArray[n2] = (byte)(n & 0xFF);
            n >>= 8;
        }
        return byArray;
    }

    public static final byte[] intToLittleEndianArray(int n, int n2) {
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)(n & 0xFF);
            n >>= 8;
        }
        return byArray;
    }

    public static final byte[] extractBytes(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static final byte[] concatenate(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        byte[] byArray3 = new byte[n2 + n4];
        System.arraycopy(byArray, n, byArray3, 0, n2);
        System.arraycopy(byArray2, n3, byArray3, n2, n4);
        return byArray3;
    }

    public static final byte[] concatenate(byte[] byArray, byte[] byArray2) {
        return byArray == null ? byArray2 : (byArray2 == null ? byArray : ByteArray.concatenate(byArray, 0, byArray.length, byArray2, 0, byArray2.length));
    }

    public static final void swapEndianness(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n2 - 1;
        int n5 = n3 = n2 / 2;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            byArray[i] = byArray[n4];
            byArray[n4] = by;
            --n4;
            if (--n5 > 0) continue;
            n5 = n3;
            n4 = (i += n3) + n2;
        }
    }

    private static final String dump(byte[] byArray) {
        return HexDump.dump(byArray);
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{1, 2, 4, 8};
        byte[] byArray = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            System.err.println("swapEndianness: wordLength = " + n);
            System.err.print("Before: " + ByteArray.dump(byArray));
            ByteArray.swapEndianness(byArray, byArray.length, n);
            System.err.print("After:  " + ByteArray.dump(byArray));
            ByteArray.swapEndianness(byArray, byArray.length, n);
            System.err.print("Back:   " + ByteArray.dump(byArray));
            System.err.println();
        }
    }
}

