/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.utils;

import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;

public class CapabilitiesAvailable {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/utils/CapabilitiesAvailable.java,v 1.20 2025/01/29 10:58:09 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(CapabilitiesAvailable.class);
    private static boolean haveScannedForCodecs = false;
    private static boolean haveCheckedForJPEGLosslessCodec = false;
    private static boolean haveFoundJPEGLosslessCodec = false;
    private static boolean haveCheckedForJPEG2000Part1Codec = false;
    private static boolean haveFoundJPEG2000Part1Codec = false;
    private static boolean haveCheckedForJPEGLSCodec = false;
    private static boolean haveFoundJPEGLSCodec = false;

    public static boolean haveJPEGBaselineSelectiveBlockRedaction() {
        boolean bl = true;
        try {
            Class<?> clazz = Class.forName("com.pixelmed.codec.jpeg.Parse");
            slf4jlogger.debug("CapabilitiesAvailable.haveJPEGBaselineSelectiveBlockRedaction(): Found redaction codec");
        }
        catch (ClassNotFoundException classNotFoundException) {
            slf4jlogger.debug("CapabilitiesAvailable.haveJPEGBaselineSelectiveBlockRedaction(): No redaction codec");
            bl = false;
        }
        return bl;
    }

    public static boolean haveBzip2Support() {
        boolean bl = true;
        try {
            Class<?> clazz = Class.forName("org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream");
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public static boolean haveUnixCompressSupport() {
        boolean bl = true;
        try {
            Class<?> clazz = Class.forName("org.apache.commons.compress.compressors.z.ZCompressorInputStream");
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public static boolean haveJPEGLosslessCodec() {
        if (!haveCheckedForJPEGLosslessCodec) {
            if (!haveScannedForCodecs) {
                slf4jlogger.debug("CapabilitiesAvailable.haveJPEGLosslessCodec(): Scanning for ImageIO plugin codecs");
                ImageIO.scanForPlugins();
                haveScannedForCodecs = true;
            }
            haveFoundJPEGLosslessCodec = false;
            String string = "jpeg-lossless";
            try {
                ImageReader imageReader = ImageIO.getImageReadersByFormatName(string).next();
                if (imageReader != null) {
                    slf4jlogger.debug("CapabilitiesAvailable.haveJPEGLosslessCodec(): Found jpeg-lossless reader");
                    haveFoundJPEGLosslessCodec = true;
                    try {
                        slf4jlogger.debug("CapabilitiesAvailable.haveJPEGLosslessCodec(): Calling dispose() on reader");
                        imageReader.dispose();
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("", exception);
                    }
                } else {
                    slf4jlogger.debug("CapabilitiesAvailable.haveJPEGLosslessCodec(): No jpeg-lossless reader");
                }
            }
            catch (Exception exception) {
                slf4jlogger.debug("CapabilitiesAvailable.haveJPEGLosslessCodec(): No jpeg-lossless reader");
                haveFoundJPEGLosslessCodec = false;
            }
            haveCheckedForJPEGLosslessCodec = true;
        }
        return haveFoundJPEGLosslessCodec;
    }

    public static boolean haveJPEG2000Part1Codec() {
        if (!haveCheckedForJPEG2000Part1Codec) {
            if (!haveScannedForCodecs) {
                slf4jlogger.debug("CapabilitiesAvailable.haveJPEG2000Part1Codec(): Scanning for ImageIO plugin codecs");
                ImageIO.scanForPlugins();
                haveScannedForCodecs = true;
            }
            haveFoundJPEG2000Part1Codec = false;
            String string = "JPEG2000";
            try {
                ImageReader imageReader = ImageIO.getImageReadersByFormatName(string).next();
                if (imageReader != null) {
                    slf4jlogger.debug("CapabilitiesAvailable.haveJPEG2000Part1Codec(): Found JPEG2000 reader");
                    haveFoundJPEG2000Part1Codec = true;
                    try {
                        slf4jlogger.debug("CapabilitiesAvailable.haveJPEG2000Part1Codec(): Calling dispose() on reader");
                        imageReader.dispose();
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("", exception);
                    }
                } else {
                    slf4jlogger.debug("CapabilitiesAvailable.haveJPEG2000Part1Codec(): No JPEG2000 reader");
                }
            }
            catch (Exception exception) {
                slf4jlogger.debug("CapabilitiesAvailable.haveJPEG2000Part1Codec(): No JPEG2000 reader");
                haveFoundJPEG2000Part1Codec = false;
            }
            haveCheckedForJPEG2000Part1Codec = true;
        }
        return haveFoundJPEG2000Part1Codec;
    }

    public static boolean haveJPEGLSCodec() {
        if (!haveCheckedForJPEGLSCodec) {
            if (!haveScannedForCodecs) {
                slf4jlogger.debug("CapabilitiesAvailable.haveJPEGLSCodec(): Scanning for ImageIO plugin codecs");
                ImageIO.scanForPlugins();
                haveScannedForCodecs = true;
            }
            haveFoundJPEGLSCodec = false;
            String string = "jpeg-ls";
            try {
                ImageReader imageReader = ImageIO.getImageReadersByFormatName(string).next();
                if (imageReader != null) {
                    slf4jlogger.debug("CapabilitiesAvailable.haveJPEGLSCodec(): Found JPEG-LS reader");
                    haveFoundJPEGLSCodec = true;
                    try {
                        slf4jlogger.debug("CapabilitiesAvailable.haveJPEGLSCodec(): Calling dispose() on reader");
                        imageReader.dispose();
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("", exception);
                    }
                } else {
                    slf4jlogger.debug("CapabilitiesAvailable.haveJPEGLSCodec(): No JPEG-LS reader");
                }
            }
            catch (Exception exception) {
                slf4jlogger.debug("CapabilitiesAvailable.haveJPEGLSCodec(): No JPEG-LS reader");
                haveFoundJPEGLSCodec = false;
            }
            haveCheckedForJPEGLSCodec = true;
        }
        return haveFoundJPEGLSCodec;
    }

    public static void dumpListOfAllAvailableReaders(PrintStream printStream) {
        String[] stringArray = ImageIO.getReaderFormatNames();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            printStream.println(stringArray[i] + ":");
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(stringArray[i]);
            while (iterator.hasNext()) {
                ImageReader imageReader = iterator.next();
                ImageReaderSpi imageReaderSpi = imageReader.getOriginatingProvider();
                printStream.println("\t" + imageReaderSpi.getDescription(Locale.US) + " " + imageReaderSpi.getVendorName() + " " + imageReaderSpi.getVersion());
            }
        }
    }

    public static void dumpListOfAllAvailableWriters(PrintStream printStream) {
        String[] stringArray = ImageIO.getWriterFormatNames();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            printStream.println(stringArray[i] + ":");
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(stringArray[i]);
            while (iterator.hasNext()) {
                ImageWriter imageWriter = iterator.next();
                ImageWriterSpi imageWriterSpi = imageWriter.getOriginatingProvider();
                printStream.println("\t" + imageWriterSpi.getDescription(Locale.US) + " " + imageWriterSpi.getVendorName() + " " + imageWriterSpi.getVersion());
            }
        }
    }

    public static void main(String[] stringArray) {
        CapabilitiesAvailable.dumpListOfAllAvailableReaders(System.err);
        CapabilitiesAvailable.dumpListOfAllAvailableWriters(System.err);
        System.err.println("CapabilitiesAvailable.haveBzip2Support(): " + (CapabilitiesAvailable.haveBzip2Support() ? "yes" : "no"));
        System.err.println("CapabilitiesAvailable.haveJPEGLosslessCodec(): " + (CapabilitiesAvailable.haveJPEGLosslessCodec() ? "yes" : "no"));
        System.err.println("CapabilitiesAvailable.haveJPEG2000Part1Codec(): " + (CapabilitiesAvailable.haveJPEG2000Part1Codec() ? "yes" : "no"));
        System.err.println("CapabilitiesAvailable.haveJPEGLSCodec(): " + (CapabilitiesAvailable.haveJPEGLSCodec() ? "yes" : "no"));
        System.err.println("CapabilitiesAvailable.haveJPEGBaselineSelectiveBlockRedaction(): " + (CapabilitiesAvailable.haveJPEGBaselineSelectiveBlockRedaction() ? "yes" : "no"));
    }
}

