/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.utils;

import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class CopyStream {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/utils/CopyStream.java,v 1.23 2025/01/29 10:58:09 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(CopyStream.class);
    private static final int defaultReadBufferSize = 32768;
    private static final int defaultBufferedInputStreamSizeForFileCopy = 0;
    private static final int defaultBufferedOutputStreamSizeForFileCopy = 0;

    private CopyStream() {
    }

    public static void skipInsistently(InputStream inputStream, long l) throws IOException {
        long l2;
        for (long i = l; i > 0L; i -= l2) {
            l2 = inputStream.skip(i);
            if (l2 > 0L) continue;
            throw new IOException("skip failed with " + i + " bytes remaining to be skipped, wanted " + l);
        }
    }

    public static final void copyByteSwapped(int n, InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        assert (l % 2L == 0L);
        if (n == 0) {
            n = 32768;
        }
        byte[] byArray = new byte[n];
        while (l > 1L) {
            int n2;
            int n3;
            int n4 = n3 = l > (long)n ? n : (int)l;
            assert (n3 % 2 == 0);
            int n5 = 0;
            while (n3 > 0) {
                n2 = inputStream.read(byArray, n5, n3);
                n5 += n2;
                n3 -= n2;
            }
            if (n5 <= 0) continue;
            for (n2 = 0; n2 < n5 - 1; n2 += 2) {
                byte by = byArray[n2];
                byArray[n2] = byArray[n2 + 1];
                byArray[n2 + 1] = by;
            }
            outputStream.write(byArray, 0, n5);
            l -= (long)n5;
        }
        outputStream.flush();
    }

    public static final void copyByteSwapped(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        CopyStream.copyByteSwapped(32768, inputStream, outputStream, l);
    }

    public static final void copy(int n, InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        CopyStream.copyTraditionalWay(n, inputStream, outputStream, l);
    }

    private static final void copyTraditionalWay(int n, InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        long l2 = l;
        slf4jlogger.debug("copyTraditionalWay(): start count = {}", l2);
        long l3 = System.currentTimeMillis();
        if (n == 0) {
            n = 32768;
        }
        byte[] byArray = new byte[n];
        while (l2 > 0L) {
            int n2 = l2 > (long)n ? n : (int)l2;
            int n3 = inputStream.read(byArray, 0, n2);
            if (n3 > 0) {
                outputStream.write(byArray, 0, n3);
                l2 -= (long)n3;
                continue;
            }
            throw new IOException("read failed with " + l2 + " bytes remaining to be read, wanted " + l);
        }
        outputStream.flush();
        slf4jlogger.debug("copyTraditionalWay(): done in {} ms", System.currentTimeMillis() - l3);
    }

    private static final void copyWithNIOBuffer(int n, InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        slf4jlogger.debug("copyWithNIOBuffer(): start count = {}", l);
        long l2 = System.currentTimeMillis();
        if (n == 0) {
            n = 32768;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        WritableByteChannel writableByteChannel = Channels.newChannel(outputStream);
        while (readableByteChannel.read(byteBuffer) != -1) {
            byteBuffer.flip();
            writableByteChannel.write(byteBuffer);
            byteBuffer.compact();
        }
        byteBuffer.flip();
        while (byteBuffer.hasRemaining()) {
            writableByteChannel.write(byteBuffer);
        }
        readableByteChannel.close();
        writableByteChannel.close();
        slf4jlogger.debug("copyTraditionalWay(): done in {} ms", System.currentTimeMillis() - l2);
    }

    public static final void copy(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        CopyStream.copy(32768, inputStream, outputStream, l);
    }

    public static final void copy(int n, InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        if (n == 0) {
            n = 32768;
        }
        byte[] byArray = new byte[n];
        while ((n2 = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n2);
        }
        outputStream.flush();
    }

    public static final void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        CopyStream.copy(32768, inputStream, outputStream);
    }

    public static final void copy(File file, File file2, int n, int n2, int n3, int n4) throws IOException {
        slf4jlogger.warn("Debug level supplied as argument ignored");
        CopyStream.copy(file, file2, n, n2, n3);
    }

    public static final void copy(File file, File file2, int n, int n2, int n3) throws IOException {
        InputStream inputStream;
        boolean bl;
        slf4jlogger.debug("Using readBufferSize of {} bytes", n);
        boolean bl2 = n2 > 0;
        boolean bl3 = bl = n3 > 0;
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug((bl2 ? "U" : "Not u") + "sing BufferedInputStream" + (bl2 ? " with size of " + n2 + " bytes" : ""));
        }
        InputStream inputStream2 = inputStream = bl2 ? new BufferedInputStream(new FileInputStream(file), n2) : new FileInputStream(file);
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug((bl ? "U" : "Not u") + "sing BufferedOutputStream" + (bl ? " with size of " + n3 + " bytes" : ""));
        }
        OutputStream outputStream = bl ? new BufferedOutputStream(new FileOutputStream(file2), n3) : new FileOutputStream(file2);
        CopyStream.copy(n, inputStream, outputStream);
        inputStream.close();
        outputStream.close();
    }

    public static final void copy(String string, String string2, int n, int n2, int n3, int n4) throws IOException {
        slf4jlogger.warn("Debug level supplied as argument ignored");
        CopyStream.copy(string, string2, n, n2, n3);
    }

    public static final void copy(String string, String string2, int n, int n2, int n3) throws IOException {
        CopyStream.copy(new File(string), new File(string2), n, n2, n3);
    }

    public static final void copy(File file, File file2) throws IOException {
        CopyStream.copy(file, file2, 32768, 0, 0);
    }

    public static final void copy(String string, String string2) throws IOException {
        CopyStream.copy(new File(string), new File(string2), 32768, 0, 0);
    }

    public static void main(String[] stringArray) {
        try {
            String string = null;
            String string2 = null;
            int n = 32768;
            int n2 = 0;
            int n3 = 0;
            if (stringArray.length == 2) {
                string = stringArray[0];
                string2 = stringArray[1];
            } else if (stringArray.length == 5) {
                string = stringArray[0];
                string2 = stringArray[1];
                n = Integer.parseInt(stringArray[2]);
                n2 = Integer.parseInt(stringArray[3]);
                n3 = Integer.parseInt(stringArray[4]);
            }
            if (string == null) {
                System.err.println("Error: Usage: java com.pixelmed.utils.CopyStream infile outfile [ readBufferSize bufferedInputStreamSizeForFileCopy bufferedOutputStreamSizeForFileCopy]");
            } else {
                long l = System.currentTimeMillis();
                CopyStream.copy(string, string2, n, n2, n3);
                double d = (double)(System.currentTimeMillis() - l) / 1000.0;
                slf4jlogger.info("Copy time {} seconds", d);
                long l2 = new File(string).length();
                double d2 = (double)l2 / 1048576.0;
                double d3 = d2 / d;
                slf4jlogger.info("Copy rate {} MB/s", d3);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

