/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.utils;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtilities {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/utils/DateUtilities.java,v 1.14 2025/01/29 10:58:09 dclunie Exp $";
    public static SimpleDateFormat yyyymmddFormat = new SimpleDateFormat("yyyyMMdd");
    public static DecimalFormat threeDigitZeroPaddedFormat = new DecimalFormat("000");

    private DateUtilities() {
    }

    public static String getAgeBetweenAsDICOMAgeString(String string, String string2) throws ParseException, IllegalArgumentException {
        yyyymmddFormat.setLenient(false);
        Date date = yyyymmddFormat.parse(string);
        Date date2 = yyyymmddFormat.parse(string2);
        return DateUtilities.getAgeBetweenAsDICOMAgeString(date, date2);
    }

    public static String getAgeBetweenAsDICOMAgeString(Date date, Date date2) throws IllegalArgumentException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date2);
        return DateUtilities.getAgeBetweenAsDICOMAgeString(gregorianCalendar, gregorianCalendar2);
    }

    public static String getAgeBetweenAsDICOMAgeString(Calendar calendar, Calendar calendar2) throws IllegalArgumentException {
        if (calendar2.before(calendar)) {
            throw new IllegalArgumentException("Age cannot be negative");
        }
        int n = calendar2.get(1) - calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar2.get(2);
        int n4 = n3 - n2;
        int n5 = calendar.get(5);
        int n6 = calendar2.get(5);
        int n7 = n6 - n5;
        if (n4 < 0) {
            --n;
            n4 = 12 - n2 + n3;
            if (n7 < 0) {
                --n4;
            }
        } else if (n4 == 0 && n7 < 0) {
            --n;
            n4 = 11;
        }
        if (n > 0) {
            return threeDigitZeroPaddedFormat.format(n) + "Y";
        }
        if (n4 > 1 || n4 == 1 && n7 >= 0) {
            return threeDigitZeroPaddedFormat.format(n4) + "M";
        }
        if (n7 < 0) {
            Calendar calendar3 = (Calendar)calendar2.clone();
            calendar3.add(2, -1);
            int n8 = calendar3.getActualMaximum(5);
            n7 = n8 - n5 + n6;
        }
        if (n7 >= 7) {
            int n9 = n7 / 7;
            return threeDigitZeroPaddedFormat.format(n9) + "W";
        }
        return threeDigitZeroPaddedFormat.format(n7) + "D";
    }
}

