/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.utils;

import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;

public class FloatFormatter {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/utils/FloatFormatter.java,v 1.20 2025/01/29 10:58:09 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(FileUtilities.class);
    public static String stringValueForNaN = "NaN";
    public static String stringValueForNegativeInfinity = "-Infinity";
    public static String stringValueForPositiveInfinity = "+Infinity";
    private static final int precisionToDisplayDouble = 4;
    private static final int maximumIntegerDigits = 8;
    private static final int maximumMaximumFractionDigits = 6;
    private static final String scientificPattern = ".####E00";
    private static double[] testDoubleValues = new double[]{0.0, 1.1, 0.11, 0.1133408781152648, -0.1133408781152648, 0.01133408781152648, -0.01133408781152648, 0.001133408781152648, -0.001133408781152648, 1.133408781152648E-4, -1.133408781152648E-4, 1.133408781152648E-5, -1.133408781152648E-5, 1.133408781152648E-6, -1.133408781152648E-6, 1.133408781152648E-12, -1.133408781152648E-12, 1.133408781152648E14, -1.133408781152648E14, 1.133408781152648E15, -1.133408781152648E15, 0.012624143592677, 99999.999, -99999.999, 100000.0, -100000.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NaN, Double.MAX_VALUE, Double.MIN_VALUE, 3.4028234663852886E38, 1.4E-45f, 9.223372036854776E18, -9.223372036854776E18, 2.147483647E9, -2.147483648E9, 32767.0, -32768.0};
    private static String[] testDoubleStringSupplied = new String[]{"0", "1.1", "0.11", "0.1133408781152648", "-0.1133408781152648", "0.01133408781152648", "-0.01133408781152648", "0.001133408781152648", "-0.001133408781152648", "0.0001133408781152648", "-0.0001133408781152648", "0.00001133408781152648", "-0.00001133408781152648", "0.000001133408781152648", "-0.000001133408781152648", "0.000000000001133408781152648", "-0.000000000001133408781152648", "113340878115264.8", "-113340878115264.8", "1133408781152648.0", "-1133408781152648.0", ".012624143592677", "99999.999", "-99999.999", "99999.999999999999999", "-99999.999999999999999", "Double.NEGATIVE_INFINITY", "Double.POSITIVE_INFINITY", "Double.NaN", "Double.MAX_VALUE", "Double.MIN_VALUE", "Float.MAX_VALUE", "Float.MIN_VALUE", "9223372036854775807", "-9223372036854775808", "2147483647", "-2147483648", "32767", "-32768"};
    private static String[] testDoubleStringExpectedForToString = new String[]{"0", "1.1", "0.11", "0.113", "-0.113", "0.0113", "-0.0113", "0.00113", "-0.00113", "0.000113", "-0.000113", ".1133E-04", "-.1133E-04", ".1133E-05", "-.1133E-05", ".1133E-11", "-.1133E-11", ".1133E15", "-.1133E15", ".1133E16", "-.1133E16", "0.0126", "100000", "-100000", "100000", "-100000", "-Infinity", "+Infinity", "NaN", ".1798E309", ".49E-323", ".3403E39", ".1401E-44", ".9223E19", "-.9223E19", ".2147E10", "-.2147E10", "32767", "-32768"};
    private static String[] testDoubleStringExpectedForFixedMaximumLength16 = new String[]{"0", "1.1", ".11", ".113340878115265", "-.11334087811526", ".011334087811526", "-.01133408781153", ".001133408781153", "-.00113340878115", ".000113340878115", "-.00011334087812", ".000011334087812", "-.00001133408781", ".113340878115E-5", "-.11334087812E-5", ".11334087812E-11", "-.1133408781E-11", "113340878115265", "-113340878115265", "1133408781152648", "-.11334087812E16", ".012624143592677", "99999.999", "-99999.999", "100000", "-100000", "-Infinity", "+Infinity", "NaN", ".17976931349E309", ".49E-323", ".340282346639E39", ".14012984643E-44", ".922337203685E19", "-.92233720369E19", "2147483647", "-2147483648", "32767", "-32768"};

    private FloatFormatter() {
    }

    public static String toString(double d) {
        return FloatFormatter.toString(d, Locale.getDefault());
    }

    public static String toString(double d, Locale locale) {
        String string = null;
        if (Double.isNaN(d)) {
            string = stringValueForNaN;
        } else if (d == Double.NEGATIVE_INFINITY) {
            string = stringValueForNegativeInfinity;
        } else if (d == Double.POSITIVE_INFINITY) {
            string = stringValueForPositiveInfinity;
        } else {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(locale);
            decimalFormat.setGroupingUsed(false);
            int n = (int)Math.log10(Math.abs(d)) + 1;
            int n2 = 4 - n;
            if (n > 8 || n2 > 6) {
                decimalFormat.applyPattern(scientificPattern);
            } else {
                if (n2 < 0) {
                    n2 = 0;
                }
                decimalFormat.setMaximumFractionDigits(n2);
            }
            string = decimalFormat.format(d);
        }
        return string;
    }

    public static String toStringOfFixedMaximumLength(double d, int n, boolean bl) {
        return FloatFormatter.toStringOfFixedMaximumLength(d, n, bl, Locale.getDefault());
    }

    public static String toStringOfFixedMaximumLength(double d, int n, boolean bl, Locale locale) {
        String string = null;
        if (d == 0.0) {
            string = "0";
        } else if (Double.isNaN(d)) {
            string = bl ? stringValueForNaN : "";
        } else if (d == Double.NEGATIVE_INFINITY) {
            string = bl ? stringValueForNegativeInfinity : "";
        } else if (d == Double.POSITIVE_INFINITY) {
            string = bl ? stringValueForPositiveInfinity : "";
        } else {
            int n2;
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(locale);
            decimalFormat.setGroupingUsed(false);
            int n3 = (int)Math.log10(Math.abs(d)) + 1;
            int n4 = n2 = d < 0.0 ? 1 : 0;
            if (n3 + n2 > n) {
                if (Math.abs(n3) > 99) {
                    if (n2 == 0) {
                        decimalFormat.applyPattern(".###########E000");
                    } else {
                        decimalFormat.applyPattern(".##########E000");
                    }
                } else if (Math.abs(n3) > 9) {
                    if (n2 == 0) {
                        decimalFormat.applyPattern(".############E00");
                    } else {
                        decimalFormat.applyPattern(".###########E00");
                    }
                } else if (n2 == 0) {
                    decimalFormat.applyPattern(".#############E0");
                } else {
                    decimalFormat.applyPattern(".############E0");
                }
            } else {
                int n5;
                boolean bl2;
                boolean bl3 = bl2 = Math.round(d) == 0L;
                if (bl2) {
                    --n3;
                }
                if ((n5 = n - n2 - n3) == 0 || n5 == 1) {
                    decimalFormat.setMaximumFractionDigits(0);
                } else if (n5 > 1 && n3 >= -4) {
                    if (n3 >= 0) {
                        decimalFormat.setMaximumIntegerDigits(n3);
                        decimalFormat.setMaximumFractionDigits(n5 - 1);
                    } else {
                        decimalFormat.setMaximumIntegerDigits(0);
                        decimalFormat.setMaximumFractionDigits(n - n2 - 1);
                    }
                } else if (Math.abs(n3) > 99) {
                    if (n2 == 0) {
                        decimalFormat.applyPattern(".##########E000");
                    } else {
                        decimalFormat.applyPattern(".#########E000");
                    }
                } else if (Math.abs(n3) > 9) {
                    if (n2 == 0) {
                        decimalFormat.applyPattern(".###########E00");
                    } else {
                        decimalFormat.applyPattern(".##########E00");
                    }
                } else if (n2 == 0) {
                    decimalFormat.applyPattern(".############E0");
                } else {
                    decimalFormat.applyPattern(".###########E0");
                }
            }
            string = decimalFormat.format(d);
        }
        return string;
    }

    public static final double[] fromString(String string, int n, char c) {
        double[] dArray = new double[n];
        int n2 = 0;
        try {
            int n3 = 0;
            int n4 = 0;
            int n5 = string.length();
            while (n2 < n) {
                if (n4 >= n5 || string.charAt(n4) == c) {
                    dArray[n2++] = Double.parseDouble(string.substring(n3, n4));
                    n3 = ++n4;
                    if (n4 < n5) continue;
                    break;
                }
                ++n4;
            }
        }
        catch (NumberFormatException numberFormatException) {
            slf4jlogger.error("", numberFormatException);
            n2 = 0;
        }
        return n2 != n ? null : dArray;
    }

    public static final double[] fromString(String string, char c) {
        int n;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n2 = 0;
        try {
            int n3 = 0;
            n = 0;
            int n4 = string.length();
            while (n3 < n4) {
                if (n >= n4 || string.charAt(n) == c) {
                    arrayList.add(new Double(Double.parseDouble(string.substring(n3, n))));
                    ++n2;
                    n3 = ++n;
                    if (n < n4) continue;
                    break;
                }
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            slf4jlogger.error("", numberFormatException);
            n2 = 0;
        }
        double[] dArray = null;
        if (n2 > 0) {
            dArray = new double[n2];
            for (n = 0; n < n2; ++n) {
                dArray[n] = (Double)arrayList.get(n);
            }
        }
        return dArray;
    }

    public static void main(String[] stringArray) {
        String string;
        int n;
        slf4jlogger.info("Test of FloatFormatter.toString():");
        for (n = 0; n < testDoubleValues.length; ++n) {
            string = FloatFormatter.toString(testDoubleValues[n]);
            System.err.println("\t" + (string.equals(testDoubleStringExpectedForToString[n]) ? "PASS" : "FAIL") + ": Supplied <" + testDoubleStringSupplied[n] + ">\t Got <" + string + ">\t Expected <" + testDoubleStringExpectedForToString[n] + ">");
        }
        slf4jlogger.info("Test of FloatFormatter.toStringOfFixedMaximumLength(double,16):");
        for (n = 0; n < testDoubleValues.length; ++n) {
            string = FloatFormatter.toStringOfFixedMaximumLength(testDoubleValues[n], 16, true);
            int n2 = string.length();
            System.err.println("\t" + (string.equals(testDoubleStringExpectedForFixedMaximumLength16[n]) && n2 <= 16 ? "PASS" : "FAIL") + ": Supplied <" + testDoubleStringSupplied[n] + ">\t Got <" + string + "> (length=" + n2 + ")\t Expected <" + testDoubleStringExpectedForFixedMaximumLength16[n] + ">\t Double.toString() <" + Double.toString(testDoubleValues[n]) + ">");
        }
    }
}

