/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.utils;

public class HexDump {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/utils/HexDump.java,v 1.22 2025/01/29 10:58:09 dclunie Exp $";

    private HexDump() {
    }

    public static String toPaddedDecimalString(int n, char c, int n2, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
        }
        String string3 = Integer.toString(n);
        int n3 = string3.length();
        while (n3++ < n2) {
            stringBuffer.append(c);
        }
        stringBuffer.append(string3);
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String byteToPaddedDecimalString(int n) {
        return HexDump.toPaddedDecimalString(n & 0xFF, ' ', 3, null, null);
    }

    public static String shortToPaddedDecimalString(int n) {
        return HexDump.toPaddedDecimalString(n & 0xFFFF, ' ', 6, null, null);
    }

    public static String intToPaddedDecimalString(int n) {
        return HexDump.toPaddedDecimalString(n & 0xFFFFFFFF, ' ', 9, null, null);
    }

    public static String toPaddedHexString(int n, char c, int n2, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
        }
        String string3 = Integer.toHexString(n);
        int n3 = string3.length();
        while (n3++ < n2) {
            stringBuffer.append(c);
        }
        stringBuffer.append(string3);
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String byteToPaddedHexString(int n) {
        return HexDump.toPaddedHexString(n & 0xFF, '0', 2, null, null);
    }

    public static String shortToPaddedHexString(int n) {
        return HexDump.toPaddedHexString(n & 0xFFFF, '0', 4, null, null);
    }

    public static String intToPaddedHexString(int n) {
        return HexDump.toPaddedHexString(n & 0xFFFFFFFF, '0', 8, null, null);
    }

    public static String byteToPaddedHexStringWith0x(int n) {
        return HexDump.toPaddedHexString(n & 0xFF, '0', 2, "0x", null);
    }

    public static String shortToPaddedHexStringWith0x(int n) {
        return HexDump.toPaddedHexString(n & 0xFFFF, '0', 4, "0x", null);
    }

    public static String intToPaddedHexStringWith0x(int n) {
        return HexDump.toPaddedHexString(n & 0xFFFFFFFF, '0', 8, "0x", null);
    }

    public static boolean isPrintableCharacter(char c) {
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    public static String byteArrayToPrintableString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ");
        while (n2-- > 0) {
            char c;
            if (HexDump.isPrintableCharacter(c = (char)byArray[n++])) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public static String byteArrayToPrintableString(byte[] byArray) {
        return HexDump.byteArrayToPrintableString(byArray, 0, byArray.length);
    }

    public static String byteArrayToHexString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(HexDump.byteToPaddedHexString(byArray[n + i]));
        }
        return stringBuffer.toString();
    }

    public static String byteArrayToHexString(byte[] byArray) {
        return HexDump.byteArrayToHexString(byArray, 0, byArray.length);
    }

    public static String dump(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray != null && n2 > 0) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n3 < n2) {
                int n6 = n3 + n;
                if (n3 % 16 == 0) {
                    if (n3 != 0) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append(HexDump.intToPaddedDecimalString(n6));
                    stringBuffer.append(" (");
                    stringBuffer.append(HexDump.intToPaddedHexStringWith0x(n6));
                    stringBuffer.append("):");
                    n4 = n6;
                    n5 = 0;
                }
                stringBuffer.append(" ");
                stringBuffer.append(HexDump.byteToPaddedHexString(byArray[n6]));
                ++n5;
                if (++n3 % 16 != 0 && n3 != n2) continue;
                stringBuffer.append(HexDump.byteArrayToPrintableString(byArray, n4, n5));
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static String dump(byte[] byArray, int n) {
        return HexDump.dump(byArray, 0, n);
    }

    public static String dump(byte[] byArray) {
        return HexDump.dump(byArray, byArray == null ? 0 : byArray.length);
    }

    public static String dump(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && n2 > 0) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n3 < n2) {
                int n6 = n3 + n;
                if (n3 % 8 == 0) {
                    if (n3 != 0) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append(HexDump.intToPaddedDecimalString(n6));
                    stringBuffer.append(" (");
                    stringBuffer.append(HexDump.intToPaddedHexStringWith0x(n6));
                    stringBuffer.append("):");
                    n4 = n6;
                    n5 = 0;
                }
                stringBuffer.append(" ");
                stringBuffer.append(HexDump.intToPaddedHexString(Character.codePointAt(string, n6)));
                ++n5;
                if (++n3 % 8 != 0 && n3 != n2) continue;
                stringBuffer.append(" ");
                stringBuffer.append(string.substring(n4, n4 + n5 - 1));
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static String dump(String string, int n) {
        return HexDump.dump(string, 0, n);
    }

    public static String dump(String string) {
        return HexDump.dump(string, string == null ? 0 : string.length());
    }

    public static void main(String[] stringArray) {
        byte[] byArray = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byArray[i] = (byte)i;
        }
        System.err.println(HexDump.dump(byArray));
    }
}

