/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.validate;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.XMLRepresentationOfStructuredReportObjectFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class DicomSRValidator {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/validate/DicomSRValidator.java,v 1.29 2025/02/11 19:35:51 dclunie Exp $";
    private Transformer transformerPass1;
    private Transformer transformerPass2;
    OurURIResolver ourURIResolver = new OurURIResolver();

    public void setOptionDescribeChecking(boolean bl) {
        this.transformerPass1.setParameter("optionDescribeChecking", bl ? "T" : "F");
    }

    public void setOptionCheckCodeMeaning(boolean bl) {
        this.transformerPass1.setParameter("optionCheckCodeMeaning", bl ? "T" : "F");
    }

    public void setOptionMatchCaseOfCodeMeaning(boolean bl) {
        this.transformerPass1.setParameter("optionMatchCaseOfCodeMeaning", bl ? "T" : "F");
    }

    public void setOptionCheckDeprecatedCodingScheme(boolean bl) {
        this.transformerPass1.setParameter("optionCheckDeprecatedCodingScheme", bl ? "T" : "F");
    }

    public void setOptionCheckTemplateID(boolean bl) {
        this.transformerPass1.setParameter("optionCheckTemplateID", bl ? "T" : "F");
    }

    public void setOptionCheckAmbiguousTemplate(boolean bl) {
        this.transformerPass2.setParameter("optionCheckAmbiguousTemplate", bl ? "T" : "F");
    }

    public void setOptionCheckContentItemOrder(boolean bl) {
        this.transformerPass2.setParameter("optionCheckContentItemOrder", bl ? "T" : "F");
    }

    public void setOptionReportContentItemsNotInTemplate(boolean bl) {
        this.transformerPass2.setParameter("optionReportContentItemsNotInTemplate", bl ? "T" : "F");
    }

    public DicomSRValidator() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setURIResolver(this.ourURIResolver);
        this.transformerPass1 = transformerFactory.newTransformer(new StreamSource(DicomSRValidator.class.getResourceAsStream("/com/pixelmed/validate/DicomSRDescriptionsCompiled.xsl")));
        this.setOptionDescribeChecking(false);
        this.setOptionMatchCaseOfCodeMeaning(true);
        this.setOptionCheckTemplateID(false);
        this.transformerPass2 = transformerFactory.newTransformer(new StreamSource(DicomSRValidator.class.getResourceAsStream("/com/pixelmed/validate/CheckSRContentItemsUsed.xsl")));
        this.setOptionCheckAmbiguousTemplate(false);
        this.setOptionCheckContentItemOrder(false);
        this.setOptionReportContentItemsNotInTemplate(true);
    }

    protected String validateFirstPass(Document document) throws ParserConfigurationException, TransformerException, UnsupportedEncodingException {
        DOMSource dOMSource = new DOMSource(document);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        this.transformerPass1.transform(dOMSource, streamResult);
        return byteArrayOutputStream.toString("UTF-8");
    }

    protected String validateSecondPass(Document document, String string) throws ParserConfigurationException, TransformerException, UnsupportedEncodingException, IOException {
        String string2;
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string));
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("<founditems>\n");
        while ((string2 = lineNumberReader.readLine()) != null) {
            if (string2.trim().startsWith("<item")) {
                stringBuffer2.append(string2);
                stringBuffer2.append("\n");
                continue;
            }
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        stringBuffer2.append("</founditems>\n");
        String string3 = stringBuffer2.toString();
        this.ourURIResolver.setFoundItems(string3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.transformerPass2.transform(new DOMSource(document), new StreamResult(byteArrayOutputStream));
        String string4 = byteArrayOutputStream.toString("UTF-8");
        stringBuffer.append(string4);
        stringBuffer.append("IOD validation complete\n");
        return stringBuffer.toString();
    }

    public String validate(AttributeList attributeList, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) throws ParserConfigurationException, TransformerException, UnsupportedEncodingException, IOException {
        this.setOptionDescribeChecking(bl);
        this.setOptionCheckCodeMeaning(bl2);
        this.setOptionMatchCaseOfCodeMeaning(bl3);
        this.setOptionCheckDeprecatedCodingScheme(bl4);
        this.setOptionCheckAmbiguousTemplate(bl5);
        this.setOptionCheckContentItemOrder(bl6);
        this.setOptionCheckTemplateID(bl7);
        this.setOptionReportContentItemsNotInTemplate(bl8);
        Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(attributeList);
        return this.validateSecondPass(document, this.validateFirstPass(document));
    }

    public String validate(AttributeList attributeList) throws ParserConfigurationException, TransformerException, UnsupportedEncodingException, IOException {
        return this.validate(attributeList, false, true, true, true, false, false, false, true);
    }

    public String validate(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) throws ParserConfigurationException, TransformerException, UnsupportedEncodingException, IOException, DicomException {
        AttributeList attributeList = new AttributeList();
        attributeList.read(string);
        return this.validate(attributeList, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8);
    }

    public String validate(String string) throws ParserConfigurationException, TransformerException, UnsupportedEncodingException, IOException, DicomException {
        return this.validate(string, false, true, true, true, false, false, false, true);
    }

    public static void main(String[] stringArray) {
        try {
            DicomSRValidator dicomSRValidator = new DicomSRValidator();
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = true;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : stringArray) {
                String string2 = string.toLowerCase().trim();
                if (string2.equals("-describe")) {
                    bl = true;
                    continue;
                }
                if (string2.equals("-donotcheckcodemeaning")) {
                    bl2 = false;
                    continue;
                }
                if (string2.equals("-donotmatchcase")) {
                    bl3 = false;
                    continue;
                }
                if (string2.equals("-donotcheckdeprecatedcodingscheme")) {
                    bl4 = false;
                    continue;
                }
                if (string2.equals("-checkambiguoustemplate")) {
                    bl5 = true;
                    continue;
                }
                if (string2.equals("-checkcontentitemorder")) {
                    bl6 = true;
                    continue;
                }
                if (string2.equals("-checktemplateid")) {
                    bl7 = true;
                    continue;
                }
                if (string2.equals("-donotcheckcontentitemsnotintemplate")) {
                    bl8 = false;
                    continue;
                }
                arrayList.add(string);
            }
            if (arrayList.size() == 1) {
                System.out.print(dicomSRValidator.validate((String)arrayList.get(0), bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8));
            } else {
                System.err.print("Usage: java com.pixelmed.validate.DicomSRValidator [-describe] [-donotcheckcodemeaning] [-donotmatchcase] [-donotcheckdeprecatedcodingscheme] [-checkambiguoustemplate] [-checkcontentitemorder] [-checktemplateid] [-donotcheckcontentitemsnotintemplate] filename");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private class OurURIResolver
    implements URIResolver {
        String foundItems;

        private OurURIResolver() {
        }

        @Override
        public Source resolve(String string, String string2) throws TransformerException {
            StreamSource streamSource = null;
            streamSource = string.equals("FoundItems.xml") ? new StreamSource(new StringReader(this.foundItems)) : new StreamSource(DicomSRValidator.class.getResourceAsStream("/com/pixelmed/validate/" + string));
            return streamSource;
        }

        public void setFoundItems(String string) {
            this.foundItems = string;
        }
    }
}

