/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.web.RequestHandler;
import com.pixelmed.web.WebRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

class PatientListRequestHandler
extends RequestHandler {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/PatientListRequestHandler.java,v 1.19 2025/01/29 10:58:09 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(PatientListRequestHandler.class);
    private Comparator compareDatabaseAttributesByPatientID = new CompareDatabaseAttributesByPatientID();

    protected PatientListRequestHandler(String string) {
        super(string);
    }

    @Override
    protected void generateResponseToGetRequest(DatabaseInformationModel databaseInformationModel, String string, String string2, WebRequest webRequest, String string3, OutputStream outputStream) throws IOException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            stringBuffer.append("<head>");
            stringBuffer.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
            if (this.stylesheetPath != null) {
                stringBuffer.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
                stringBuffer.append(string);
                stringBuffer.append(this.stylesheetPath);
                stringBuffer.append("\">");
            }
            stringBuffer.append("</head>\r\n");
            stringBuffer.append("<body><table>\r\n");
            stringBuffer.append("<tr><th>Patient's ID</th><th>Patient's Name</th></tr>\r\n");
            String string4 = databaseInformationModel.getLocalPrimaryKeyColumnName(InformationEntity.PATIENT);
            ArrayList arrayList = databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntity(InformationEntity.PATIENT);
            Collections.sort(arrayList, this.compareDatabaseAttributesByPatientID);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Map map = (Map)arrayList.get(i);
                String string5 = (String)map.get("PATIENTNAME");
                String string6 = (String)map.get("PATIENTID");
                String string7 = (String)map.get(string4);
                stringBuffer.append("<tr><td><a href=\"");
                stringBuffer.append(string);
                stringBuffer.append("?requestType=STUDYLIST&primaryKey=");
                stringBuffer.append(string7);
                stringBuffer.append("\">");
                stringBuffer.append(string6 == null || string6.length() == 0 ? "NONE" : string6);
                stringBuffer.append("</a>");
                stringBuffer.append("</td>");
                stringBuffer.append("<td>");
                stringBuffer.append(string5 == null ? "&nbsp;" : string5);
                stringBuffer.append("</td>");
                stringBuffer.append("</tr>");
            }
            stringBuffer.append("</table></body></html>\r\n");
            String string8 = stringBuffer.toString();
            this.sendHeaderAndBodyText(outputStream, string8, "patients.html", "text/html");
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            slf4jlogger.debug("generateResponseToGetRequest(): Sending 404 Not Found");
            PatientListRequestHandler.send404NotFound(outputStream, exception.getMessage());
        }
    }

    private class CompareDatabaseAttributesByPatientID
    implements Comparator {
        private CompareDatabaseAttributesByPatientID() {
        }

        public int compare(Object object, Object object2) {
            String string = (String)((Map)object).get("PATIENTID");
            String string2 = (String)((Map)object2).get("PATIENTID");
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            return string.compareTo(string2);
        }
    }
}

