/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.display.ConsumerFormatImageMaker;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.web.RequestHandler;
import com.pixelmed.web.WadoRequest;
import com.pixelmed.web.WebRequest;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

class WadoRequestHandler
extends RequestHandler {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/WadoRequestHandler.java,v 1.24 2025/01/29 10:58:10 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(WadoRequestHandler.class);
    private static final String convertedFormatNameForCodec = "jpeg";
    private static final String convertedExtension = ".jpg";
    private static final String convertedContentType = "image/jpeg";
    private static Map<String, CachedFileEntry> cacheOfConvertedFiles = new HashMap<String, CachedFileEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCacheOfConvertedFiles(String string, CachedFileEntry cachedFileEntry) {
        Map<String, CachedFileEntry> map = cacheOfConvertedFiles;
        synchronized (map) {
            cacheOfConvertedFiles.put(string, cachedFileEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedFileEntry getFromCacheOfConvertedFiles(String string) {
        CachedFileEntry cachedFileEntry = null;
        if (string != null) {
            Map<String, CachedFileEntry> map = cacheOfConvertedFiles;
            synchronized (map) {
                cachedFileEntry = cacheOfConvertedFiles.get(string);
            }
        }
        return cachedFileEntry;
    }

    private static final String makeCacheKey(String string, double d, double d2, int n, int n2, int n3) {
        return string + "#" + Double.toString(d) + "#" + Double.toString(d2) + "#" + Integer.toString(n) + "#" + Integer.toString(n2) + "#" + Integer.toString(n3);
    }

    protected WadoRequestHandler(String string) {
        super(string);
    }

    protected void generateResponseToGetRequestForCacheWithoutSending(DatabaseInformationModel databaseInformationModel, WebRequest webRequest, OutputStream outputStream) throws IOException {
        this.generateResponseToGetRequest(databaseInformationModel, null, null, webRequest, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void generateResponseToGetRequest(DatabaseInformationModel databaseInformationModel, String string, String string2, WebRequest webRequest, String string3, OutputStream outputStream) throws IOException {
        try {
            WadoRequest wadoRequest = new WadoRequest(webRequest);
            String string4 = wadoRequest.getObjectUID();
            ArrayList arrayList = databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedUID(InformationEntity.INSTANCE, string4);
            if (arrayList == null || arrayList.size() != 1) throw new Exception("Could not find SOP Instance " + string4);
            Map map = (Map)arrayList.get(0);
            String string5 = (String)map.get(databaseInformationModel.getLocalFileNameColumnName(InformationEntity.INSTANCE));
            slf4jlogger.trace("generateResponseToGetRequest(): Found in database {}", string5);
            File file = new File(string5);
            if (!file.exists() || !file.isFile()) throw new Exception("SOP Instance " + string4 + " in database but file \"" + string5 + "\" referenced by database missing");
            slf4jlogger.trace("generateResponseToGetRequest(): File exists");
            if (wadoRequest.isContentTypeDicom()) {
                slf4jlogger.trace("generateResponseToGetRequest(): is DICOM request");
                if (outputStream == null) return;
                this.sendHeaderAndBodyOfFile(outputStream, file, string4 + ".dcm", "application/dicom");
                return;
            }
            slf4jlogger.trace("generateResponseToGetRequest(): is non-DICOM request");
            String string6 = (String)map.get("SOPCLASSUID");
            slf4jlogger.trace("generateResponseToGetRequest(): SOP Class UID from database = {}", string6);
            if (string6 == null) throw new Exception("Cannot determine SOP Class of instance");
            if (!SOPClass.isImageStorage(string6)) throw new Exception("Only images supported");
            double d = wadoRequest.getWindowWidth();
            double d2 = wadoRequest.getWindowCenter();
            int n = wadoRequest.getColumns();
            int n2 = wadoRequest.getRows();
            int n3 = wadoRequest.getImageQuality();
            File file2 = null;
            Date date = null;
            String string7 = WadoRequestHandler.makeCacheKey(string4, d2, d, n, n2, n3);
            CachedFileEntry cachedFileEntry = this.getFromCacheOfConvertedFiles(string7);
            try {
                if (cachedFileEntry == null) {
                    slf4jlogger.trace("generateResponseToGetRequest(): not in cache");
                    file2 = File.createTempFile("RequestTypeServer", convertedExtension);
                    file2.deleteOnExit();
                    String string8 = file2.getAbsolutePath();
                    ConsumerFormatImageMaker.convertFileToEightBitImage(string5, string8, convertedFormatNameForCodec, d2, d, n, n2, n3, "all_color");
                    date = new Date();
                    cachedFileEntry = new CachedFileEntry(string8, date);
                    this.addToCacheOfConvertedFiles(string7, cachedFileEntry);
                } else {
                    slf4jlogger.trace("generateResponseToGetRequest(): in cache");
                    file2 = new File(cachedFileEntry.filename);
                    date = cachedFileEntry.date;
                }
                if (outputStream != null) {
                    try {
                        this.sendHeaderAndBodyOfFile(outputStream, file2, string4 + convertedExtension, convertedContentType, date);
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                }
                if (!slf4jlogger.isTraceEnabled()) return;
            }
            catch (Exception exception) {
                try {
                    slf4jlogger.error("Cannot convert image in file {} to {} or send it", file2, convertedFormatNameForCodec, exception);
                    throw new Exception("Cannot convert image to jpeg or send it");
                }
                catch (Throwable throwable) {
                    if (!slf4jlogger.isTraceEnabled()) throw throwable;
                    slf4jlogger.trace("generateResponseToGetRequest(): convertedFile = {}", file2.getAbsolutePath());
                    throw throwable;
                }
            }
            slf4jlogger.trace("generateResponseToGetRequest(): convertedFile = {}", file2.getAbsolutePath());
            return;
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            slf4jlogger.debug("generateResponseToGetRequest(): Sending 404 Not Found");
            WadoRequestHandler.send404NotFound(outputStream, exception.getMessage());
        }
    }

    private class CachedFileEntry {
        String filename;
        Date date;

        CachedFileEntry(String string, Date date) {
            this.filename = string;
            this.date = date;
        }
    }
}

