/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CompressedFrameDecoder;
import com.pixelmed.dicom.CompressedFrameEncoder;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.OtherByteAttributeMultipleCompressedFrames;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.display.SourceImage;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.utils.PrintStreamMessageLogger;
import java.awt.image.BufferedImage;
import java.io.File;

public class CompressDicomFiles
extends MediaImporter {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/CompressDicomFiles.java,v 1.26 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(CompressDicomFiles.class);
    protected String outputPath;
    protected String outputFormat;
    protected String transferSyntaxUID;
    protected boolean reuseSameBaseFileName;

    public CompressDicomFiles(MessageLogger messageLogger) {
        super(messageLogger);
        String string = System.getProperty("os.name");
        if (string != null && string.toLowerCase().startsWith("windows")) {
            slf4jlogger.info("disabling memory mapping for SourceImage on Windows platform");
            SourceImage.setAllowMemoryMapping(false);
        }
    }

    @Override
    protected boolean isOKToImport(String string, String string2) {
        return string != null && SOPClass.isImageStorage(string) && string2 != null;
    }

    @Override
    protected void doSomethingWithUnwantedFileOnMedia(String string, String string2, String string3) {
        this.logLn("Not a DICOM file, not a DICOM PS 3.10 file or not an image so cannot compress: " + string);
    }

    @Override
    protected void doSomethingWithDicomFileOnMedia(String string) {
        slf4jlogger.info("doSomethingWithDicomFileOnMedia(): {} outputFormat = {} transferSyntaxUID = {}", string, this.outputFormat, this.transferSyntaxUID);
        try {
            Object object;
            Object object2;
            boolean bl = CompressedFrameDecoder.canDecompress(string);
            slf4jlogger.info("doSomethingWithDicomFileOnMedia(): deferredDecompression {}", bl);
            AttributeList attributeList = new AttributeList();
            attributeList.setDecompressPixelData(!bl);
            attributeList.read(string);
            attributeList.removeGroupLengthAttributes();
            attributeList.remove(TagFromName.DataSetTrailingPadding);
            SourceImage sourceImage = new SourceImage(attributeList);
            if (sourceImage == null) {
                throw new DicomException("Could not get images for frames from" + string);
            }
            int n = sourceImage.getNumberOfFrames();
            File[] fileArray = new File[n];
            for (int i = 0; i < n; ++i) {
                object2 = sourceImage.getBufferedImage(i);
                if (object2 == null) {
                    throw new DicomException("Could not get image for frame " + i + " from" + string);
                }
                object = File.createTempFile("CompressDicomFiles_tmp", ".tmp");
                ((File)object).deleteOnExit();
                fileArray[i] = CompressedFrameEncoder.getCompressedFrameAsFile(attributeList, (BufferedImage)object2, this.outputFormat, (File)object);
            }
            OtherByteAttributeMultipleCompressedFrames otherByteAttributeMultipleCompressedFrames = new OtherByteAttributeMultipleCompressedFrames(TagFromName.PixelData, fileArray);
            attributeList.put(otherByteAttributeMultipleCompressedFrames);
            attributeList.correctDecompressedImagePixelModule(bl);
            attributeList.insertLossyImageCompressionHistoryIfDecompressed(bl);
            object2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PhotometricInterpretation);
            if (((String)object2).equals("YBR_FULL_422")) {
                object2 = "YBR_FULL";
                object = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
                ((Attribute)object).addValue((String)object2);
                attributeList.put((Attribute)object);
            }
            if (this.outputFormat.equals("jpeg2000")) {
                if (((String)object2).equals("RGB")) {
                    object2 = "YBR_RCT";
                    object = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
                    ((Attribute)object).addValue((String)object2);
                    attributeList.put((Attribute)object);
                } else if (!((String)object2).equals("MONOCHROME1") && !((String)object2).equals("MONOCHROME2")) {
                    throw new DicomException("Cannot encode " + (String)object2 + " using JPEG 2000, only RGB transformed to YBR_RCT is permitted");
                }
            }
            if (Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 0) > 1) {
                object = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
                ((Attribute)object).addValue(this.outputFormat.equals("rle") ? 1 : 0);
                attributeList.put((Attribute)object);
            } else {
                attributeList.remove(TagFromName.PlanarConfiguration);
            }
            attributeList.removeMetaInformationHeaderAttributes();
            FileMetaInformation.addFileMetaInformation(attributeList, this.transferSyntaxUID, "OURAETITLE");
            object = this.reuseSameBaseFileName ? new File(string).getName() : Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.SOPInstanceUID, "NONAME");
            File file = new File(this.outputPath, (String)object);
            if (file.exists()) {
                throw new DicomException("Not overwriting output file that already exists " + file);
            }
            slf4jlogger.info("doSomethingWithDicomFileOnMedia(): writing compressed file {}", file);
            attributeList.write(file, this.transferSyntaxUID, true, true);
            for (int i = 0; i < n; ++i) {
                fileArray[i].delete();
                fileArray[i] = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            slf4jlogger.error("While processing " + string + " ", exception);
        }
    }

    public static void main(String[] stringArray) {
        block7: {
            try {
                if (stringArray.length == 2) {
                    CompressDicomFiles compressDicomFiles = new CompressDicomFiles(new PrintStreamMessageLogger(System.err));
                    compressDicomFiles.outputPath = stringArray[1];
                    compressDicomFiles.outputFormat = "jpeg2000";
                    compressDicomFiles.transferSyntaxUID = "1.2.840.10008.1.2.4.90";
                    compressDicomFiles.reuseSameBaseFileName = false;
                    compressDicomFiles.importDicomFiles(stringArray[0]);
                    break block7;
                }
                if (stringArray.length == 3) {
                    CompressDicomFiles compressDicomFiles = new CompressDicomFiles(new PrintStreamMessageLogger(System.err));
                    compressDicomFiles.outputPath = stringArray[1];
                    if (stringArray[2].startsWith("1.")) {
                        compressDicomFiles.transferSyntaxUID = stringArray[2].trim();
                        compressDicomFiles.outputFormat = CompressedFrameEncoder.chooseOutputFormatForTransferSyntax(compressDicomFiles.transferSyntaxUID);
                    } else {
                        compressDicomFiles.outputFormat = stringArray[2].toLowerCase().trim();
                        compressDicomFiles.transferSyntaxUID = CompressedFrameEncoder.chooseTransferSyntaxForOutputFormat(compressDicomFiles.outputFormat);
                    }
                    if (compressDicomFiles.outputFormat == null || compressDicomFiles.transferSyntaxUID == null) {
                        throw new Exception("Unsupported output format or Transfer Syntax UID");
                    }
                    compressDicomFiles.reuseSameBaseFileName = false;
                    compressDicomFiles.importDicomFiles(stringArray[0]);
                    break block7;
                }
                throw new Exception("Argument list must be zero or one value");
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
                System.exit(0);
            }
        }
    }
}

