/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.apps.DoseReporterWithLegacyOCRAndAutoSendToRegistry;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.MoveDicomFilesIntoHierarchy;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CopyStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CopyOnlyHeadOfMultipleStructuredReportsAndReferences {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/CopyOnlyHeadOfMultipleStructuredReportsAndReferences.java,v 1.12 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DoseReporterWithLegacyOCRAndAutoSendToRegistry.class);
    protected String ourAETitle = "OURAETITLE";
    private SetOfDicomFiles dicomFilesRead = new SetOfDicomFiles();
    private SetOfDicomFiles dicomFilesToCopy = new SetOfDicomFiles();
    private Set<String> srSOPClassInstances = new HashSet<String>();
    private Set<String> otherSOPClassInstances = new HashSet<String>();
    private Map<String, SetOfDicomFiles.DicomFile> mapOfSOPInstanceUIDToDicomFile = new HashMap<String, SetOfDicomFiles.DicomFile>();
    private Map<String, Set<String>> mapOfSRSOPInstanceUIDToPredecessorSRSOPInstanceUIDs = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> mapOfSRSOPInstanceUIDToAllSOPInstancesReferenced = new HashMap<String, Set<String>>();
    private String dstFolderName;

    private void extractPredecessorDocumentsSequence(AttributeList attributeList, String string) {
        Attribute attribute = attributeList.get(TagFromName.PredecessorDocumentsSequence);
        if (attribute != null && attribute instanceof SequenceAttribute) {
            Set<String> set = this.mapOfSRSOPInstanceUIDToPredecessorSRSOPInstanceUIDs.get(string);
            if (set == null) {
                set = new HashSet<String>();
                this.mapOfSRSOPInstanceUIDToPredecessorSRSOPInstanceUIDs.put(string, set);
            }
            SequenceAttribute sequenceAttribute = (SequenceAttribute)attribute;
            Iterator<SequenceItem> iterator = sequenceAttribute.iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList2 = iterator.next().getAttributeList();
                attributeList2.findAllNestedReferencedSOPInstanceUIDs(set);
            }
        }
    }

    private boolean hasSuccessor(String string) {
        for (Set<String> set : this.mapOfSRSOPInstanceUIDToPredecessorSRSOPInstanceUIDs.values()) {
            for (String string2 : set) {
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private void extractAllSOPInstancesReferencedWithinSR(AttributeList attributeList, String string) {
        Set<String> set = this.mapOfSRSOPInstanceUIDToAllSOPInstancesReferenced.get(string);
        if (set == null) {
            set = new HashSet<String>();
            this.mapOfSRSOPInstanceUIDToAllSOPInstancesReferenced.put(string, set);
        }
        attributeList.findAllNestedReferencedSOPInstanceUIDs(set);
    }

    public CopyOnlyHeadOfMultipleStructuredReportsAndReferences(String[] stringArray, String string) throws FileNotFoundException, IOException, DicomException {
        this.dstFolderName = string;
        OurMediaImporter ourMediaImporter = new OurMediaImporter();
        for (String set2 : stringArray) {
            ourMediaImporter.importDicomFiles(set2);
        }
        for (String string2 : this.srSOPClassInstances) {
            if (this.hasSuccessor(string2)) continue;
            SetOfDicomFiles.DicomFile dicomFile = this.mapOfSOPInstanceUIDToDicomFile.get(string2);
            this.dicomFilesToCopy.add(dicomFile);
            Set<String> set = this.mapOfSRSOPInstanceUIDToAllSOPInstancesReferenced.get(string2);
            if (set == null) continue;
            for (String string3 : set) {
                if (!this.otherSOPClassInstances.contains(string3)) continue;
                SetOfDicomFiles.DicomFile dicomFile2 = this.mapOfSOPInstanceUIDToDicomFile.get(string3);
                this.dicomFilesToCopy.add(dicomFile2);
            }
        }
        for (SetOfDicomFiles.DicomFile dicomFile : this.dicomFilesToCopy) {
            try {
                File file = new File(dicomFile.getFileName());
                File file2 = new File(string, MoveDicomFilesIntoHierarchy.makeHierarchicalPathFromAttributes(dicomFile.getAttributeList()));
                if (file2.exists()) {
                    throw new DicomException("\"" + file + "\": new file \"" + file2 + "\" already exists - not overwriting");
                }
                File file3 = file2.getParentFile();
                if (!file3.exists() && !file3.mkdirs()) {
                    throw new DicomException("\"" + file + "\": parent directory creation failed for \"" + file2 + "\"");
                }
                CopyStream.copy(file, file2);
            }
            catch (Exception exception) {
                slf4jlogger.error("File {}", dicomFile.getFileName(), exception);
            }
        }
        for (SetOfDicomFiles.DicomFile dicomFile : this.dicomFilesRead) {
            if (this.dicomFilesToCopy.contains(dicomFile)) {
                slf4jlogger.info("Copied - SOP Instance {} in file {}", dicomFile.getSOPInstanceUID(), dicomFile.getFileName());
                continue;
            }
            slf4jlogger.info("Not copied - SOP Instance {} in file {}", dicomFile.getSOPInstanceUID(), dicomFile.getFileName());
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length >= 2) {
                int n = stringArray.length - 1;
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                new CopyOnlyHeadOfMultipleStructuredReportsAndReferences(stringArray2, stringArray[n]);
            } else {
                System.err.println("Usage: java -cp ./pixelmed.jar com.pixelmed.apps.CopyOnlyHeadOfMultipleStructuredReportsAndReferences srcdir|DICOMDIR [srcdir|DICOMDIR]* dstdir");
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurMediaImporter
    extends MediaImporter {
        public OurMediaImporter() {
            super(null);
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            block5: {
                try {
                    SetOfDicomFiles.DicomFile dicomFile = CopyOnlyHeadOfMultipleStructuredReportsAndReferences.this.dicomFilesRead.add(string, true, false);
                    AttributeList attributeList = dicomFile.getAttributeList();
                    String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
                    if (string2.length() > 0) {
                        CopyOnlyHeadOfMultipleStructuredReportsAndReferences.this.mapOfSOPInstanceUIDToDicomFile.put(string2, dicomFile);
                        String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
                        if (SOPClass.isStructuredReport(string3)) {
                            CopyOnlyHeadOfMultipleStructuredReportsAndReferences.this.srSOPClassInstances.add(string2);
                            CopyOnlyHeadOfMultipleStructuredReportsAndReferences.this.extractPredecessorDocumentsSequence(attributeList, string2);
                            CopyOnlyHeadOfMultipleStructuredReportsAndReferences.this.extractAllSOPInstancesReferencedWithinSR(attributeList, string2);
                        } else {
                            CopyOnlyHeadOfMultipleStructuredReportsAndReferences.this.otherSOPClassInstances.add(string2);
                        }
                        break block5;
                    }
                    throw new DicomException("No SOP Instance UID in file " + string);
                }
                catch (Exception exception) {
                    slf4jlogger.error("File {}", string, exception);
                }
            }
        }
    }
}

