/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.utils.PrintStreamMessageLogger;
import java.io.File;

public class DecompressDicomFiles
extends MediaImporter {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/DecompressDicomFiles.java,v 1.15 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DecompressDicomFiles.class);
    protected String outputPath;

    public DecompressDicomFiles(MessageLogger messageLogger) {
        super(messageLogger);
    }

    @Override
    protected boolean isOKToImport(String string, String string2) {
        return string != null && (SOPClass.isImageStorage(string) || SOPClass.isNonImageStorage(string) && !SOPClass.isDirectory(string)) && string2 != null;
    }

    @Override
    protected void doSomethingWithDicomFileOnMedia(String string) {
        slf4jlogger.info("MediaImporter.doSomethingWithDicomFile(): {}", string);
        try {
            AttributeList attributeList = new AttributeList();
            attributeList.read(string);
            attributeList.removeGroupLengthAttributes();
            attributeList.removeMetaInformationHeaderAttributes();
            attributeList.remove(TagFromName.DataSetTrailingPadding);
            attributeList.correctDecompressedImagePixelModule();
            attributeList.insertLossyImageCompressionHistoryIfDecompressed();
            FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
            String string2 = Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.SOPInstanceUID, "NONAME");
            attributeList.write(new File(this.outputPath, string2), "1.2.840.10008.1.2.1", true, true);
        }
        catch (Exception exception) {
            slf4jlogger.error("While processing " + string + " ", exception);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 2) {
                slf4jlogger.error("Usage: com.pixelmed.apps.DecompressDicomFiles inputpath outputpath");
                throw new Exception("Argument list must be two values");
            }
            DecompressDicomFiles decompressDicomFiles = new DecompressDicomFiles(new PrintStreamMessageLogger(System.err));
            decompressDicomFiles.outputPath = stringArray[1];
            decompressDicomFiles.importDicomFiles(stringArray[0]);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }
}

