/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.apps.DeidentifyAndRedact;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;

public class DeidentifyAndRedactWithOriginalFileName
extends DeidentifyAndRedact {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/DeidentifyAndRedactWithOriginalFileName.java,v 1.14 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DeidentifyAndRedactWithOriginalFileName.class);

    @Override
    protected String makeOutputFileName(String string, String string2, String string3) throws IOException {
        return new File(string, new File(string2).getName().replaceFirst("[.]dcm$", "") + "_Anon.dcm").getCanonicalPath();
    }

    public DeidentifyAndRedactWithOriginalFileName(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, AttributeList attributeList) throws DicomException, Exception, IOException {
        super(string, string2, string3, bl, bl2, bl3, attributeList);
    }

    public DeidentifyAndRedactWithOriginalFileName(String string, String string2, String string3, boolean bl, boolean bl2, AttributeList attributeList) throws DicomException, Exception, IOException {
        super(string, string2, string3, bl, bl2, attributeList);
    }

    public DeidentifyAndRedactWithOriginalFileName(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) throws DicomException, Exception, IOException {
        super(string, string2, string3, bl, bl2, bl3);
    }

    public DeidentifyAndRedactWithOriginalFileName(String string, String string2, String string3, boolean bl, boolean bl2) throws DicomException, Exception, IOException {
        super(string, string2, string3, bl, bl2);
    }

    public static void main(String[] stringArray) {
        try {
            boolean bl = false;
            if (stringArray.length >= 3) {
                String string;
                AttributeList attributeList = null;
                int n = 3;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = true;
                if (stringArray.length - n > 0) {
                    string = stringArray[n].trim().toUpperCase();
                    if (string.equals("DECOMPRESS")) {
                        bl2 = true;
                        ++n;
                    } else if (string.equals("BLOCK")) {
                        ++n;
                    }
                }
                slf4jlogger.info("main(): decompress = {}", bl2);
                if (stringArray.length - n > 0) {
                    string = stringArray[n].trim().toUpperCase();
                    if (string.equals("KEEPALLPRIVATE")) {
                        bl3 = true;
                        ++n;
                    } else if (string.equals("KEEPSAFEPRIVATE")) {
                        ++n;
                    }
                }
                slf4jlogger.info("main(): keepAllPrivate = {}", bl3);
                if (stringArray.length - n > 0) {
                    string = stringArray[n].trim().toUpperCase();
                    if (string.equals("ADDCONTRIBUTINGEQUIPMENT")) {
                        bl4 = true;
                        ++n;
                    } else if (string.equals("DONOTADDCONTRIBUTINGEQUIPMENT")) {
                        bl4 = false;
                        ++n;
                    }
                }
                slf4jlogger.info("main(): addContributingEquipmentSequence = {}", bl4);
                if (stringArray.length > n) {
                    if ((stringArray.length - n) % 2 == 0) {
                        slf4jlogger.info("main(): have replacement attributes");
                        attributeList = AttributeList.makeAttributeListFromKeywordAndValuePairs(stringArray, n, stringArray.length - n);
                        slf4jlogger.info("main(): the replacement attributes are:\n{}", attributeList);
                    } else {
                        slf4jlogger.error("Replacement keyword/value pairs must be pairs");
                        bl = true;
                    }
                }
                if (!bl) {
                    long l = System.currentTimeMillis();
                    new DeidentifyAndRedactWithOriginalFileName(stringArray[0], stringArray[1], stringArray[2], bl2, bl3, bl4, attributeList);
                    long l2 = System.currentTimeMillis();
                    slf4jlogger.info("entire set took = " + (l2 - l) + " ms");
                }
            } else {
                slf4jlogger.error("Error: Incorrect number of arguments");
                bl = true;
            }
            if (bl) {
                slf4jlogger.error("Usage: DeidentifyAndRedactWithOriginalFileName inputPath outputFile redactionControlFile [BLOCK|DECOMPRESS] [KEEPALLPRIVATE|KEEPSAFEPRIVATE] [keyword value]*");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

