/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CopyStream;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.utils.PrintStreamMessageLogger;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class FindAndCopySelectedDicomFiles
extends MediaImporter {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/FindAndCopySelectedDicomFiles.java,v 1.12 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(FindAndCopySelectedDicomFiles.class);
    protected boolean exact;
    protected Set<String> sopClasses;
    protected String outputPath;

    public FindAndCopySelectedDicomFiles(MessageLogger messageLogger) {
        super(messageLogger);
    }

    @Override
    protected boolean isOKToImport(String string, String string2) {
        return this.sopClasses.contains(string);
    }

    @Override
    protected void doSomethingWithDicomFileOnMedia(String string) {
        slf4jlogger.info("MediaImporter.doSomethingWithDicomFile(): {}", string);
        try {
            AttributeList attributeList = new AttributeList();
            attributeList.readOnlyMetaInformationHeader(string);
            String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.MediaStorageSOPInstanceUID);
            if (string2.length() <= 0) {
                throw new DicomException("Cannot extract SOP Instance UID from \"" + string + "\" to create output file name - ignoring");
            }
            CopyStream.copy(new File(string), new File(this.outputPath, string2));
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 3) {
                FindAndCopySelectedDicomFiles findAndCopySelectedDicomFiles = new FindAndCopySelectedDicomFiles(new PrintStreamMessageLogger(System.err));
                findAndCopySelectedDicomFiles.outputPath = stringArray[1];
                findAndCopySelectedDicomFiles.sopClasses = new HashSet<String>();
                if (stringArray[2].startsWith("1")) {
                    findAndCopySelectedDicomFiles.sopClasses.add(stringArray[2]);
                } else {
                    String[] stringArray2 = SOPClass.getPlausibleStandardSOPClassUIDsForModality(stringArray[2]);
                    if (stringArray2 == null) {
                        throw new DicomException("Cannot find plausible SOP Standard Classes for modality \"" + stringArray[2] + "\"");
                    }
                    for (String string : stringArray2) {
                        findAndCopySelectedDicomFiles.sopClasses.add(string);
                    }
                }
                findAndCopySelectedDicomFiles.importDicomFiles(stringArray[0]);
            } else {
                System.err.println("Usage: java -cp ./pixelmed.jar com.pixelmed.apps.FindAndCopySelectedDicomFiles srcdir dstdir sopclass|modality");
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }
}

