/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.apps.InstanceReceiver;
import com.pixelmed.apps.TiledPyramid;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.MultipleInstanceTransferStatusHandlerWithFileName;
import com.pixelmed.network.PresentationAddress;
import com.pixelmed.network.StorageSOPClassSCU;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import com.pixelmed.utils.MessageLogger;
import java.io.File;
import java.io.IOException;

public class ProcessReceivedWholeSlideImagesMakeTiledPyramidAndSend
extends InstanceReceiver {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/ProcessReceivedWholeSlideImagesMakeTiledPyramidAndSend.java,v 1.8 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ProcessReceivedWholeSlideImagesMakeTiledPyramidAndSend.class);
    protected static String propertyName_PyramidImagesFolderName = "Application.PyramidImagesFolderName";
    protected static String propertyName_DicomCurrentlySelectedStorageTargetAE = "Dicom.CurrentlySelectedStorageTargetAE";
    protected String defaultPyramidImagesFolderName = ".com.pixelmed.apps.ProcessReceivedWholeSlideImagesMakeTiledPyramidAndSend.pyramidimages";
    protected String defaultDicomCurrentlySelectedStorageTargetAE = "them";
    protected File pyramidImagesFolder = ProcessReceivedWholeSlideImagesMakeTiledPyramidAndSend.getFolderNameCreatingItIfNecessary(this.properties.getProperty(propertyName_PyramidImagesFolderName, this.defaultPyramidImagesFolderName));
    protected String ourCallingAETitle;
    protected String remoteAETitle;
    protected String remoteHost;
    protected int remotePort;

    @Override
    protected void doSomethingWithReceivedDicomFile(String string, String string2, String string3, String string4) {
        System.err.println("doSomethingWithReceivedDicomFile(): " + string + " received from " + string2 + " in " + string3 + " is " + string4);
        boolean bl = true;
        try {
            new TiledPyramid(string, this.pyramidImagesFolder.getCanonicalPath());
        }
        catch (Exception exception) {
            slf4jlogger.error("Failed to build tiled pyramid", exception);
            bl = false;
        }
        if (bl) {
            Object object;
            SetOfDicomFiles setOfDicomFiles = new SetOfDicomFiles();
            try {
                object = this.pyramidImagesFolder.listFiles();
                int n = ((File[])object).length;
                for (int i = 0; i < n; ++i) {
                    File file = object[i];
                    if (slf4jlogger.isInfoEnabled()) {
                        slf4jlogger.info("Queueing {}", file.getCanonicalPath());
                    }
                    setOfDicomFiles.add(file);
                }
                slf4jlogger.info("Queueing {}", string);
                setOfDicomFiles.add(string);
            }
            catch (Exception exception) {
                slf4jlogger.error("Failed to make SetOfDicomFiles", exception);
            }
            if (setOfDicomFiles != null & setOfDicomFiles.size() > 0 && ((StorageSOPClassSCU)(object = new StorageSOPClassSCU(this.remoteHost, this.remotePort, this.remoteAETitle, this.ourCallingAETitle, setOfDicomFiles, 0, new OurMultipleInstanceTransferStatusHandlerWithFileName(0, null), null, 0))).encounteredTrappedExceptions()) {
                slf4jlogger.info("Sending queued files problem - connection or association failure ?");
            }
        }
    }

    public ProcessReceivedWholeSlideImagesMakeTiledPyramidAndSend(String string) throws DicomException, DicomNetworkException, IOException, InterruptedException {
        super(string);
        String string2 = this.properties.getProperty(propertyName_DicomCurrentlySelectedStorageTargetAE);
        this.ourCallingAETitle = this.networkApplicationProperties.getCallingAETitle();
        this.remoteAETitle = this.networkApplicationInformation.getApplicationEntityTitleFromLocalName(string2);
        PresentationAddress presentationAddress = this.networkApplicationInformation.getApplicationEntityMap().getPresentationAddress(this.remoteAETitle);
        this.remoteHost = presentationAddress.getHostname();
        this.remotePort = presentationAddress.getPort();
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray.length > 0 ? stringArray[0] : FileUtilities.makePathToFileInUsersHomeDirectory(defaultPropertiesFileName);
            new ProcessReceivedWholeSlideImagesMakeTiledPyramidAndSend(string);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurMultipleInstanceTransferStatusHandlerWithFileName
    extends MultipleInstanceTransferStatusHandlerWithFileName {
        int verbosityLevel;
        MessageLogger logger;

        OurMultipleInstanceTransferStatusHandlerWithFileName(int n, MessageLogger messageLogger) {
            this.verbosityLevel = n;
            this.logger = messageLogger;
        }

        @Override
        public void updateStatus(int n, int n2, int n3, int n4, String string, String string2, boolean bl) {
            File file = new File(string2);
            String string3 = file.getName();
            if (this.verbosityLevel > 0 && this.logger != null) {
                this.logger.sendLn("Send of " + string3 + " " + (bl ? "succeeded" : "failed"));
            }
            slf4jlogger.info("Send of {} {}", string3, bl ? "succeeded" : "failed");
            if (bl) {
                if (file.exists() && file.isFile()) {
                    slf4jlogger.debug("removing {}", string3);
                    if (file.delete()) {
                        if (this.verbosityLevel > 0 && this.logger != null) {
                            this.logger.sendLn("Removed " + string3);
                        }
                        slf4jlogger.info("Removed {}", string3);
                    } else {
                        if (this.verbosityLevel > 0 && this.logger != null) {
                            this.logger.sendLn("Failed to remove " + string3);
                        }
                        slf4jlogger.info("Failed to remove {}", string3);
                    }
                }
            } else {
                if (this.verbosityLevel > 0 && this.logger != null) {
                    this.logger.sendLn("Leaving " + string3);
                }
                slf4jlogger.info("Leaving {}", string3);
            }
        }
    }
}

